/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.impl.Entry;
import org.cache2k.impl.Hash;
import org.cache2k.impl.LockFreeCache;

public class CarCache<K, V>
extends LockFreeCache<K, V> {
    int size;
    int arcP = 0;
    Hash<Entry> b1HashCtrl;
    Entry[] b1Hash;
    Hash<Entry> b2HashCtrl;
    Entry[] b2Hash;
    int t1Size;
    int t2Size;
    Entry<K, V> t2Head;
    Entry<K, V> t1Head;
    Entry<K, V> b1Head;
    Entry<K, V> b2Head;
    boolean b2HitPreferenceForEviction;
    long hits;

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.t1Size = 0;
        this.t2Size = 0;
        this.t1Head = null;
        this.t2Head = null;
        this.b1Head = new Entry();
        this.b2Head = new Entry();
        this.b1Head = new Entry().shortCircuit();
        this.b2Head = new Entry().shortCircuit();
        this.b1HashCtrl = new Hash();
        this.b2HashCtrl = new Hash();
        this.b1Hash = this.b1HashCtrl.init(Entry.class);
        this.b2Hash = this.b2HashCtrl.init(Entry.class);
    }

    @Override
    protected void recordHit(Entry e) {
        ++e.hitCnt;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.size;
        ++this.t1Size;
        this.t1Head = CarCache.insertIntoTailCyclicList(this.t1Head, e);
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    @Override
    public long getHitCnt() {
        return this.hits + (long)this.sumUpListHits(this.t1Head) + (long)this.sumUpListHits(this.t2Head);
    }

    private int sumUpListHits(Entry e) {
        if (e == null) {
            return 0;
        }
        int cnt = 0;
        Entry _head = e;
        do {
            cnt = (int)((long)cnt + e.hitCnt);
        } while ((e = e.prev) != _head);
        return cnt;
    }

    @Override
    protected Entry checkForGhost(K key, int hc) {
        Entry e = this.b1HashCtrl.remove(this.b1Hash, key, hc);
        if (e != null) {
            CarCache.removeFromList(e);
            this.b1HitAdaption();
            this.insertT2(e);
            return e;
        }
        e = this.b2HashCtrl.remove(this.b2Hash, key, hc);
        if (e != null) {
            CarCache.removeFromList(e);
            this.b2HitAdaption();
            this.insertT2(e);
            return e;
        }
        return null;
    }

    private void b1HitAdaption() {
        int _b1Size = this.b1HashCtrl.size + 1;
        int _b2Size = this.b2HashCtrl.size;
        int _delta = _b1Size >= _b2Size ? 1 : _b2Size / _b1Size;
        this.arcP = Math.min(this.arcP + _delta, this.maxSize);
        this.b2HitPreferenceForEviction = false;
    }

    private void b2HitAdaption() {
        int _b2Size = this.b2HashCtrl.size + 1;
        int _b1Size = this.b1HashCtrl.size;
        int _delta = _b2Size >= _b1Size ? 1 : _b1Size / _b2Size;
        this.arcP = Math.max(this.arcP - _delta, 0);
        this.b2HitPreferenceForEviction = true;
    }

    @Override
    protected Entry findEvictionCandidate() {
        return this.replace();
    }

    private Entry<K, V> replace() {
        Entry<K, V> e = null;
        while (true) {
            if (this.t1Size >= Math.max(1, this.arcP) || this.t2Size == 0) {
                e = this.t1Head;
                if (e.hitCnt == 0L) {
                    this.t1Head = e.next;
                    break;
                }
                this.hits += e.hitCnt;
                e.hitCnt = 0L;
                this.t1Head = CarCache.removeFromCyclicList(this.t1Head, e);
                --this.t1Size;
                this.t2Head = CarCache.insertIntoTailCyclicList(this.t2Head, e);
                ++this.t2Size;
                continue;
            }
            e = this.t2Head;
            if (e.hitCnt == 0L) {
                this.t2Head = e.next;
                break;
            }
            this.hits += e.hitCnt;
            e.hitCnt = 0L;
            this.t2Head = e.next;
        }
        this.evictGhosts();
        return e;
    }

    private void evictGhosts() {
        int _b1Size = this.b1HashCtrl.size;
        if (this.t1Size + _b1Size == this.maxSize && _b1Size > 0) {
            Entry e = this.b1Head.prev;
            CarCache.removeFromList(e);
            boolean f = this.b1HashCtrl.remove(this.b1Hash, e);
            return;
        }
        int _b2Size = this.b2HashCtrl.size;
        if (this.t1Size + this.t2Size + _b1Size + _b2Size > 2 * this.maxSize && _b2Size > 0) {
            Entry e = this.b2Head.prev;
            CarCache.removeFromList(e);
            boolean bl = this.b2HashCtrl.remove(this.b2Hash, e);
        }
    }

    private void insertT2(Entry<K, V> e) {
        ++this.t2Size;
        this.t2Head = CarCache.insertIntoTailCyclicList(this.t2Head, e);
    }

    private int getListSize() {
        return this.t1Size + this.t2Size;
    }

    private void insertCopyIntoB1(Entry<K, V> e) {
        Entry<K, V> e2 = this.copyEntryForGhost(e);
        this.b1Hash = this.b1HashCtrl.insert(this.b1Hash, e2);
        CarCache.insertInList(this.b1Head, e2);
    }

    private void insertCopyIntoB2(Entry<K, V> e) {
        Entry<K, V> e2 = this.copyEntryForGhost(e);
        this.b2Hash = this.b2HashCtrl.insert(this.b2Hash, e2);
        CarCache.insertInList(this.b2Head, e2);
    }

    private Entry<K, V> copyEntryForGhost(Entry<K, V> e) {
        Entry e2 = new Entry();
        e2.key = e.key;
        e2.hashCode = e.hashCode;
        return e2;
    }

    @Override
    protected void removeEntryFromReplacementList(Entry e) {
        boolean _t2Hit;
        boolean _t1Hit = this.t1Head != null && this.t1Head.prev == e;
        boolean bl = _t2Hit = this.t2Head != null && this.t2Head.prev == e;
        if (!_t1Hit || !_t2Hit) {
            if (this.t1Size < this.t2Size) {
                _t1Hit = false;
                _t2Hit = true;
                Entry x = this.t1Head;
                if (x != null) {
                    do {
                        if (x != e) continue;
                        _t1Hit = true;
                        _t2Hit = false;
                        break;
                    } while ((x = x.next) != this.t1Head);
                }
            } else {
                _t1Hit = true;
                _t2Hit = false;
                Entry x = this.t2Head;
                if (x != null) {
                    do {
                        if (x != e) continue;
                        _t1Hit = false;
                        _t2Hit = true;
                        break;
                    } while ((x = x.next) != this.t2Head);
                }
            }
        }
        if (_t1Hit) {
            this.insertCopyIntoB1(e);
            this.t1Head = CarCache.removeFromCyclicList(this.t1Head, e);
            --this.t1Size;
        } else {
            this.insertCopyIntoB2(e);
            this.t2Head = CarCache.removeFromCyclicList(this.t2Head, e);
            --this.t2Size;
        }
    }
}

