/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cache2k.Cache;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.Cache2kManagerProviderImpl;
import org.cache2k.impl.CacheClosedException;
import org.cache2k.impl.CacheInternalError;
import org.cache2k.impl.CacheLifeCycleListener;
import org.cache2k.impl.CacheManagerLifeCycleListener;
import org.cache2k.impl.CacheUsageExcpetion;
import org.cache2k.impl.InternalCache;
import org.cache2k.impl.threading.Futures;
import org.cache2k.impl.util.Cache2kVersion;
import org.cache2k.impl.util.Log;

public class CacheManagerImpl
extends CacheManager {
    static List<CacheLifeCycleListener> cacheLifeCycleListeners = new ArrayList<CacheLifeCycleListener>();
    static List<CacheManagerLifeCycleListener> cacheManagerLifeCycleListeners = new ArrayList<CacheManagerLifeCycleListener>();
    private Map<String, StackTrace> name2CreationStackTrace = null;
    private Object lock = new Object();
    private Log log;
    private String name;
    private Map<String, InternalCache> cacheNames = new HashMap<String, InternalCache>();
    private Set<Cache> caches = new HashSet<Cache>();
    private int disambiguationCounter = 1;
    private Properties properties;
    private ClassLoader classLoader;
    private String version;
    private String buildNumber;

    public CacheManagerImpl(ClassLoader cl, String _name, Properties p) {
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        this.classLoader = cl;
        if (p == null) {
            p = new Properties();
        }
        this.properties = p;
        this.name = _name;
        this.log = Log.getLog(CacheManager.class.getName() + '.' + this.name);
        this.buildNumber = Cache2kVersion.getBuildNumber();
        this.version = Cache2kVersion.getVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("org.cache2k manager starting. ");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", version=");
        sb.append(this.version);
        sb.append(", build=");
        sb.append(this.buildNumber);
        boolean _traceCacheCreation = this.log.isDebugEnabled();
        sb.append(", defaultImplementation=");
        sb.append(BaseCache.TUNABLE.defaultImplementation.getSimpleName());
        this.log.info(sb.toString());
        for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
            lc.managerCreated(this);
        }
        if (_traceCacheCreation) {
            this.name2CreationStackTrace = new HashMap<String, StackTrace>();
        }
    }

    private void sendCreatedEvent(Cache c) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheCreated(this, c);
        }
    }

    private void sendDestroyedEvent(Cache c) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheDestroyed(this, c);
        }
    }

    private void checkName(String s) {
        for (char c : s.toCharArray()) {
            if (c == '.' || c == '-' || c == '~' || c == '@' || c == ' ' || c == ',' || c == '(' || c == ')' || Character.isJavaIdentifierPart(c)) continue;
            throw new CacheUsageExcpetion("Cache name contains illegal chars: '" + c + "', name=\"" + s + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newCache(InternalCache c, String _requestedName) {
        Object object = this.lock;
        synchronized (object) {
            String _name = _requestedName;
            while (this.cacheNames.containsKey(_name)) {
                _name = _requestedName + "~" + Integer.toString(this.disambiguationCounter++, 36);
            }
            if (!_requestedName.equals(_name)) {
                this.log.warn("duplicate name, disambiguating: " + _requestedName + " -> " + _name, new StackTrace());
                if (this.name2CreationStackTrace != null) {
                    this.log.warn("initial creation of " + _requestedName, this.name2CreationStackTrace.get(_requestedName));
                }
            }
            this.checkName(_name);
            if (this.name2CreationStackTrace != null) {
                this.name2CreationStackTrace.put(_name, new StackTrace());
            }
            this.caches.add(c);
            this.sendCreatedEvent(c);
            this.cacheNames.put(_name, c);
            return _name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheDestroyed(Cache c) {
        Object object = this.lock;
        synchronized (object) {
            this.cacheNames.remove(c.getName());
            if (this.name2CreationStackTrace != null) {
                this.name2CreationStackTrace.remove(c.getName());
            }
            this.caches.remove(c);
            this.sendDestroyedEvent(c);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Cache> iterator() {
        HashSet<Cache> _caches = new HashSet<Cache>();
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                for (Cache c : this.caches) {
                    if (c.isClosed()) continue;
                    _caches.add(c);
                }
            }
        }
        return _caches.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.cacheNames.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            for (Cache c : this.caches) {
                c.clear();
            }
        }
    }

    @Override
    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.caches == null) {
                return;
            }
            ArrayList<Throwable> _suppressedExceptions = new ArrayList<Throwable>();
            if (this.caches != null) {
                Futures.WaitForAllFuture<Void> _wait = new Futures.WaitForAllFuture<Void>(new Future[0]);
                for (Cache cache : this.caches) {
                    if (!(cache instanceof InternalCache)) continue;
                    try {
                        Future<Void> f = ((InternalCache)cache).cancelTimerJobs();
                        _wait.add(f);
                    }
                    catch (Throwable t) {
                        _suppressedExceptions.add(t);
                    }
                }
                try {
                    _wait.get(3000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    _suppressedExceptions.add(ex);
                }
                if (!_wait.isDone()) {
                    for (Cache cache : this.caches) {
                        if (!(cache instanceof InternalCache)) continue;
                        InternalCache bc = (InternalCache)cache;
                        try {
                            Future<Void> f = bc.cancelTimerJobs();
                            if (f.isDone()) continue;
                            bc.getLog().info("fetches ongoing, terminating anyway...");
                        }
                        catch (Throwable t) {
                            _suppressedExceptions.add(t);
                        }
                    }
                }
                HashSet<Cache> _caches = new HashSet<Cache>();
                _caches.addAll(this.caches);
                for (Cache c : _caches) {
                    try {
                        c.destroy();
                    }
                    catch (Throwable t) {
                        _suppressedExceptions.add(t);
                    }
                }
                try {
                    for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
                        lc.managerDestroyed(this);
                    }
                    this.caches = null;
                }
                catch (Throwable throwable) {
                    _suppressedExceptions.add(throwable);
                }
            }
            ((Cache2kManagerProviderImpl)provider).removeManager(this);
            this.eventuallyThrowException(_suppressedExceptions);
        }
    }

    private void eventuallyThrowException(List<Throwable> _suppressedExceptions) {
        if (!_suppressedExceptions.isEmpty()) {
            Throwable _throwNow;
            Throwable _error = null;
            for (Throwable t : _suppressedExceptions) {
                if (t instanceof Error) {
                    _error = t;
                }
                if (!(t instanceof ExecutionException) || !(((ExecutionException)t).getCause() instanceof Error)) continue;
                _error = t;
            }
            String _text = "shutdown";
            if (_suppressedExceptions.size() > 1) {
                _text = " (" + _suppressedExceptions.size() + " exceptions)";
            }
            if (_error != null) {
                _throwNow = new CacheInternalError(_text, _error);
            } else {
                _throwNow = new CacheException(_text, _suppressedExceptions.get(0));
                _suppressedExceptions.remove(0);
            }
            for (Throwable t : _suppressedExceptions) {
                if (t == _error) continue;
                _throwNow.addSuppressed(t);
            }
            if (_error != null) {
                throw (Error)_throwNow;
            }
            throw (RuntimeException)_throwNow;
        }
    }

    @Override
    @Deprecated
    public boolean isDestroyed() {
        return this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.caches == null;
    }

    private String getThreadNamePrefix() {
        if (!"default".equals(this.name)) {
            return "cache2k-" + this.name + ":";
        }
        return "cache2k-";
    }

    public Object getLockObject() {
        return this.lock;
    }

    private void checkClosed() {
        if (this.caches == null) {
            throw new IllegalStateException("CacheManager already closed");
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    static {
        ClassLoader cl = CacheManagerImpl.class.getClassLoader();
        for (CacheLifeCycleListener cacheLifeCycleListener : ServiceLoader.load(CacheLifeCycleListener.class, cl)) {
            cacheLifeCycleListeners.add(cacheLifeCycleListener);
        }
        for (CacheManagerLifeCycleListener cacheManagerLifeCycleListener : ServiceLoader.load(CacheManagerLifeCycleListener.class, cl)) {
            cacheManagerLifeCycleListeners.add(cacheManagerLifeCycleListener);
        }
    }

    class ExceptionWrapper
    implements Runnable {
        Runnable runnable;

        ExceptionWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (CacheClosedException cacheClosedException) {
            }
            catch (Throwable t) {
                CacheManagerImpl.this.log.warn("Exception in thread \"" + Thread.currentThread().getName() + "\"", t);
            }
        }
    }

    static class StackTrace
    extends Exception {
        StackTrace() {
        }
    }
}

