/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.cache2k.BulkCacheSource;
import org.cache2k.Cache;
import org.cache2k.CacheBuilder;
import org.cache2k.CacheConfig;
import org.cache2k.CacheManager;
import org.cache2k.CacheSource;
import org.cache2k.CacheSourceWithMetaInfo;
import org.cache2k.ExperimentalBulkCacheSource;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.CacheManagerImpl;
import org.cache2k.impl.InternalCache;
import org.cache2k.impl.RefreshHandler;
import org.cache2k.impl.WiredCache;

public class CacheBuilderImpl<K, T>
extends CacheBuilder<K, T> {
    List<CacheEntryOperationListener<K, T>> syncListeners;

    @Override
    public CacheBuilder<K, T> addListener(CacheEntryOperationListener<K, T> listener) {
        if (this.syncListeners == null) {
            this.syncListeners = new ArrayList<CacheEntryOperationListener<K, T>>();
        }
        this.syncListeners.add(listener);
        return this;
    }

    String deriveNameFromStackTrace() {
        Exception ex = new Exception();
        for (StackTraceElement e : ex.getStackTrace()) {
            if (e.getClassName().startsWith(this.getClass().getPackage().getName())) continue;
            int idx = e.getClassName().lastIndexOf(46);
            String _simpleClassName = e.getClassName().substring(idx + 1);
            String _methodName = e.getMethodName();
            if (_methodName.equals("<init>")) {
                _methodName = "INIT";
            }
            if (_methodName == null || _methodName.length() <= 0) continue;
            return _simpleClassName + "." + _methodName + "" + "." + e.getLineNumber();
        }
        return null;
    }

    Object getConstructorParameter(Class<?> c) {
        if (CacheConfig.class.isAssignableFrom(c)) {
            return this.config;
        }
        if (CacheSource.class.isAssignableFrom(c)) {
            return this.cacheSource;
        }
        if (CacheSourceWithMetaInfo.class.isAssignableFrom(c)) {
            return this.cacheSourceWithMetaInfo;
        }
        if (ExperimentalBulkCacheSource.class.isAssignableFrom(c)) {
            return this.experimentalBulkCacheSource;
        }
        if (BulkCacheSource.class.isAssignableFrom(c)) {
            return this.bulkCacheSource;
        }
        return null;
    }

    Constructor<?> findConstructor(Class<?> c) {
        for (Constructor<?> ctr : c.getConstructors()) {
            Class<?>[] pt = ctr.getParameterTypes();
            if (pt == null || pt.length <= 0 || !CacheConfig.class.isAssignableFrom(pt[0])) continue;
            return ctr;
        }
        return null;
    }

    void confiugreViaSettersDirect(BaseCache c) {
        if (this.cacheSource != null) {
            c.setSource(this.cacheSource);
        }
        if (this.cacheSourceWithMetaInfo != null) {
            c.setSource(this.cacheSourceWithMetaInfo);
        }
        if (this.config.getLoader() != null) {
            c.setLoader(this.config.getLoader());
        }
        if (this.config.getAdvancedLoader() != null) {
            c.setAdvancedLoader(this.config.getAdvancedLoader());
        }
        if (this.exceptionPropagator != null) {
            c.setExceptionPropagator(this.exceptionPropagator);
        }
        if (this.config != null) {
            c.setCacheConfig(this.config);
        }
        if (this.bulkCacheSource != null) {
            c.setBulkCacheSource(this.bulkCacheSource);
        }
        if (this.experimentalBulkCacheSource != null) {
            c.setExperimentalBulkCacheSource(this.experimentalBulkCacheSource);
        }
    }

    void configureViaSetters(Object o) {
        if (o instanceof InternalCache) {
            this.confiugreViaSettersDirect((BaseCache)o);
            return;
        }
        try {
            for (Method m : o.getClass().getMethods()) {
                Object p;
                Class<?>[] ps = m.getParameterTypes();
                if (ps == null || ps.length != 1 || !m.getName().startsWith("set") || (p = this.getConstructorParameter(ps[0])) == null) continue;
                m.invoke(o, p);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to configure cache", ex);
        }
    }

    protected InternalCache<K, T> constructImplementationAndFillParameters(Class<?> cls) {
        if (!InternalCache.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Specified impl not a cache" + cls.getName());
        }
        try {
            InternalCache _cache;
            Constructor<?> ctr = this.findConstructor(cls);
            if (ctr != null) {
                Class<?>[] pt = ctr.getParameterTypes();
                Object[] _args = new Object[pt.length];
                for (int i = 0; i < _args.length; ++i) {
                    _args[i] = this.getConstructorParameter(pt[i]);
                }
                _cache = (InternalCache)ctr.newInstance(_args);
            } else {
                _cache = (InternalCache)cls.newInstance();
            }
            return _cache;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not able to instantiate cache implementation", e);
        }
    }

    @Override
    public Cache<K, T> build() {
        this.config = this.createConfiguration();
        if (this.config.getName() == null) {
            this.config.setName(this.deriveNameFromStackTrace());
        }
        Class _implClass = BaseCache.TUNABLE.defaultImplementation;
        if (this.config.getImplementation() != null) {
            _implClass = this.config.getImplementation();
        }
        InternalCache<K, T> _cache = this.constructImplementationAndFillParameters(_implClass);
        BaseCache bc = (BaseCache)_cache;
        CacheManagerImpl cm = (CacheManagerImpl)(this.manager == null ? CacheManager.getInstance() : this.manager);
        bc.setCacheManager(cm);
        this.configureViaSetters(bc);
        boolean _wrap = false;
        if (this.syncListeners != null) {
            _wrap = true;
        }
        if (this.cacheWriter != null) {
            _wrap = true;
        }
        WiredCache<K, T> wc = null;
        if (_wrap) {
            wc = new WiredCache<K, T>();
            wc.heapCache = bc;
            _cache = wc;
        }
        String _name = cm.newCache(_cache, bc.getName());
        bc.setName(_name);
        if (_wrap) {
            wc.loader = bc.loader;
            if (this.cacheWriter != null) {
                wc.writer = this.cacheWriter;
            }
            if (this.syncListeners != null) {
                ArrayList<CacheEntryCreatedListener> cll = new ArrayList<CacheEntryCreatedListener>();
                ArrayList<CacheEntryUpdatedListener> ull = new ArrayList<CacheEntryUpdatedListener>();
                ArrayList<CacheEntryRemovedListener> rll = new ArrayList<CacheEntryRemovedListener>();
                for (CacheEntryOperationListener<K, T> el : this.syncListeners) {
                    if (el instanceof CacheEntryCreatedListener) {
                        cll.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        ull.add((CacheEntryUpdatedListener)el);
                    }
                    if (!(el instanceof CacheEntryRemovedListener)) continue;
                    rll.add((CacheEntryRemovedListener)el);
                }
                if (!cll.isEmpty()) {
                    wc.syncEntryCreatedListeners = cll.toArray(new CacheEntryCreatedListener[cll.size()]);
                }
                if (!ull.isEmpty()) {
                    wc.syncEntryUpdatedListeners = ull.toArray(new CacheEntryUpdatedListener[ull.size()]);
                }
                if (!rll.isEmpty()) {
                    wc.syncEntryRemovedListeners = rll.toArray(new CacheEntryRemovedListener[rll.size()]);
                }
            }
            bc.listener = wc;
            RefreshHandler rh = RefreshHandler.of(this.config);
            wc.refreshHandler = rh;
            wc.init();
        } else {
            bc.setRefreshHandler(RefreshHandler.of(this.config));
            bc.init();
        }
        return _cache;
    }
}

