/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.impl.BaseCache;
import org.cache2k.impl.Entry;
import org.cache2k.impl.Hash;
import org.cache2k.impl.IntegrityState;

public class ArcCache<K, V>
extends BaseCache<K, V> {
    int arcP = 0;
    Hash<Entry> b1HashCtrl;
    Entry[] b1Hash;
    Hash<Entry> b2HashCtrl;
    Entry[] b2Hash;
    long t2Hit;
    long t1Hit;
    int t1Size = 0;
    Entry<K, V> t2Head;
    Entry<K, V> t1Head;
    Entry<K, V> b1Head;
    Entry<K, V> b2Head;
    boolean b2HitPreferenceForEviction;

    @Override
    public long getHitCnt() {
        return this.t2Hit + this.t1Hit;
    }

    @Override
    protected void recordHit(Entry e0) {
        ArcEntry e = (ArcEntry)e0;
        ArcCache.moveToFront(this.t2Head, e);
        if (e.withinT2) {
            ++this.t2Hit;
        } else {
            e.withinT2 = true;
            ++this.t1Hit;
            --this.t1Size;
        }
    }

    @Override
    protected void insertIntoReplacementList(Entry e0) {
        ArcEntry e = (ArcEntry)e0;
        ArcCache.insertInList(this.t1Head, e);
        ++this.t1Size;
    }

    @Override
    protected Entry<K, V> newEntry() {
        return new ArcEntry();
    }

    @Override
    protected Entry checkForGhost(K key, int hc) {
        Entry e = this.b1HashCtrl.remove(this.b1Hash, key, hc);
        if (e != null) {
            ArcCache.removeFromList(e);
            this.b1HitAdaption();
            this.insertT2(e);
            return e;
        }
        e = this.b2HashCtrl.remove(this.b2Hash, key, hc);
        if (e != null) {
            ArcCache.removeFromList(e);
            this.b2HitAdaption();
            this.insertT2(e);
            return e;
        }
        this.allMissEvictGhosts();
        return null;
    }

    @Override
    protected void removeEntryFromReplacementList(Entry e0) {
        ArcEntry e = (ArcEntry)e0;
        if (!e.withinT2) {
            --this.t1Size;
        }
        super.removeEntryFromReplacementList(e);
        e.withinT2 = false;
    }

    private void b1HitAdaption() {
        int _b1Size = this.b1HashCtrl.size + 1;
        int _b2Size = this.b2HashCtrl.size;
        int _delta = _b1Size >= _b2Size ? 1 : _b2Size / _b1Size;
        this.arcP = Math.min(this.arcP + _delta, this.maxSize);
        this.b2HitPreferenceForEviction = false;
    }

    private void b2HitAdaption() {
        int _b2Size = this.b2HashCtrl.size + 1;
        int _b1Size = this.b1HashCtrl.size;
        int _delta = _b2Size >= _b1Size ? 1 : _b1Size / _b2Size;
        this.arcP = Math.max(this.arcP - _delta, 0);
        this.b2HitPreferenceForEviction = true;
    }

    private void insertT2(Entry<K, V> e0) {
        ArcEntry e = (ArcEntry)e0;
        e.withinT2 = true;
        ArcCache.insertInList(this.t2Head, e);
    }

    int getT2Size() {
        return this.getLocalSize() - this.t1Size;
    }

    Entry cloneGhost(Entry e) {
        ArcEntry e2 = new ArcEntry();
        e2.hashCode = e.hashCode;
        e2.key = e.key;
        return e2;
    }

    private void allMissEvictGhosts() {
        if (this.t1Size + this.b1HashCtrl.size >= this.maxSize) {
            if (this.b1HashCtrl.size > 0) {
                Entry e = this.b1Head.prev;
                ArcCache.removeFromList(e);
                boolean bl = this.b1HashCtrl.remove(this.b1Hash, e);
            } else if (this.b2HashCtrl.size >= this.maxSize) {
                Entry e = this.b2Head.prev;
                ArcCache.removeFromList(e);
                boolean bl = this.b2HashCtrl.remove(this.b2Hash, e);
            }
        } else {
            int _totalCnt = this.b1HashCtrl.size + this.b2HashCtrl.size;
            if (_totalCnt >= this.maxSize) {
                if (this.b2HashCtrl.size == 0) {
                    Entry e = this.b1Head.prev;
                    ArcCache.removeFromList(e);
                    boolean f = this.b1HashCtrl.remove(this.b1Hash, e);
                    return;
                }
                Entry e = this.b2Head.prev;
                ArcCache.removeFromList(e);
                boolean bl = this.b2HashCtrl.remove(this.b2Hash, e);
            }
        }
    }

    @Override
    protected Entry findEvictionCandidate() {
        Entry e = this.b2HitPreferenceForEviction ? this.replaceB2Hit() : this.replace();
        if (this.b1HashCtrl.size + this.b2HashCtrl.size > this.maxSize) {
            this.allMissEvictGhosts();
        }
        return e;
    }

    private Entry replace() {
        return this.replace(this.t1Size > this.arcP || this.getT2Size() == 0);
    }

    private Entry replaceB2Hit() {
        return this.replace(this.t1Size >= this.arcP && this.t1Size > 0 || this.getT2Size() == 0);
    }

    private Entry<K, V> replace(boolean _fromT1) {
        Entry e;
        if (_fromT1) {
            e = this.t1Head.prev;
            Entry e2 = this.cloneGhost(e);
            ArcCache.insertInList(this.b1Head, e2);
            this.b1Hash = this.b1HashCtrl.insert(this.b1Hash, e2);
        } else {
            e = this.t2Head.prev;
            Entry e2 = this.cloneGhost(e);
            ArcCache.insertInList(this.b2Head, e2);
            this.b2Hash = this.b2HashCtrl.insert(this.b2Hash, e2);
        }
        return e;
    }

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.t1Size = 0;
        this.b1HashCtrl = new Hash();
        this.b2HashCtrl = new Hash();
        this.b1Hash = this.b1HashCtrl.init(Entry.class);
        this.b2Hash = this.b2HashCtrl.init(Entry.class);
        this.t1Head = new Entry().shortCircuit();
        this.t2Head = new Entry().shortCircuit();
        this.b1Head = new Entry().shortCircuit();
        this.b2Head = new Entry().shortCircuit();
    }

    final int getListEntryCount() {
        return ArcCache.getListEntryCount(this.t1Head) + ArcCache.getListEntryCount(this.t2Head);
    }

    @Override
    protected String getExtraStatistics() {
        return ", arcP=" + this.arcP + ", " + "t1Size=" + this.t1Size + ", " + "t2Size=" + (this.mainHashCtrl.size - this.t1Size) + ", " + "b1Size=" + this.b1HashCtrl.size + ", " + "b2Size=" + this.b2HashCtrl.size;
    }

    @Override
    protected IntegrityState getIntegrityState() {
        return super.getIntegrityState().check("getSize() == getHashEntryCount()", this.getLocalSize() == this.calculateHashEntryCount()).check("getSize() == getListEntryCount()", this.getLocalSize() == this.getListEntryCount()).checkEquals("t1Size == getListEntryCount(t1Head)", this.t1Size, ArcCache.getListEntryCount(this.t1Head)).checkEquals("getSize() - t1Size == getListEntryCount(t2Head)", this.getLocalSize() - this.t1Size, ArcCache.getListEntryCount(this.t2Head)).checkLessOrEquals("b1HashCtrl.size + b2HashCtrl.size <= maxSize", this.b1HashCtrl.size + this.b2HashCtrl.size, this.maxSize).checkEquals("b1HashCtrl.size == getListEntryCount(b1Head)", this.b1HashCtrl.size, ArcCache.getListEntryCount(this.b1Head)).checkEquals("b2HashCtrl.size == getListEntryCount(b2Head)", this.b2HashCtrl.size, ArcCache.getListEntryCount(this.b2Head));
    }

    protected static class ArcEntry<K, T>
    extends Entry<K, T> {
        boolean withinT2;

        protected ArcEntry() {
        }
    }
}

