/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.CacheEntry;
import org.cache2k.CustomizationException;
import org.cache2k.impl.CacheInternalError;
import org.cache2k.impl.ConcurrentMapWrapper;
import org.cache2k.impl.Entry;
import org.cache2k.impl.EntryAction;
import org.cache2k.impl.InternalCache;
import org.cache2k.impl.operation.Semantic;
import org.cache2k.processor.CacheEntryProcessor;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.storageApi.StorageAdapter;

public abstract class AbstractCache<K, V>
implements InternalCache<K, V> {
    @Override
    public void removeAllAtOnce(Set<K> _keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        for (CacheEntry e : this) {
            this.remove(e.getKey());
        }
    }

    @Override
    public void removeAll(Iterable<? extends K> _keys) {
        for (K k : _keys) {
            this.remove(k);
        }
    }

    @Override
    public <X> X requestInterface(Class<X> _type) {
        if (_type.equals(ConcurrentMap.class) || _type.equals(Map.class)) {
            return (X)new ConcurrentMapWrapper(this);
        }
        if (_type.equals(InternalCache.class)) {
            return (X)this;
        }
        return null;
    }

    @Override
    public StorageAdapter getStorage() {
        return null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void purge() {
    }

    @Override
    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, CacheEntryProcessor<K, V, R> entryProcessor, Object ... objs) {
        HashMap m = new HashMap();
        for (K k : keys) {
            try {
                final R _result = this.invoke(k, entryProcessor, objs);
                if (_result == null) continue;
                m.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        return _result;
                    }

                    @Override
                    public Throwable getException() {
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                m.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        return null;
                    }

                    @Override
                    public Throwable getException() {
                        return t;
                    }
                });
            }
        }
        return m;
    }

    protected <R> R execute(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction<K, V, R> _action = this.createEntryAction(key, e, op);
        return this.execute(op, _action);
    }

    protected abstract <R> EntryAction<K, V, R> createEntryAction(K var1, Entry<K, V> var2, Semantic<K, V, R> var3);

    protected <R> R execute(Semantic<K, V, R> op, EntryAction<K, V, R> _action) {
        op.start(_action);
        if (_action.entryLocked) {
            throw new CacheInternalError("entry not unlocked?");
        }
        CustomizationException t = _action.exceptionToPropagate;
        if (t != null) {
            t.fillInStackTrace();
            throw t;
        }
        return _action.result;
    }

    protected <R> R execute(K key, Semantic<K, V, R> op) {
        return this.execute(key, null, op);
    }

    @Override
    public void prefetch(List<? extends K> keys, int _startIndex, int _endIndexExclusive) {
        this.prefetch((Iterable<? extends K>)keys.subList(_startIndex, _endIndexExclusive));
    }

    @Override
    public void prefetch(Iterable<? extends K> keys) {
        this.prefetchAll(keys);
    }
}

