// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.tesseract;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.leptonica.*;
import static org.bytedeco.leptonica.global.lept.*;

import static org.bytedeco.tesseract.global.tesseract.*;


@NoOffset @Properties(inherit = org.bytedeco.tesseract.presets.tesseract.class)
public class STRING extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public STRING(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public STRING(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public STRING position(long position) {
        return (STRING)super.position(position);
    }
    @Override public STRING getPointer(long i) {
        return new STRING(this).position(position + i);
    }

  public STRING() { super((Pointer)null); allocate(); }
  private native void allocate();
  public STRING(@Const @ByRef STRING string) { super((Pointer)null); allocate(string); }
  private native void allocate(@Const @ByRef STRING string);
  public STRING(@Cast("const char*") BytePointer string) { super((Pointer)null); allocate(string); }
  private native void allocate(@Cast("const char*") BytePointer string);
  public STRING(String string) { super((Pointer)null); allocate(string); }
  private native void allocate(String string);
  public STRING(@Cast("const char*") BytePointer data, int length) { super((Pointer)null); allocate(data, length); }
  private native void allocate(@Cast("const char*") BytePointer data, int length);
  public STRING(String data, int length) { super((Pointer)null); allocate(data, length); }
  private native void allocate(String data, int length);

  // Writes to the given file. Returns false in case of error.
  public native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp);
  // Reads from the given file. Returns false in case of error.
  // If swap is true, assumes a big/little-endian swap is needed.
  public native @Cast("bool") boolean DeSerialize(@Cast("bool") boolean swap, @Cast("FILE*") Pointer fp);
  // Writes to the given file. Returns false in case of error.
  public native @Cast("bool") boolean Serialize(TFile fp);
  // Reads from the given file. Returns false in case of error.
  // If swap is true, assumes a big/little-endian swap is needed.
  public native @Cast("bool") boolean DeSerialize(TFile fp);
  // As DeSerialize, but only seeks past the data - hence a static method.
  public static native @Cast("bool") boolean SkipDeSerialize(TFile fp);

  public native @Cast("bool") boolean contains(@Cast("char") byte c);
  public native int length();
  public native int size();
  // Workaround to avoid g++ -Wsign-compare warnings.
  public native @Cast("uint32_t") int unsigned_size();
  public native @Cast("const char*") BytePointer string();
  public native @Cast("const char*") BytePointer c_str();

  public native @Cast("char*") BytePointer strdup();

// #if STRING_IS_PROTECTED
// #else
  public native @Cast("char*") @ByRef @Name("operator []") BytePointer get(int index);
// #endif
  public native void split(@Cast("char") byte c, StringGenericVector splited);
  public native void truncate_at(int index);

  public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef STRING string);
  public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef STRING string);
  public native @Cast("bool") @Name("operator !=") boolean notEquals(@Cast("const char*") BytePointer string);
  public native @Cast("bool") @Name("operator !=") boolean notEquals(String string);

  public native @ByRef @Name("operator =") STRING put(@Cast("const char*") BytePointer string);
  public native @ByRef @Name("operator =") STRING put(String string);
  public native @ByRef @Name("operator =") STRING put(@Const @ByRef STRING string);

  public native @ByVal @Name("operator +") STRING add(@Const @ByRef STRING string);
  public native @ByVal @Name("operator +") STRING add(@Cast("char") byte ch);

  public native @ByRef @Name("operator +=") STRING addPut(@Cast("const char*") BytePointer string);
  public native @ByRef @Name("operator +=") STRING addPut(String string);
  public native @ByRef @Name("operator +=") STRING addPut(@Const @ByRef STRING string);
  public native @ByRef @Name("operator +=") STRING addPut(@Cast("char") byte ch);

  // Assignment for strings which are not null-terminated.
  public native void assign(@Cast("const char*") BytePointer cstr, int len);
  public native void assign(String cstr, int len);

  // Appends the given string and int (as a %d) to this.
  // += cannot be used for ints as there as a char += operator that would
  // be ambiguous, and ints usually need a string before or between them
  // anyway.
  public native void add_str_int(@Cast("const char*") BytePointer str, int number);
  public native void add_str_int(String str, int number);
  // Appends the given string and double (as a %.8g) to this.
  public native void add_str_double(@Cast("const char*") BytePointer str, double number);
  public native void add_str_double(String str, double number);

  // ensure capacity but keep pointer encapsulated
  public native void ensure(int min_capacity);
}
