/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorrt.presets;

import java.util.List;
import org.bytedeco.cuda.presets.cublas;
import org.bytedeco.cuda.presets.cudnn;
import org.bytedeco.cuda.presets.nvrtc;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;

@Properties(inherit={cublas.class, cudnn.class, nvrtc.class}, value={@Platform(value={"linux-arm64", "linux-ppc64le", "linux-x86_64", "windows-x86_64"}, compiler={"cpp11"}, include={"NvInferVersion.h", "NvInferRuntimeBase.h", "NvInferRuntimePlugin.h", "NvInferRuntimeCommon.h", "NvInferLegacyDims.h", "NvInferRuntime.h", "NvInfer.h", "NvInferImpl.h", "NvUtils.h"}, link={"nvinfer@.8"}, preload={"nvinfer_builder_resource@.8.6.1"}), @Platform(value={"linux-arm64"}, includepath={"/usr/include/aarch64-linux-gnu/", "/usr/local/tensorrt/include/"}, linkpath={"/usr/lib/aarch64-linux-gnu/", "/usr/local/tensorrt/lib/"}), @Platform(value={"linux-ppc64le"}, includepath={"/usr/include/powerpc64le-linux-gnu/", "/usr/local/tensorrt/include/"}, linkpath={"/usr/lib/powerpc64le-linux-gnu/", "/usr/local/tensorrt/lib/"}), @Platform(value={"linux-x86_64"}, includepath={"/usr/include/x86_64-linux-gnu/", "/usr/local/tensorrt/include/"}, linkpath={"/usr/lib/x86_64-linux-gnu/", "/usr/local/tensorrt/lib/"}), @Platform(value={"windows-x86_64"}, includepath={"C:/Program Files/NVIDIA GPU Computing Toolkit/TensorRT/include"}, linkpath={"C:/Program Files/NVIDIA GPU Computing Toolkit/TensorRT/lib/"})}, target="org.bytedeco.tensorrt.nvinfer", global="org.bytedeco.tensorrt.global.nvinfer")
public class nvinfer
implements LoadEnabled,
InfoMapper {
    public void init(ClassProperties properties) {
        String[] libs;
        String platform = properties.getProperty("platform");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        if (!Loader.isLoadLibraries()) {
            return;
        }
        int i = 0;
        if (platform.startsWith("windows")) {
            preloads.add(i++, "zlibwapi");
        }
        for (String lib : libs = new String[]{"cudart", "cublasLt", "cublas", "cudnn", "nvrtc", "cudnn_ops_infer", "cudnn_ops_train", "cudnn_adv_infer", "cudnn_adv_train", "cudnn_cnn_infer", "cudnn_cnn_train"}) {
            if (platform.startsWith("linux")) {
                lib = lib + (lib.startsWith("cudnn") ? "@.8" : (lib.equals("cudart") ? "@.12" : (lib.equals("nvrtc") ? "@.12" : "@.12")));
            } else {
                if (!platform.startsWith("windows")) continue;
                lib = lib + (lib.startsWith("cudnn") ? "64_8" : (lib.equals("cudart") ? "64_12" : (lib.equals("nvrtc") ? "64_120_0" : "64_12")));
            }
            if (preloads.contains(lib)) continue;
            preloads.add(i++, lib);
        }
        if (i > 0) {
            resources.add("/org/bytedeco/cuda/");
        }
    }

    public void map(InfoMap infoMap) {
        infoMap.put(new Info().enumerate()).put(new Info(new String[]{"NV_TENSORRT_FINAL", "_TENSORRT_FINAL", "_TENSORRT_OVERRIDE", "TENSORRTAPI"}).cppTypes(new String[0]).annotations(new String[0])).put(new Info(new String[]{"NV_TENSORRT_VERSION"}).translate(false)).put(new Info(new String[]{"TRT_DEPRECATED"}).cppText("#define TRT_DEPRECATED deprecated").cppTypes(new String[0])).put(new Info(new String[]{"TRT_DEPRECATED_API"}).cppText("#define TRT_DEPRECATED_API deprecated").cppTypes(new String[0])).put(new Info(new String[]{"deprecated"}).annotations(new String[]{"@Deprecated"})).put(new Info(new String[]{"std::size_t"}).cast().valueTypes(new String[]{"long"}).pointerTypes(new String[]{"LongPointer", "LongBuffer", "long[]"})).put(new Info(new String[]{"const char", "nvinfer1::AsciiChar"}).pointerTypes(new String[]{"String", "@Cast(\"const char*\") BytePointer"})).put(new Info(new String[]{"nvinfer1::IErrorRecorder::ErrorDesc"}).valueTypes(new String[]{"String", "@Cast(\"const char*\") BytePointer"})).put(new Info(new String[]{"nvinfer1::PluginFormat"}).cast().valueTypes(new String[]{"TensorFormat", "int"}).pointerTypes(new String[]{"IntPointer", "IntBuffer", "int[]"})).put(new Info(new String[]{"nvinfer1::safe::IPluginRegistry"}).pointerTypes(new String[]{"SafeIPluginRegistry"})).put(new Info(new String[]{"nvinfer1::EnumMax", "nvinfer1::EnumMaxImpl"}).skip()).put(new Info(new String[]{"nvinfer1::Weights::values"}).javaText("public native @Const Pointer values(); public native Weights values(Pointer values);")).put(new Info(new String[]{"nvinfer1::IDimensionExpr", "nvinfer1::IExprBuilder", "nvinfer1::IOptimizationProfile", "nvinfer1::ITensor", "nvinfer1::ILayer", "nvinfer1::IConvolutionLayer", "nvinfer1::IFullyConnectedLayer", "nvinfer1::IActivationLayer", "nvinfer1::IPoolingLayer", "nvinfer1::ILRNLayer", "nvinfer1::IScaleLayer", "nvinfer1::IPluginV2Layer", "nvinfer1::IUnaryLayer", "nvinfer1::IReduceLayer", "nvinfer1::IPaddingLayer", "nvinfer1::IRaggedSoftMaxLayer", "nvinfer1::IIdentityLayer", "nvinfer1::ISoftMaxLayer", "nvinfer1::IConcatenationLayer", "nvinfer1::IDeconvolutionLayer", "nvinfer1::IElementWiseLayer", "nvinfer1::IGatherLayer", "nvinfer1::IRNNv2Layer", "nvinfer1::IIteratorLayer", "nvinfer1::IParametricReLULayer", "nvinfer1::IShuffleLayer", "nvinfer1::ISliceLayer", "nvinfer1::IShapeLayer", "nvinfer1::ITopKLayer", "nvinfer1::IMatrixMultiplyLayer", "nvinfer1::ISelectLayer", "nvinfer1::IConstantLayer", "nvinfer1::IResizeLayer", "nvinfer1::ILoop", "nvinfer1::ILoopBoundaryLayer", "nvinfer1::ILoopOutputLayer", "nvinfer1::IRecurrenceLayer", "nvinfer1::ITripLimitLayer", "nvinfer1::IFillLayer", "nvinfer1::IQuantizeLayer", "nvinfer1::IDequantizeLayer", "nvinfer1::IAssertionLayer", "nvinfer1::IConditionLayer", "nvinfer1::IEinsumLayer", "nvinfer1::IIfConditional", "nvinfer1::IIfConditionalBoundaryLayer", "nvinfer1::IIfConditionalInputLayer", "nvinfer1::IIfConditionalOutputLayer", "nvinfer1::IScatterLayer", "nvinfer1::IAlgorithmIOInfo", "nvinfer1::IAlgorithmVariant", "nvinfer1::IAlgorithmContext", "nvinfer1::IAlgorithm", "nvinfer1::ICastLayer", "nvinfer1::IGridSampleLayer", "nvinfer1::INMSLayer", "nvinfer1::INonZeroLayer", "nvinfer1::INormalizationLayer", "nvinfer1::IReverseSequenceLayer"}).purify()).put(new Info(new String[]{"nvinfer1::IGpuAllocator::free"}).javaNames(new String[]{"_free"})).put(new Info(new String[]{"nvinfer1::IGpuAllocator", "nvinfer1::IProfiler", "nvinfer1::ILogger", "nvinfer1::IInt8Calibrator", "nvinfer1::IInt8EntropyCalibrator", "nvinfer1::IInt8EntropyCalibrator2", "nvinfer1::IInt8MinMaxCalibrator", "nvinfer1::IInt8LegacyCalibrator"}).virtualize()).put(new Info(new String[]{"nvinfer1::IPluginRegistry::getPluginCreatorList"}).javaText("public native @Cast(\"nvinfer1::IPluginCreator*const*\") PointerPointer getPluginCreatorList(IntPointer numCreators);"));
    }

    static {
        Loader.checkVersion((String)"org.bytedeco", (String)"tensorrt");
    }
}

