/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorrt.nvonnxparser;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.tensorrt.nvonnxparser.SubGraph_t;
import org.bytedeco.tensorrt.presets.nvonnxparser;

@Name(value={"std::vector<SubGraph_t>"})
@Properties(inherit={nvonnxparser.class})
public class SubGraphCollection_t
extends Pointer {
    public SubGraphCollection_t(Pointer p) {
        super(p);
    }

    public SubGraphCollection_t(SubGraph_t value) {
        this(1L);
        this.put(0L, value);
    }

    public SubGraphCollection_t(SubGraph_t ... array) {
        this(array.length);
        this.put(array);
    }

    public SubGraphCollection_t() {
        this.allocate();
    }

    public SubGraphCollection_t(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native SubGraphCollection_t put(@ByRef SubGraphCollection_t var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public SubGraph_t front() {
        return this.get(0L);
    }

    public SubGraph_t back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native SubGraph_t get(@Cast(value={"size_t"}) long var1);

    public native SubGraphCollection_t put(@Cast(value={"size_t"}) long var1, SubGraph_t var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef SubGraph_t var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public SubGraph_t[] get() {
        SubGraph_t[] array = new SubGraph_t[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public SubGraph_t pop_back() {
        long size = this.size();
        SubGraph_t value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public SubGraphCollection_t push_back(SubGraph_t value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public SubGraphCollection_t put(SubGraph_t value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public SubGraphCollection_t put(SubGraph_t ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native SubGraph_t get();
    }
}

