// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvparsers;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;
import org.bytedeco.tensorrt.nvinfer.*;
import static org.bytedeco.tensorrt.global.nvinfer.*;
import org.bytedeco.tensorrt.nvinfer_plugin.*;
import static org.bytedeco.tensorrt.global.nvinfer_plugin.*;

import static org.bytedeco.tensorrt.global.nvparsers.*;

/**
 *  \class ICaffeParser
 * 
 *  \brief Class used for parsing Caffe models.
 * 
 *  Allows users to export models trained using Caffe to TRT.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvcaffeparser1") @Properties(inherit = org.bytedeco.tensorrt.presets.nvparsers.class)
public class ICaffeParser extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ICaffeParser(Pointer p) { super(p); }

    /**
     *  \brief Parse a prototxt file and a binaryproto Caffe model to extract
     *    network definition and weights associated with the network, respectively.
     * 
     *  @param deploy The plain text, prototxt file used to define the network definition.
     *  @param model The binaryproto Caffe model that contains the weights associated with the network.
     *  @param network Network in which the CaffeParser will fill the layers.
     *  @param weightType The type to which the weights will transformed.
     * 
     *  @return A pointer to an IBlobNameToTensor object that contains the extracted data.
     * 
     *  @see nvcaffeparser1::IBlobNameToTensor
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Const @NoException(true) IBlobNameToTensor parse(String deploy, String model, @ByRef INetworkDefinition network,
            DataType weightType);
    public native @Const @NoException(true) IBlobNameToTensor parse(@Cast("const char*") BytePointer deploy, @Cast("const char*") BytePointer model, @ByRef INetworkDefinition network,
            @Cast("nvinfer1::DataType") int weightType);

    /**
     *  \brief Parse a deploy prototxt and a binaryproto Caffe model from memory buffers to extract
     *    network definition and weights associated with the network, respectively.
     * 
     *  @param deployBuffer The plain text deploy prototxt used to define the network definition.
     *  @param deployLength The length of the deploy buffer.
     *  @param modelBuffer The binaryproto Caffe memory buffer that contains the weights associated with the network.
     *  @param modelLength The length of the model buffer.
     *  @param network Network in which the CaffeParser will fill the layers.
     *  @param weightType The type to which the weights will transformed.
     * 
     *  @return A pointer to an IBlobNameToTensor object that contains the extracted data.
     * 
     *  @see nvcaffeparser1::IBlobNameToTensor
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Const @NoException(true) IBlobNameToTensor parseBuffers(@Cast("const uint8_t*") BytePointer deployBuffer, @Cast("std::size_t") long deployLength,
            @Cast("const uint8_t*") BytePointer modelBuffer, @Cast("std::size_t") long modelLength, @ByRef INetworkDefinition network,
            DataType weightType);
    public native @Const @NoException(true) IBlobNameToTensor parseBuffers(@Cast("const uint8_t*") ByteBuffer deployBuffer, @Cast("std::size_t") long deployLength,
            @Cast("const uint8_t*") ByteBuffer modelBuffer, @Cast("std::size_t") long modelLength, @ByRef INetworkDefinition network,
            @Cast("nvinfer1::DataType") int weightType);
    public native @Const @NoException(true) IBlobNameToTensor parseBuffers(@Cast("const uint8_t*") byte[] deployBuffer, @Cast("std::size_t") long deployLength,
            @Cast("const uint8_t*") byte[] modelBuffer, @Cast("std::size_t") long modelLength, @ByRef INetworkDefinition network,
            DataType weightType);
    public native @Const @NoException(true) IBlobNameToTensor parseBuffers(@Cast("const uint8_t*") BytePointer deployBuffer, @Cast("std::size_t") long deployLength,
            @Cast("const uint8_t*") BytePointer modelBuffer, @Cast("std::size_t") long modelLength, @ByRef INetworkDefinition network,
            @Cast("nvinfer1::DataType") int weightType);
    public native @Const @NoException(true) IBlobNameToTensor parseBuffers(@Cast("const uint8_t*") ByteBuffer deployBuffer, @Cast("std::size_t") long deployLength,
            @Cast("const uint8_t*") ByteBuffer modelBuffer, @Cast("std::size_t") long modelLength, @ByRef INetworkDefinition network,
            DataType weightType);
    public native @Const @NoException(true) IBlobNameToTensor parseBuffers(@Cast("const uint8_t*") byte[] deployBuffer, @Cast("std::size_t") long deployLength,
            @Cast("const uint8_t*") byte[] modelBuffer, @Cast("std::size_t") long modelLength, @ByRef INetworkDefinition network,
            @Cast("nvinfer1::DataType") int weightType);

    /**
     *  \brief Parse and extract data stored in binaryproto file.
     * 
     *  The binaryproto file contains data stored in a binary blob. parseBinaryProto() converts it
     *  to an IBinaryProtoBlob object which gives the user access to the data and meta-data about data.
     * 
     *  @param fileName Path to file containing binary proto.
     * 
     *  @return A pointer to an IBinaryProtoBlob object that contains the extracted data.
     * 
     *  @see nvcaffeparser1::IBinaryProtoBlob
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) IBinaryProtoBlob parseBinaryProto(String fileName);
    public native @NoException(true) IBinaryProtoBlob parseBinaryProto(@Cast("const char*") BytePointer fileName);

    /**
     *  \brief Set buffer size for the parsing and storage of the learned model.
     * 
     *  @param size The size of the buffer specified as the number of bytes.
     * 
     *  \note  Default size is 2^30 bytes.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void setProtobufBufferSize(@Cast("size_t") long size);

    /**
     *  \brief Destroy this ICaffeParser object.
     * 
     *  @deprecated Deprecated in TensorRT 8.0. Superseded by {@code delete}.
     * 
     *  \warning Calling destroy on a managed pointer will result in a double-free error.
     *  */
    
    
    //!
    //!
    //!
    public native @Deprecated @NoException(true) void destroy();

    /**
     *  \brief Set the IPluginFactoryV2 used to create the user defined pluginV2 objects.
     * 
     *  @param factory Pointer to an instance of the user implementation of IPluginFactoryV2.
     *  */
    
    
    //!
    //!
    public native @NoException(true) void setPluginFactoryV2(IPluginFactoryV2 factory);

    /**
     *  \brief Set the namespace used to lookup and create plugins in the network.
     *  */
    public native @NoException(true) void setPluginNamespace(String libNamespace);
    public native @NoException(true) void setPluginNamespace(@Cast("const char*") BytePointer libNamespace);
    /**
     *  \brief Set the ErrorRecorder for this interface
     * 
     *  Assigns the ErrorRecorder to this interface. The ErrorRecorder will track all errors during execution.
     *  This function will call incRefCount of the registered ErrorRecorder at least once. Setting
     *  recorder to nullptr unregisters the recorder with the interface, resulting in a call to decRefCount if
     *  a recorder has been registered.
     * 
     *  If an error recorder is not set, messages will be sent to the global log stream.
     * 
     *  @param recorder The error recorder to register with this interface.
     * 
     *  @see getErrorRecorder()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setErrorRecorder(IErrorRecorder recorder);

    /**
     *  \brief get the ErrorRecorder assigned to this interface.
     * 
     *  Retrieves the assigned error recorder object for the given class. A
     *  nullptr will be returned if setErrorRecorder has not been called.
     * 
     *  @return A pointer to the IErrorRecorder object that has been registered.
     * 
     *  @see setErrorRecorder()
     *  */
    public native @NoException(true) IErrorRecorder getErrorRecorder();
}
