// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer_plugin;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;
import org.bytedeco.tensorrt.nvinfer.*;
import static org.bytedeco.tensorrt.global.nvinfer.*;

import static org.bytedeco.tensorrt.global.nvinfer_plugin.*;


/**
 *  \brief The Region plugin layer performs region proposal calculation: generate 5 bounding boxes per cell (for yolo9000, generate 3 bounding boxes per cell).
 *  For each box, calculating its probablities of objects detections from 80 pre-defined classifications (yolo9000 has 9418 pre-defined classifications,
 *  and these 9418 items are organized as work-tree structure).
 *  RegionParameters defines a set of parameters for creating the Region plugin layer.
 *  @param num Number of predicted bounding box for each grid cell.
 *  @param coords Number of coordinates for a bounding box.
 *  @param classes Number of classifications to be predicted.
 *  @param smTree Helping structure to do softmax on confidence scores.
 *  */
@Namespace("nvinfer1::plugin") @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer_plugin.class)
public class RegionParameters extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public RegionParameters() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public RegionParameters(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RegionParameters(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public RegionParameters position(long position) {
        return (RegionParameters)super.position(position);
    }
    @Override public RegionParameters getPointer(long i) {
        return new RegionParameters((Pointer)this).offsetAddress(i);
    }

    public native int num(); public native RegionParameters num(int setter);
    public native int coords(); public native RegionParameters coords(int setter);
    public native int classes(); public native RegionParameters classes(int setter);
    public native softmaxTree smTree(); public native RegionParameters smTree(softmaxTree setter);
}
