// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


@Namespace("nvinfer1::apiv") @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class VExecutionContext extends VRoot {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VExecutionContext(Pointer p) { super(p); }

    public native @Cast("bool") @NoException(true) boolean execute(int batchSize, @Cast("void*const*") PointerPointer bindings);
    public native @Cast("bool") @NoException(true) boolean execute(int batchSize, @Cast("void*const*") @ByPtrPtr Pointer bindings);
    public native @Cast("bool") @NoException(true) boolean enqueue(
            int batchSize, @Cast("void*const*") PointerPointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);
    public native @Cast("bool") @NoException(true) boolean enqueue(
            int batchSize, @Cast("void*const*") @ByPtrPtr Pointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);
    public native @NoException(true) void setDebugSync(@Cast("bool") boolean sync);
    public native @Cast("bool") @NoException(true) boolean getDebugSync();
    public native @NoException(true) void setProfiler(IProfiler arg0);
    public native @NoException(true) IProfiler getProfiler();
    public native @Const @ByRef @NoException(true) ICudaEngine getEngine();
    public native @NoException(true) void setName(String name);
    public native @NoException(true) void setName(@Cast("const char*") BytePointer name);
    public native @NoException(true) String getName();
    public native @NoException(true) void setDeviceMemory(Pointer memory);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getStrides(int bindingIndex);
    public native @Cast("bool") @NoException(true) boolean setOptimizationProfile(int profileIndex);
    public native @NoException(true) int getOptimizationProfile();
    public native @Cast("bool") @NoException(true) boolean setBindingDimensions(int bindingIndex, @ByVal @Cast("nvinfer1::Dims*") Dims32 dimensions);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getBindingDimensions(int bindingIndex);
    public native @Cast("bool") @NoException(true) boolean setInputShapeBinding(int bindingIndex, @Const IntPointer data);
    public native @Cast("bool") @NoException(true) boolean setInputShapeBinding(int bindingIndex, @Const IntBuffer data);
    public native @Cast("bool") @NoException(true) boolean setInputShapeBinding(int bindingIndex, @Const int[] data);
    public native @Cast("bool") @NoException(true) boolean getShapeBinding(int bindingIndex, IntPointer data);
    public native @Cast("bool") @NoException(true) boolean getShapeBinding(int bindingIndex, IntBuffer data);
    public native @Cast("bool") @NoException(true) boolean getShapeBinding(int bindingIndex, int[] data);
    public native @Cast("bool") @NoException(true) boolean allInputDimensionsSpecified();
    public native @Cast("bool") @NoException(true) boolean allInputShapesSpecified();
    public native @NoException(true) void setErrorRecorder(IErrorRecorder recorder);
    public native @NoException(true) IErrorRecorder getErrorRecorder();
    public native @Cast("bool") @NoException(true) boolean executeV2(@Cast("void*const*") PointerPointer bindings);
    public native @Cast("bool") @NoException(true) boolean executeV2(@Cast("void*const*") @ByPtrPtr Pointer bindings);
    public native @Cast("bool") @NoException(true) boolean enqueueV2(@Cast("void*const*") PointerPointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);
    public native @Cast("bool") @NoException(true) boolean enqueueV2(@Cast("void*const*") @ByPtrPtr Pointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);
    public native @Cast("bool") @NoException(true) boolean setOptimizationProfileAsync(int profileIndex, CUstream_st stream);
    public native @NoException(true) void setEnqueueEmitsProfile(@Cast("bool") boolean enqueueEmitsProfile);
    public native @Cast("bool") @NoException(true) boolean getEnqueueEmitsProfile();
    public native @Cast("bool") @NoException(true) boolean reportToProfiler();
    public native @Cast("bool") @NoException(true) boolean setInputShape(String tensorName, @Cast("const nvinfer1::Dims*") @ByRef Dims32 dims);
    public native @Cast("bool") @NoException(true) boolean setInputShape(@Cast("const char*") BytePointer tensorName, @Cast("const nvinfer1::Dims*") @ByRef Dims32 dims);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorShape(String tensorName);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorShape(@Cast("const char*") BytePointer tensorName);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorStrides(String tensorName);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorStrides(@Cast("const char*") BytePointer tensorName);
    public native @Cast("bool") @NoException(true) boolean setTensorAddress(String tensorName, Pointer data);
    public native @Cast("bool") @NoException(true) boolean setTensorAddress(@Cast("const char*") BytePointer tensorName, Pointer data);
    public native @Const @NoException(true) Pointer getTensorAddress(String tensorName);
    public native @Const @NoException(true) Pointer getTensorAddress(@Cast("const char*") BytePointer tensorName);
    public native @Cast("bool") @NoException(true) boolean setInputTensorAddress(String tensorName, @Const Pointer data);
    public native @Cast("bool") @NoException(true) boolean setInputTensorAddress(@Cast("const char*") BytePointer tensorName, @Const Pointer data);
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") PointerPointer tensorNames);
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") @ByPtrPtr BytePointer tensorNames);
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") @ByPtrPtr ByteBuffer tensorNames);
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") @ByPtrPtr byte[] tensorNames);
    public native @Cast("bool") @NoException(true) boolean setInputConsumedEvent(CUevent_st event);
    public native @NoException(true) CUevent_st getInputConsumedEvent();
    public native @NoException(true) Pointer getOutputTensorAddress(String tensorName);
    public native @NoException(true) Pointer getOutputTensorAddress(@Cast("const char*") BytePointer tensorName);
    public native @Cast("bool") @NoException(true) boolean setOutputAllocator(String tensorName, IOutputAllocator outputAllocator);
    public native @Cast("bool") @NoException(true) boolean setOutputAllocator(@Cast("const char*") BytePointer tensorName, IOutputAllocator outputAllocator);
    public native @NoException(true) IOutputAllocator getOutputAllocator(String name);
    public native @NoException(true) IOutputAllocator getOutputAllocator(@Cast("const char*") BytePointer name);
    public native @Cast("int64_t") @NoException(true) long getMaxOutputSize(String tensorName);
    public native @Cast("int64_t") @NoException(true) long getMaxOutputSize(@Cast("const char*") BytePointer tensorName);
    public native @Cast("bool") @NoException(true) boolean setTemporaryStorageAllocator(IGpuAllocator allocator);
    public native @NoException(true) IGpuAllocator getTemporaryStorageAllocator();
    public native @Cast("bool") @NoException(true) boolean enqueueV3(CUstream_st stream);
    public native @NoException(true) void setPersistentCacheLimit(@Cast("size_t") long size);
    public native @Cast("size_t") @NoException(true) long getPersistentCacheLimit();
    public native @Cast("bool") @NoException(true) boolean setNvtxVerbosity(ProfilingVerbosity verbosity);
    public native @Cast("bool") @NoException(true) boolean setNvtxVerbosity(@Cast("nvinfer1::ProfilingVerbosity") int verbosity);
    public native @NoException(true) ProfilingVerbosity getNvtxVerbosity();
    public native @NoException(true) IExecutionContext getPImpl();
    public native @NoException(true) void setAuxStreams(@ByPtrPtr CUstream_st auxStreams, int nbStreams);
}
