// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IRuntime
 * 
 *  \brief Allows a serialized functionally unsafe engine to be deserialized.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IRuntime extends INoCopy {
    static { Loader.load(); }
    /** Default native constructor. */
    public IRuntime() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IRuntime(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IRuntime(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public IRuntime position(long position) {
        return (IRuntime)super.position(position);
    }
    @Override public IRuntime getPointer(long i) {
        return new IRuntime((Pointer)this).offsetAddress(i);
    }


    /**
     *  \brief Deserialize an engine from a stream.
     * 
     *  If an error recorder has been set for the runtime, it will also be passed to the engine.
     * 
     *  @param blob The memory that holds the serialized engine.
     *  @param size The size of the memory in bytes.
     *  @param pluginFactory The plugin factory, if any plugins are used by the network, otherwise nullptr.
     * 
     *  @return The engine, or nullptr if it could not be deserialized.
     * 
     *  @deprecated Deprecated in TensorRT 8.0.
     * 
     *  \warning IPluginFactory is no longer supported, therefore pluginFactory must be a nullptr.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) ICudaEngine deserializeCudaEngine(
            @Const Pointer blob, @Cast("std::size_t") long size, IPluginFactory pluginFactory);

    /**
     *  \brief Sets the DLA core used by the network. Defaults to -1.
     *  @param dlaCore The DLA core to execute the engine on, in the range [0,getNbDlaCores()).
     * 
     *  This function is used to specify which DLA core to use via indexing, if multiple DLA cores are available.
     * 
     *  \warning if getNbDLACores() returns 0, then this function does nothing.
     * 
     *  @see getDLACore()
     *  */
    
    
    //!
    //!
    public native @NoException(true) void setDLACore(int dlaCore);

    /**
     *  \brief Get the DLA core that the engine executes on.
     *  @return assigned DLA core or -1 for DLA not present or unset.
     *  */
    
    
    //!
    //!
    public native @NoException(true) int getDLACore();

    /**
     *  \brief Returns number of DLA hardware cores accessible or 0 if DLA is unavailable.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbDLACores();

    /**
     *  \brief Destroy this object.
     * 
     *  @deprecated Deprecated in TRT 8.0. Superseded by {@code delete}.
     * 
     *  \warning Calling destroy on a managed pointer will result in a double-free error.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) void destroy();

    /**
     *  \brief Set the GPU allocator.
     *  @param allocator Set the GPU allocator to be used by the runtime. All GPU memory acquired will use this
     *  allocator. If NULL is passed, the default allocator will be used.
     * 
     *  Default: uses cudaMalloc/cudaFree.
     * 
     *  If nullptr is passed, the default allocator will be used.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setGpuAllocator(IGpuAllocator allocator);

    /**
     *  \brief Set the ErrorRecorder for this interface
     * 
     *  Assigns the ErrorRecorder to this interface. The ErrorRecorder will track all errors during execution.
     *  This function will call incRefCount of the registered ErrorRecorder at least once. Setting
     *  recorder to nullptr unregisters the recorder with the interface, resulting in a call to decRefCount if
     *  a recorder has been registered.
     * 
     *  If an error recorder is not set, messages will be sent to the global log stream.
     * 
     *  @param recorder The error recorder to register with this interface. */
    //
    /** @see getErrorRecorder()
    /** */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setErrorRecorder(IErrorRecorder recorder);

    /**
     *  \brief get the ErrorRecorder assigned to this interface.
     * 
     *  Retrieves the assigned error recorder object for the given class. A nullptr will be returned if
     *  an error handler has not been set.
     * 
     *  @return A pointer to the IErrorRecorder object that has been registered.
     * 
     *  @see setErrorRecorder()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IErrorRecorder getErrorRecorder();

    /**
     *  \brief Deserialize an engine from a stream.
     * 
     *  If an error recorder has been set for the runtime, it will also be passed to the engine.
     * 
     *  @param blob The memory that holds the serialized engine.
     *  @param size The size of the memory.
     * 
     *  @return The engine, or nullptr if it could not be deserialized.
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) ICudaEngine deserializeCudaEngine(@Const Pointer blob, @Cast("std::size_t") long size);

    /**
     *  \brief get the logger with which the runtime was created
     * 
     *  @return the logger
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) ILogger getLogger();

    /**
     *  \brief Set the maximum number of threads.
     *  @param maxThreads The maximum number of threads that can be used by the runtime.
     *  @return True if successful, false otherwise.
     * 
     *  The default value is 1 and includes the current thread.
     *  A value greater than 1 permits TensorRT to use multi-threaded algorithms.
     *  A value less than 1 triggers a kINVALID_ARGUMENT error.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setMaxThreads(int maxThreads);

    /**
     *  \brief Get the maximum number of threads that can be used by the runtime.
     * 
     *  Retrieves the maximum number of threads that can be used by the runtime.
     * 
     *  @return The maximum number of threads that can be used by the runtime.
     * 
     *  @see setMaxThreads()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int getMaxThreads();

    /**
     *  \brief Set the directory that will be used by this runtime for temporary files.
     * 
     *  On some platforms the TensorRT runtime may need to create and use temporary files
     *  with read/write/execute permissions to implement runtime functionality.
     * 
     *  @param path Path to the temporary directory for use, or nullptr.
     * 
     *  If path is nullptr, then TensorRT will use platform-specific heuristics to pick
     *  a default temporary directory if required:
     * 
     *  - On UNIX/Linux platforms, TensorRT will first try the TMPDIR environment variable, then fall back to /tmp
     *  - On Windows, TensorRT will try the TEMP environment variable.
     * 
     *  See the TensorRT Developer Guide for more information.
     * 
     *  The default value is nullptr.
     * 
     *  \warning If path is not nullptr, it must be a non-empty string representing a relative
     *  or absolute path in the format expected by the host operating system.
     * 
     *  \warning The string path must be null-terminated, and be at most 4096 bytes including the
     *  terminator. Note that the operating system may have stricter path length requirements.
     * 
     *  \warning The process using TensorRT must have rwx permissions for the temporary directory,
     *  and the directory shall be configured to disallow other users from modifying created files
     *  (e.g. on Linux, if the directory is shared with other users, the sticky bit must be set).
     * 
     *  @see getTemporaryDirectory()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setTemporaryDirectory(String path);
    public native @NoException(true) void setTemporaryDirectory(@Cast("const char*") BytePointer path);

    /**
     *  \brief Get the directory that will be used by this runtime for temporary files.
     * 
     *  @return A path to the temporary directory in use, or nullptr if no path is specified.
     * 
     *  @see setTemporaryDirectory() */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) String getTemporaryDirectory();

    /**
     *  \brief Set the tempfile control flags for this runtime.
     * 
     *  @param flags The flags to set.
     * 
     *  The default value is all flags set, i.e.
     * 
     *  (1U << static_cast<uint32_t>(kALLOW_IN_MEMORY_FILES)) | (1U << static_cast<uint32_t>(kALLOW_TEMPORARY_FILES))
     * 
     *  @see TempfileControlFlag, TempfileControlFlags, getTempfileControlFlags()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void setTempfileControlFlags(@Cast("nvinfer1::TempfileControlFlags") int flags);

    /**
     *  \brief Get the tempfile control flags for this runtime.
     * 
     *  @return The flags currently set.
     * 
     *  @see TempfileControlFlag, TempfileControlFlags, setTempfileControlFlags()
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("nvinfer1::TempfileControlFlags") @NoException(true) int getTempfileControlFlags();

    /**
     *  \brief Get the local plugin registry that can be used by the runtime.
     * 
     *  @return The local plugin registry that can be used by the runtime.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @ByRef @NoException(true) IPluginRegistry getPluginRegistry();

    /**
     *  \brief Load IRuntime from the file.
     * 
     *  This method loads a runtime library from a shared library file. The runtime can then be used to execute
     *  a plan file built with BuilderFlag::kVERSION_COMPATIBLE and BuilderFlag::kEXCLUDE_LEAN_RUNTIME both set
     *  and built with the same version of TensorRT as the loaded runtime library.
     * 
     *  @param path Path to the runtime lean library.
     * 
     *  @return the runtime library, or nullptr if it could not be loaded
     * 
     *  \warning The path string must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) IRuntime loadRuntime(String path);
    public native @NoException(true) IRuntime loadRuntime(@Cast("const char*") BytePointer path);

    /**
     *  \brief Set whether the runtime is allowed to deserialize engines with host executable code.
     * 
     *  @param allowed Whether the runtime is allowed to deserialize engines with host executable code.
     * 
     *  The default value is false.
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setEngineHostCodeAllowed(@Cast("bool") boolean allowed);

    /**
     *  \brief Get whether the runtime is allowed to deserialize engines with host executable code.
     * 
     *  @return Whether the runtime is allowed to deserialize engines with host executable code.
     *  */
    public native @Cast("bool") @NoException(true) boolean getEngineHostCodeAllowed();
}
