// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;
 // class INMSLayer

/** \class IReverseSequenceLayer
 * 
 *  \brief A ReverseSequence layer in a network definition.
 * 
 *  This layer performs batch-wise reversal, which slices the input tensor along the axis batchAxis. For the
 *  i-th slice, the operation reverses the first N elements, specified by the corresponding i-th value in
 *  sequenceLens, along sequenceAxis and keeps the remaining elements unchanged. The output tensor will have
 *  the same shape as the input tensor.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IReverseSequenceLayer extends ILayer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IReverseSequenceLayer(Pointer p) { super(p); }

    /**
     *  \brief Set the batch axis. Default is 1.
     * 
     *  batchAxis should be between zero (inclusive) and the rank of input (exclusive), and different from
     *  sequenceAxis. Otherwise, ErrorCode::kINVALID_ARGUMENT will be triggered.
     * 
     *  @see setBatchAxis()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setBatchAxis(int batchAxis);

    /**
     *  \brief Return the batch axis. Return 1 if no batch axis was set.
     * 
     *  @see getBatchAxis()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) int getBatchAxis();

    /**
     *  \brief Set the sequence axis. Default is 0.
     * 
     *  sequenceAxis should be between zero (inclusive) and the rank of input (exclusive), and different from
     *  batchAxis. Otherwise, ErrorCode::kINVALID_ARGUMENT will be triggered.
     * 
     *  @see setSequenceAxis()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setSequenceAxis(int sequenceAxis);

    /**
     *  \brief Return the sequence axis. Return 0 if no sequence axis was set.
     * 
     *  @see getSequenceAxis()
     *  */
    public native @NoException(true) int getSequenceAxis();
}
