// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IProfiler
 * 
 *  \brief Application-implemented interface for profiling.
 * 
 *  When this class is added to an execution context, the profiler will be called once per layer for each invocation of
 *  executeV2()/enqueueV2()/enqueueV3().
 * 
 *  It is not recommended to run inference with profiler enabled when the inference execution time is critical since the
 *  profiler may affect execution time negatively.
 *  */
@Namespace("nvinfer1") @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IProfiler extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public IProfiler() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IProfiler(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IProfiler(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public IProfiler position(long position) {
        return (IProfiler)super.position(position);
    }
    @Override public IProfiler getPointer(long i) {
        return new IProfiler((Pointer)this).offsetAddress(i);
    }

    /**
     *  \brief Layer time reporting callback.
     * 
     *  @param layerName The name of the layer, set when constructing the network definition. If the engine is built
     *                   with profiling verbosity set to kNONE, the layerName is the decimal index of the layer.
     *  @param ms The time in milliseconds to execute the layer.
     *  */
    @Virtual(true) public native @NoException(true) void reportLayerTime(String layerName, float ms);
}
