// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IOutputAllocator
 * 
 *  \brief Callback from ExecutionContext::enqueueV3()
 * 
 *  Clients should override the method reallocateOutput.
 * 
 *  @see IExecutionContext::enqueueV3()
 *  */
@Namespace("nvinfer1") @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IOutputAllocator extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IOutputAllocator(Pointer p) { super(p); }

    /**
     *  \brief Return the API version of this IOutputAllocator.
     * 
     *  Do not override this method as it is used by the TensorRT library to maintain
     *  backwards-compatibility with IOutputAllocator. The value will change if Nvidia
     *  adds additional virtual methods to this class.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int getInterfaceVersion();

    /**
     *  \brief Return a pointer to memory for an output tensor, or nullptr if memory cannot be allocated.
     * 
     *  @param tensorName name of the output tensor.
     *  @param currentMemory points to the address set by IExectionContext::setTensorAddress.
     *  @param size number of bytes required. Always positive, even for an empty tensor.
     *  @param alignment required alignment of the allocation.
     * 
     *  @return A pointer to memory to use for the output tensor or nullptr.
     * 
     *  If currentMemory is known to be big enough, one option is to return currentMemory.
     * 
     *  To preallocate memory and have the engine fail if the preallocation is not big enough,
     *  use IExecutionContext::setTensorAddress to set a pointer to the preallocated memory,
     *  and have reallocateOutput return nullptr if that memory is not big enough.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) Pointer reallocateOutput(String tensorName, Pointer currentMemory, @Cast("uint64_t") long size, @Cast("uint64_t") long alignment);
    public native @NoException(true) Pointer reallocateOutput(@Cast("const char*") BytePointer tensorName, Pointer currentMemory, @Cast("uint64_t") long size, @Cast("uint64_t") long alignment);

    /**
     *  \brief Called by TensorRT when the shape of the output tensor is known.
     * 
     *  Called by TensorRT sometime between when it calls reallocateOutput and enqueueV3 returns.
     * 
     *  @param dims dimensions of the output
     *  @param tensorName name of the tensor
     *  */
    public native @NoException(true) void notifyShape(String tensorName, @Cast("const nvinfer1::Dims*") @ByRef Dims32 dims);
    public native @NoException(true) void notifyShape(@Cast("const char*") BytePointer tensorName, @Cast("const nvinfer1::Dims*") @ByRef Dims32 dims);
}
