// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IOptimizationProfile
 *  \brief Optimization profile for dynamic input dimensions and shape tensors.
 * 
 *  When building an ICudaEngine from an INetworkDefinition that has dynamically resizable inputs (at least
 *  one input tensor has one or more of its dimensions specified as -1) or shape input tensors, users need to specify
 *  at least one optimization profile. Optimization profiles are numbered 0, 1, ...
 *  The first optimization profile that has been defined (with index 0) will be used by the ICudaEngine whenever no
 *  optimization profile has been selected explicitly. If none of the inputs are dynamic, the default optimization
 *  profile will be generated automatically unless it is explicitly provided by the user (this is possible but not
 *  required in this case). If more than a single optimization profile is defined, users may set a target how
 *  much additional weight space should be maximally allocated to each additional profile (as a fraction of the
 *  maximum, unconstrained memory).
 * 
 *  Users set optimum input tensor dimensions, as well as minimum and maximum input tensor dimensions. The builder
 *  selects the kernels that result in the lowest runtime for the optimum input tensor dimensions, and are valid for
 *  all input tensor sizes in the valid range between minimum and maximum dimensions. A runtime error will be raised
 *  if the input tensor dimensions fall outside the valid range for this profile. Likewise, users provide minimum,
 *  optimum, and maximum values for all shape tensor input values.
 * 
 *  @see IBuilderConfig::addOptimizationProfile()
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IOptimizationProfile extends INoCopy {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IOptimizationProfile(Pointer p) { super(p); }

    /**
     *  \brief Set the minimum / optimum / maximum dimensions for a dynamic input tensor.
     * 
     *  This function must be called three times (for the minimum, optimum, and maximum) for any network input tensor
     *  that has dynamic dimensions. If minDims, optDims, and maxDims are the minimum, optimum, and maximum dimensions,
     *  and networkDims are the dimensions for this input tensor that are provided to the INetworkDefinition object,
     *  then the following conditions must all hold:
     * 
     *  (1) minDims.nbDims == optDims.nbDims == maxDims.nbDims == networkDims.nbDims
     *  (2) 0 <= minDims.d[i] <= optDims.d[i] <= maxDims.d[i] for i = 0, ..., networkDims.nbDims-1
     *  (3) if networkDims.d[i] != -1, then minDims.d[i] == optDims.d[i] == maxDims.d[i] == networkDims.d[i]
     * 
     *  This function may (but need not be) called for an input tensor that does not have dynamic dimensions. In this
     *  case, the third argument must always equal networkDims.
     * 
     *  @param inputName The input tensor name
     *  @param select Whether to set the minimum, optimum, or maximum dimensions
     *  @param dims The minimum, optimum, or maximum dimensions for this input tensor
     * 
     *  @return false if an inconsistency was detected (e.g. the rank does not match another dimension that was
     *          previously set for the same input), true if no inconsistency was detected. Note that inputs can be
     *          validated only partially; a full validation is performed at engine build time.
     * 
     *  \warning If run on DLA, minimum, optimum, and maximum dimensions must to be the same.
     * 
     *  \warning The string inputName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setDimensions(String inputName, OptProfileSelector select, @ByVal @Cast("nvinfer1::Dims*") Dims32 dims);
    public native @Cast("bool") @NoException(true) boolean setDimensions(@Cast("const char*") BytePointer inputName, @Cast("nvinfer1::OptProfileSelector") int select, @ByVal @Cast("nvinfer1::Dims*") Dims32 dims);

    /**
     *  \brief Get the minimum / optimum / maximum dimensions for a dynamic input tensor.
     * 
     *  If the dimensions have not been previously set via setDimensions(), return an invalid Dims with nbDims == -1.
     * 
     *  \warning The string inputName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getDimensions(String inputName, OptProfileSelector select);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getDimensions(@Cast("const char*") BytePointer inputName, @Cast("nvinfer1::OptProfileSelector") int select);

    /**
     *  \brief Set the minimum / optimum / maximum values for an input shape tensor.
     * 
     *  This function must be called three times for every input tensor t that is a shape tensor (t.isShape() == true).
     *  This implies that the datatype of t is DataType::kINT32, the rank is either 0 or 1, and the dimensions of t
     *  are fixed at network definition time. This function must not be called for any input tensor that is not a
     *  shape tensor.
     * 
     *  Each time this function is called for the same input tensor, the same nbValues must be supplied (either 1
     *  if the tensor rank is 0, or dims.d[0] if the rank is 1). Furthermore, if minVals, optVals, maxVals are the
     *  minimum, optimum, and maximum values, it must be true that minVals[i] <= optVals[i] <= maxVals[i] for
     *  i = 0, ..., nbValues - 1. Execution of the network must be valid for the optVals.
     * 
     *  Shape tensors are tensors that contribute to shape calculations in some way, and can contain
     *  any int32_t values appropriate for the network. Shape tensors of other data types (e.g. float) are not
     *  supported. Examples:
     * 
     *  * A shape tensor used as the second input to IShuffleLayer can contain a -1 wildcard.
     *    The corresponding minVal[i] should be -1.
     * 
     *  * A shape tensor used as the stride input to ISliceLayer can contain any valid strides.
     *    The values could be positive, negative, or zero.
     * 
     *  * A shape tensor subtracted from zero to compute the size input of an ISliceLayer can
     *    contain any non-positive values that yield a valid slice operation.
     * 
     *  Tightening the minVals and maxVals bounds to cover only values that are necessary may help optimization.
     * 
     *  @param inputName The input tensor name
     *  @param select Whether to set the minimum, optimum, or maximum input values.
     *  @param values An array of length nbValues containing the minimum, optimum, or maximum shape tensor elements.
     *  @param nbValues The length of the value array, which must equal the number of shape tensor elements (>= 1)
     * 
     *  @return false if an inconsistency was detected (e.g. nbValues does not match a previous call for the same
     *          tensor), else true. As for setDimensions(), a full validation can only be performed at engine build
     *          time.
     * 
     *  \warning If run on DLA, minimum, optimum, and maximum shape values must to be the same.
     * 
     *  \warning The string inputName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setShapeValues(
            String inputName, OptProfileSelector select, @Const IntPointer values, int nbValues);
    public native @Cast("bool") @NoException(true) boolean setShapeValues(
            @Cast("const char*") BytePointer inputName, @Cast("nvinfer1::OptProfileSelector") int select, @Const IntBuffer values, int nbValues);
    public native @Cast("bool") @NoException(true) boolean setShapeValues(
            String inputName, OptProfileSelector select, @Const int[] values, int nbValues);
    public native @Cast("bool") @NoException(true) boolean setShapeValues(
            @Cast("const char*") BytePointer inputName, @Cast("nvinfer1::OptProfileSelector") int select, @Const IntPointer values, int nbValues);
    public native @Cast("bool") @NoException(true) boolean setShapeValues(
            String inputName, OptProfileSelector select, @Const IntBuffer values, int nbValues);
    public native @Cast("bool") @NoException(true) boolean setShapeValues(
            @Cast("const char*") BytePointer inputName, @Cast("nvinfer1::OptProfileSelector") int select, @Const int[] values, int nbValues);

    /**
     *  \brief Get the number of values for an input shape tensor.
     * 
     *  This will return the number of shape values if setShapeValues() has been called before for this input tensor.
     *  Otherwise, return -1.
     * 
     *  \warning The string inputName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbShapeValues(String inputName);
    public native @NoException(true) int getNbShapeValues(@Cast("const char*") BytePointer inputName);

    /**
     *  \brief Get the minimum / optimum / maximum values for an input shape tensor.
     * 
     *  If the shape values have not been set previously with setShapeValues(), this returns nullptr.
     * 
     *  \warning The string inputName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Const @NoException(true) IntPointer getShapeValues(String inputName, OptProfileSelector select);
    public native @Const @NoException(true) IntBuffer getShapeValues(@Cast("const char*") BytePointer inputName, @Cast("nvinfer1::OptProfileSelector") int select);

    /**
     *  \brief Set a target for extra GPU memory that may be used by this profile.
     * 
     *  @param target Additional memory that the builder should aim to maximally allocate for this profile, as a
     *         fraction of the memory it would use if the user did not impose any constraints on memory. This
     *         unconstrained case is the default; it corresponds to target == 1.0. If target == 0.0, the builder
     *         aims to create the new optimization profile without allocating any additional weight memory.
     *         Valid inputs lie between 0.0 and 1.0. This parameter is only a hint, and TensorRT does not guarantee
     *         that the target will be reached. This parameter is ignored for the first (default) optimization profile
     *         that is defined.
     * 
     *  @return true if the input is in the valid range (between 0 and 1 inclusive), else false.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setExtraMemoryTarget(float target);

    /**
     *  \brief Get the extra memory target that has been defined for this profile.
     * 
     *  This defaults to 1.0F.
     * 
     *  @return the valid value set by setExtraMemoryTarget or 1.0F.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) float getExtraMemoryTarget();

    /**
     *  \brief Check whether the optimization profile can be passed to an IBuilderConfig object.
     * 
     *  This function performs partial validation, by e.g. checking that whenever one of the minimum, optimum, or
     *  maximum dimensions of a tensor have been set, the others have also been set and have the same rank, as
     *  well as checking that the optimum dimensions are always as least as large as the minimum dimensions, and
     *  that the maximum dimensions are at least as large as the optimum dimensions. Some validation steps require
     *  knowledge of the network definition and are deferred to engine build time.
     * 
     * 
     *  @return true if the optimization profile is valid and may be passed to an IBuilderConfig, else false.
     *  */
    public native @Cast("bool") @NoException(true) boolean isValid();
}
