// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;
 // class IReverseSequenceLayer

/** \class INormalizationLayer
 * 
 *  \brief A normalization layer in a network definition.
 * 
 *  The normalization layer performs the following operation:
 * 
 *  X - input Tensor
 *  Y - output Tensor
 *  S - scale Tensor
 *  B - bias Tensor
 * 
 *  Y = (X - Mean(X, axes)) / Sqrt(Variance(X) + epsilon) * S + B
 * 
 *  Where Mean(X, axes) is a reduction over a set of axes, and Variance(X) = Mean((X - Mean(X, axes)) ^ 2, axes).
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI. */

@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class INormalizationLayer extends ILayer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public INormalizationLayer(Pointer p) { super(p); }

    /** \brief Set the epsilon value used for the normalization calculation.
     * 
     *  The default value of \p eps is 1e-5F.
     * 
     *  @param eps The epsilon value used for the normalization calculation.
     *  */
    
    //!
    //!
    public native @NoException(true) void setEpsilon(float eps);

    /** \brief Get the epsilon value used for the normalization calculation.
     * 
     *  @return The epsilon value used for the normalization calculation.
     *  */
    
    //!
    //!
    public native @NoException(true) float getEpsilon();

    /** \brief Set the reduction axes for the normalization calculation.
     * 
     *  @param axesMask The axes used for the normalization calculation.
     *  */
    
    //!
    //!
    public native @NoException(true) void setAxes(@Cast("uint32_t") int axesMask);

    /** \brief Get the axes value used for the normalization calculation.
     * 
     *  @return The axes used for the normalization calculation.
     *  */
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("uint32_t") @NoException(true) int getAxes();

    /** \brief Set the number of groups used to split the channels in the normalization calculation.
     * 
     *  The input tensor channels are divided into \p nbGroups groups, and normalization is performed per group.
     *  The channel dimension is considered to be the second dimension in a [N, C, H, W, ...] formatted tensor.
     * 
     *  The default \p nbGroups is 1.
     * 
     *  \warning It is an error to set \p nbGroups to a value that does not evenly divide into the number of channels
     *  of the input tensor.
     * 
     *  \warning When \p nbGroups is != 1, it is expected that the provided axesMask will have all bits corresponding
     *  to dimensions after the channel dimension set to 1, with all other bits set to 0.
     * 
     *  @param nbGroups The number of groups to split the channels into for the normalization calculation.
     *  */
    
    //!
    //!
    public native @NoException(true) void setNbGroups(int nbGroups);

    /** \brief Get the number of groups used to split the channels for the normalization calculation.
     * 
     *  @return The number of groups used to split the channel used for the normalization calculation.
     *  */
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbGroups();

    /** \brief Set the compute precision of this layer.
     * 
     *  @param type The datatype used for the compute precision of this layer.
     * 
     *  By default TensorRT will run the normalization computation in DataType::kFLOAT32 even in mixed precision
     *  mode regardless of any set builder flags to avoid overflow errors. To override this default,
     *  use this function to set the desired compute precision.
     * 
     *  setPrecision() and setOutputPrecision() functions can still be called to control the input and output data types
     *  to this layer.
     * 
     *  Only DataType::kFLOAT32 and DataType::kHALF are valid types for \p type.
     *  */
    
    //!
    //!
    public native @NoException(true) void setComputePrecision(DataType type);
    public native @NoException(true) void setComputePrecision(@Cast("nvinfer1::DataType") int type);

    /** \brief Get the compute precision of this layer.
     * 
     *  @return The datatype used for the compute precision of this layer.
     *  */
    public native @NoException(true) DataType getComputePrecision();
}
