// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class INetworkDefinition
 * 
 *  \brief A network definition for input to the builder.
 * 
 *  A network definition defines the structure of the network, and combined with a IBuilderConfig, is built
 *  into an engine using an IBuilder. An INetworkDefinition can either have an implicit batch dimensions, specified
 *  at runtime, or all dimensions explicit, full dims mode, in the network definition. The former mode, i.e. the
 *  implicit batch size mode, has been deprecated. The function hasImplicitBatchDimension() can be used to query the
 *  mode of the network.
 * 
 *  A network with implicit batch dimensions returns the dimensions of a layer without the implicit dimension,
 *  and instead the batch is specified at execute/enqueue time. If the network has all dimensions specified, then
 *  the first dimension follows elementwise broadcast rules: if it is 1 for some inputs and is some value N for all
 *  other inputs, then the first dimension of each output is N, and the inputs with 1 for the first dimension are
 *  broadcast. Having divergent batch sizes across inputs to a layer is not supported.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class INetworkDefinition extends INoCopy {
    static { Loader.load(); }
    /** Default native constructor. */
    public INetworkDefinition() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public INetworkDefinition(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public INetworkDefinition(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public INetworkDefinition position(long position) {
        return (INetworkDefinition)super.position(position);
    }
    @Override public INetworkDefinition getPointer(long i) {
        return new INetworkDefinition((Pointer)this).offsetAddress(i);
    }


    /**
     *  \brief Add an input tensor to the network.
     * 
     *  The name of the input tensor is used to find the index into the buffer array for an engine built from
     *  the network. The volume must be less than 2^31 elements.
     * 
     *  For networks with an implicit batch dimension, this volume includes the batch dimension with its length set
     *  to the maximum batch size. For networks with all explicit dimensions and with wildcard dimensions, the volume
     *  is based on the maxima specified by an IOptimizationProfile.Dimensions are normally non-negative integers. The
     *  exception is that in networks with all explicit dimensions, -1 can be used as a wildcard for a dimension to
     *  be specified at runtime. Input tensors with such a wildcard must have a corresponding entry in the
     *  IOptimizationProfiles indicating the permitted extrema, and the input dimensions must be set by
     *  IExecutionContext::setBindingDimensions. Different IExecutionContext instances can have different dimensions.
     *  Wildcard dimensions are only supported for EngineCapability::kSTANDARD. They are not
     *  supported in safety contexts. DLA does not support Wildcard dimensions.
     * 
     *  Tensor dimensions are specified independent of format.  For example, if a
     *  tensor is formatted in "NHWC" or a vectorized format, the dimensions are
     *  still specified in the order{N, C, H, W}. For 2D images with a channel
     *  dimension, the last three dimensions are always {C,H,W}. For 3D images
     *  with a channel dimension, the last four dimensions are always {C,D,H,W}.
     * 
     *  @param name The name of the tensor.
     *  @param type The type of the data held in the tensor.
     *  @param dimensions The dimensions of the tensor.
     * 
     *  \warning It is an error to specify a wildcard value on a dimension that is determined by trained parameters.
     * 
     *  \warning If run on DLA with explicit dimensions, only leading dimension can be a wildcard. And provided profile
     *  must have same minimum, optimum, and maximum dimensions.
     * 
     *  \warning The string name must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see ITensor
     * 
     *  @return The new tensor or nullptr if there is an error.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) ITensor addInput(String name, DataType type, @ByVal @Cast("nvinfer1::Dims*") Dims32 dimensions);
    public native @NoException(true) ITensor addInput(@Cast("const char*") BytePointer name, @Cast("nvinfer1::DataType") int type, @ByVal @Cast("nvinfer1::Dims*") Dims32 dimensions);

    /**
     *  \brief Mark a tensor as a network output.
     * 
     *  @param tensor The tensor to mark as an output tensor.
     * 
     *  \warning It is an error to mark a network input as an output.
     *  \warning It is an error to mark a tensor inside an ILoop or an
     *           IIfConditional as an output.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void markOutput(@ByRef ITensor tensor);

    /**
     *  \brief Add a convolution layer to the network.
     * 
     *  @param input The input tensor to the convolution.
     *  @param nbOutputMaps The number of output feature maps for the convolution.
     *  @param kernelSize The HW-dimensions of the convolution kernel.
     *  @param kernelWeights The kernel weights for the convolution.
     *  @param biasWeights The bias weights for the convolution. Weights{} represents no bias.
     * 
     *  @see IConvolutionLayer
     * 
     *  \warning It is an error to specify a wildcard value for the 'C' dimension of the input tensor.
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new convolution layer, or nullptr if it could not be created.
     * 
     *  @deprecated Superseded by addConvolutionNd. Deprecated prior to TensorRT 8.0 and will be removed in 9.0
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) IConvolutionLayer addConvolution(
            @ByRef ITensor input, int nbOutputMaps, @ByVal DimsHW kernelSize, @ByVal Weights kernelWeights, @ByVal Weights biasWeights);

    /**
     *  \brief Add a fully connected layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param nbOutputs The number of outputs of the layer.
     *  @param kernelWeights The kernel weights for the fully connected layer.
     *  @param biasWeights The bias weights for the fully connected layer. Weights{} represents no bias.
     * 
     *  @see IFullyConnectedLayer
     * 
     *  \warning It is an error to specify a wildcard value for the 'C' dimension of the input tensor.
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new fully connected layer, or nullptr if it could not be created.
     * 
     *  @deprecated Deprecated in TensorRT 8.4. Superseded by addMatrixMultiply().
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) IFullyConnectedLayer addFullyConnected(
            @ByRef ITensor input, int nbOutputs, @ByVal Weights kernelWeights, @ByVal Weights biasWeights);

    /**
     *  \brief Add an activation layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param type The type of activation function to apply.
     * 
     *  Note that the setAlpha() and setBeta() methods must be used on the
     *  output for activations that require these parameters.
     * 
     *  @see IActivationLayer ActivationType
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new activation layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IActivationLayer addActivation(@ByRef ITensor input, ActivationType type);
    public native @NoException(true) IActivationLayer addActivation(@ByRef ITensor input, @Cast("nvinfer1::ActivationType") int type);

    /**
     *  \brief Add a pooling layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param type The type of pooling to apply.
     *  @param windowSize The size of the pooling window.
     * 
     *  @see IPoolingLayer PoolingType
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new pooling layer, or nullptr if it could not be created.
     * 
     *  @deprecated Superseded by addPoolingNd. Deprecated prior to TensorRT 8.0 and will be removed in 9.0
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) IPoolingLayer addPooling(@ByRef ITensor input, PoolingType type, @ByVal DimsHW windowSize);
    public native @Deprecated @NoException(true) IPoolingLayer addPooling(@ByRef ITensor input, @Cast("nvinfer1::PoolingType") int type, @ByVal DimsHW windowSize);

    /**
     *  \brief Add a LRN layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param window The size of the window.
     *  @param alpha The alpha value for the LRN computation.
     *  @param beta The beta value for the LRN computation.
     *  @param k The k value for the LRN computation.
     * 
     *  @see ILRNLayer
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new LRN layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ILRNLayer addLRN(@ByRef ITensor input, int window, float alpha, float beta, float k);

    /**
     *  \brief Add a Scale layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *               This tensor is required to have a minimum of 3 dimensions in implicit batch mode
     *               and a minimum of 4 dimensions in explicit batch mode.
     *  @param mode The scaling mode.
     *  @param shift The shift value.
     *  @param scale The scale value.
     *  @param power The power value.
     * 
     *  If the weights are available, then the size of weights are dependent on the ScaleMode.
     *  For ScaleMode::kUNIFORM, the number of weights equals 1.
     *  For ScaleMode::kCHANNEL, the number of weights equals the channel dimension.
     *  For ScaleMode::kELEMENTWISE, the number of weights equals the product of the last three dimensions of the input.
     * 
     *  @see addScaleNd
     *  @see IScaleLayer
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new Scale layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) IScaleLayer addScale(@ByRef ITensor input, ScaleMode mode, @ByVal Weights shift, @ByVal Weights scale, @ByVal Weights power);
    public native @NoException(true) IScaleLayer addScale(@ByRef ITensor input, @Cast("nvinfer1::ScaleMode") int mode, @ByVal Weights shift, @ByVal Weights scale, @ByVal Weights power);

    /**
     *  \brief Add a SoftMax layer to the network.
     * 
     *  @see ISoftMaxLayer
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new SoftMax layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ISoftMaxLayer addSoftMax(@ByRef ITensor input);

    /**
     *  \brief Add a concatenation layer to the network.
     * 
     *  @param inputs The input tensors to the layer.
     *  @param nbInputs The number of input tensors.
     * 
     *  @see IConcatenationLayer
     * 
     *  @return The new concatenation layer, or nullptr if it could not be created.
     * 
     *  \warning All tensors must have the same dimensions except along the concatenation axis.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IConcatenationLayer addConcatenation(@Cast("nvinfer1::ITensor*const*") PointerPointer inputs, int nbInputs);
    public native @NoException(true) IConcatenationLayer addConcatenation(@ByPtrPtr ITensor inputs, int nbInputs);

    /**
     *  \brief Add a deconvolution layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param nbOutputMaps The number of output feature maps.
     *  @param kernelSize The HW-dimensions of the deconvolution kernel.
     *  @param kernelWeights The kernel weights for the deconvolution.
     *  @param biasWeights The bias weights for the deconvolution. Weights{} represents no bias.
     * 
     *  @see IDeconvolutionLayer
     * 
     *  \warning It is an error to specify a wildcard value for the 'C' dimension of the input tensor.
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new deconvolution layer, or nullptr if it could not be created.
     * 
     *  @deprecated Superseded by addDeconvolutionNd. Deprecated prior to TensorRT 8.0 and will be removed in 9.0
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) IDeconvolutionLayer addDeconvolution(
            @ByRef ITensor input, int nbOutputMaps, @ByVal DimsHW kernelSize, @ByVal Weights kernelWeights, @ByVal Weights biasWeights);

    /**
     *  \brief Add an elementwise layer to the network.
     * 
     *  @param input1 The first input tensor to the layer.
     *  @param input2 The second input tensor to the layer.
     *  @param op The binary operation that the layer applies.
     * 
     *  The input tensors must have the same rank and compatible type.
     *  Two types are compatible if they are the same type or are both in the set {kFLOAT, kHALF}.
     *  For each dimension, their lengths must match, or one of them must be one.
     *  In the latter case, the tensor is broadcast along that axis.
     * 
     *  The output tensor has the same rank as the inputs.
     *  For each dimension, its length is the maximum of the lengths of the
     *  corresponding input dimension.
     * 
     *  The inputs are shape tensors if the output is a shape tensor.
     * 
     *  @see IElementWiseLayer
     * 
     *  @return The new elementwise layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IElementWiseLayer addElementWise(@ByRef ITensor input1, @ByRef ITensor input2, ElementWiseOperation op);
    public native @NoException(true) IElementWiseLayer addElementWise(@ByRef ITensor input1, @ByRef ITensor input2, @Cast("nvinfer1::ElementWiseOperation") int op);

    /**
     *  \brief Add a unary layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param operation The operation to apply.
     * 
     *  @see IUnaryLayer
     * 
     *  Generally the input must have a floating-point type (or kINT8 as a quantized float),
     *  except for the following operations:
     *  * kSIGN accepts a floating-point or Int32 tensor.
     *  * kNOT requires a Bool tensor.
     * 
     *  The input is a shape tensor if the output is a shape tensor.
     * 
     *  @return The new unary layer, or nullptr if it could not be created
     *  */
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IUnaryLayer addUnary(@ByRef ITensor input, UnaryOperation operation);
    public native @NoException(true) IUnaryLayer addUnary(@ByRef ITensor input, @Cast("nvinfer1::UnaryOperation") int operation);

    /** \brief Add a padding layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param prePadding The padding to apply to the start of the tensor.
     *  @param postPadding The padding to apply to the end of the tensor.
     * 
     *  @see IPaddingLayer
     * 
     *  @return The new padding layer, or nullptr if it could not be created.
     * 
     *  @deprecated Superseded by addPaddingNd. Deprecated prior to TensorRT 8.0 and will be removed in 9.0
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) IPaddingLayer addPadding(@ByRef ITensor input, @ByVal DimsHW prePadding, @ByVal DimsHW postPadding);

    /**
     *  \brief Add a shuffle layer to the network.
     * 
     *  @param input The input tensor to the layer.
     * 
     *  @see IShuffleLayer
     * 
     *  @return The new shuffle layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IShuffleLayer addShuffle(@ByRef ITensor input);

    /**
     *  \brief Add a OneHot layer to the network.
     * 
     *  @param indices - tensor containing indices where on_value should be set.
     *  @param values - a 2-element tensor, consisting of [off_value, on_value].
     *  @param depth - tensor containing the width of the added one-hot dimension.
     *  @param axis - the axis to add the one-hot encoding to.
     * 
     *  @see IOneHotLayer
     * 
     *  @return The new OneHot layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) IOneHotLayer addOneHot(@ByRef ITensor indices, @ByRef ITensor values, @ByRef ITensor depth, int axis);

    /**
     *  \brief Get the number of layers in the network.
     * 
     *  @return The number of layers in the network.
     * 
     *  @see getLayer()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbLayers();

    /**
     *  \brief Get the layer specified by the given index.
     * 
     *  @param index The index of the layer.
     * 
     *  @return The layer, or nullptr if the index is out of range.
     * 
     *  @see getNbLayers()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) ILayer getLayer(int index);

    /**
     *  \brief Get the number of inputs in the network.
     * 
     *  @return The number of inputs in the network.
     * 
     *  @see getInput()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbInputs();

    /**
     *  \brief Get the input tensor specified by the given index.
     * 
     *  @param index The index of the input tensor.
     * 
     *  @return The input tensor, or nullptr if the index is out of range.
     * 
     *  \note adding inputs invalidates indexing here
     * 
     *  @see getNbInputs()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ITensor getInput(int index);

    /**
     *  \brief Get the number of outputs in the network.
     * 
     *  The outputs include those marked by markOutput or markOutputForShapes.
     * 
     *  @return The number of outputs in the network.
     * 
     *  @see getOutput()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbOutputs();

    /**
     *  \brief Get the output tensor specified by the given index.
     * 
     *  @param index The index of the output tensor.
     * 
     *  @return The output tensor, or nullptr if the index is out of range.
     * 
     *  \note adding inputs invalidates indexing here
     * 
     *  @see getNbOutputs()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) ITensor getOutput(int index);

    /**
     *  \brief Destroy this INetworkDefinition object.
     * 
     *  @deprecated Deprecated in TensorRT 8.0. Superseded by {@code delete}.
     * 
     *  \warning Calling destroy on a managed pointer will result in a double-free error.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) void destroy();

    /**
     *  \brief Add a reduce layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param operation The reduction operation to perform.
     *  @param reduceAxes The reduction dimensions.
     *         The bit in position i of bitmask reduceAxes corresponds to explicit dimension i if result.
     *         E.g., the least significant bit corresponds to the first explicit dimension and the next to least
     *         significant bit corresponds to the second explicit dimension.
     * 
     *  @param keepDimensions The boolean that specifies whether or not to keep the reduced dimensions in the
     *  output of the layer.
     * 
     *  The reduce layer works by performing an operation specified by \p operation to reduce the tensor \p input
     *  across the axes specified by \p reduceAxes.
     * 
     *  @see IReduceLayer
     * 
     *  \warning If output is an Int32 shape tensor, ReduceOperation::kAVG is unsupported.
     * 
     *  @return The new reduce layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IReduceLayer addReduce(
            @ByRef ITensor input, ReduceOperation operation, @Cast("uint32_t") int reduceAxes, @Cast("bool") boolean keepDimensions);
    public native @NoException(true) IReduceLayer addReduce(
            @ByRef ITensor input, @Cast("nvinfer1::ReduceOperation") int operation, @Cast("uint32_t") int reduceAxes, @Cast("bool") boolean keepDimensions);

    /**
     *  \brief Add a TopK layer to the network.
     * 
     *  The TopK layer has two outputs of the same dimensions. The first contains data values,
     *  the second contains index positions for the values. Output values are sorted, largest first
     *  for operation kMAX and smallest first for operation kMIN.
     * 
     *  Currently only values of K up to 3840 are supported.
     * 
     *  @param input The input tensor to the layer.
     * 
     *  @param op Operation to perform.
     * 
     *  @param k The number of elements to keep. For dynamic k, use the setInput() method to pass in k as a tensor
     *         instead, which will override the static k value passed here in calculations.
     * 
     *  @param reduceAxes The reduction dimensions.
     *         The bit in position i of bitmask reduceAxes corresponds to explicit dimension i of the result.
     *         E.g., the least significant bit corresponds to the first explicit dimension and the next to least
     *         significant bit corresponds to the second explicit dimension.
     * 
     *         Currently reduceAxes must specify exactly one dimension, and it must be one of the last four dimensions.
     * 
     *  @see ITopKLayer
     * 
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new TopK layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ITopKLayer addTopK(@ByRef ITensor input, TopKOperation op, int k, @Cast("uint32_t") int reduceAxes);
    public native @NoException(true) ITopKLayer addTopK(@ByRef ITensor input, @Cast("nvinfer1::TopKOperation") int op, int k, @Cast("uint32_t") int reduceAxes);

    /**
     *  \brief Add gather with mode GatherMode::kDEFAULT and specified axis and nbElementWiseDims=0.
     * 
     *  @param data The tensor to gather values from.
     *  @param indices The tensor to get indices from to populate the output tensor.
     *  @param axis The axis in the data tensor to gather on.
     * 
     *  @see IGatherLayer
     * 
     *  @return The new gather layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IGatherLayer addGather(@ByRef ITensor data, @ByRef ITensor indices, int axis);

    /**
     *  \brief Add gather with specified mode, axis=0 and nbElementWiseDims=0.
     * 
     *  @param data The tensor to gather values from.
     *  @param indices The tensor to get indices from to populate the output tensor.
     *  @param mode The gather mode.
     * 
     *  @see IGatherLayer
     * 
     *  @return The new gather layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IGatherLayer addGatherV2(@ByRef ITensor data, @ByRef ITensor indices, GatherMode mode);
    public native @NoException(true) IGatherLayer addGatherV2(@ByRef ITensor data, @ByRef ITensor indices, @Cast("nvinfer1::GatherMode") int mode);

    /**
     *  \brief Add a RaggedSoftMax layer to the network.
     * 
     *  @param input The ZxS input tensor.
     *  @param bounds The Zx1 bounds tensor.
     * 
     *  @see IRaggedSoftMaxLayer
     * 
     *  \warning The bounds tensor cannot have the last dimension be the wildcard character.
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new RaggedSoftMax layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IRaggedSoftMaxLayer addRaggedSoftMax(@ByRef ITensor input, @ByRef ITensor bounds);

    /**
     *  \brief Add a MatrixMultiply layer to the network.
     * 
     *  @param input0 The first input tensor (commonly A).
     *  @param op0 The operation to apply to input0.
     *  @param input1 The second input tensor (commonly B).
     *  @param op1 The operation to apply to input1.
     * 
     *  The inputs are shape tensors if the output is a shape tensor.
     * 
     *  @see IMatrixMultiplyLayer
     * 
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new matrix multiply layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IMatrixMultiplyLayer addMatrixMultiply(
            @ByRef ITensor input0, MatrixOperation op0, @ByRef ITensor input1, MatrixOperation op1);
    public native @NoException(true) IMatrixMultiplyLayer addMatrixMultiply(
            @ByRef ITensor input0, @Cast("nvinfer1::MatrixOperation") int op0, @ByRef ITensor input1, @Cast("nvinfer1::MatrixOperation") int op1);

    /**
     *  \brief Add a nonzero layer to the network.
     * 
     *  @param input The input tensor to the layer.
     * 
     *  @see INonZeroLayer
     * 
     *  @return The new nonzero layer, or nullptr if it could be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) INonZeroLayer addNonZero(@ByRef ITensor input);

    /**
     *  \brief Add a constant layer to the network.
     * 
     *  @param dimensions The dimensions of the constant.
     *  @param weights The constant value, represented as weights.
     * 
     *  @see IConstantLayer
     * 
     *  @return The new constant layer, or nullptr if it could not be created.
     * 
     *  If weights.type is DataType::kINT32, the output is a tensor of 32-bit indices.
     *  Otherwise the output is a tensor of real values and the output type will be
     *  follow TensorRT's normal precision rules.
     * 
     *  If tensors in the network have an implicit batch dimension, the constant
     *  is broadcast over that dimension.
     * 
     *  If a wildcard dimension is used, the volume of the runtime dimensions must equal
     *  the number of weights specified.
     * 
     *  \warning DataType::kUINT8 not supported.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IConstantLayer addConstant(@ByVal @Cast("nvinfer1::Dims*") Dims32 dimensions, @ByVal Weights weights);

    /**
     *  \brief Add an \p layerCount deep RNN layer to the network with \p hiddenSize internal states that can
     *  take a batch with fixed or variable sequence lengths.
     * 
     *  @param input The input tensor to the layer (see below).
     *  @param layerCount The number of layers in the RNN.
     *  @param hiddenSize Size of the internal hidden state for each layer.
     *  @param maxSeqLen Maximum sequence length for the input.
     *  @param op The type of RNN to execute.
     * 
     *  By default, the layer is configured with RNNDirection::kUNIDIRECTION and RNNInputMode::kLINEAR.
     *  To change these settings, use IRNNv2Layer::setDirection() and IRNNv2Layer::setInputMode().
     * 
     *  %Weights and biases for the added layer should be set using
     *  IRNNv2Layer::setWeightsForGate() and IRNNv2Layer::setBiasForGate() prior
     *  to building an engine using this network.
     * 
     *  The input tensors must be of the type DataType::kFLOAT or DataType::kHALF.
     *  The layout of the weights is row major and must be the same datatype as the input tensor.
     *  \p weights contain 8 matrices and \p bias contains 8 vectors.
     * 
     *  See IRNNv2Layer::setWeightsForGate() and IRNNv2Layer::setBiasForGate() for details on the required input
     *  format for \p weights and \p bias.
     * 
     *  The \p input ITensor should contain zero or more index dimensions {@code {N1, ..., Np}}, followed by
     *  two dimensions, defined as follows:
     *    - {@code S_max} is the maximum allowed sequence length (number of RNN iterations)
     *    - {@code E} specifies the embedding length (unless RNNInputMode::kSKIP is set, in which case it should match
     *      getHiddenSize()).
     * 
     *  By default, all sequences in the input are assumed to be size \p maxSeqLen.  To provide explicit sequence
     *  lengths for each input sequence in the batch, use IRNNv2Layer::setSequenceLengths().
     * 
     *  The RNN layer outputs up to three tensors.
     * 
     *  The first output tensor is the output of the final RNN layer across all timesteps, with dimensions
     *  {@code {N1, ..., Np, S_max, H}}:
     * 
     *    - {@code N1..Np} are the index dimensions specified by the input tensor
     *    - {@code S_max} is the maximum allowed sequence length (number of RNN iterations)
     *    - {@code H} is an output hidden state (equal to getHiddenSize() or 2x getHiddenSize())
     * 
     *  The second tensor is the final hidden state of the RNN across all layers, and if the RNN
     *  is an LSTM (i.e. getOperation() is RNNOperation::kLSTM), then the third tensor is the final cell state
     *  of the RNN across all layers.  Both the second and third output tensors have dimensions
     *  {@code {N1, ..., Np, L, H}}:
     * 
     *   - {@code N1..Np} are the index dimensions specified by the input tensor
     *   - {@code L} is the number of layers in the RNN, equal to getLayerCount() if getDirection is
     *   RNNDirection::kUNIDIRECTION,
     *      and 2x getLayerCount() if getDirection is RNNDirection::kBIDIRECTION. In the bi-directional
     *      case, layer {@code l}'s final forward hidden state is stored in {@code L = 2*l}, and
     *      final backward hidden state is stored in {@code L= 2*l + 1}.
     *   - {@code H} is the hidden state for each layer, equal to getHiddenSize().
     * 
     *  @see IRNNv2Layer
     * 
     *  @deprecated Deprecated prior to TensorRT 8.0 and will be removed in 9.0. Superseded by
     *  INetworkDefinition::addLoop().
     * 
     *  \warning RNN inputs do not support wildcard dimensions or explicit batch size networks.
     *  \warning Int32 tensors are not valid input tensors, only for sequence lengths.
     * 
     *  @return The new RNN layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) IRNNv2Layer addRNNv2(
            @ByRef ITensor input, int layerCount, int hiddenSize, int maxSeqLen, RNNOperation op);
    public native @Deprecated @NoException(true) IRNNv2Layer addRNNv2(
            @ByRef ITensor input, int layerCount, int hiddenSize, int maxSeqLen, @Cast("nvinfer1::RNNOperation") int op);

    /**
     *  \brief Add an identity layer.
     * 
     *  @param input The input tensor to the layer.
     * 
     *  @see IIdentityLayer
     * 
     *  @return The new identity layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IIdentityLayer addIdentity(@ByRef ITensor input);

    /**
     *  \brief Add a cast layer.
     * 
     *  @param input The input tensor to the layer.
     *  @param toType The DataType of the output tensor
     * 
     *  @see ICastLayer
     * 
     *  @return The new cast layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) ICastLayer addCast(@ByRef ITensor input, DataType toType);
    public native @NoException(true) ICastLayer addCast(@ByRef ITensor input, @Cast("nvinfer1::DataType") int toType);

    /**
     *  \brief remove a tensor from the network definition.
     * 
     *  @param tensor the tensor to remove
     * 
     *  It is illegal to remove a tensor that is the input or output of a layer.
     *  if this method is called with such a tensor, a warning will be emitted on the log
     *  and the call will be ignored. Its intended use is to remove detached tensors after
     *  e.g. concatenating two networks with Layer::setInput().
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void removeTensor(@ByRef ITensor tensor);

    /**
     *  \brief unmark a tensor as a network output.
     * 
     *  @param tensor The tensor to unmark as an output tensor.
     * 
     *  see markOutput()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void unmarkOutput(@ByRef ITensor tensor);

    /**
     *  \brief Add a plugin layer to the network using the IPluginV2 interface.
     * 
     *  @param inputs The input tensors to the layer.
     *  @param nbInputs The number of input tensors.
     *  @param plugin The layer plugin.
     * 
     *  @see IPluginV2Layer
     * 
     *  \warning Dimension wildcard are only supported with IPluginV2DynamicExt or IPluginV2IOExt plugins.
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new plugin layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IPluginV2Layer addPluginV2(@Cast("nvinfer1::ITensor*const*") PointerPointer inputs, int nbInputs, @ByRef IPluginV2 plugin);
    public native @NoException(true) IPluginV2Layer addPluginV2(@ByPtrPtr ITensor inputs, int nbInputs, @ByRef IPluginV2 plugin);

    /**
     *  \brief Add a slice layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param start The start offset
     *  @param size The output dimension
     *  @param stride The slicing stride
     * 
     *  Positive, negative, zero stride values, and combinations of them in different dimensions are allowed.
     * 
     *  @see ISliceLayer
     * 
     *  @return The new slice layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ISliceLayer addSlice(@ByRef ITensor input, @ByVal @Cast("nvinfer1::Dims*") Dims32 start, @ByVal @Cast("nvinfer1::Dims*") Dims32 size, @ByVal @Cast("nvinfer1::Dims*") Dims32 stride);

    /**
     *  \brief Sets the name of the network.
     * 
     *  @param name The name to assign to this network.
     * 
     *  Set the name of the network so that it can be associated with a built
     *  engine. The \p name must be a null-terminated C-style string.
     *  TensorRT makes no use of this string except storing it as part of the engine
     *  so that it may be retrieved at runtime.
     *  A name unique to the builder will be generated by default.
     * 
     *  This method copies the name string.
     * 
     *  \warning The string name must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see INetworkDefinition::getName(), ISafeCudaEngine::getName()
     * 
     *  @return none
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setName(String name);
    public native @NoException(true) void setName(@Cast("const char*") BytePointer name);

    /**
     *  \brief Returns the name associated with the network.
     * 
     *  The memory pointed to by getName() is owned by the INetworkDefinition object.
     * 
     *  @see INetworkDefinition::setName()
     * 
     *  @return A null-terminated C-style string representing the name of the network.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) String getName();

    /**
     *  \brief Add a shape layer to the network.
     * 
     *  @param input The input tensor to the layer.
     * 
     *  @see IShapeLayer
     * 
     *  \warning addShape is only supported when hasImplicitBatchDimensions is false.
     * 
     *  @return The new shape layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IShapeLayer addShape(@ByRef ITensor input);

    /**
     *  \brief Query whether the network was created with an implicit batch dimension.
     * 
     *  @return True if tensors have implicit batch dimension, false otherwise.
     * 
     *  This is a network-wide property. Either all tensors in the network
     *  have an implicit batch dimension or none of them do.
     * 
     *  hasImplicitBatchDimension() is true if and only if this INetworkDefinition
     *  was created with createNetworkV2() without NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag.
     * 
     *  @see createNetworkV2
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean hasImplicitBatchDimension();

    /**
     *  \brief Enable tensor's value to be computed by IExecutionContext::getShapeBinding.
     * 
     *  @return True if successful, false if tensor is already marked as an output.
     * 
     *  The tensor must be of type DataType::kINT32 and have no more than one dimension.
     * 
     *  \warning The tensor must have dimensions that can be determined to be constants at build time.
     * 
     *  \warning It is an error to mark a network input as a shape output.
     * 
     *  @see isShapeBinding(), getShapeBinding()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean markOutputForShapes(@ByRef ITensor tensor);

    /**
     *  \brief Undo markOutputForShapes.
     * 
     *  \warning inputs to addShape cannot contain wildcard dimension values.
     * 
     *  @return True if successful, false if tensor is not marked as an output.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean unmarkOutputForShapes(@ByRef ITensor tensor);

    /**
     *  \brief Add a parametric ReLU layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param slope The slope tensor to the layer. This tensor should be unidirectionally broadcastable
     *         to the input tensor.
     * 
     *  @see IParametricReLULayer
     * 
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new parametric ReLU layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IParametricReLULayer addParametricReLU(@ByRef ITensor input, @ByRef ITensor slope);

    /**
     *  \brief Add a multi-dimension convolution layer to the network.
     * 
     *  @param input The input tensor to the convolution.
     *  @param nbOutputMaps The number of output feature maps for the convolution.
     *  @param kernelSize The multi-dimensions of the convolution kernel.
     *  @param kernelWeights The kernel weights for the convolution.
     *  @param biasWeights The bias weights for the convolution. Weights{} represents no bias.
     * 
     *  @see IConvolutionLayer
     * 
     *  \warning It is an error to specify a wildcard value for the 'C' dimension of the input tensor.
     *  \warning Int32 tensors are not valid input tensors.
     *  \warning Only 2D or 3D convolution is supported.
     * 
     *  @return The new convolution layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IConvolutionLayer addConvolutionNd(
            @ByRef ITensor input, int nbOutputMaps, @ByVal @Cast("nvinfer1::Dims*") Dims32 kernelSize, @ByVal Weights kernelWeights, @ByVal Weights biasWeights);

    /**
     *  \brief Add a multi-dimension pooling layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param type The type of pooling to apply.
     *  @param windowSize The size of the pooling window.
     * 
     *  @see IPoolingLayer PoolingType
     * 
     *  \warning Int32 tensors are not valid input tensors.
     *  \warning Only 2D or 3D pooling is supported.
     * 
     *  @return The new pooling layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IPoolingLayer addPoolingNd(@ByRef ITensor input, PoolingType type, @ByVal @Cast("nvinfer1::Dims*") Dims32 windowSize);
    public native @NoException(true) IPoolingLayer addPoolingNd(@ByRef ITensor input, @Cast("nvinfer1::PoolingType") int type, @ByVal @Cast("nvinfer1::Dims*") Dims32 windowSize);

    /**
     *  \brief Add a multi-dimension deconvolution layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param nbOutputMaps The number of output feature maps.
     *  @param kernelSize The multi-dimensions of the deconvolution kernel.
     *  @param kernelWeights The kernel weights for the deconvolution.
     *  @param biasWeights The bias weights for the deconvolution. Weights{} represents no bias.
     * 
     *  @see IDeconvolutionLayer
     * 
     *  \warning It is an error to specify a wildcard value for the 'C' dimension of the input tensor.
     *  \warning Int32 tensors are not valid input tensors.
     *  \warning Only 2D or 3D deconvolution is supported. */
    //
    /** @return The new deconvolution layer, or nullptr if it could not be created.
    /** */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IDeconvolutionLayer addDeconvolutionNd(
            @ByRef ITensor input, int nbOutputMaps, @ByVal @Cast("nvinfer1::Dims*") Dims32 kernelSize, @ByVal Weights kernelWeights, @ByVal Weights biasWeights);

    /**
     *  \brief Add a multi-dimension scale layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param mode The scaling mode.
     *  @param shift The shift value.
     *  @param scale The scale value.
     *  @param power The power value.
     *  @param channelAxis The channel axis.
     * 
     *  If the weights are available, then the size of weights are dependent on the ScaleMode.
     *  For ScaleMode::kUNIFORM, the number of weights equals 1.
     *  For ScaleMode::kCHANNEL, the number of weights equals the channel dimension.
     *  For ScaleMode::kELEMENTWISE, the number of weights equals the product of all input dimensions at channelAxis and
     *  beyond.
     * 
     *  For example, if the inputs dimensions are [A,B,C,D,E,F], and channelAxis=2:
     *  For ScaleMode::kUNIFORM, the number of weights is equal to 1.
     *  For ScaleMode::kCHANNEL, the number of weights is C.
     *  For ScaleMode::kELEMENTWISE, the number of weights is C*D*E*F.
     * 
     *  channelAxis can also be set explicitly using setChannelAxis().
     * 
     *  @see IScaleLayer
     *  @see setChannelAxis()
     * 
     *  \warning Int32 tensors are not valid input tensors.
     *  \warning Only 2D or 3D scale is supported.
     * 
     *  @return The new Scale layer, or nullptr if it could not be created.
     *  */
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IScaleLayer addScaleNd(
            @ByRef ITensor input, ScaleMode mode, @ByVal Weights shift, @ByVal Weights scale, @ByVal Weights power, int channelAxis);
    public native @NoException(true) IScaleLayer addScaleNd(
            @ByRef ITensor input, @Cast("nvinfer1::ScaleMode") int mode, @ByVal Weights shift, @ByVal Weights scale, @ByVal Weights power, int channelAxis);

    /** \brief Add a resize layer to the network.
     * 
     *  @param input The input tensor to the layer.
     * 
     *  @see IResizeLayer
     * 
     *  \warning Int32 tensors are not valid input tensors.
     * 
     *  @return The new resize layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IResizeLayer addResize(@ByRef ITensor input);

    /**
     *  \brief True if network is an explicit precision network
     * 
     *  @deprecated Deprecated in TensorRT 8.0.
     * 
     *  @see createNetworkV2
     * 
     *  @return True if network has explicit precision, false otherwise.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean hasExplicitPrecision();

    /**
     *  \brief Add a loop to the network.
     * 
     *  An ILoop provides a way to specify a recurrent subgraph.
     * 
     *  @return Pointer to ILoop that can be used to add loop boundary layers for the loop,
     *          or nullptr if network has an implicit batch dimension or this version
     *          of TensorRT does not support loops.
     * 
     *  The network must not have an implicit batch dimension.
     *  */
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ILoop addLoop();

    /** \brief Add a select layer to the network.
     * 
     *  @param condition The condition tensor to the layer. Must have type DataType::kBOOL.
     *  @param thenInput The "then" input tensor to the layer.
     *  @param elseInput The "else" input tensor to the layer.
     * 
     *  All three input tensors must have the same rank, and along each axis
     *  must have the same length or a length of one. If the length is one, the tensor
     *  is broadcast along that axis. The output tensor has the dimensions of the inputs AFTER
     *  the broadcast rule is applied. For example, given:
     * 
     *     dimensions of condition:  [1,1,5,9]
     *     dimensions of thenInput:  [1,1,5,9]
     *     dimensions of elseInput:  [1,3,1,9]
     * 
     *  the output dimensions are [1,3,5,9], and the output contents are defined by:
     * 
     *       output[0,i,j,k] = condition[0,0,j,k] ? thenInput[0,0,j,k] : elseInput[0,i,0,k]
     * 
     *  The output dimensions are not necessarily the max of the input dimensions if any input
     *  is an empty tensor. For example, if in the preceding example, 5 is changed to 0:
     * 
     *     dimensions of condition:  [1,1,0,9]
     *     dimensions of thenInput:  [1,1,0,9]
     *     dimensions of elseInput:  [1,3,1,9]
     * 
     *  then the output dimensions are [1,3,0,9].
     * 
     *  The network must not have an implicit batch dimension.
     * 
     *  The inputs are shape tensors if the output is a shape tensor.
     * 
     *  @see ISelectLayer
     * 
     *  @return The new select layer, or nullptr if it could not be created. */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ISelectLayer addSelect(@ByRef ITensor condition, @ByRef ITensor thenInput, @ByRef ITensor elseInput);

    /**
     *  \brief Add an assertion layer to the network.
     * 
     *  @param condition The input tensor to the layer.
     *  @param message A message to print if the assertion fails.
     * 
     *  @see IAssertionLayer
     * 
     *  @return The new assertion layer, or nullptr if it could not be created.
     * 
     *  The input tensor must be a boolean shape tensor.
     *  */
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IAssertionLayer addAssertion(@ByRef ITensor condition, String message);
    public native @NoException(true) IAssertionLayer addAssertion(@ByRef ITensor condition, @Cast("const char*") BytePointer message);

    /** \brief Add a fill layer to the network.
     * 
     *  @param dimensions The output tensor dimensions.
     *  @param op The fill operation that the layer applies.
     * 
     *  \warning For FillOperation::kLINSPACE, dimensions.nbDims must be 1.
     * 
     *  This layer is non-deterministic across subsequent calls as the same inputs will produce different
     *  output tensors if \p op is either FillOperation::kRANDOM_UNIFORM or FillOperation::kRANDOM_NORMAL
     *  due to random state being shared across calls. The output tensors generated are determinstic when
     *  starting from the same initial state.
     * 
     *  The network must not have an implicit batch dimension.
     * 
     *  @see IFillLayer
     * 
     *  @return The new fill layer, or nullptr if it could not be created.
     *  */
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IFillLayer addFill(@ByVal @Cast("nvinfer1::Dims*") Dims32 dimensions, FillOperation op);
    public native @NoException(true) IFillLayer addFill(@ByVal @Cast("nvinfer1::Dims*") Dims32 dimensions, @Cast("nvinfer1::FillOperation") int op);

    /** \brief Add a padding layer to the network. Only 2D padding is currently supported.
     * 
     *  @param input The input tensor to the layer.
     *  @param prePadding The padding to apply to the start of the tensor.
     *  @param postPadding The padding to apply to the end of the tensor.
     * 
     *  @see IPaddingLayer
     * 
     *  @return The new padding layer, or nullptr if it could not be created.
     * 
     *  @deprecated Deprecated in TensorRT 8.0. Superseded by addSlice().
     *  */
    
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) IPaddingLayer addPaddingNd(@ByRef ITensor input, @ByVal @Cast("nvinfer1::Dims*") Dims32 prePadding, @ByVal @Cast("nvinfer1::Dims*") Dims32 postPadding);

    /** \brief Associate a name with all current uses of the given weights.
     * 
     *  The name must be set after the Weights are used in the network.
     *  Lookup is associative. The name applies to all Weights with matching
     *  type, value pointer, and count. If Weights with a matching value
     *  pointer, but different type or count exists in the network, an
     *  error message is issued, the name is rejected, and return false.
     *  If the name has already been used for other weights,
     *  return false. A nullptr causes the weights to become unnamed,
     *  i.e. clears any previous name.
     * 
     *  @param weights The weights to be named.
     *  @param name The name to associate with the weights.
     * 
     *  @return true on success.
     * 
     *  \warning The string name must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setWeightsName(@ByVal Weights weights, String name);
    public native @Cast("bool") @NoException(true) boolean setWeightsName(@ByVal Weights weights, @Cast("const char*") BytePointer name);

    /**
     *  \brief Set the ErrorRecorder for this interface
     * 
     *  Assigns the ErrorRecorder to this interface. The ErrorRecorder will track all errors during execution.
     *  This function will call incRefCount of the registered ErrorRecorder at least once. Setting
     *  recorder to nullptr unregisters the recorder with the interface, resulting in a call to decRefCount if
     *  a recorder has been registered.
     * 
     *  If an error recorder is not set, messages will be sent to the global log stream.
     * 
     *  @param recorder The error recorder to register with this interface. */
    //
    /** @see getErrorRecorder()
    /** */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setErrorRecorder(IErrorRecorder recorder);

    /**
     *  \brief get the ErrorRecorder assigned to this interface.
     * 
     *  Retrieves the assigned error recorder object for the given class.
     *  A nullptr will be returned if setErrorRecorder has not been called.
     * 
     *  @return A pointer to the IErrorRecorder object that has been registered.
     * 
     *  @see setErrorRecorder()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IErrorRecorder getErrorRecorder();

    /**
     *  \brief Add a dequantization layer to the network.
     * 
     *  @param input The input tensor to be quantized.
     *  @param scale A tensor with the scale value.
     * 
     *  @see IDequantizeLayer
     * 
     *  \p input tensor data type must be DataType::kFLOAT.
     *  \p scale tensor data type must be DataType::kFLOAT. The subgraph which terminates with the \p scale tensor must
     *  be a build-time constant.
     * 
     *  @return The new quantization layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IDequantizeLayer addDequantize(@ByRef ITensor input, @ByRef ITensor scale);

    /**
     *  \brief Add a Scatter layer to the network with specified mode and axis=0.
     * 
     *  @param data The input tensor to be updated with additional values.
     *  @param indices indices of the elements to be updated.
     *  @param updates values to be used for updates.
     *  @param mode scatter mode.
     * 
     *  @see IScatterLayer
     * 
     *  \p indices tensor data type must be DataType::kINT32.
     *  \p updates tensor data type must be the same as \p data
     * 
     *  @return The new Scatter layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IScatterLayer addScatter(@ByRef ITensor data, @ByRef ITensor indices, @ByRef ITensor updates, ScatterMode mode);
    public native @NoException(true) IScatterLayer addScatter(@ByRef ITensor data, @ByRef ITensor indices, @ByRef ITensor updates, @Cast("nvinfer1::ScatterMode") int mode);

    /**
     *  \brief Add a quantization layer to the network.
     * 
     *  @param input The input tensor to be quantized.
     *  @param scale A tensor with the scale value.
     * 
     *  @see IQuantizeLayer
     * 
     *  \p input tensor data type must be DataType::kFLOAT.
     *  \p scale tensor data type must be DataType::kFLOAT. The subgraph which terminates with the \p scale tensor must
     *  be a build-time constant.
     * 
     *  @return The new quantization layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IQuantizeLayer addQuantize(@ByRef ITensor input, @ByRef ITensor scale);

    /**
     *  \brief Add an If-conditional layer to the network.
     * 
     *  An IIfConditional provides a way to conditionally execute parts of the network.
     * 
     *  @see IIfConditional
     * 
     *  @return The new conditional layer, or nullptr if network has an implicit batch dimension
     *          or this version of TensorRT does not support conditional execution.
     *  */
    
    //!
    //!
    //!
    public native @NoException(true) IIfConditional addIfConditional();

    /** \brief Add an Einsum layer to the network.
     * 
     *  @param inputs The input tensors to the layer.
     *  @param nbInputs The number of input tensors.
     *  @param equation The equation of the layer
     *  @see IEinsumLayer
     * 
     *  @return The new Einsum layer, or nullptr if it could not be created.
     *  */
    
    //!
    //!
    //!
    //!
    public native @NoException(true) IEinsumLayer addEinsum(@Cast("nvinfer1::ITensor*const*") PointerPointer inputs, int nbInputs, String equation);
    public native @NoException(true) IEinsumLayer addEinsum(@ByPtrPtr ITensor inputs, int nbInputs, String equation);
    public native @NoException(true) IEinsumLayer addEinsum(@ByPtrPtr ITensor inputs, int nbInputs, @Cast("const char*") BytePointer equation);

    /** \brief Add a GridSample layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param grid The grid tensor to the layer.
     *  @see IGridSampleLayer
     * 
     *  Creates a GridSample layer with a InterpolationMode::kLINEAR, unaligned corners,
     *  and SampleMode::kFILL for 4d-shape input tensors.
     * 
     *  @return The new GridSample layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IGridSampleLayer addGridSample(@ByRef ITensor input, @ByRef ITensor grid);

    /**
     *  \brief Add a non-maximum suppression layer to the network.
     * 
     *  @param boxes The input boxes tensor to the layer.
     * 
     *  @param scores The input scores tensor to the layer.
     * 
     *  @param maxOutputBoxesPerClass The input maxOutputBoxesPerClass tensor to the layer.
     * 
     *  @see INMSLayer
     * 
     *  @return The new NMS layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) INMSLayer addNMS(@ByRef ITensor boxes, @ByRef ITensor scores, @ByRef ITensor maxOutputBoxesPerClass);

    /**
     *  \brief Add a ReverseSequence layer to the network.
     * 
     *  @param input The input tensor to the layer. Must have rank >= 2.
     * 
     *  @param sequenceLens 1D tensor specifying lengths of sequences to reverse in a batch. The length of the
     *         sequenceLens tensor must be equal to the size of the dimension in input tensor specified by batchAxis.
     * 
     *  @see IReverseSequenceLayer
     * 
     *  @return The new ReverseSequence layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IReverseSequenceLayer addReverseSequence(@ByRef ITensor input, @ByRef ITensor sequenceLens);

    /**
     *  \brief Add a normalization layer to the network.
     * 
     *  @param input The input tensor to the layer.
     *  @param scale The scale tensor used to scale the normalized output.
     *  @param bias The bias tensor used to scale the normalized output.
     *  @param axesMask The axes on which to perform mean calculations.
     *         The bit in position i of bitmask axesMask corresponds to explicit dimension i of the result.
     *         E.g., the least significant bit corresponds to the first explicit dimension and the next to least
     *         significant bit corresponds to the second explicit dimension.
     * 
     *  The normalization layer works by performing normalization of the tensor \p input on the specified \p axesMask.
     *  The result is then scaled by multiplying with \p scale and adding \p bias.
     * 
     *  The shape of \p scale and \p bias are expected the be the same, and must have the same rank and be
     *  unidirectionally broadcastable to the shape of \p input.
     * 
     *  @see INormalizationLayer
     * 
     *  @return The new normalization layer, or nullptr if it could not be created.
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) INormalizationLayer addNormalization(
            @ByRef ITensor input, @ByRef ITensor scale, @ByRef ITensor bias, @Cast("uint32_t") int axesMask);

    /**
     *  \brief Return the builder from which this INetworkDefinition was created.
     * 
     *  @see IBuilder::createNetworkV2
     * 
     *  @return the builder */
    public native @ByRef @NoException(true) IBuilder getBuilder();
}
