// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;

/**
 *  \class ILoggerFinder
 * 
 *  \brief A virtual base class to find a logger.
 *  Allows a plugin to find an instance of a logger if it needs to emit a log message.
 *  A pointer to an instance of this class is passed to a plugin shared library on initialization when that plugin
 *  is serialized as part of a version-compatible plan. See the plugin chapter in the developer guide for details.
 *  */
@Namespace("nvinfer1") @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class ILoggerFinder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ILoggerFinder(Pointer p) { super(p); }

    /**
     *  \brief Get the logger used by the engine or execution context which called the plugin method.
     * 
     *  \warning Must be called from the thread in which the plugin method was called.
     * 
     *  @return A pointer to the logger.
     *  */
    public native ILogger findLogger();
}
