// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class ILogger
 * 
 *  \brief Application-implemented logging interface for the builder, refitter and runtime.
 * 
 *  The logger used to create an instance of IBuilder, IRuntime or IRefitter is used for all objects created through
 *  that interface. The logger should be valid until all objects created are released.
 * 
 *  The Logger object implementation must be thread safe. All locking and synchronization is pushed to the
 *  interface implementation and TensorRT does not hold any synchronization primitives when calling the interface
 *  functions.
 *  */
@Namespace("nvinfer1") @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class ILogger extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ILogger(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ILogger(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ILogger position(long position) {
        return (ILogger)super.position(position);
    }
    @Override public ILogger getPointer(long i) {
        return new ILogger((Pointer)this).offsetAddress(i);
    }

    /**
     *  \enum Severity
     * 
     *  The severity corresponding to a log message.
     *  */
    public enum Severity {
        /** An internal error has occurred. Execution is unrecoverable. */
        kINTERNAL_ERROR(0),
        /** An application error has occurred. */
        kERROR(1),
        /** An application error has been discovered, but TensorRT has recovered or fallen back to a default. */
        kWARNING(2),
        /**  Informational messages with instructional information. */
        kINFO(3),
        /**  Verbose messages with debugging information. */
        kVERBOSE(4);

        public final int value;
        private Severity(int v) { this.value = v; }
        private Severity(Severity e) { this.value = e.value; }
        public Severity intern() { for (Severity e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    /**
     *  A callback implemented by the application to handle logging messages;
     * 
     *  @param severity The severity of the message.
     *  @param msg A null-terminated log message.
     * 
     *  \u005Cusage
     *  - Allowed context for the API call
     *    - Thread-safe: Yes, this method is required to be thread-safe and may be called from multiple threads
     *                   when multiple execution contexts are used during runtime, or if the same logger is used
     *                   for multiple runtimes, builders, or refitters.
     *  */
    @Virtual(true) public native @NoException(true) void log(Severity severity, String msg);

    public ILogger() { super((Pointer)null); allocate(); }
    private native void allocate();
}
