// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class ILayer
 * 
 *  \brief Base class for all layer classes in a network definition.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class ILayer extends INoCopy {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ILayer(Pointer p) { super(p); }

    /**
     *  \brief Return the type of a layer.
     * 
     *  @see LayerType
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) LayerType getType();

    /**
     *  \brief Set the name of a layer.
     * 
     *  This method copies the name string.
     * 
     *  \warning The string name must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see getName()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setName(String name);
    public native @NoException(true) void setName(@Cast("const char*") BytePointer name);

    /**
     *  \brief Return the name of a layer.
     * 
     *  @see setName()
     *  */
    
    
    //!
    //!
    public native @NoException(true) String getName();

    /**
     *  \brief Get the number of inputs of a layer.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbInputs();

    /**
     *  \brief Get the layer input corresponding to the given index.
     * 
     *  @param index The index of the input tensor.
     * 
     *  @return The input tensor, or nullptr if the index is out of range or the tensor is optional
     *  (\ref ISliceLayer and \ref IRNNv2Layer).
     *  */
    
    
    //!
    //!
    public native @NoException(true) ITensor getInput(int index);

    /**
     *  \brief Get the number of outputs of a layer.
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) int getNbOutputs();

    /**
     *  \brief Get the layer output corresponding to the given index.
     * 
     *  @return The indexed output tensor, or nullptr if the index is out of range or the tensor is optional
     *  (\ref IRNNv2Layer).
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ITensor getOutput(int index);

    /**
     *  \brief Replace an input of this layer with a specific tensor.
     * 
     *  @param index the index of the input to modify.
     *  @param tensor the new input tensor
     * 
     *  Except for IFillLayer, ILoopOutputLayer, INMSLayer, IResizeLayer, IShuffleLayer, and ISliceLayer,
     *  this method cannot change the number of inputs to a layer. The index argument must be
     *  less than the value of getNbInputs().
     * 
     *  See comments for overloads of setInput() for layers with special behavior.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setInput(int index, @ByRef ITensor tensor);

    /**
     *  \brief Set the computational precision of this layer
     * 
     *  Setting the precision allows TensorRT to choose an implementation which run at this computational precision.
     *  TensorRT could still choose a non-conforming fastest implementation that ignores the requested precision.
     *  To force choosing an implementation with the requested precision, set exactly one of the following flags,
     *  which differ in what happens if no such implementation exists:
     * 
     *  * BuilderFlag::kOBEY_PRECISION_CONSTRAINTS - build fails with an error message.
     * 
     *  * BuilderFlag::kPREFER_PRECISION_CONSTRAINTS - TensorRT falls back to an
     *    implementation without the requested precision.
     * 
     *  If precision is not set, or falling back, TensorRT will select the layer computational precision
     *  and layer input type based on global performance considerations and the flags specified to the builder.
     * 
     *  For a IIdentityLayer: If it casts to/from float/half/int8/uint8, the precision must be one of those types,
     *  otherwise it must be either the input or output type.
     * 
     *  @param dataType the computational precision.
     * 
     *  @see getPrecision() precisionIsSet() resetPrecision()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void setPrecision(DataType dataType);
    public native @NoException(true) void setPrecision(@Cast("nvinfer1::DataType") int dataType);

    /**
     *  \brief get the computational precision of this layer
     * 
     *  @return the computational precision
     * 
     *  @see setPrecision() precisionIsSet() resetPrecision()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) DataType getPrecision();

    /**
     *  \brief whether the computational precision has been set for this layer
     * 
     *  @return whether the computational precision has been explicitly set
     * 
     *  @see setPrecision() getPrecision() resetPrecision()
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean precisionIsSet();

    /**
     *  \brief reset the computational precision for this layer
     * 
     *  @see setPrecision() getPrecision() precisionIsSet()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void resetPrecision();

    /**
     *  \brief Set the output type of this layer
     * 
     *  Setting the output type constrains TensorRT to choose implementations which generate output data with the
     *  given type. If it is not set, TensorRT will select output type based on layer computational precision. TensorRT
     *  could still choose non-conforming output type based on fastest implementation. To force choosing the requested
     *  output type, set exactly one of the following flags, which differ in what happens if no such implementation exists:
     * 
     *  * BuilderFlag::kOBEY_PRECISION_CONSTRAINTS - build fails with an error message.
     * 
     *  * BuilderFlag::kPREFER_PRECISION_CONSTRAINTS - TensorRT falls back to an
     *    implementation with a non-conforming output type.
     * 
     *  In case layer precision is not specified, or falling back, the output type depends on the
     *  chosen implementation, based on performance considerations and the flags specified to the builder.
     * 
     *  This method cannot be used to set the data type of the second output tensor of the TopK layer. The data type of
     *  the second output tensor of the topK layer is always Int32. Also the output type of all layers that are shape
     *  operations must be DataType::kINT32, and all attempts to set the output type to some other data type will be
     *  ignored except for issuing an error message.
     * 
     *  Note that the layer output type is generally not identical to the data type of the output tensor, as TensorRT
     *  may insert implicit reformatting operations to convert the former to the latter. Calling layer->setOutputType(i,
     *  type) has no effect on the data type of the i-th output tensor of layer, and users need to call
     *  layer->getOutput(i)->setType(type) to change the tensor data type. This is particularly relevant if the tensor
     *  is marked as a network output, since only setType() [but not setOutputType()] will affect the data
     *  representation in the corresponding output binding.
     * 
     *  @param index the index of the output to set
     *  @param dataType the type of the output
     * 
     *  @see getOutputType() outputTypeIsSet() resetOutputType()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void setOutputType(int index, DataType dataType);
    public native @NoException(true) void setOutputType(int index, @Cast("nvinfer1::DataType") int dataType);

    /**
     *  \brief get the output type of this layer
     * 
     *  @param index the index of the output
     *  @return the output precision. If no precision has been set, DataType::kFLOAT will be returned,
     *          unless the output type is inherently DataType::kINT32.
     * 
     *  @see getOutputType() outputTypeIsSet() resetOutputType()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) DataType getOutputType(int index);

    /**
     *  \brief whether the output type has been set for this layer
     * 
     *  @param index the index of the output
     *  @return whether the output type has been explicitly set
     * 
     *  @see setOutputType() getOutputType() resetOutputType()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean outputTypeIsSet(int index);

    /**
     *  \brief reset the output type for this layer
     * 
     *  @param index the index of the output
     * 
     *  @see setOutputType() getOutputType() outputTypeIsSet()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void resetOutputType(int index);

    /**
     *  \brief Set the metadata for this layer.
     * 
     *  The metadata is emitted in the JSON returned by IEngineInspector with
     *  ProfilingVerbosity set to kDETAILED.
     * 
     *  @param metadata The per-layer metadata.
     * 
     *  \warning The string name must be null-terminated and be at most 4096 bytes including the terminator.
     * 
     *  @see getMetadata()
     *  @see getLayerInformation()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void setMetadata(String metadata);
    public native @NoException(true) void setMetadata(@Cast("const char*") BytePointer metadata);

    /**
     *  \brief Get the metadata of the layer.
     * 
     *  @return The metadata as a null-terminated C-style string. If setMetadata() has not been called,
     *          an empty string "" will be returned as a default value.
     * 
     *  @see setMetadata()
     *  */
    public native @NoException(true) String getMetadata();
}
