// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  Helper for constructing conditionally-executed subgraphs.
 * 
 *  An If-conditional conditionally executes part of the network according
 *  to the following pseudo-code:
 * 
 *  If condition is true then:
 *      output = trueSubgraph(trueInputs);
 *  Else
 *      output = falseSubgraph(falseInputs);
 *  Emit output
 * 
 *  Condition is a 0D boolean tensor (representing a scalar).
 *  trueSubgraph represents a network subgraph that is executed when condition is evaluated to True.
 *  falseSubgraph represents a network subgraph that is executed when condition is evaluated to False.
 * 
 *  The following constraints apply to If-conditionals:
 *  - Both the trueSubgraph and falseSubgraph must be defined.
 *  - The number of output tensors in both subgraphs is the same.
 *  - The type and shape of each output tensor from true/false subgraphs are the same.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IIfConditional extends INoCopy {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IIfConditional(Pointer p) { super(p); }

    /**
     *  \brief Set the condition tensor for this If-Conditional construct.
     * 
     *  @param condition The condition tensor that will determine which subgraph to execute.
     * 
     *  \p condition tensor must be a 0D execution tensor (scalar) with type DataType::kBOOL.
     * 
     *  @see IConditionLayer
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IConditionLayer setCondition(@ByRef ITensor condition);

    /**
     *  \brief Add an If-conditional output.
     * 
     *  @param trueSubgraphOutput The output of the subgraph executed when the conditional evaluates to true.
     *  @param falseSubgraphOutput The output of the subgraph executed when the conditional evaluates to false.
     * 
     *  Each output layer of an IIfConditional represents a single output of either the true-subgraph or the
     *  false-subgraph of an IIfConditional, depending on which subgraph was executed.
     * 
     *  @see IIfConditionalOutputLayer
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) IIfConditionalOutputLayer addOutput(@ByRef ITensor trueSubgraphOutput, @ByRef ITensor falseSubgraphOutput);

    /**
     *  \brief Add an If-conditional input.
     * 
     *  @param input An input to the conditional that can be used by either or both of the conditional’s subgraphs.
     * 
     *  @see IIfConditionalInputLayer
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IIfConditionalInputLayer addInput(@ByRef ITensor input);

    /**
     *  \brief Set the name of the conditional.
     * 
     *  The name is used in error diagnostics.
     *  This method copies the name string.
     * 
     *  \warning The string name must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see getName()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setName(String name);
    public native @NoException(true) void setName(@Cast("const char*") BytePointer name);

    /**
     *  \brief Return the name of the conditional.
     * 
     *  @see setName()
     *  */
    public native @NoException(true) String getName();
}
