// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/** \class IIdentityLayer
 * 
 *  \brief A layer that represents the identity function.
 * 
 *  If the output type is explicitly specified via setOutputType, IIdentityLayer can be
 *  used to convert from one type to another. Other than conversions between the same
 *  type (kFLOAT -> kFLOAT for example), the only valid conversions are:
 * 
 *      (kFLOAT | kHALF | kINT32 | kBOOL) -> (kFLOAT | kHALF | kINT32 | kBOOL)
 * 
 *      (kFLOAT | kHALF) -> kUINT8
 * 
 *      kUINT8 -> (kFLOAT | kHALF)
 * 
 *  Conversion also happens implicitly, without calling setOutputType, if the output
 *  tensor is a network output.
 * 
 *  Two types are compatible if they are identical, or are both in {kFLOAT, kHALF}.
 *  Implicit conversion between incompatible types, i.e. without using setOutputType,
 *  is recognized as incorrect as of TensorRT 8.4, but is retained for API compatibility
 *  within TensorRT 8.x releases. In a future major release the behavior will change
 *  to record an error if the network output tensor type is incompatible with the layer
 *  output type. E.g., implicit conversion from kFLOAT to kINT32 will not be allowed,
 *  and instead such a conversion will require calling setOutputType(DataType::kINT32).
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IIdentityLayer extends ILayer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IIdentityLayer(Pointer p) { super(p); }

}
