// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/** \class IGridSampleLayer
 * 
 *  \brief A GridSample layer in a network definition.
 * 
 *  This layer uses an input tensor and a grid tensor to produce an interpolated output tensor.
 *  The input and grid tensors must be shape tensors of rank 4. The only supported SampleMode
 *  values are SampleMode::kCLAMP, SampleMode::kFILL, and SampleMode::kREFLECT.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IGridSampleLayer extends ILayer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IGridSampleLayer(Pointer p) { super(p); }

    /**
     *  \brief Set the grid sample interpolation mode.
     * 
     *  @see getInterpolationMode()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void setInterpolationMode(InterpolationMode mode);
    public native @NoException(true) void setInterpolationMode(@Cast("nvinfer1::InterpolationMode") int mode);

    /**
     *  \brief Get the grid sample interpolation mode.
     * 
     *  @see setInterpolationMode()
     * 
     *  @return The value specified by setInterpolationMode, or InterpolationMode::kLINEAR otherwise.
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) InterpolationMode getInterpolationMode();

    /**
     *  \brief Set the align corners mode.
     * 
     *  @see getAlignCorners()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) void setAlignCorners(@Cast("bool") boolean alignCorners);

    /**
     *  \brief Get the align corners mode.
     * 
     *  @see setAlignCorners()
     * 
     *  @return The value specified by setAlignCorners(), or false otherwise.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean getAlignCorners();

    /**
     *  \brief Set the sample mode.
     * 
     *  @see getSampleMode()
     * 
     *  @return true if layer's sample mode was set to mode, false otherwise.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setSampleMode(SampleMode mode);
    public native @Cast("bool") @NoException(true) boolean setSampleMode(@Cast("nvinfer1::SampleMode") int mode);

    /**
     *  \brief Get the sample mode.
     * 
     *  @see setSampleMode()
     * 
     *  @return the value specified by a successful call to setSampleMode(), or SampleMode::kFILL otherwise.
     *  */
    public native @NoException(true) SampleMode getSampleMode();
}
