// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IExecutionContext
 * 
 *  \brief Context for executing inference using an engine, with functionally unsafe features.
 * 
 *  Multiple execution contexts may exist for one ICudaEngine instance, allowing the same
 *  engine to be used for the execution of multiple batches simultaneously. If the engine supports
 *  dynamic shapes, each execution context in concurrent use must use a separate optimization profile.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI. */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IExecutionContext extends INoCopy {
    static { Loader.load(); }
    /** Default native constructor. */
    public IExecutionContext() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IExecutionContext(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IExecutionContext(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public IExecutionContext position(long position) {
        return (IExecutionContext)super.position(position);
    }
    @Override public IExecutionContext getPointer(long i) {
        return new IExecutionContext((Pointer)this).offsetAddress(i);
    }


    /**
     *  \brief Synchronously execute inference on a batch.
     * 
     *  This method requires an array of input and output buffers. The mapping from tensor names to indices
     *  can be queried using ICudaEngine::getBindingIndex()
     * 
     *  @param batchSize The batch size. This is at most the max batch size value supplied to the builder when the
     *  engine was built. If the network is created with NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag, please use
     *  executeV2() instead, and this batchSize argument has no effect.
     *  @param bindings An array of pointers to input and output buffers for the network.
     * 
     *  @return True if execution succeeded.
     * 
     *  @deprecated Deprecated in TensorRT 8.4. Superseded by executeV2() if the network is created with
     *  NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag.
     * 
     *  \warning This function will trigger layer resource updates if hasImplicitBatchDimension()
     *           returns true and batchSize changes between subsequent calls, possibly resulting
     *           in performance bottlenecks.
     * 
     *  @see ICudaEngine::getBindingIndex() ICudaEngine::getMaxBatchSize()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean execute(int batchSize, @Cast("void*const*") PointerPointer bindings);
    public native @Cast("bool") @Deprecated @NoException(true) boolean execute(int batchSize, @Cast("void*const*") @ByPtrPtr Pointer bindings);

    /**
     *  \brief Enqueue inference of a batch on a stream.
     * 
     *  This method requires an array of input and output buffers. The mapping from tensor names to indices can be
     *  queried using ICudaEngine::getBindingIndex()
     * 
     *  @param batchSize The batch size. This is at most the max batch size value supplied to the builder when the
     *  engine was built. If the network is created with NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag, please use
     *  enqueueV3() instead, and this batchSize argument has no effect.
     *  @param bindings An array of pointers to input and output buffers for the network.
     *  @param stream A cuda stream on which the inference kernels will be enqueued.
     *  @param inputConsumed An optional event which will be signaled when the input buffers can be refilled with new
     *  data.
     * 
     *  @return True if the kernels were enqueued successfully.
     * 
     *  @deprecated Deprecated in TensorRT 8.4. Superseded by enqueueV2() if the network is created with
     *  NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag.
     * 
     *  @see ICudaEngine::getBindingIndex() ICudaEngine::getMaxBatchSize()
     * 
     *  \warning Calling enqueue() in from the same IExecutionContext object with different CUDA streams concurrently
     *           results in undefined behavior. To perform inference concurrently in multiple streams, use one execution
     *           context per stream.
     * 
     *  \warning This function will trigger layer resource updates if hasImplicitBatchDimension()
     *           returns true and batchSize changes between subsequent calls, possibly resulting in performance
     *           bottlenecks.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean enqueue(
            int batchSize, @Cast("void*const*") PointerPointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);
    public native @Cast("bool") @Deprecated @NoException(true) boolean enqueue(
            int batchSize, @Cast("void*const*") @ByPtrPtr Pointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);

    /**
     *  \brief Set the debug sync flag.
     * 
     *  If this flag is set to true, the engine will log the successful execution for each kernel during executeV2(). It
     *  has no effect when using enqueueV2()/enqueueV3().
     * 
     *  @see getDebugSync()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setDebugSync(@Cast("bool") boolean sync);

    /**
     *  \brief Get the debug sync flag.
     * 
     *  @see setDebugSync()
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean getDebugSync();

    /**
     *  \brief Set the profiler.
     * 
     *  @see IProfiler getProfiler()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setProfiler(IProfiler profiler);

    /**
     *  \brief Get the profiler.
     * 
     *  @see IProfiler setProfiler()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) IProfiler getProfiler();

    /**
     *  \brief Get the associated engine.
     * 
     *  @see ICudaEngine
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Const @ByRef @NoException(true) ICudaEngine getEngine();

    /**
     *  \brief Destroy this object.
     * 
     *  @deprecated Deprecated in TRT 8.0. Superseded by {@code delete}.
     * 
     *  \warning Calling destroy on a managed pointer will result in a double-free error.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) void destroy();

    /**
     *  \brief Set the name of the execution context.
     * 
     *  This method copies the name string.
     * 
     *  \warning The string name must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see getName()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setName(String name);
    public native @NoException(true) void setName(@Cast("const char*") BytePointer name);

    /**
     *  \brief Return the name of the execution context.
     * 
     *  @see setName()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) String getName();

    /**
     *  \brief Set the device memory for use by this execution context.
     * 
     *  The memory must be aligned with cuda memory alignment property (using cudaGetDeviceProperties()), and its size
     *  must be at least that returned by getDeviceMemorySize(). Setting memory to nullptr is acceptable if
     *  getDeviceMemorySize() returns 0. If using enqueueV2()/enqueueV3() to run the network, the memory is in use from
     *  the invocation of enqueueV2()/enqueueV3() until network execution is complete. If using executeV2(), it is in
     *  use until executeV2() returns. Releasing or otherwise using the memory for other purposes during this time will
     *  result in undefined behavior.
     * 
     *  @see ICudaEngine::getDeviceMemorySize() ICudaEngine::createExecutionContextWithoutDeviceMemory()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setDeviceMemory(Pointer memory);

    /**
     *  \brief Return the strides of the buffer for the given binding.
     * 
     *  The strides are in units of elements, not components or bytes.
     *  For example, for TensorFormat::kHWC8, a stride of one spans 8 scalars.
     * 
     *  Note that strides can be different for different execution contexts
     *  with dynamic shapes.
     * 
     *  If the bindingIndex is invalid or there are dynamic dimensions that have not been
     *  set yet, returns Dims with Dims::nbDims = -1.
     * 
     *  @param bindingIndex The binding index.
     * 
     *  @deprecated Deprecated in TensorRT 8.5. Superseded by getTensorStrides().
     * 
     *  @see getTensorStrides()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getStrides(int bindingIndex);

    /**
     *  \brief Return the strides of the buffer for the given tensor name.
     * 
     *  The strides are in units of elements, not components or bytes.
     *  For example, for TensorFormat::kHWC8, a stride of one spans 8 scalars.
     * 
     *  Note that strides can be different for different execution contexts
     *  with dynamic shapes.
     * 
     *  If the provided name does not map to an input or output tensor, or there are dynamic dimensions that have not
     *  been set yet, return Dims{-1, {}}
     * 
     *  @param tensorName The name of an input or output tensor.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorStrides(String tensorName);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorStrides(@Cast("const char*") BytePointer tensorName);
    /**
     *  \brief Select an optimization profile for the current context.
     * 
     *  @param profileIndex Index of the profile. It must lie between 0 and
     *         getEngine().getNbOptimizationProfiles() - 1
     * 
     *  The selected profile will be used in subsequent calls to executeV2()/enqueueV2()/enqueueV3().
     * 
     *  When an optimization profile is switched via this API, TensorRT may
     *  enqueue GPU memory copy operations required to set up the new profile during the subsequent
     *  enqueueV2()/enqueueV3() operations. To avoid these calls during enqueueV2()/enqueueV3(), use
     *  setOptimizationProfileAsync() instead.
     * 
     *  If the associated CUDA engine does not have inputs with dynamic shapes, this method need not be
     *  called, in which case the default profile index of 0 will be used (this is particularly
     *  the case for all safe engines).
     * 
     *  setOptimizationProfile() must be called before calling setBindingDimensions() and
     *  setInputShapeBinding() for all dynamic input tensors or input shape tensors, which in
     *  turn must be called before executeV2()/enqueueV2()/enqueueV3().
     * 
     *  \warning This function will trigger layer resource updates on the next
     *           call of enqueueV2()/enqueueV3()/executeV2(), possibly resulting in performance bottlenecks.
     * 
     *  @return true if the call succeeded, else false (e.g. input out of range)
     * 
     *  @deprecated Superseded by setOptimizationProfileAsync. Deprecated prior to TensorRT 8.0 and will be
     *  removed in 9.0.
     * 
     *  @see ICudaEngine::getNbOptimizationProfiles() IExecutionContext::setOptimizationProfileAsync()
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean setOptimizationProfile(int profileIndex);

    /**
     *  \brief Get the index of the currently selected optimization profile.
     * 
     *  If the profile index has not been set yet (implicitly to 0 if no other execution context has been set to
     *  profile 0, or explicitly for all subsequent contexts), an invalid value of -1 will be returned
     *  and all calls to enqueueV2()/enqueueV3()/executeV2() will fail until a valid profile index has been set.
     *  This behavior is deprecated in TensorRT 8.6 and in TensorRT 9.0, all profiles will default to optimization
     *  profile 0 and -1 will no longer be returned.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int getOptimizationProfile();

    /**
     *  \brief Set the dynamic dimensions of an input binding.
     * 
     *  @param bindingIndex index of an input tensor whose dimensions must be compatible with
     *         the network definition (i.e. only the wildcard dimension -1 can be replaced with a
     *         new dimension >= 0).
     * 
     *  @param dimensions specifies the dimensions of the input tensor. It must be in the valid
     *         range for the currently selected optimization profile, and the corresponding engine must
     *         not be safety-certified.
     * 
     *  This method requires the engine to be built without an implicit batch dimension.
     *  This method will fail unless a valid optimization profile is defined for the current
     *  execution context (getOptimizationProfile() must not be -1).
     * 
     *  For all dynamic non-output bindings (which have at least one wildcard dimension of -1),
     *  this method needs to be called before either enqueueV2() or executeV2() may be called.
     *  This can be checked using the method allInputDimensionsSpecified().
     * 
     *  \warning This function will trigger layer resource updates on the next
     *           call of enqueueV2()/executeV2(), possibly resulting in performance bottlenecks,
     *           if the dimensions are different than the previous set dimensions.
     * 
     *  @return false if an error occurs (e.g. bindingIndex is out of range for the currently selected
     *          optimization profile or binding dimension is inconsistent with min-max range of the
     *          optimization profile), else true. Note that the network can still be invalid for certain
     *          combinations of input shapes that lead to invalid output shapes. To confirm the correctness
     *          of the network input shapes, check whether the output binding has valid
     *          dimensions using getBindingDimensions() on the output bindingIndex.
     * 
     *  @deprecated Deprecated in TensorRT 8.5. Superseded by setInputShape().
     * 
     *  @see setInputShape()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean setBindingDimensions(int bindingIndex, @ByVal @Cast("nvinfer1::Dims*") Dims32 dimensions);

    /**
     *  \brief Set shape of given input.
     * 
     *  @param tensorName The name of an input tensor.
     *  @param dims The shape of an input tensor.
     * 
     *  @return True on success, false if the provided name does not map to an input tensor, or if some other error
     *  occurred.
     * 
     *  Each dimension must agree with the network dimension unless the latter was -1.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setInputShape(String tensorName, @Cast("const nvinfer1::Dims*") @ByRef Dims32 dims);
    public native @Cast("bool") @NoException(true) boolean setInputShape(@Cast("const char*") BytePointer tensorName, @Cast("const nvinfer1::Dims*") @ByRef Dims32 dims);

    /**
     *  \brief Get the dynamic dimensions of a binding.
     * 
     *  If the engine was built with an implicit batch dimension, same as ICudaEngine::getBindingDimensions.
     * 
     *  If setBindingDimensions() has been called on this binding (or if there are no
     *  dynamic dimensions), all dimensions will be positive. Otherwise, it is necessary to
     *  call setBindingDimensions() before enqueueV2() or executeV2() may be called.
     * 
     *  If the bindingIndex is out of range, an invalid Dims with nbDims == -1 is returned.
     *  The same invalid Dims will be returned if the engine was not built with an implicit
     *  batch dimension and if the execution context is not currently associated with a valid
     *  optimization profile (i.e. if getOptimizationProfile() returns -1).
     * 
     *  If ICudaEngine::bindingIsInput(bindingIndex) is false, then both
     *  allInputDimensionsSpecified() and allInputShapesSpecified() must be true
     *  before calling this method.
     * 
     *  @return Currently selected binding dimensions
     * 
     *  For backwards compatibility with earlier versions of TensorRT, a bindingIndex that does not belong
     *  to the current profile is corrected as described for ICudaEngine::getProfileDimensions.
     * 
     *  @deprecated Deprecated in TensorRT 8.5. Superseded by getTensorShape().
     * 
     *  @see ICudaEngine::getProfileDimensions()
     *  @see getTensorShape()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getBindingDimensions(int bindingIndex);

    /**
     *  \brief Return the shape of the given input or output.
     * 
     *  @param tensorName The name of an input or output tensor.
     * 
     *  Return Dims{-1, {}} if the provided name does not map to an input or output tensor.
     *  Otherwise return the shape of the input or output tensor.
     * 
     *  A dimension in an input tensor will have a -1 wildcard value if all the following are true:
     *   * setInputShape() has not yet been called for this tensor
     *   * The dimension is a runtime dimension that is not implicitly constrained to be a single value.
     * 
     *  A dimension in an output tensor will have a -1 wildcard value if the dimension depends
     *  on values of execution tensors OR if all the following are true:
     *   * It is a runtime dimension.
     *   * setInputShape() has NOT been called for some input tensor(s) with a runtime shape.
     *   * setTensorAddress() has NOT been called for some input tensor(s) with isShapeInferenceIO() = true.
     * 
     *  An output tensor may also have -1 wildcard dimensions if its shape depends on values of tensors supplied to
     *  enqueueV3().
     * 
     *  If the request is for the shape of an output tensor with runtime dimensions,
     *  all input tensors with isShapeInferenceIO() = true should have their value already set,
     *  since these values might be needed to compute the output shape.
     * 
     *  Examples of an input dimension that is implicitly constrained to a single value:
     *  * The optimization profile specifies equal min and max values.
     *  * The dimension is named and only one value meets the optimization profile requirements
     *    for dimensions with that name.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorShape(String tensorName);
    public native @ByVal @Cast("nvinfer1::Dims*") @NoException(true) Dims32 getTensorShape(@Cast("const char*") BytePointer tensorName);

    /**
     *  \brief Set values of input tensor required by shape calculations.
     * 
     *  @param bindingIndex index of an input tensor for which
     *         ICudaEngine::isShapeBinding(bindingIndex) and ICudaEngine::bindingIsInput(bindingIndex)
     *         are both true.
     * 
     *  @param data pointer to values of the input tensor.  The number of values should be
     *          the product of the dimensions returned by getBindingDimensions(bindingIndex).
     * 
     *  If ICudaEngine::isShapeBinding(bindingIndex) and ICudaEngine::bindingIsInput(bindingIndex)
     *  are both true, this method must be called before enqueueV2() or executeV2() may be called.
     *  This method will fail unless a valid optimization profile is defined for the current
     *  execution context (getOptimizationProfile() must not be -1).
     * 
     *  \warning This function will trigger layer resource updates on the next call of
     *           enqueueV2()/executeV2(), possibly resulting in performance bottlenecks, if the
     *           shapes are different than the previous set shapes.
     * 
     *  @return false if an error occurs (e.g. bindingIndex is out of range for the currently selected
     *          optimization profile or shape data is inconsistent with min-max range of the
     *          optimization profile), else true. Note that the network can still be invalid for certain
     *          combinations of input shapes that lead to invalid output shapes. To confirm the correctness
     *          of the network input shapes, check whether the output binding has valid
     *          dimensions using getBindingDimensions() on the output bindingIndex.
     * 
     *  @deprecated Deprecated in TensorRT 8.5. Superseded by setInputTensorAddress() or setTensorAddress().
     * 
     *  @see setInputTensorAddress() setTensorAddress()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean setInputShapeBinding(int bindingIndex, @Const IntPointer data);
    public native @Cast("bool") @Deprecated @NoException(true) boolean setInputShapeBinding(int bindingIndex, @Const IntBuffer data);
    public native @Cast("bool") @Deprecated @NoException(true) boolean setInputShapeBinding(int bindingIndex, @Const int[] data);

    /**
     *  \brief Get values of an input tensor required for shape calculations or an output tensor produced by shape
     *  calculations.
     * 
     *  @param bindingIndex index of an input or output tensor for which
     *         ICudaEngine::isShapeBinding(bindingIndex) is true.
     * 
     *  @param data pointer to where values will be written.  The number of values written is
     *         the product of the dimensions returned by getBindingDimensions(bindingIndex).
     * 
     *  If ICudaEngine::bindingIsInput(bindingIndex) is false, then both
     *  allInputDimensionsSpecified() and allInputShapesSpecified() must be true
     *  before calling this method. The method will also fail if no valid optimization profile
     *  has been set for the current execution context, i.e. if getOptimizationProfile() returns -1.
     * 
     *  @deprecated Deprecated in TensorRT 8.5. Superseded by getTensorAddress() or getOutputTensorAddress().
     * 
     *  @see isShapeBinding() getTensorAddress() getOutputTensorAddress()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean getShapeBinding(int bindingIndex, IntPointer data);
    public native @Cast("bool") @Deprecated @NoException(true) boolean getShapeBinding(int bindingIndex, IntBuffer data);
    public native @Cast("bool") @Deprecated @NoException(true) boolean getShapeBinding(int bindingIndex, int[] data);

    /**
     *  \brief Whether all dynamic dimensions of input tensors have been specified
     * 
     *  @return True if all dynamic dimensions of input tensors have been specified
     *          by calling setBindingDimensions().
     * 
     *  Trivially true if network has no dynamically shaped input tensors.
     * 
     *  Does not work with name-base interfaces eg. IExecutionContext::setInputShape(). Use
     *  IExecutionContext::inferShapes() instead.
     * 
     *  @see setBindingDimensions(bindingIndex,dimensions)
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean allInputDimensionsSpecified();

    /**
     *  \brief Whether all input shape bindings have been specified
     * 
     *  @return True if all input shape bindings have been specified by setInputShapeBinding().
     * 
     *  Trivially true if network has no input shape bindings.
     * 
     *  Does not work with name-base interfaces eg. IExecutionContext::setInputShape(). Use
     *  IExecutionContext::inferShapes() instead.
     * 
     *  @see isShapeBinding(bindingIndex)
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean allInputShapesSpecified();

    /**
     *  \brief Set the ErrorRecorder for this interface
     * 
     *  Assigns the ErrorRecorder to this interface. The ErrorRecorder will track all errors during execution.
     *  This function will call incRefCount of the registered ErrorRecorder at least once. Setting
     *  recorder to nullptr unregisters the recorder with the interface, resulting in a call to decRefCount if
     *  a recorder has been registered.
     * 
     *  If an error recorder is not set, messages will be sent to the global log stream.
     * 
     *  @param recorder The error recorder to register with this interface. */
    //
    /** @see getErrorRecorder()
    /** */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setErrorRecorder(IErrorRecorder recorder);

    /**
     *  \brief Get the ErrorRecorder assigned to this interface.
     * 
     *  Retrieves the assigned error recorder object for the given class. A nullptr will be returned if
     *  an error handler has not been set.
     * 
     *  @return A pointer to the IErrorRecorder object that has been registered.
     * 
     *  @see setErrorRecorder()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IErrorRecorder getErrorRecorder();

    /**
     *  \brief Synchronously execute inference a network.
     * 
     *  This method requires an array of input and output buffers. The mapping from tensor names to indices can be
     *  queried using ICudaEngine::getBindingIndex().
     *  This method only works for execution contexts built with full dimension networks.
     *  @param bindings An array of pointers to input and output buffers for the network.
     * 
     *  @return True if execution succeeded.
     * 
     *  @see ICudaEngine::getBindingIndex() ICudaEngine::getMaxBatchSize()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean executeV2(@Cast("void*const*") PointerPointer bindings);
    public native @Cast("bool") @NoException(true) boolean executeV2(@Cast("void*const*") @ByPtrPtr Pointer bindings);

    /**
     *  \brief Enqueue inference on a stream.
     * 
     *  This method requires an array of input and output buffers. The mapping from tensor names to indices can be
     *  queried using ICudaEngine::getBindingIndex().
     *  This method only works for execution contexts built with full dimension networks.
     *  @param bindings An array of pointers to input and output buffers for the network.
     *  @param stream A cuda stream on which the inference kernels will be enqueued
     *  @param inputConsumed An optional event which will be signaled when the input buffers can be refilled with new
     *  data
     * 
     *  @return True if the kernels were enqueued successfully.
     * 
     *  @deprecated Superseded by enqueueV3(). Deprecated in TensorRT 8.5
     * 
     *  @see ICudaEngine::getBindingIndex() ICudaEngine::getMaxBatchSize() IExecutionContext::enqueueV3()
     * 
     *  \note Calling enqueueV2() with a stream in CUDA graph capture mode has a known issue. If dynamic shapes are
     *        used, the first enqueueV2() call after a setInputShapeBinding() call will cause failure in stream capture
     *        due to resource allocation. Please call enqueueV2() once before capturing the graph.
     * 
     *  \warning Calling enqueueV2() in from the same IExecutionContext object with different CUDA streams concurrently
     *           results in undefined behavior. To perform inference concurrently in multiple streams, use one execution
     *           context per stream.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @Deprecated @NoException(true) boolean enqueueV2(@Cast("void*const*") PointerPointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);
    public native @Cast("bool") @Deprecated @NoException(true) boolean enqueueV2(@Cast("void*const*") @ByPtrPtr Pointer bindings, CUstream_st stream, @ByPtrPtr CUevent_st inputConsumed);

    /**
     *  \brief Select an optimization profile for the current context with async
     *  semantics.
     * 
     *  @param profileIndex Index of the profile. The value must lie between 0 and
     *         getEngine().getNbOptimizationProfiles() - 1
     * 
     *  @param stream A cuda stream on which the cudaMemcpyAsyncs may be
     *  enqueued
     * 
     *  When an optimization profile is switched via this API, TensorRT may
     *  require that data is copied via cudaMemcpyAsync. It is the
     *  application’s responsibility to guarantee that synchronization between
     *  the profile sync stream and the enqueue stream occurs.
     * 
     *  The selected profile will be used in subsequent calls to executeV2()/enqueueV2()/enqueueV3().
     *  If the associated CUDA engine has inputs with dynamic shapes, the optimization profile must
     *  be set with its corresponding profileIndex before calling execute or enqueue. If no execution
     *  context is assigned optimization profile 0 and a new context is created for an engine,
     *  setOptimizationProfile(0) is called implicitly. This functionality is deprecated in TensorRT 8.6
     *  and will instead default all optimization profiles to 0 starting in TensorRT 9.0.
     * 
     *  If the associated CUDA engine does not have inputs with dynamic shapes,
     *  this method need not be called, in which case the default profile index
     *  of 0 will be used.
     * 
     *  setOptimizationProfileAsync() must be called before calling
     *  setBindingDimensions() and setInputShapeBinding() for all dynamic input
     *  tensors or input shape tensors, which in turn must be called before
     *  executeV2()/enqueueV2()/enqueueV3().
     * 
     *  \warning This function will trigger layer resource updates on the next call of
     *           enqueueV2()/executeV2()/enqueueV3(), possibly resulting in performance bottlenecks.
     * 
     *  \warning Not synchronizing the stream used at enqueue with the stream
     *  used to set optimization profile asynchronously using this API will
     *  result in undefined behavior.
     * 
     *  @return true if the call succeeded, else false (e.g. input out of range)
     * 
     *  @see ICudaEngine::getNbOptimizationProfiles()
     *  @see IExecutionContext::setOptimizationProfile() */
    
    
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setOptimizationProfileAsync(int profileIndex, CUstream_st stream);

    /**
     *  \brief Set whether enqueue emits layer timing to the profiler
     * 
     *  If set to true (default), enqueue is synchronous and does layer timing profiling implicitly if
     *  there is a profiler attached.
     *  If set to false, enqueue will be asynchronous if there is a profiler attached. An extra method
     *  reportToProfiler() needs to be called to obtain the profiling data and report to the profiler attached.
     * 
     *  @see IExecutionContext::getEnqueueEmitsProfile()
     *  @see IExecutionContext::reportToProfiler() */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setEnqueueEmitsProfile(@Cast("bool") boolean enqueueEmitsProfile);

    /**
     *  \brief Get the enqueueEmitsProfile state.
     * 
     *  @return The enqueueEmitsProfile state.
     * 
     *  @see IExecutionContext::setEnqueueEmitsProfile() */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean getEnqueueEmitsProfile();

    /**
     *  \brief Calculate layer timing info for the current optimization profile in IExecutionContext
     *  and update the profiler after one iteration of inference launch.
     * 
     *  If IExecutionContext::getEnqueueEmitsProfile() returns true, the enqueue function will calculate layer timing
     *  implicitly if a profiler is provided. This function returns true and does nothing.
     * 
     *  If IExecutionContext::getEnqueueEmitsProfile() returns false, the enqueue function will record the CUDA event
     *  timers if a profiler is provided. But it will not perform the layer timing calculation.
     *  IExecutionContext::reportToProfiler() needs to be called explicitly to calculate layer timing for the previous
     *  inference launch.
     * 
     *  In the CUDA graph launch scenario, it will record the same set of CUDA events
     *  as in regular enqueue functions if the graph is captured from an IExecutionContext with profiler enabled.
     *  This function needs to be called after graph launch to report the layer timing info to the profiler.
     * 
     *  \warning profiling CUDA graphs is only available from CUDA 11.1 onwards.
     *  \warning reportToProfiler uses the stream of the previous enqueue call, so the stream must be live otherwise
     *  behavior is undefined.
     * 
     *  @return true if the call succeeded, else false (e.g. profiler not provided, in CUDA graph capture mode, etc.)
     * 
     *  @see IExecutionContext::setEnqueueEmitsProfile()
     *  @see IExecutionContext::getEnqueueEmitsProfile() */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean reportToProfiler();

    /**
     *  \brief Set memory address for given input or output tensor.
     * 
     *  @param tensorName The name of an input or output tensor.
     *  @param data The pointer (void*) to the data owned by the user.
     * 
     *  @return True on success, false if error occurred.
     * 
     *  An address defaults to nullptr.
     *  Pass data=nullptr to reset to the default state.
     * 
     *  Return false if the provided name does not map to an input or output tensor.
     * 
     *  If an input pointer has type (void const*), use setInputTensorAddress() instead.
     * 
     *  Before calling enqueueV3(), each input must have a non-null address and
     *  each output must have a non-null address or an IOutputAllocator to set it later.
     * 
     *  If the TensorLocation of the tensor is kHOST, the pointer must point to a host buffer of sufficient size. For
     *  shape tensors, the only supported data type is int32_t.
     *  If the TensorLocation of the tensor is kDEVICE, the pointer must point to a device buffer of sufficient size and
     *  alignment, or be nullptr if the tensor is an output tensor that will be allocated by IOutputAllocator.
     * 
     *  If getTensorShape(name) reports a -1 for any dimension of an output after all
     *  input shapes have been set, then to find out
     *  the dimensions, use setOutputAllocator() to associate an IOutputAllocator to
     *  which the dimensions will be reported when known.
     * 
     *  Calling both setTensorAddress and setOutputAllocator() for the same output is allowed,
     *  and can be useful for preallocating memory, and then reallocating if it's not big enough.
     * 
     *  The pointer must have at least 256-byte alignment.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see setInputTensorAddress() getTensorShape() setOutputAllocator() IOutputAllocator
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setTensorAddress(String tensorName, Pointer data);
    public native @Cast("bool") @NoException(true) boolean setTensorAddress(@Cast("const char*") BytePointer tensorName, Pointer data);

    /**
     *  \brief Get memory address bound to given input or output tensor, or nullptr if the provided name does not map to
     *  an input or output tensor.
     * 
     *  @param tensorName The name of an input or output tensor.
     * 
     *  Use method getOutputTensorAddress() if a non-const pointer for an output tensor is required.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see getOutputTensorAddress()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Const @NoException(true) Pointer getTensorAddress(String tensorName);
    public native @Const @NoException(true) Pointer getTensorAddress(@Cast("const char*") BytePointer tensorName);

    /**
     *  \brief Set memory address for given input.
     * 
     *  @param tensorName The name of an input tensor.
     *  @param data The pointer (void const*) to the const data owned by the user.
     * 
     *  @return True on success, false if the provided name does not map to an input tensor, does not meet alignment
     *  requirements, or some other error occurred.
     * 
     *  Input addresses can also be set using method setTensorAddress, which requires a (void*).
     * 
     *  See description of method setTensorAddress() for alignment and data type constraints.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see setTensorAddress()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setInputTensorAddress(String tensorName, @Const Pointer data);
    public native @Cast("bool") @NoException(true) boolean setInputTensorAddress(@Cast("const char*") BytePointer tensorName, @Const Pointer data);

    /**
     *  \brief Get memory address for given output.
     * 
     *  @param tensorName The name of an output tensor.
     * 
     *  @return Raw output data pointer (void*) for given output tensor, or nullptr if the provided name does not map to
     *  an output tensor.
     * 
     *  If only a (void const*) pointer is needed, an alternative is to call method getTensorAddress().
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see getTensorAddress()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) Pointer getOutputTensorAddress(String tensorName);
    public native @NoException(true) Pointer getOutputTensorAddress(@Cast("const char*") BytePointer tensorName);

    /**
     *  \brief Run shape calculations.
     * 
     *  @param nbMaxNames Maximum number of names to write to tensorNames.
     *         When the return value is a positive value n and tensorNames != nullptr,
     *         the names of min(n,nbMaxNames) insufficiently specified input tensors are
     *         written to tensorNames.
     * 
     *  @param tensorNames Buffer in which to place names of insufficiently specified input tensors.
     * 
     *  @return 0 on success.
     *          Positive value n if n input tensors were not sufficiently specified.
     *          -1 for other errors.
     * 
     *  An input tensor is insufficiently specified if either of the following is true:
     * 
     *  * It has dynamic dimensions and its runtime dimensions have not yet
     *    been specified via IExecutionContext::setInputShape.
     * 
     *  * isShapeInferenceIO(t)=true and the tensor's address has not yet been set.
     * 
     *  If an output tensor has isShapeInferenceIO(t)=true and its address has been specified,
     *  then its value is written.
     * 
     *  Returns -1 if tensorNames == nullptr and nbMaxNames != 0.
     *  Returns -1 if nbMaxNames < 0.
     *  Returns -1 if a tensor's dimensions are invalid, e.g. a tensor ends up with a negative dimension.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") PointerPointer tensorNames);
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") @ByPtrPtr BytePointer tensorNames);
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") @ByPtrPtr ByteBuffer tensorNames);
    public native @NoException(true) int inferShapes(int nbMaxNames, @Cast("const char**") @ByPtrPtr byte[] tensorNames);

    /**
     *  \brief Mark input as consumed.
     * 
     *  @param event The cuda event that is triggered after all input tensors have been consumed.
     * 
     *  \warning The set event must be valid during the inferece.
     * 
     *  @return True on success, false if error occurred.
     * 
     *  Passing event==nullptr removes whatever event was set, if any.
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setInputConsumedEvent(CUevent_st event);

    /**
     *  \brief The event associated with consuming the input.
     * 
     *  @return The cuda event. Nullptr will be returned if the event is not set yet.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) CUevent_st getInputConsumedEvent();

    /**
     *  \brief Set output allocator to use for output tensor of given name.
     *  Pass nullptr to outputAllocator to unset.
     *  The allocator is called by enqueueV3().
     * 
     *  @param tensorName The name of an output tensor.
     *  @param outputAllocator IOutputAllocator for the tensors.
     * 
     *  @return True if success, false if the provided name does not map to an output or, if some other error occurred.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see enqueueV3() IOutputAllocator
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setOutputAllocator(String tensorName, IOutputAllocator outputAllocator);
    public native @Cast("bool") @NoException(true) boolean setOutputAllocator(@Cast("const char*") BytePointer tensorName, IOutputAllocator outputAllocator);

    /**
     *  \brief Get output allocator associated with output tensor of given name, or nullptr if the provided name does
     *  not map to an output tensor.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     * 
     *  @see IOutputAllocator
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IOutputAllocator getOutputAllocator(String tensorName);
    public native @NoException(true) IOutputAllocator getOutputAllocator(@Cast("const char*") BytePointer tensorName);

    /**
     *  \brief Get upper bound on an output tensor's size, in bytes, based on
     *  the current optimization profile and input dimensions.
     * 
     *  If the profile or input dimensions are not yet set, or the provided name
     *  does not map to an output, returns -1.
     * 
     *  @param tensorName The name of an output tensor.
     * 
     *  @return Upper bound in bytes.
     * 
     *  \warning The string tensorName must be null-terminated, and be at most 4096 bytes including the terminator.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("int64_t") @NoException(true) long getMaxOutputSize(String tensorName);
    public native @Cast("int64_t") @NoException(true) long getMaxOutputSize(@Cast("const char*") BytePointer tensorName);

    /**
     *  \brief Specify allocator to use for internal temporary storage.
     * 
     *  This allocator is used only by enqueueV3() for temporary storage whose size cannot be
     *  predicted ahead of enqueueV3(). It is not used for output tensors, because memory
     *  allocation for those is allocated by the allocator set by setOutputAllocator().
     *  All memory allocated is freed by the time enqueueV3() returns.
     * 
     *  @param allocator pointer to allocator to use. Pass nullptr to revert to using TensorRT's
     *         default allocator.
     * 
     *  @return True on success, false if error occurred.
     * 
     *  @see enqueueV3() setOutputAllocator()
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setTemporaryStorageAllocator(IGpuAllocator allocator);

    /**
     *  \brief Get allocator set by setTemporaryStorageAllocator.
     * 
     *  Returns a nullptr if a nullptr was passed with setTemporaryStorageAllocator().
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IGpuAllocator getTemporaryStorageAllocator();

    /**
     *  \brief Enqueue inference on a stream.
     * 
     *  @param stream A cuda stream on which the inference kernels will be enqueued.
     * 
     *  @return True if the kernels were enqueued successfully, false otherwise.
     * 
     *  Modifying or releasing memory that has been registered for the tensors before stream
     *  synchronization or the event passed to setInputConsumedEvent has been being triggered results in undefined
     *  behavior.
     *  Input tensor can be released after the setInputConsumedEvent whereas output tensors require stream
     *  synchronization.
     *  */
    
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean enqueueV3(CUstream_st stream);

    /** \brief Set the maximum size for persistent cache usage.
     * 
     *  This function sets the maximum persistent L2 cache that this execution context may use for activation caching.
     *  Activation caching is not supported on all architectures - see "How TensorRT uses Memory" in the developer guide
     *  for details
     * 
     *  @param size the size of persistent cache limitation in bytes.
     *  The default is 0 Bytes.
     * 
     *  @see getPersistentCacheLimit */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setPersistentCacheLimit(@Cast("size_t") long size);

    /**
     *  \brief Get the maximum size for persistent cache usage.
     * 
     *  @return The size of the persistent cache limit
     * 
     *  @see setPersistentCacheLimit */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("size_t") @NoException(true) long getPersistentCacheLimit();

    /**
     *  \brief Set the verbosity of the NVTX markers in the execution context.
     * 
     *  Building with kDETAILED verbosity will generally increase latency in enqueueV2/enqueueV3(). Call this method
     *  to select NVTX verbosity in this execution context at runtime.
     * 
     *  The default is the verbosity with which the engine was built, and the verbosity may not be raised above that
     *  level.
     * 
     *  This function does not affect how IEngineInspector interacts with the engine.
     * 
     *  @param verbosity The verbosity of the NVTX markers.
     * 
     *  @return True if the NVTX verbosity is set successfully. False if the provided verbosity level is higher than the
     *  profiling verbosity of the corresponding engine.
     * 
     *  @see getNvtxVerbosity()
     *  @see ICudaEngine::getProfilingVerbosity()
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setNvtxVerbosity(ProfilingVerbosity verbosity);
    public native @Cast("bool") @NoException(true) boolean setNvtxVerbosity(@Cast("nvinfer1::ProfilingVerbosity") int verbosity);

    /**
     *  \brief Get the NVTX verbosity of the execution context.
     * 
     *  @return The current NVTX verbosity of the execution context.
     * 
     *  @see setNvtxVerbosity()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) ProfilingVerbosity getNvtxVerbosity();

    /**
     *  \brief Set the auxiliary streams that TensorRT should launch kernels on in the next enqueueV3() call.
     * 
     *  If set, TensorRT will launch the kernels that are supposed to run on the auxiliary streams using the streams
     *  provided by the user with this API. If this API is not called before the enqueueV3() call, then TensorRT will
     *  use the auxiliary streams created by TensorRT internally.
     * 
     *  TensorRT will always insert event synchronizations between the main stream provided via enqueueV3() call and the
     *  auxiliary streams:
     *   - At the beginning of the enqueueV3() call, TensorRT will make sure that all the auxiliary streams wait on
     *     the activities on the main stream.
     *   - At the end of the enqueueV3() call, TensorRT will make sure that the main stream wait on the activities on
     *     all the auxiliary streams.
     * 
     *  @param auxStreams The pointer to an array of cudaStream_t with the array length equal to nbStreams.
     *  @param nbStreams The number of auxiliary streams provided. If nbStreams is greater than
     *         {@code engine->getNbAuxStreams()}, then only the first {@code engine->getNbAuxStreams()} streams will be used. If
     *         {@code nbStreams} is less than {@code engine->getNbAuxStreams()}, such as setting {@code nbStreams} to 0, then TensorRT
     *         will use the provided streams for the first {@code nbStreams} auxiliary streams, and will create additional
     *         streams internally for the rest of the auxiliary streams.
     * 
     *  \note The provided auxiliary streams must not be the default stream and must all be different to avoid
     *        deadlocks.
     * 
     *  @see enqueueV3(), IBuilderConfig::setMaxAuxStreams(), ICudaEngine::getNbAuxStreams()
     *  */
    public native @NoException(true) void setAuxStreams(@ByPtrPtr CUstream_st auxStreams, int nbStreams);
}
