// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IEngineInspector
 * 
 *  \brief An engine inspector which prints out the layer information of an engine or an execution context.
 * 
 *  The amount of printed information depends on the profiling verbosity setting of the builder config when the engine
 *  is built:
 *  - ProfilingVerbosity::kLAYER_NAMES_ONLY: only layer names will be printed.
 *  - ProfilingVerbosity::kNONE: no layer information will be printed.
 *  - ProfilingVerbosity::kDETAILED: layer names and layer parameters will be printed.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 * 
 *  @see ProfilingVerbosity, IEngineInspector
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IEngineInspector extends INoCopy {
    static { Loader.load(); }
    /** Default native constructor. */
    public IEngineInspector() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IEngineInspector(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IEngineInspector(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public IEngineInspector position(long position) {
        return (IEngineInspector)super.position(position);
    }
    @Override public IEngineInspector getPointer(long i) {
        return new IEngineInspector((Pointer)this).offsetAddress(i);
    }


    /**
     *  \brief Set an execution context as the inspection source.
     * 
     *  Setting the execution context and specifying all the input shapes allows the inspector
     *  to calculate concrete dimensions for any dynamic shapes and display their format information.
     *  Otherwise, values dependent on input shapes will be displayed as -1 and format information
     *  will not be shown.
     * 
     *  Passing nullptr will remove any association with an execution context.
     * 
     *  @return Whether the action succeeds.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setExecutionContext(@Const IExecutionContext context);

    /**
     *  \brief Get the context currently being inspected.
     * 
     *  @return The pointer to the context currently being inspected.
     * 
     *  @see setExecutionContext()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Const @NoException(true) IExecutionContext getExecutionContext();

    /**
     *  \brief Get a string describing the information about a specific layer in the current engine or the execution
     *         context.
     * 
     *  @param layerIndex the index of the layer. It must lie in range [0, engine.getNbLayers()).
     * 
     *  @param format the format the layer information should be printed in.
     * 
     *  @return A null-terminated C-style string describing the information about a specific layer in the current
     *          engine or the execution context.
     * 
     *  \warning The content of the returned string may change when another execution context has
     *           been set, or when another getLayerInformation() or getEngineInformation() has been called.
     * 
     *  \warning In a multi-threaded environment, this function must be protected from other threads changing the
     *           inspection source. If the inspection source changes, the data that is being pointed to can change.
     *           Copy the string to another buffer before releasing the lock in order to guarantee consistency.
     * 
     *  @see LayerInformationFormat
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) String getLayerInformation(int layerIndex, LayerInformationFormat format);
    public native @NoException(true) @Cast("const char*") BytePointer getLayerInformation(int layerIndex, @Cast("nvinfer1::LayerInformationFormat") int format);

    /**
     *  \brief Get a string describing the information about all the layers in the current engine or the execution
     *         context.
     * 
     *  @param format the format the layer information should be printed in.
     * 
     *  @return A null-terminated C-style string describing the information about all the layers in the current
     *          engine or the execution context.
     * 
     *  \warning The content of the returned string may change when another execution context has
     *           been set, or when another getLayerInformation() or getEngineInformation() has been called.
     * 
     *  \warning In a multi-threaded environment, this function must be protected from other threads changing the
     *           inspection source. If the inspection source changes, the data that is being pointed to can change.
     *           Copy the string to another buffer before releasing the lock in order to guarantee consistency.
     * 
     *  @see LayerInformationFormat
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) String getEngineInformation(LayerInformationFormat format);
    public native @NoException(true) @Cast("const char*") BytePointer getEngineInformation(@Cast("nvinfer1::LayerInformationFormat") int format);

    /**
     *  \brief Set the ErrorRecorder for this interface
     * 
     *  Assigns the ErrorRecorder to this interface. The ErrorRecorder will track all errors during execution.
     *  This function will call incRefCount of the registered ErrorRecorder at least once. Setting
     *  recorder to nullptr unregisters the recorder with the interface, resulting in a call to decRefCount if
     *  a recorder has been registered.
     * 
     *  If an error recorder is not set, messages will be sent to the global log stream.
     * 
     *  @param recorder The error recorder to register with this interface. */
    //
    /** @see getErrorRecorder()
    /** */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setErrorRecorder(IErrorRecorder recorder);

    /**
     *  \brief Get the ErrorRecorder assigned to this interface.
     * 
     *  Retrieves the assigned error recorder object for the given class. A nullptr will be returned if
     *  an error handler has not been set.
     * 
     *  @return A pointer to the IErrorRecorder object that has been registered.
     * 
     *  @see setErrorRecorder()
     *  */
    public native @NoException(true) IErrorRecorder getErrorRecorder();
}
