// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IConcatenationLayer
 * 
 *  \brief A concatenation layer in a network definition.
 * 
 *  The output dimension along the concatenation axis is the sum of the corresponding input dimensions.
 *  Every other output dimension is the same as the corresponding dimension of the inputs.
 * 
 *  \warning All tensors must have the same dimensions except along the concatenation axis.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IConcatenationLayer extends ILayer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IConcatenationLayer(Pointer p) { super(p); }

    /**
     *  \brief Set the axis along which concatenation occurs.
     * 
     *  The default axis is the number of tensor dimensions minus three, or zero if the tensor has fewer than three
     *  dimensions. For example, for a tensor with dimensions NCHW, it is C.
     *  For implicit batch mode, the number of tensor dimensions does NOT include the implicit batch dimension.
     * 
     *  When running this layer on the DLA, the concatenation axis must be the third to last axis, e.g. C if tensor
     *  dimensions are NCHW.
     * 
     *  @param axis The axis along which concatenation occurs.
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setAxis(int axis);

    /**
     *  \brief Get the axis along which concatenation occurs.
     * 
     *  @see setAxis()
     *  */
    public native @NoException(true) int getAxis();
}
