// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IBuilder
 * 
 *  \brief Builds an engine from a network definition.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IBuilder extends INoCopy {
    static { Loader.load(); }
    /** Default native constructor. */
    public IBuilder() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IBuilder(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IBuilder(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public IBuilder position(long position) {
        return (IBuilder)super.position(position);
    }
    @Override public IBuilder getPointer(long i) {
        return new IBuilder((Pointer)this).offsetAddress(i);
    }


    /**
     *  \brief Set the maximum batch size. This has no effect for networks created with explicit batch dimension mode.
     * 
     *  @param batchSize The maximum batch size which can be used at execution time, and also the batch size for which
     *  the engine will be optimized.
     * 
     *  @deprecated Deprecated in TensorRT 8.4.
     * 
     *  @see getMaxBatchSize()
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) void setMaxBatchSize(int batchSize);

    /**
     *  \brief Get the maximum batch size.
     * 
     *  @return The maximum batch size.
     * 
     *  @deprecated Deprecated in TensorRT 8.4.
     * 
     *  @see setMaxBatchSize()
     *  @see getMaxDLABatchSize()
     *  */
    
    
    //!
    //!
    public native @Deprecated @NoException(true) int getMaxBatchSize();

    /**
     *  \brief Determine whether the platform has fast native fp16.
     *  */
    
    
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean platformHasFastFp16();

    /**
     *  \brief Determine whether the platform has fast native int8.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean platformHasFastInt8();

    /**
     *  \brief Destroy this object.
     * 
     *  @deprecated Deprecated in TensorRT 8.0. Superseded by {@code delete}.
     * 
     *  \warning Calling destroy on a managed pointer will result in a double-free error.
     *  */
    
    
    //!
    //!
    //!
    public native @Deprecated @NoException(true) void destroy();

    /**
     *  \brief Get the maximum batch size DLA can support.
     *  For any tensor the total volume of index dimensions combined(dimensions other than CHW) with the requested
     *  batch size should not exceed the value returned by this function.
     * 
     *  \warning getMaxDLABatchSize does not work with dynamic shapes.
     *  */
    
    
    //!
    //!
    public native @NoException(true) int getMaxDLABatchSize();

    /**
     *  \brief Return the number of DLA engines available to this builder.
     *  */
    
    
    //!
    //!
    //!
    //!
    public native @NoException(true) int getNbDLACores();

    /**
     *  \brief Set the GPU allocator.
     *  @param allocator Set the GPU allocator to be used by the builder. All GPU memory acquired will use this
     *  allocator. If NULL is passed, the default allocator will be used.
     * 
     *  Default: uses cudaMalloc/cudaFree.
     * 
     *  \note This allocator will be passed to any engines created via the builder; thus the lifetime of the allocator
     *  must span the lifetime of those engines as
     *  well as that of the builder. If nullptr is passed, the default allocator will be used.
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setGpuAllocator(IGpuAllocator allocator);

    /**
     *  \brief Create a builder configuration object.
     * 
     *  @see IBuilderConfig
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IBuilderConfig createBuilderConfig();

    /**
     *  \brief Builds an engine for the given INetworkDefinition and given IBuilderConfig.
     * 
     *  It enables the builder to build multiple engines based on the same network definition, but with different
     *  builder configurations.
     * 
     *  \note This function will synchronize the cuda stream returned by \p config.getProfileStream() before returning.
     * 
     *  @deprecated Deprecated in TensorRT 8.0. Superseded by IBuilder::buildSerializedNetwork().
     *  */
    
    //!
    //!
    //!
    //!
    public native @Deprecated @NoException(true) ICudaEngine buildEngineWithConfig(
            @ByRef INetworkDefinition network, @ByRef IBuilderConfig config);

    /** \brief Create a network definition object
     * 
     *  Creates a network definition object with immutable properties specified using the flags parameter.
     *  CreateNetworkV2 supports dynamic shapes and explicit batch dimensions when used with
     *  NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag.
     *  Creating a network without NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag has been deprecated.
     * 
     *  @param flags Bitset of NetworkDefinitionCreationFlags specifying network properties combined with bitwise OR.
     *              e.g., 1U << NetworkDefinitionCreationFlag::kEXPLICIT_BATCH
     * 
     *  @see INetworkDefinition, NetworkDefinitionCreationFlags
     *  */
    
    //!
    //!
    //!
    public native @NoException(true) INetworkDefinition createNetworkV2(@Cast("nvinfer1::NetworkDefinitionCreationFlags") int flags);

    /** \brief Create a new optimization profile.
     * 
     *  If the network has any dynamic input tensors, the appropriate calls to setDimensions() must be made.
     *  Likewise, if there are any shape input tensors, the appropriate calls to setShapeValues() are required.
     *  The builder retains ownership of the created optimization profile and returns a raw pointer, i.e. the users
     *  must not attempt to delete the returned pointer.
     * 
     *  @see IOptimizationProfile
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IOptimizationProfile createOptimizationProfile();

    /**
     *  \brief Set the ErrorRecorder for this interface
     * 
     *  Assigns the ErrorRecorder to this interface. The ErrorRecorder will track all errors during execution.
     *  This function will call incRefCount of the registered ErrorRecorder at least once. Setting
     *  recorder to nullptr unregisters the recorder with the interface, resulting in a call to decRefCount if
     *  a recorder has been registered.
     * 
     *  If an error recorder is not set, messages will be sent to the global log stream.
     * 
     *  @param recorder The error recorder to register with this interface. */
    //
    /** @see getErrorRecorder()
    /** */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) void setErrorRecorder(IErrorRecorder recorder);

    /**
     *  \brief get the ErrorRecorder assigned to this interface.
     * 
     *  Retrieves the assigned error recorder object for the given class.
     *  A nullptr will be returned if setErrorRecorder has not been called.
     * 
     *  @return A pointer to the IErrorRecorder object that has been registered.
     * 
     *  @see setErrorRecorder()
     *  */
    
    
    //!
    //!
    public native @NoException(true) IErrorRecorder getErrorRecorder();

    /**
     *  \brief Resets the builder state to default values.
     *  */
    
    
    //!
    //!
    public native @NoException(true) void reset();

    /**
     *  \brief Determine whether the platform has TF32 support.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean platformHasTf32();

    /**
     *  \brief Builds and serializes a network for the given INetworkDefinition and IBuilderConfig.
     * 
     *  This function allows building and serialization of a network without creating an engine.
     * 
     *  @param network Network definition.
     *  @param config Builder configuration.
     * 
     *  @return A pointer to a IHostMemory object that contains a serialized network.
     * 
     *  \note This function will synchronize the cuda stream returned by \p config.getProfileStream() before returning.
     * 
     *  @see INetworkDefinition, IBuilderConfig, IHostMemory
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    //!
    //!
    public native @NoException(true) IHostMemory buildSerializedNetwork(@ByRef INetworkDefinition network, @ByRef IBuilderConfig config);

    /**
     *  \brief Checks that a network is within the scope of the IBuilderConfig settings.
     * 
     *  @param network The network definition to check for configuration compliance.
     *  @param config The configuration of the builder to use when checking \p network.
     * 
     *  Given an INetworkDefinition, \p network, and an IBuilderConfig, \p config, check if
     *  the network falls within the constraints of the builder configuration based on the
     *  EngineCapability, BuilderFlag, and DeviceType. If the network is within the constraints,
     *  then the function returns true, and false if a violation occurs. This function reports
     *  the conditions that are violated to the registered ErrorRecorder.
     * 
     *  @return True if network is within the scope of the restrictions specified by the builder config,
     *  false otherwise.
     * 
     *  \note This function will synchronize the cuda stream returned by \p config.getProfileStream() before returning.
     * 
     *  This function is only supported in NVIDIA Drive(R) products.
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean isNetworkSupported(@Const @ByRef INetworkDefinition network, @Const @ByRef IBuilderConfig config);

    /**
     *  \brief get the logger with which the builder was created
     * 
     *  @return the logger
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) ILogger getLogger();

    /**
     *  \brief Set the maximum number of threads.
     *  @param maxThreads The maximum number of threads that can be used by the builder.
     *  @return True if successful, false otherwise.
     * 
     *  The default value is 1 and includes the current thread.
     *  A value greater than 1 permits TensorRT to use multi-threaded algorithms.
     *  A value less than 1 triggers a kINVALID_ARGUMENT error.
     *  */
    
    
    //!
    //!
    //!
    //!
    //!
    public native @Cast("bool") @NoException(true) boolean setMaxThreads(int maxThreads);

    /**
     *  \brief get the maximum number of threads that can be used by the builder.
     * 
     *  Retrieves the maximum number of threads that can be used by the builder.
     * 
     *  @return The maximum number of threads that can be used by the builder.
     * 
     *  @see setMaxThreads()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) int getMaxThreads();

    /**
     *  \brief get the local plugin registry that can be used by the builder.
     * 
     *  @return The local plugin registry that can be used by the builder.
     *  */
    public native @ByRef @NoException(true) IPluginRegistry getPluginRegistry();
}
