// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/** \class IAssertionLayer
 * 
 *  \brief An assertion layer in a network
 * 
 *  The layer has a single input and no output. The input must be a boolean shape tensor.
 *  If any element of the input is provably false at build time, the network is rejected.
 *  If any element of the input is false at runtime for the supplied runtime dimensions,
 *  an error occurs, much the same as if any other runtime error (e.g. using IShuffleLayer
 *  to change the volume of a tensor) is handled.
 * 
 *  Asserting equality of input dimensions may help the optimizer.
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IAssertionLayer extends ILayer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IAssertionLayer(Pointer p) { super(p); }

    /**
     *  \brief Set the message to print if the assertion fails.
     * 
     *  The name is used in error diagnostics.
     *  This method copies the message string.
     * 
     *  @see getMessage()
     *  */
    
    
    //!
    //!
    //!
    public native @NoException(true) void setMessage(String message);
    public native @NoException(true) void setMessage(@Cast("const char*") BytePointer message);

    /**
     *  \brief Return the assertion message.
     * 
     *  @see setMessage()
     *  */
    public native @NoException(true) String getMessage();
}
