// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class IAlgorithm
 *  \brief Describes a variation of execution of a layer.
 *         An algorithm is represented by IAlgorithmVariant and the IAlgorithmIOInfo for each of its inputs and outputs.
 *         An algorithm can be selected or reproduced using AlgorithmSelector::selectAlgorithms()."
 *  @see IAlgorithmIOInfo, IAlgorithmVariant, IAlgorithmSelector::selectAlgorithms()
 * 
 *  \warning Do not inherit from this class, as doing so will break forward-compatibility of the API and ABI.
 *  */
@Namespace("nvinfer1") @NoOffset @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class IAlgorithm extends INoCopy {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IAlgorithm(Pointer p) { super(p); }

    /**
     *  \brief Returns the format of an Algorithm input or output. Algorithm inputs are incrementally numbered first,
     *         followed by algorithm outputs.
     *  @param index Index of the input or output of the algorithm. Incremental numbers assigned to indices of inputs
     *               and the outputs.
     * 
     *  @return a reference to IAlgorithmIOInfo specified by index or the first algorithm if index is out of range.
     * 
     *  @deprecated Deprecated in TensorRT 8.0. Superseded by IAlgorithm::getAlgorithmIOInfoByIndex().
     *  */
    
    
    //!
    //!
    public native @Const @Deprecated @ByRef @NoException(true) IAlgorithmIOInfo getAlgorithmIOInfo(int index);

    /**
     *  \brief Returns the algorithm variant.
     *  */
    
    
    //!
    //!
    public native @Const @ByRef @NoException(true) IAlgorithmVariant getAlgorithmVariant();

    /**
     *  \brief The time in milliseconds to execute the algorithm.
     *  */
    
    
    //!
    //!
    public native @NoException(true) float getTimingMSec();

    /**
     *  \brief The size of the GPU temporary memory in bytes which the algorithm uses at execution time.
     *  */
    
    
    //!
    //!
    //!
    public native @Cast("std::size_t") @NoException(true) long getWorkspaceSize();

    /**
     *  \brief Returns the format of an Algorithm input or output. Algorithm inputs are incrementally numbered first,
     *         followed by algorithm outputs.
     *  @param index Index of the input or output of the algorithm. Incremental numbers assigned to indices of inputs
     *               and the outputs.
     * 
     *  @return a pointer to a IAlgorithmIOInfo interface or nullptr if index is out of range.
     *  */
    public native @Const @NoException(true) IAlgorithmIOInfo getAlgorithmIOInfoByIndex(int index);
}
