// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.nvinfer;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

import static org.bytedeco.tensorrt.global.nvinfer.*;


/**
 *  \class DimsHW
 *  \brief Descriptor for two-dimensional spatial data.
 *  */
@Namespace("nvinfer1") @Properties(inherit = org.bytedeco.tensorrt.presets.nvinfer.class)
public class DimsHW extends Dims2 {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DimsHW(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DimsHW(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DimsHW position(long position) {
        return (DimsHW)super.position(position);
    }
    @Override public DimsHW getPointer(long i) {
        return new DimsHW((Pointer)this).offsetAddress(i);
    }

    /**
     *  \brief Construct an empty DimsHW object.
     *  */
    
    
    //!
    //!
    //!
    public DimsHW() { super((Pointer)null); allocate(); }
    private native void allocate();

    /**
     *  \brief Construct a DimsHW given height and width.
     * 
     *  @param height the height of the data
     *  @param width the width of the data
     *  */
    
    
    //!
    //!
    //!
    public DimsHW(int height, int width) { super((Pointer)null); allocate(height, width); }
    private native void allocate(int height, int width);

    /**
     *  \brief Get the height.
     * 
     *  @return The height.
     *  */
    
    
    //!
    //!
    //!
    public native @ByRef IntPointer h();

    /**
     *  \brief Get the height.
     * 
     *  @return The height.
     *  */

    /**
     *  \brief Get the width.
     * 
     *  @return The width.
     *  */
    
    
    //!
    //!
    //!
    public native @ByRef IntPointer w();

    /**
     *  \brief Get the width.
     * 
     *  @return The width.
     *  */
}
