// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.tensorrt.global;

import org.bytedeco.tensorrt.nvinfer.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.cublas.*;
import static org.bytedeco.cuda.global.cublas.*;
import org.bytedeco.cuda.cudnn.*;
import static org.bytedeco.cuda.global.cudnn.*;
import org.bytedeco.cuda.nvrtc.*;
import static org.bytedeco.cuda.global.nvrtc.*;

public class nvinfer extends org.bytedeco.tensorrt.presets.nvinfer {
    static { Loader.load(); }

// Parsed from NvInferVersion.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

/**
/** \file NvInferVersion.h
/**
/** Defines the TensorRT version
/** */
// #ifndef NV_INFER_VERSION_H
// #define NV_INFER_VERSION_H

/** TensorRT major version. */
public static final int NV_TENSORRT_MAJOR = 8;
/** TensorRT minor version. */
public static final int NV_TENSORRT_MINOR = 6;
/** TensorRT patch version. */
public static final int NV_TENSORRT_PATCH = 1;
/** TensorRT build number. */
public static final int NV_TENSORRT_BUILD = 6;

/** TensorRT LWS major version. */
public static final int NV_TENSORRT_LWS_MAJOR = 0;
/** TensorRT LWS minor version. */
public static final int NV_TENSORRT_LWS_MINOR = 0;
/** TensorRT LWS patch version. */
public static final int NV_TENSORRT_LWS_PATCH = 0;

// This #define is deprecated in TensorRT 8.6 and will be removed in 10.0. Use NV_TENSORRT_MAJOR.
/** Shared object library major version number. */
public static final int NV_TENSORRT_SONAME_MAJOR = 8;
// This #define is deprecated in TensorRT 8.6 and will be removed in 10.0. Use NV_TENSORRT_MINOR.
/** Shared object library minor version number. */
public static final int NV_TENSORRT_SONAME_MINOR = 6;
// This #define is deprecated in TensorRT 8.6 and will be removed in 10.0. Use NV_TENSORRT_PATCH.
/** Shared object library patch version number. */
public static final int NV_TENSORRT_SONAME_PATCH = 1;

/** An early access release */
public static final int NV_TENSORRT_RELEASE_TYPE_EARLY_ACCESS = 0;
/** A release candidate */
public static final int NV_TENSORRT_RELEASE_TYPE_RELEASE_CANDIDATE = 1;
/** A final release */
public static final int NV_TENSORRT_RELEASE_TYPE_GENERAL_AVAILABILITY = 2;

/** TensorRT release type */
public static final int NV_TENSORRT_RELEASE_TYPE = NV_TENSORRT_RELEASE_TYPE_GENERAL_AVAILABILITY;

// #endif // NV_INFER_VERSION_H


// Parsed from NvInferRuntimeBase.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_INFER_RUNTIME_BASE_H
// #define NV_INFER_RUNTIME_BASE_H

// #include "NvInferVersion.h"
// #include <cstddef>
// #include <cstdint>
// #include <cuda_runtime_api.h>

// Items that are marked as deprecated will be removed in a future release.
// #if __cplusplus >= 201402L
// #define TRT_DEPRECATED [[deprecated]]
// #if __GNUC__ < 6
// #define TRT_DEPRECATED_ENUM
// #else
// #define TRT_DEPRECATED_ENUM TRT_DEPRECATED
// #endif
// #ifdef _MSC_VER
// #define TRT_DEPRECATED_API __declspec(dllexport)
// #else
// #define TRT_DEPRECATED_API [[deprecated]] __attribute__((visibility("default")))
// #endif
// #else
// #ifdef _MSC_VER
// #define TRT_DEPRECATED
// #define TRT_DEPRECATED_ENUM
// #define TRT_DEPRECATED_API __declspec(dllexport)
// #else
// #define TRT_DEPRECATED __attribute__((deprecated))
// #define TRT_DEPRECATED_ENUM
// #define TRT_DEPRECATED_API __attribute__((deprecated, visibility("default")))
// #endif
// #endif

// Defines which symbols are exported
// #ifdef TENSORRT_BUILD_LIB
// #ifdef _MSC_VER
// #define TENSORRTAPI __declspec(dllexport)
// #else
// #define TENSORRTAPI __attribute__((visibility("default")))
// #endif
// #else
// #define TENSORRTAPI
// #endif

//!
//!
//!
//!
// #define TRTNOEXCEPT
/**
 *  \file NvInferRuntimeBase.h
 * 
 *  This file contains common definitions, data structures and interfaces shared between the standard and safe runtime.
 * 
 *  \warning Do not directly include this file. Instead include either NvInferRuntime.h (for the standard runtime) or
 *  NvInferSafeRuntime.h (for the safety runtime).
 *  */

// forward declare some CUDA types to avoid an include dependency
// Targeting ../nvinfer/cublasContext.java


// Targeting ../nvinfer/cudnnContext.java




//!
//!
//!
public static native @MemberGetter int NV_TENSORRT_VERSION();
public static final int NV_TENSORRT_VERSION = NV_TENSORRT_VERSION();
/**
 *  \namespace nvinfer1
 * 
 *  \brief The TensorRT API version 1 namespace.
 *  */

@Namespace("nvinfer1") @MemberGetter public static native int kNV_TENSORRT_VERSION_IMPL();
public static final int kNV_TENSORRT_VERSION_IMPL = kNV_TENSORRT_VERSION_IMPL(); // major, minor, patch

/** char_t is the type used by TensorRT to represent all valid characters. */

/** AsciiChar is the type used by TensorRT to represent valid ASCII characters.
 *  This type is used by IPluginV2, PluginField, IPluginCreator, IPluginRegistry, and
 *  ILogger due to their use in automotive safety context. */

/** Forward declare IErrorRecorder for use in other interfaces. */
/** Forward declare IGpuAllocator for use in other interfaces. */
/** Declaration of EnumMaxImpl struct to store maximum number of elements in an enumeration type. */
 // namespace impl

/** Maximum number of elements in an enumeration type. */


/**
 *  \enum DataType
 *  \brief The type of weights and tensors.
 *  */
@Namespace("nvinfer1") public enum DataType {
    /** 32-bit floating point format. */
    kFLOAT(0),

    /** IEEE 16-bit floating-point format. */
    kHALF(1),

    /** Signed 8-bit integer representing a quantized floating-point value. */
    kINT8(2),

    /** Signed 32-bit integer format. */
    kINT32(3),

    /** 8-bit boolean. 0 = false, 1 = true, other values undefined. */
    kBOOL(4),

    /** Unsigned 8-bit integer format.
     *  Cannot be used to represent quantized floating-point values.
     *  Use the IdentityLayer to convert kUINT8 network-level inputs to {kFLOAT, kHALF} prior
     *  to use with other TensorRT layers, or to convert intermediate output
     *  before kUINT8 network-level outputs from {kFLOAT, kHALF} to kUINT8.
     *  kUINT8 conversions are only supported for {kFLOAT, kHALF}.
     *  kUINT8 to {kFLOAT, kHALF} conversion will convert the integer values
     *  to equivalent floating point values.
     *  {kFLOAT, kHALF} to kUINT8 conversion will convert the floating point values
     *  to integer values by truncating towards zero. This conversion has undefined behavior for
     *  floating point values outside the range [0.0f, 256.0f) after truncation.
     *  kUINT8 conversions are not supported for {kINT8, kINT32, kBOOL}. */
    kUINT8(5),

    /** Signed 8-bit floating point with
     *  1 sign bit, 4 exponent bits, 3 mantissa bits, and exponent-bias 7.
     *  \warning kFP8 is not supported yet and will result in an error or undefined behavior. */
    kFP8(6);

    public final int value;
    private DataType(int v) { this.value = v; }
    private DataType(DataType e) { this.value = e.value; }
    public DataType intern() { for (DataType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/** Maximum number of elements in DataType enum. @see DataType */

// Targeting ../nvinfer/Dims32.java



/**
 *  Alias for Dims32.
 * 
 *  \warning: This alias might change in the future.
 *  */


//!
//!
//!
//!
//!
//!

/**
 *  \enum TensorFormat
 * 
 *  \brief Format of the input/output tensors.
 * 
 *  This enum is used by both plugins and network I/O tensors.
 * 
 *  @see IPluginV2::supportsFormat(), safe::ICudaEngine::getBindingFormat()
 * 
 *  For more information about data formats, see the topic "Data Format Description" located in the
 *  TensorRT Developer Guide.
 *  */
@Namespace("nvinfer1") public enum TensorFormat {
    /** Row major linear format.
     *  For a tensor with dimensions {N, C, H, W} or {numbers, channels,
     *  columns, rows}, the dimensional index corresponds to {3, 2, 1, 0}
     *  and thus the order is W minor.
     * 
     *  For DLA usage, the tensor sizes are limited to C,H,W in the range [1,8192].
     *  */
    kLINEAR(0),

    /** Two wide channel vectorized row major format. This format is bound to
     *  FP16. It is only available for dimensions >= 3.
     *  For a tensor with dimensions {N, C, H, W},
     *  the memory layout is equivalent to a C array with dimensions
     *  [N][(C+1)/2][H][W][2], with the tensor coordinates (n, c, h, w)
     *  mapping to array subscript [n][c/2][h][w][c%2]. */
    kCHW2(1),

    /** Eight channel format where C is padded to a multiple of 8. This format
     *  is bound to FP16. It is only available for dimensions >= 3.
     *  For a tensor with dimensions {N, C, H, W},
     *  the memory layout is equivalent to the array with dimensions
     *  [N][H][W][(C+7)/8*8], with the tensor coordinates (n, c, h, w)
     *  mapping to array subscript [n][h][w][c]. */
    
//!
//!
    kHWC8(2),

    /** Four wide channel vectorized row major format. This format is bound to
     *  INT8 or FP16. It is only available for dimensions >= 3.
     *  For INT8, the C dimension must be a build-time constant.
     *  For a tensor with dimensions {N, C, H, W},
     *  the memory layout is equivalent to a C array with dimensions
     *  [N][(C+3)/4][H][W][4], with the tensor coordinates (n, c, h, w)
     *  mapping to array subscript [n][c/4][h][w][c%4].
     * 
     *  Deprecated usage:
     * 
     *  If running on the DLA, this format can be used for acceleration
     *  with the caveat that C must be equal or lesser than 4.
     *  If used as DLA input and the build option kGPU_FALLBACK is not specified,
     *  it needs to meet line stride requirement of DLA format. Column stride in bytes should
     *  be a multiple of 32 on Xavier and 64 on Orin. */
    
//!
//!
    kCHW4(3),

    /** Sixteen wide channel vectorized row major format. This format is bound
     *  to FP16. It is only available for dimensions >= 3.
     *  For a tensor with dimensions {N, C, H, W},
     *  the memory layout is equivalent to a C array with dimensions
     *  [N][(C+15)/16][H][W][16], with the tensor coordinates (n, c, h, w)
     *  mapping to array subscript [n][c/16][h][w][c%16].
     * 
     *  For DLA usage, this format maps to the native feature format for FP16,
     *  and the tensor sizes are limited to C,H,W in the range [1,8192].
     *  */
    
//!
    kCHW16(4),

    /** Thirty-two wide channel vectorized row major format. This format is
     *  only available for dimensions >= 3.
     *  For a tensor with dimensions {N, C, H, W},
     *  the memory layout is equivalent to a C array with dimensions
     *  [N][(C+31)/32][H][W][32], with the tensor coordinates (n, c, h, w)
     *  mapping to array subscript [n][c/32][h][w][c%32].
     * 
     *  For DLA usage, this format maps to the native feature format for INT8,
     *  and the tensor sizes are limited to C,H,W in the range [1,8192]. */
    kCHW32(5),

    /** Eight channel format where C is padded to a multiple of 8. This format
     *  is bound to FP16, and it is only available for dimensions >= 4.
     *  For a tensor with dimensions {N, C, D, H, W},
     *  the memory layout is equivalent to an array with dimensions
     *  [N][D][H][W][(C+7)/8*8], with the tensor coordinates (n, c, d, h, w)
     *  mapping to array subscript [n][d][h][w][c]. */
    kDHWC8(6),

    /** Thirty-two wide channel vectorized row major format. This format is
     *  bound to FP16 and INT8 and is only available for dimensions >= 4.
     *  For a tensor with dimensions {N, C, D, H, W},
     *  the memory layout is equivalent to a C array with dimensions
     *  [N][(C+31)/32][D][H][W][32], with the tensor coordinates (n, c, d, h, w)
     *  mapping to array subscript [n][c/32][d][h][w][c%32]. */
    kCDHW32(7),

    /** Non-vectorized channel-last format. This format is bound to either FP32 or UINT8,
     *  and is only available for dimensions >= 3. */
    
//!
    kHWC(8),

    /** DLA planar format. For a tensor with dimension {N, C, H, W}, the W axis
     *  always has unit stride. The stride for stepping along the H axis is
     *  rounded up to 64 bytes.
     * 
     *  The memory layout is equivalent to a C array with dimensions
     *  [N][C][H][roundUp(W, 64/elementSize)] where elementSize is
     *  2 for FP16 and 1 for Int8, with the tensor coordinates (n, c, h, w)
     *  mapping to array subscript [n][c][h][w]. */
    
//!
    kDLA_LINEAR(9),

    /** DLA image format. For a tensor with dimension {N, C, H, W} the C axis
     *  always has unit stride. The stride for stepping along the H axis is rounded up
     *  to 32 bytes on Xavier and 64 bytes on Orin. C can only be 1, 3 or 4.
     *  If C == 1, it will map to grayscale format.
     *  If C == 3 or C == 4, it will map to color image format. And if C == 3,
     *  the stride for stepping along the W axis needs to be padded to 4 in elements.
     * 
     *  When C is {1, 3, 4}, then C' is {1, 4, 4} respectively,
     *  the memory layout is equivalent to a C array with dimensions
     *  [N][H][roundUp(W, 32/C'/elementSize)][C'] on Xavier and [N][H][roundUp(W, 64/C'/elementSize)][C'] on Orin
     *  where elementSize is 2 for FP16
     *  and 1 for Int8. The tensor coordinates (n, c, h, w) mapping to array
     *  subscript [n][h][w][c]. */
    kDLA_HWC4(10),

    /** Sixteen channel format where C is padded to a multiple of 16. This format
     *  is bound to FP16. It is only available for dimensions >= 3.
     *  For a tensor with dimensions {N, C, H, W},
     *  the memory layout is equivalent to the array with dimensions
     *  [N][H][W][(C+15)/16*16], with the tensor coordinates (n, c, h, w)
     *  mapping to array subscript [n][h][w][c]. */
    kHWC16(11),

    /** Non-vectorized channel-last format. This format is bound to FP32.
     *  It is only available for dimensions >= 4. */
    kDHWC(12);

    public final int value;
    private TensorFormat(int v) { this.value = v; }
    private TensorFormat(TensorFormat e) { this.value = e.value; }
    public TensorFormat intern() { for (TensorFormat e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/** Maximum number of elements in TensorFormat enum. @see TensorFormat */
 // namespace impl

@Namespace("nvinfer1") public enum AllocatorFlag {
    /** TensorRT may call realloc() on this allocation */
    kRESIZABLE(0);

    public final int value;
    private AllocatorFlag(int v) { this.value = v; }
    private AllocatorFlag(AllocatorFlag e) { this.value = e.value; }
    public AllocatorFlag intern() { for (AllocatorFlag e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/** Maximum number of elements in AllocatorFlag enum. @see AllocatorFlag */
 // namespace impl



//!
//!
//!
// Targeting ../nvinfer/IGpuAllocator.java


// Targeting ../nvinfer/ILogger.java


/** Maximum number of elements in ILogger::Severity enum. @see ILogger::Severity */
 // namespace impl

/**
 *  \enum ErrorCode
 * 
 *  \brief Error codes that can be returned by TensorRT during execution.
 *  */
@Namespace("nvinfer1") public enum ErrorCode {
    /**
     *  Execution completed successfully.
     *  */
    

//!
//!
    kSUCCESS(0),

    /**
     *  An error that does not fall into any other category. This error is included for forward compatibility.
     *  */
    

//!
//!
    kUNSPECIFIED_ERROR(1),

    /**
     *  A non-recoverable TensorRT error occurred. TensorRT is in an invalid internal state when this error is
     *  emitted and any further calls to TensorRT will result in undefined behavior.
     *  */
    

//!
//!
    kINTERNAL_ERROR(2),

    /**
     *  An argument passed to the function is invalid in isolation.
     *  This is a violation of the API contract.
     *  */
    

//!
//!
    kINVALID_ARGUMENT(3),

    /**
     *  An error occurred when comparing the state of an argument relative to other arguments. For example, the
     *  dimensions for concat differ between two tensors outside of the channel dimension. This error is triggered
     *  when an argument is correct in isolation, but not relative to other arguments. This is to help to distinguish
     *  from the simple errors from the more complex errors.
     *  This is a violation of the API contract.
     *  */
    

//!
//!
    kINVALID_CONFIG(4),

    /**
     *  An error occurred when performing an allocation of memory on the host or the device.
     *  A memory allocation error is normally fatal, but in the case where the application provided its own memory
     *  allocation routine, it is possible to increase the pool of available memory and resume execution.
     *  */
    

//!
//!
    kFAILED_ALLOCATION(5),

    /**
     *  One, or more, of the components that TensorRT relies on did not initialize correctly.
     *  This is a system setup issue.
     *  */
    

//!
//!
    kFAILED_INITIALIZATION(6),

    /**
     *  An error occurred during execution that caused TensorRT to end prematurely, either an asynchronous error or
     *  other execution errors reported by CUDA/DLA. In a dynamic system, the
     *  data can be thrown away and the next frame can be processed or execution can be retried.
     *  This is either an execution error or a memory error.
     *  */
    

//!
//!
    kFAILED_EXECUTION(7),

    /**
     *  An error occurred during execution that caused the data to become corrupted, but execution finished. Examples
     *  of this error are NaN squashing or integer overflow. In a dynamic system, the data can be thrown away and the
     *  next frame can be processed or execution can be retried.
     *  This is either a data corruption error, an input error, or a range error.
     *  This is not used in safety but may be used in standard.
     *  */
    

//!
//!
//!
    kFAILED_COMPUTATION(8),

    /**
     *  TensorRT was put into a bad state by incorrect sequence of function calls. An example of an invalid state is
     *  specifying a layer to be DLA only without GPU fallback, and that layer is not supported by DLA. This can occur
     *  in situations where a service is optimistically executing networks for multiple different configurations
     *  without checking proper error configurations, and instead throwing away bad configurations caught by TensorRT.
     *  This is a violation of the API contract, but can be recoverable.
     * 
     *  Example of a recovery:
     *  GPU fallback is disabled and conv layer with large filter(63x63) is specified to run on DLA. This will fail due
     *  to DLA not supporting the large kernel size. This can be recovered by either turning on GPU fallback
     *  or setting the layer to run on the GPU.
     *  */
    

//!
//!
    kINVALID_STATE(9),

    /**
     *  An error occurred due to the network not being supported on the device due to constraints of the hardware or
     *  system. An example is running a unsafe layer in a safety certified context, or a resource requirement for the
     *  current network is greater than the capabilities of the target device. The network is otherwise correct, but
     *  the network and hardware combination is problematic. This can be recoverable.
     *  Examples:
     *   * Scratch space requests larger than available device memory and can be recovered by increasing allowed
     *     workspace size.
     *   * Tensor size exceeds the maximum element count and can be recovered by reducing the maximum batch size.
     *  */
    kUNSUPPORTED_STATE(10);

    public final int value;
    private ErrorCode(int v) { this.value = v; }
    private ErrorCode(ErrorCode e) { this.value = e.value; }
    public ErrorCode intern() { for (ErrorCode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/** Maximum number of elements in ErrorCode enum. @see ErrorCode */

// Targeting ../nvinfer/IErrorRecorder.java

 // class IErrorRecorder

/**
 *  \enum TensorIOMode
 * 
 *  \brief Definition of tensor IO Mode.
 *  */
@Namespace("nvinfer1") public enum TensorIOMode {
    /** Tensor is not an input or output. */
    kNONE(0),

    /** Tensor is input to the engine. */
    kINPUT(1),

    /** Tensor is output by the engine. */
    kOUTPUT(2);

    public final int value;
    private TensorIOMode(int v) { this.value = v; }
    private TensorIOMode(TensorIOMode e) { this.value = e.value; }
    public TensorIOMode intern() { for (TensorIOMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/** Maximum number of elements in TensorIOMode enum. @see TensorIOMode */
 // namespace impl
 // namespace nvinfer1

/**
 *  \brief Return the library version number.
 * 
 *  The format is as for TENSORRT_VERSION: (TENSORRT_MAJOR * 1000) + (TENSORRT_MINOR * 100) + TENSOR_PATCH.
 *  */
public static native @NoException(true) int getInferLibVersion();

// #endif // NV_INFER_RUNTIME_BASE_H


// Parsed from NvInferRuntimePlugin.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_INFER_RUNTIME_PLUGIN_H
// #define NV_INFER_RUNTIME_PLUGIN_H



//!
//!
//!
//!

//!
//!
//!
// #include "NvInferRuntimeBase.h"

/**
 *  \file NvInferRuntimePlugin.h
 * 
 *  This file contains common definitions, data structures and interfaces that relate to plugins and are shared
 *  between the standard and safe runtime.
 * 
 *  \warning Do not directly include this file. Instead include either NvInferRuntime.h (for the standard runtime) or
 *  NvInferSafeRuntime.h (for the safety runtime).
 * 
 <p>
 * 
 *  \namespace nvinfer1
 * 
 *  \brief The TensorRT API version 1 namespace.
 *  */

/**
 *  \brief PluginFormat is reserved for backward compatibility.
 * 
 *  @see IPluginV2::supportsFormat()
 *  */

//!
//!
//!
//!
// Targeting ../nvinfer/PluginTensorDesc.java



/** \struct PluginVersion
 * 
 *  \brief Definition of plugin versions.
 * 
 *  Tag for plug-in versions.  Used in upper byte of getTensorRTVersion().
 *  */
@Namespace("nvinfer1") public enum PluginVersion {
    /** IPluginV2 */
    kV2((byte)(0)),
    /** IPluginV2Ext */
    kV2_EXT((byte)(1)),
    /** IPluginV2IOExt */
    kV2_IOEXT((byte)(2)),
    /** IPluginV2DynamicExt */
    kV2_DYNAMICEXT((byte)(3));

    public final byte value;
    private PluginVersion(byte v) { this.value = v; }
    private PluginVersion(PluginVersion e) { this.value = e.value; }
    public PluginVersion intern() { for (PluginVersion e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../nvinfer/IPluginV2.java


// Targeting ../nvinfer/IPluginV2Ext.java


// Targeting ../nvinfer/IPluginV2IOExt.java



/**
 *  \enum PluginFieldType
 *  \brief The possible field types for custom layer.
 *  */

@Namespace("nvinfer1") public enum PluginFieldType {
    /** FP16 field type. */
    kFLOAT16(0),
    /** FP32 field type. */
    kFLOAT32(1),
    /** FP64 field type. */
    kFLOAT64(2),
    /** INT8 field type. */
    kINT8(3),
    /** INT16 field type. */
    kINT16(4),
    /** INT32 field type. */
    kINT32(5),
    /** char field type. */
    kCHAR(6),
    /** nvinfer1::Dims field type. */
    kDIMS(7),
    /** Unknown field type. */
    kUNKNOWN(8);

    public final int value;
    private PluginFieldType(int v) { this.value = v; }
    private PluginFieldType(PluginFieldType e) { this.value = e.value; }
    public PluginFieldType intern() { for (PluginFieldType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../nvinfer/PluginField.java


// Targeting ../nvinfer/PluginFieldCollection.java


// Targeting ../nvinfer/IPluginCreator.java



 // namespace nvinfer1

// #endif // NV_INFER_RUNTIME_PLUGIN_H


// Parsed from NvInferRuntimeCommon.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_INFER_RUNTIME_COMMON_H


//!
//!
//!
//!
//!
// #define NV_INFER_RUNTIME_COMMON_H

/**
 *  \file NvInferRuntimeCommon.h
 * 
 *  This file provides the nvinfer1::IPluginRegistry interface, which will be moved to the NvInferRuntime.h header
 *  in TensorRT 9.0.
 * 
 *  \warning This file will be removed in TensorRT 9.0.
 * 
 *  \warning Do not directly include this file. Instead include NvInferRuntime.h
 *  */
// #include "NvInferRuntimeBase.h"
// #include "NvInferRuntimePlugin.h"
// Targeting ../nvinfer/IPluginRegistry.java



 // namespace nvinfer1

// #endif /* NV_INFER_RUNTIME_COMMON_H */


// Parsed from NvInferLegacyDims.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_INFER_LEGACY_DIMS_H
// #define NV_INFER_LEGACY_DIMS_H



//!
//!
//!

//!
//!
//!
// #include "NvInferRuntimeCommon.h"

/**
 *  \file NvInferLegacyDims.h
 * 
 *  This file contains declarations of legacy dimensions types which use channel
 *  semantics in their names, and declarations on which those types rely.
 * 
 <p>
 * 
 *  \namespace nvinfer1
 * 
 *  \brief The TensorRT API version 1 namespace.
 *  */
// Targeting ../nvinfer/Dims2.java


// Targeting ../nvinfer/DimsHW.java


// Targeting ../nvinfer/Dims3.java


// Targeting ../nvinfer/Dims4.java



 // namespace nvinfer1

// #endif // NV_INFER_LEGCY_DIMS_H


// Parsed from NvInferRuntime.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_INFER_RUNTIME_H


//!
//!
//!
// #define NV_INFER_RUNTIME_H

/**
 *  \file NvInferRuntime.h
 * 
 *  This is the top-level API file for TensorRT extended runtime library.
 *  */

// #include "NvInferImpl.h"
// #include "NvInferRuntimeCommon.h"
// Targeting ../nvinfer/IPluginFactory.java


// Targeting ../nvinfer/INoCopy.java



/**
 *  \enum EngineCapability
 * 
 *  \brief List of supported engine capability flows.
 * 
 *  \details The EngineCapability determines the restrictions of a network during build time and what runtime
 *  it targets. When BuilderFlag::kSAFETY_SCOPE is not set (by default), EngineCapability::kSTANDARD does not provide
 *  any restrictions on functionality and the resulting serialized engine can be executed with TensorRT's standard
 *  runtime APIs in the nvinfer1 namespace. EngineCapability::kSAFETY provides a restricted subset of network
 *  operations that are safety certified and the resulting serialized engine can be executed with TensorRT's safe
 *  runtime APIs in the nvinfer1::safe namespace. EngineCapability::kDLA_STANDALONE provides a restricted subset of
 *  network operations that are DLA compatible and the resulting serialized engine can be executed using standalone
 *  DLA runtime APIs. See sampleCudla for an example of integrating cuDLA APIs with TensorRT APIs.
 *  */

@Namespace("nvinfer1") public enum EngineCapability {
    /**
     *  Standard: TensorRT flow without targeting the safety runtime.
     *  This flow supports both DeviceType::kGPU and DeviceType::kDLA.
     *  */
    kSTANDARD(0),

    /** @deprecated Deprecated in TensorRT 8.0. Superseded by kSTANDARD. */
    

//!
//!
    kDEFAULT(kSTANDARD.value),

    /**
     *  Safety: TensorRT flow with restrictions targeting the safety runtime.
     *  See safety documentation for list of supported layers and formats.
     *  This flow supports only DeviceType::kGPU.
     * 
     *  This flag is only supported in NVIDIA Drive(R) products. */
    kSAFETY(1),

    /** @deprecated Deprecated in TensorRT 8.0. Superseded by kSAFETY. */
    

//!
//!
    kSAFE_GPU(kSAFETY.value),

    /**
     *  DLA Standalone: TensorRT flow with restrictions targeting external, to TensorRT, DLA runtimes.
     *  See DLA documentation for list of supported layers and formats.
     *  This flow supports only DeviceType::kDLA.
     *  */
    kDLA_STANDALONE(2),

    /** @deprecated Deprecated in TensorRT 8.0. Superseded by kDLA_STANDALONE. */
    kSAFE_DLA(kDLA_STANDALONE.value);

    public final int value;
    private EngineCapability(int v) { this.value = v; }
    private EngineCapability(EngineCapability e) { this.value = e.value; }
    public EngineCapability intern() { for (EngineCapability e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/** Maximum number of elements in EngineCapability enum. @see EngineCapability */

// Targeting ../nvinfer/Weights.java


// Targeting ../nvinfer/IHostMemory.java



/**
 *  \enum DimensionOperation
 * 
 *  \brief An operation on two IDimensionExpr, which represent integer expressions used in dimension computations.
 * 
 *  For example, given two IDimensionExpr x and y and an IExprBuilder& eb,
 *  eb.operation(DimensionOperation::kSUM, x, y) creates a representation of x+y.
 * 
 *  @see IDimensionExpr, IExprBuilder
 *  */
@Namespace("nvinfer1") public enum DimensionOperation {
    /** Sum of the two operands. */
    kSUM(0),
    /** Product of the two operands. */
    kPROD(1),
    /** Maximum of the two operands. */
    kMAX(2),
    /** Minimum of the two operands. */
    kMIN(3),
    /** Substract the second element from the first. */
    kSUB(4),
    /** 1 if operands are equal, 0 otherwise. */
    kEQUAL(5),
    /** 1 if first operand is less than second operand, 0 otherwise. */
    kLESS(6),
    /** Floor division of the first element by the second. */
    kFLOOR_DIV(7),
    /** Division rounding up */
    kCEIL_DIV(8);

    public final int value;
    private DimensionOperation(int v) { this.value = v; }
    private DimensionOperation(DimensionOperation e) { this.value = e.value; }
    public DimensionOperation intern() { for (DimensionOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Maximum number of elements in DimensionOperation enum. @see DimensionOperation */


/**
 *  \enum TensorLocation
 *  \brief The location for tensor data storage, device or host.
 *  */
@Namespace("nvinfer1") public enum TensorLocation {
    /** Data stored on device. */
    kDEVICE(0),
    /** Data stored on host. */
    kHOST(1);

    public final int value;
    private TensorLocation(int v) { this.value = v; }
    private TensorLocation(TensorLocation e) { this.value = e.value; }
    public TensorLocation intern() { for (TensorLocation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/** Maximum number of elements in TensorLocation enum. @see TensorLocation */

// Targeting ../nvinfer/IDimensionExpr.java


// Targeting ../nvinfer/IExprBuilder.java


// Targeting ../nvinfer/DimsExprs.java


// Targeting ../nvinfer/DynamicPluginTensorDesc.java


// Targeting ../nvinfer/IPluginV2DynamicExt.java


// Targeting ../nvinfer/IProfiler.java



/**
 *  \enum WeightsRole
 *  \brief How a layer uses particular Weights.
 * 
 *  The power weights of an IScaleLayer are omitted.  Refitting those is not supported.
 *  */
@Namespace("nvinfer1") public enum WeightsRole {
    /** kernel for IConvolutionLayer, IDeconvolutionLayer, or IFullyConnectedLayer */
    kKERNEL(0),
    /** bias for IConvolutionLayer, IDeconvolutionLayer, or IFullyConnectedLayer */
    kBIAS(1),
    /** shift part of IScaleLayer */
    kSHIFT(2),
    /** scale part of IScaleLayer */
    kSCALE(3),
    /** weights for IConstantLayer */
    kCONSTANT(4),
    /** Any other weights role */
    kANY(5);

    public final int value;
    private WeightsRole(int v) { this.value = v; }
    private WeightsRole(WeightsRole e) { this.value = e.value; }
    public WeightsRole intern() { for (WeightsRole e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Maximum number of elements in WeightsRole enum. @see WeightsRole */


/**
 *  \enum DeviceType
 *  \brief The device that this layer/network will execute on.
 * 
 *  */
@Namespace("nvinfer1") public enum DeviceType {
    /** GPU Device */
    kGPU(0),
    /** DLA Core */
    kDLA(1);

    public final int value;
    private DeviceType(int v) { this.value = v; }
    private DeviceType(DeviceType e) { this.value = e.value; }
    public DeviceType intern() { for (DeviceType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Maximum number of elements in DeviceType enum. @see DeviceType */


/**
 *  \enum TempfileControlFlag
 * 
 *  \brief Flags used to control TensorRT's behavior when creating executable temporary files.
 * 
 *  On some platforms the TensorRT runtime may need to create files in a temporary directory or use platform-specific
 *  APIs to create files in-memory to load temporary DLLs that implement runtime code. These flags allow the
 *  application to explicitly control TensorRT's use of these files. This will preclude the use of certain TensorRT
 *  APIs for deserializing and loading lean runtimes.
 *  */
@Namespace("nvinfer1") public enum TempfileControlFlag {
    /** Allow creating and loading files in-memory (or unnamed files). */
    
//!
    kALLOW_IN_MEMORY_FILES(0),

    /** Allow creating and loading named files in a temporary directory on the filesystem.
     * 
     *  @see IRuntime::setTemporaryDirectory() */
    kALLOW_TEMPORARY_FILES(1);

    public final int value;
    private TempfileControlFlag(int v) { this.value = v; }
    private TempfileControlFlag(TempfileControlFlag e) { this.value = e.value; }
    public TempfileControlFlag intern() { for (TempfileControlFlag e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Maximum number of elements in TempfileControlFlag enum. @see TempfileControlFlag */


/** \brief Represents a collection of one or more TempfileControlFlag values combined using bitwise-OR operations.
 * 
 *  @see TempfileControlFlag,
 *       IRuntime::setTempfileControlFlags(),
 *       IRuntime::getTempfileControlFlags() */


//!
//!
//!
//!
// Targeting ../nvinfer/IRuntime.java


// Targeting ../nvinfer/IRefitter.java



/**
 *  \enum OptProfileSelector
 * 
 *  \brief When setting or querying optimization profile parameters (such as shape tensor inputs or dynamic dimensions),
 *         select whether we are interested in the minimum, optimum, or maximum values for these parameters.
 *         The minimum and maximum specify the permitted range that is supported at runtime, while the optimum value
 *         is used for the kernel selection. This should be the "typical" value that is expected to occur at runtime.
 * 
 *  @see IOptimizationProfile::setDimensions(), IOptimizationProfile::setShapeValues()
 *  */
@Namespace("nvinfer1") public enum OptProfileSelector {
    /** This is used to set or get the minimum permitted value for dynamic dimensions etc. */
    kMIN(0),
    /** This is used to set or get the value that is used in the optimization (kernel selection). */
    kOPT(1),
    /** This is used to set or get the maximum permitted value for dynamic dimensions etc. */
    kMAX(2);

    public final int value;
    private OptProfileSelector(int v) { this.value = v; }
    private OptProfileSelector(OptProfileSelector e) { this.value = e.value; }
    public OptProfileSelector intern() { for (OptProfileSelector e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  \brief Number of different values of OptProfileSelector enum.
 * 
 *  @see OptProfileSelector
 *  */

// Targeting ../nvinfer/IOptimizationProfile.java



/**
 *  \enum TacticSource
 * 
 *  \brief List of tactic sources for TensorRT.
 * 
 *  @see TacticSources, IBuilderConfig::setTacticSources(), IBuilderConfig::getTacticSources(),
 *  PreviewFeature::kDISABLE_EXTERNAL_TACTIC_SOURCES_FOR_CORE_0805
 *  */
@Namespace("nvinfer1") public enum TacticSource {
    /** cuBLAS tactics. Enabled by default.
     *  \note Disabling kCUBLAS will cause the cublas handle passed to plugins in attachToContext to be null. */
    kCUBLAS(0),
    /** cuBLAS LT tactics.
     *  Enabled for x86 platforms and only enabled for non-x86 platforms when CUDA >= 11.0 by default. */
    kCUBLAS_LT(1),
    /** cuDNN tactics.  Enabled by default.
     *  \note Disabling kCUDNN will cause the cuDNN handle passed to plugins in attachToContext to be null. */
    kCUDNN(2),

    /** Enables convolution tactics implemented with edge mask tables. These tactics tradeoff memory for performance by
     *  consuming additional memory space proportional to the input size.
     *  Enabled by default. */
    kEDGE_MASK_CONVOLUTIONS(3),

    /** Enables convolution tactics implemented with source-code JIT fusion. The engine building time may increase
     *  when this is enabled. Enabled by default. */
    kJIT_CONVOLUTIONS(4);

    public final int value;
    private TacticSource(int v) { this.value = v; }
    private TacticSource(TacticSource e) { this.value = e.value; }
    public TacticSource intern() { for (TacticSource e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}



/**
 *  \brief Represents a collection of one or more TacticSource values
 *  combine using bitwise-OR operations.
 * 
 *  @see IBuilderConfig::setTacticSources(), IBuilderConfig::getTacticSources()
 *  */


//!
//!
//!
//!

/**
 *  \enum ProfilingVerbosity
 * 
 *  \brief List of verbosity levels of layer information exposed in NVTX annotations and in IEngineInspector.
 * 
 *  @see IBuilderConfig::setProfilingVerbosity(),
 *       IBuilderConfig::getProfilingVerbosity(),
 *       IEngineInspector
 *  */
@Namespace("nvinfer1") public enum ProfilingVerbosity {
    /** Print only the layer names. This is the default setting. */
    kLAYER_NAMES_ONLY(0),
    /** Do not print any layer information. */
    kNONE(1),
    /** Print detailed layer information including layer names and layer parameters. */
    kDETAILED(2),

    /** @deprecated Deprecated in TensorRT 8.0. Superseded by kLAYER_NAMES_ONLY. */
    kDEFAULT(kLAYER_NAMES_ONLY.value),
    /** @deprecated Deprecated in TensorRT 8.0. Superseded by kDETAILED. */
    kVERBOSE(kDETAILED.value);

    public final int value;
    private ProfilingVerbosity(int v) { this.value = v; }
    private ProfilingVerbosity(ProfilingVerbosity e) { this.value = e.value; }
    public ProfilingVerbosity intern() { for (ProfilingVerbosity e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Maximum number of profile verbosity levels in ProfilingVerbosity enum. @see ProfilingVerbosity */

// Targeting ../nvinfer/ICudaEngine.java


// Targeting ../nvinfer/IOutputAllocator.java


// Targeting ../nvinfer/IExecutionContext.java

 // class IExecutionContext

/**
 *  \enum LayerInformationFormat
 * 
 *  \brief The format in which the IEngineInspector prints the layer information.
 * 
 *  @see IEngineInspector::getLayerInformation(), IEngineInspector::getEngineInformation()
 *  */
@Namespace("nvinfer1") public enum LayerInformationFormat {
    /** Print layer information in one line per layer. */
    kONELINE(0),
    /** Print layer information in JSON format. */
    kJSON(1);

    public final int value;
    private LayerInformationFormat(int v) { this.value = v; }
    private LayerInformationFormat(LayerInformationFormat e) { this.value = e.value; }
    public LayerInformationFormat intern() { for (LayerInformationFormat e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** Maximum number of layer information formats in LayerInformationFormat enum.
 *  @see LayerInformationFormat */

// Targeting ../nvinfer/IEngineInspector.java

 // class IEngineInspector

 // namespace nvinfer1

/**
 *  Internal C entry point for creating IRuntime.
 *  \private
 *  */


//!
//!
public static native @NoException(true) Pointer createInferRuntime_INTERNAL(Pointer logger, int version);

/**
 *  Internal C entry point for creating IRefitter.
 *  \private
 *  */


//!
//!
public static native @NoException(true) Pointer createInferRefitter_INTERNAL(Pointer engine, Pointer logger, int version);

/**
 *  \brief Return the plugin registry
 *  */


//!
//!
public static native @NoException(true) IPluginRegistry getPluginRegistry();

/**
 *  \brief Return the logger object.
 *  \note the global logger is used only by standalone functions which have no associated builder, runtime
 *  or refitter.
 *  */
public static native @NoException(true) ILogger getLogger();
/**
 *  \brief Create an instance of an IRuntime class.
 * 
 *  @param logger The logging class for the runtime.
 *  */


//!
//!
//!
@Namespace("nvinfer1") public static native @NoException(true) IRuntime createInferRuntime(@ByRef ILogger logger);

/**
 *  \brief Create an instance of an IRefitter class.
 * 
 *  @param logger The logging class for the refitter.
 *  */
@Namespace("nvinfer1") public static native @NoException(true) IRefitter createInferRefitter(@ByRef ICudaEngine engine, @ByRef ILogger logger);

 // namespace

/**
 *  \brief Register the plugin creator to the registry
 *  The static registry object will be instantiated when the plugin library is
 *  loaded. This static object will register all creators available in the
 *  library to the registry.
 * 
 *  \warning Statically registering plugins should be avoided in the automotive
 *   safety context as the application developer should first register an error recorder
 *   with the plugin registry via IPluginRegistry::setErrorRecorder() before using
 *   IPluginRegistry::registerCreator() or other methods.
 *  */

 // namespace nvinfer1

// #define REGISTER_TENSORRT_PLUGIN(name)
//     static nvinfer1::PluginRegistrar<name> pluginRegistrar##name {}
// Targeting ../nvinfer/ILoggerFinder.java



 // namespace nvinfer1

// #endif // NV_INFER_RUNTIME_H


// Parsed from NvInfer.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_INFER_H
// #define NV_INFER_H

// #include "NvInferLegacyDims.h"


//!
//!
//!
//!

//!
//!
//!

//!
//!
//!
// #include "NvInferRuntime.h"

/**
 *  \mainpage
 * 
 *  This is the API documentation for the NVIDIA TensorRT library. It provides information on individual
 *  functions, classes and methods. Use the index on the left to navigate the documentation.
 * 
 *  Please see the accompanying user guide and samples for higher-level information and general advice on
 *  using TensorRT. */
//
/** TensorRT Versioning follows Semantic Versioning Guidelines specified here: https://semver.org/
/**
<p>
/**
/** \file NvInfer.h
/**
/** This is the top-level API file for TensorRT.
/**
<p>
/**
/** \namespace nvinfer1
/**
/** \brief The TensorRT API version 1 namespace.
/** */

/**
 *  \enum LayerType
 * 
 *  \brief The type values of layer classes.
 * 
 *  @see ILayer::getType()
 *  */
@Namespace("nvinfer1") public enum LayerType {
    /** Convolution layer. */
    kCONVOLUTION(0),
    /** Fully connected layer. */
    kFULLY_CONNECTED(1),
    /** Activation layer. */
    kACTIVATION(2),
    /** Pooling layer. */
    kPOOLING(3),
    /** LRN layer. */
    kLRN(4),
    /** Scale layer. */
    kSCALE(5),
    /** SoftMax layer. */
    kSOFTMAX(6),
    /** Deconvolution layer. */
    kDECONVOLUTION(7),
    /** Concatenation layer. */
    kCONCATENATION(8),
    /** Elementwise layer. */
    kELEMENTWISE(9),
    /** Plugin layer. */
    kPLUGIN(10),
    /** UnaryOp operation Layer. */
    kUNARY(11),
    /** Padding layer. */
    kPADDING(12),
    /** Shuffle layer. */
    kSHUFFLE(13),
    /** Reduce layer. */
    kREDUCE(14),
    /** TopK layer. */
    kTOPK(15),
    /** Gather layer. */
    kGATHER(16),
    /** Matrix multiply layer. */
    kMATRIX_MULTIPLY(17),
    /** Ragged softmax layer. */
    kRAGGED_SOFTMAX(18),
    /** Constant layer. */
    kCONSTANT(19),
    /** RNNv2 layer. */
    kRNN_V2(20),
    /** Identity layer. */
    kIDENTITY(21),
    /** PluginV2 layer. */
    kPLUGIN_V2(22),
    /** Slice layer. */
    kSLICE(23),
    /** Shape layer. */
    kSHAPE(24),
    /** Parametric ReLU layer. */
    kPARAMETRIC_RELU(25),
    /** Resize Layer. */
    kRESIZE(26),
    /** Loop Trip limit layer */
    kTRIP_LIMIT(27),
    /** Loop Recurrence layer */
    kRECURRENCE(28),
    /** Loop Iterator layer */
    kITERATOR(29),
    /** Loop output layer */
    kLOOP_OUTPUT(30),
    /** Select layer. */
    kSELECT(31),
    /** Fill layer */
    kFILL(32),
    /** Quantize layer */
    kQUANTIZE(33),
    /** Dequantize layer */
    kDEQUANTIZE(34),
    /** Condition layer */
    kCONDITION(35),
    /** Conditional Input layer */
    kCONDITIONAL_INPUT(36),
    /** Conditional Output layer */
    kCONDITIONAL_OUTPUT(37),
    /** Scatter layer */
    kSCATTER(38),
    /** Einsum layer */
    kEINSUM(39),
    /** Assertion layer */
    kASSERTION(40),
    /** OneHot layer */
    kONE_HOT(41),
    /** NonZero layer */
    kNON_ZERO(42),
    /** Grid sample layer */
    kGRID_SAMPLE(43),
    /** NMS layer */
    kNMS(44),
    /** Reverse sequence layer */
    kREVERSE_SEQUENCE(45),
    /** Normalization layer */
    kNORMALIZATION(46),
    /** Cast layer */
    kCAST(47);

    public final int value;
    private LayerType(int v) { this.value = v; }
    private LayerType(LayerType e) { this.value = e.value; }
    public LayerType intern() { for (LayerType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in LayerType enum.
 * 
 *  @see LayerType
 *  */


/**
 *  \brief It is capable of representing one or more TensorFormat by binary OR
 *  operations, e.g., 1U << TensorFormat::kCHW4 | 1U << TensorFormat::kCHW32.
 * 
 *  @see ITensor::getAllowedFormats(), ITensor::setAllowedFormats(),
 *  */


//!
//!
//!

/**
 *  \enum ActivationType
 * 
 *  \brief Enumerates the types of activation to perform in an activation layer.
 *  */
@Namespace("nvinfer1") public enum ActivationType {
    /** Rectified linear activation. */
    kRELU(0),
    /** Sigmoid activation. */
    kSIGMOID(1),
    /** TanH activation. */
    kTANH(2),
    /** LeakyRelu activation: x>=0 ? x : alpha * x. */
    kLEAKY_RELU(3),
    /** Elu activation: x>=0 ? x : alpha * (exp(x) - 1). */
    kELU(4),
    /** Selu activation: x>0 ? beta * x : beta * (alpha*exp(x) - alpha) */
    kSELU(5),
    /** Softsign activation: x / (1+|x|) */
    kSOFTSIGN(6),
    /** Parametric softplus activation: alpha*log(exp(beta*x)+1) */
    kSOFTPLUS(7),
    /** Clip activation: max(alpha, min(beta, x)) */
    kCLIP(8),
    /** Hard sigmoid activation: max(0, min(1, alpha*x+beta)) */
    kHARD_SIGMOID(9),
    /** Scaled tanh activation: alpha*tanh(beta*x) */
    kSCALED_TANH(10),
    /** Thresholded ReLU activation: x>alpha ? x : 0 */
    kTHRESHOLDED_RELU(11);

    public final int value;
    private ActivationType(int v) { this.value = v; }
    private ActivationType(ActivationType e) { this.value = e.value; }
    public ActivationType intern() { for (ActivationType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in ActivationType enum.
 * 
 *  @see ActivationType
 *  */

// Targeting ../nvinfer/ITensor.java


// Targeting ../nvinfer/ILayer.java



/**
 *  \enum PaddingMode
 * 
 *  \brief Enumerates the modes of padding to perform in convolution, deconvolution and pooling layer,
 *  padding mode takes precedence if setPaddingMode() and setPrePadding() are also used.
 * 
 *  There are three padding styles, EXPLICIT, SAME, and CAFFE, with each style having two variants.
 *  The EXPLICIT and CAFFE styles determine if the final sampling location is used or not.
 *  The SAME style determine if the asymmetry in the padding is on the pre or post padding.
 * 
 *  <pre>{@code
 *  Shorthand:
 *      I = dimensions of input image.
 *      B = prePadding, before the image data. For deconvolution, prePadding is set before output.
 *      A = postPadding, after the image data. For deconvolution, postPadding is set after output.
 *      P = delta between input and output
 *      S = stride
 *      F = filter
 *      O = output
 *      D = dilation
 *      M = I + B + A ; The image data plus any padding
 *      DK = 1 + D * (F - 1)
 *  }</pre>
 * 
 *  Formulas for Convolution:
 *      - EXPLICIT_ROUND_DOWN:
 *  <pre>{@code
 *          O = floor((M - DK) / S) + 1
 *  }</pre>
 *      - CAFFE_ROUND_DOWN:
 *  <pre>{@code
 *          O = floor((I + B * 2 - DK) / S) + 1
 *  }</pre>
 *      - EXPLICIT_ROUND_UP:
 *  <pre>{@code
 *          O = ceil((M - DK) / S) + 1
 *  }</pre>
 *      - CAFFE_ROUND_UP:
 *  <pre>{@code
 *          O = ceil((I + B * 2 - DK) / S) + 1
 *  }</pre>
 *      - SAME_UPPER:
 *  <pre>{@code
 *          O = ceil(I / S)
 *          P = floor((I - 1) / S) * S + DK - I;
 *          B = floor(P / 2)
 *          A = P - B
 *  }</pre>
 *      - SAME_LOWER:
 *  <pre>{@code
 *          O = ceil(I / S)
 *          P = floor((I - 1) / S) * S + DK - I;
 *          A = floor(P / 2)
 *          B = P - A
 *  }</pre>
 * 
 *  Formulas for Deconvolution:
 *      - EXPLICIT_ROUND_DOWN:
 *      - CAFFE_ROUND_DOWN:
 *      - EXPLICIT_ROUND_UP:
 *      - CAFFE_ROUND_UP:
 *  <pre>{@code
 *          O = (I - 1) * S + DK - (B + A)
 *  }</pre>
 *      - SAME_UPPER:
 *  <pre>{@code
 *          O = min(I * S, (I - 1) * S + DK)
 *          P = max(DK - S, 0)
 *          B = floor(P / 2)
 *          A = P - B
 *  }</pre>
 *      - SAME_LOWER:
 *  <pre>{@code
 *          O = min(I * S, (I - 1) * S + DK)
 *          P = max(DK - S, 0)
 *          A = floor(P / 2)
 *          B = P - A
 *  }</pre>
 * 
 *  Formulas for Pooling:
 *      - EXPLICIT_ROUND_DOWN:
 *  <pre>{@code
 *          O = floor((M - F) / S) + 1
 *  }</pre>
 *      - EXPLICIT_ROUND_UP:
 *  <pre>{@code
 *          O = ceil((M - F) / S) + 1
 *  }</pre>
 *      - SAME_UPPER:
 *  <pre>{@code
 *          O = ceil(I / S)
 *          P = floor((I - 1) / S) * S + F - I;
 *          B = floor(P / 2)
 *          A = P - B
 *  }</pre>
 *      - SAME_LOWER:
 *  <pre>{@code
 *          O = ceil(I / S)
 *          P = floor((I - 1) / S) * S + F - I;
 *          A = floor(P / 2)
 *          B = P - A
 *  }</pre>
 *      - CAFFE_ROUND_DOWN:
 *  <pre>{@code
 *          EXPLICIT_ROUND_DOWN - ((EXPLICIT_ROUND_DOWN - 1) * S >= I + B)
 *  }</pre>
 *      - CAFFE_ROUND_UP:
 *  <pre>{@code
 *          EXPLICIT_ROUND_UP - ((EXPLICIT_ROUND_UP - 1) * S >= I + B)
 *  }</pre>
 * 
 *  Pooling Example 1:
 *  <pre>{@code
 *      Given I = {6, 6}, B = {3, 3}, A = {2, 2}, S = {2, 2}, F = {3, 3}. What is O?
 *      (B, A can be calculated for SAME_UPPER and SAME_LOWER mode)
 *  }</pre>
 * 
 *  - EXPLICIT_ROUND_DOWN:
 *  <pre>{@code
 *      Computation:
 *          M = {6, 6} + {3, 3} + {2, 2} ==> {11, 11}
 *          O ==> floor((M - F) / S) + 1
 *            ==> floor(({11, 11} - {3, 3}) / {2, 2}) + {1, 1}
 *            ==> floor({8, 8} / {2, 2}) + {1, 1}
 *            ==> {5, 5}
 *  }</pre>
 *  - EXPLICIT_ROUND_UP:
 *  <pre>{@code
 *      Computation:
 *          M = {6, 6} + {3, 3} + {2, 2} ==> {11, 11}
 *          O ==> ceil((M - F) / S) + 1
 *            ==> ceil(({11, 11} - {3, 3}) / {2, 2}) + {1, 1}
 *            ==> ceil({8, 8} / {2, 2}) + {1, 1}
 *            ==> {5, 5}
 *  }</pre>
 *      The sample points are {0, 2, 4, 6, 8} in each dimension.
 * 
 *  - SAME_UPPER:
 *  <pre>{@code
 *      Computation:
 *          I = {6, 6}
 *          S = {2, 2}
 *          O = ceil(I / S) = {3, 3}
 *          P = floor((I - 1) / S) * S + F - I
 *              ==> floor(({6, 6} - {1, 1}) / {2, 2}) * {2, 2} + {3, 3} - {6, 6}
 *              ==> {4, 4} + {3, 3} - {6, 6}
 *              ==> {1, 1}
 *          B = floor({1, 1} / {2, 2})
 *              ==> {0, 0}
 *          A = {1, 1} - {0, 0}
 *              ==> {1, 1}
 *  }</pre>
 *  - SAME_LOWER:
 *  <pre>{@code
 *      Computation:
 *          I = {6, 6}
 *          S = {2, 2}
 *          O = ceil(I / S) = {3, 3}
 *          P = floor((I - 1) / S) * S + F - I
 *            ==> {1, 1}
 *          A = floor({1, 1} / {2, 2})
 *            ==> {0, 0}
 *          B = {1, 1} - {0, 0}
 *            ==> {1, 1}
 *  }</pre>
 *      The sample pointers are {0, 2, 4} in each dimension.
 *      SAMPLE_UPPER has {O0, O1, O2, pad} in output in each dimension.
 *      SAMPLE_LOWER has {pad, O0, O1, O2} in output in each dimension.
 * 
 *  Pooling Example 2:
 *  <pre>{@code
 *      Given I = {6, 6}, B = {3, 3}, A = {3, 3}, S = {2, 2}, F = {3, 3}. What is O?
 *  }</pre>
 * 
 *  - CAFFE_ROUND_DOWN:
 *  <pre>{@code
 *      Computation:
 *          M = {6, 6} + {3, 3} + {3, 3} ==> {12, 12}
 *          EXPLICIT_ROUND_DOWN ==> floor((M - F) / S) + 1
 *                              ==> floor(({12, 12} - {3, 3}) / {2, 2}) + {1, 1}
 *                              ==> {5, 5}
 *          DIFF = (((EXPLICIT_ROUND_DOWN - 1) * S >= I + B) ? {1, 1} : {0, 0})
 *            ==> ({5, 5} - {1, 1}) * {2, 2} >= {6, 6} + {3, 3} ? {1, 1} : {0,0}
 *            ==> {0, 0}
 *          O ==> EXPLICIT_ROUND_DOWN - DIFF
 *            ==> {5, 5} - {0, 0}
 *            ==> {5, 5}
 *  }</pre>
 *  - CAFFE_ROUND_UP:
 *  <pre>{@code
 *      Computation:
 *          M = {6, 6} + {3, 3} + {3, 3} ==> {12, 12}
 *          EXPLICIT_ROUND_UP ==> ceil((M - F) / S) + 1
 *                            ==> ceil(({12, 12} - {3, 3}) / {2, 2}) + {1, 1}
 *                            ==> {6, 6}
 *          DIFF = (((EXPLICIT_ROUND_UP - 1) * S >= I + B) ? {1, 1} : {0, 0})
 *            ==> ({6, 6} - {1, 1}) * {2, 2} >= {6, 6} + {3, 3} ? {1, 1} : {0,0}
 *            ==> {1, 1}
 *          O ==> EXPLICIT_ROUND_UP - DIFF
 *            ==> {6, 6} - {1, 1}
 *            ==> {5, 5}
 *  }</pre>
 * 
 *  The sample points are {0, 2, 4, 6, 8} in each dimension. <br>
 *  CAFFE_ROUND_DOWN and CAFFE_ROUND_UP have two restrictions each on usage with pooling operations.
 *  This will cause getDimensions to return an empty dimension and also to reject the network
 *  at validation time. <br>
 *  For more information on original reference code, see
 *  https://github.com/BVLC/caffe/blob/master/src/caffe/layers/pooling_layer.cpp
 * 
 *  - Restriction 1:
 *  <pre>{@code
 *      CAFFE_ROUND_DOWN: B >= F is an error if (B - S) < F
 *      CAFFE_ROUND_UP: (B + S) >= (F + 1) is an error if B < (F + 1)
 *  }</pre>
 * 
 *  - Restriction 2:
 *  <pre>{@code
 *      CAFFE_ROUND_DOWN: (B - S) >= F is an error if B >= F
 *      CAFFE_ROUND_UP: B >= (F + 1) is an error if (B + S) >= (F + 1)
 *  }</pre>
 *  */
@Namespace("nvinfer1") public enum PaddingMode {
    /** Use explicit padding, rounding output size down. */
    kEXPLICIT_ROUND_DOWN(0),
    /** Use explicit padding, rounding output size up. */
    kEXPLICIT_ROUND_UP(1),
    /** Use SAME padding, with prePadding <= postPadding. */
    kSAME_UPPER(2),
    /** Use SAME padding, with prePadding >= postPadding. */
    kSAME_LOWER(3),
    /** Use CAFFE padding, rounding output size down, uses prePadding value. */
    kCAFFE_ROUND_DOWN(4),
    /** Use CAFFE padding, rounding output size up, uses prePadding value. */
    kCAFFE_ROUND_UP(5);

    public final int value;
    private PaddingMode(int v) { this.value = v; }
    private PaddingMode(PaddingMode e) { this.value = e.value; }
    public PaddingMode intern() { for (PaddingMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in PaddingMode enum.
 * 
 *  @see PaddingMode
 *  */

// Targeting ../nvinfer/IConvolutionLayer.java


// Targeting ../nvinfer/IFullyConnectedLayer.java


// Targeting ../nvinfer/IActivationLayer.java



/**
 *  \enum PoolingType
 * 
 *  \brief The type of pooling to perform in a pooling layer.
 *  */
@Namespace("nvinfer1") public enum PoolingType {
    kMAX(0),              // Maximum over elements
    kAVERAGE(1),          // Average over elements. If the tensor is padded, the count includes the padding
    kMAX_AVERAGE_BLEND(2);// Blending between max and average pooling: (1-blendFactor)*maxPool + blendFactor*avgPool

    public final int value;
    private PoolingType(int v) { this.value = v; }
    private PoolingType(PoolingType e) { this.value = e.value; }
    public PoolingType intern() { for (PoolingType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in PoolingType enum.
 * 
 *  @see PoolingType
 *  */

// Targeting ../nvinfer/IPoolingLayer.java


// Targeting ../nvinfer/ILRNLayer.java



/**
 *  \brief Controls how shift, scale and power are applied in a Scale layer.
 * 
 *  @see IScaleLayer
 *  */
@Namespace("nvinfer1") public enum ScaleMode {
    /** Identical coefficients across all elements of the tensor. */
    kUNIFORM(0),
    /** Per-channel coefficients. */
    kCHANNEL(1),
    /** Elementwise coefficients. */
    kELEMENTWISE(2);

    public final int value;
    private ScaleMode(int v) { this.value = v; }
    private ScaleMode(ScaleMode e) { this.value = e.value; }
    public ScaleMode intern() { for (ScaleMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in ScaleMode enum.
 * 
 *  @see ScaleMode
 *  */

// Targeting ../nvinfer/IScaleLayer.java


// Targeting ../nvinfer/ISoftMaxLayer.java


// Targeting ../nvinfer/IConcatenationLayer.java


// Targeting ../nvinfer/IDeconvolutionLayer.java



/**
 *  \enum ElementWiseOperation
 * 
 *  \brief Enumerates the binary operations that may be performed by an ElementWise layer.
 * 
 *  Operations kAND, kOR, and kXOR must have inputs of DataType::kBOOL.
 * 
 *  Operation kPOW must have inputs of DataType::kFLOAT, DataType::kHALF, or DataType::kINT8.
 * 
 *  All other operations must have inputs of DataType::kFLOAT, DataType::kHALF, DataType::kINT8, or DataType::kINT32.
 * 
 *  @see IElementWiseLayer
 *  */
@Namespace("nvinfer1") public enum ElementWiseOperation {
    /** Sum of the two elements. */
    kSUM(0),
    /** Product of the two elements. */
    kPROD(1),
    /** Maximum of the two elements. */
    kMAX(2),
    /** Minimum of the two elements. */
    kMIN(3),
    /** Subtract the second element from the first. */
    kSUB(4),
    /** Divide the first element by the second. */
    kDIV(5),
    /** The first element to the power of the second element. */
    kPOW(6),
    /** Floor division of the first element by the second. */
    kFLOOR_DIV(7),
    /** Logical AND of two elements. */
    kAND(8),
    /** Logical OR of two elements. */
    kOR(9),
    /** Logical XOR of two elements. */
    kXOR(10),
    /** Check if two elements are equal. */
    kEQUAL(11),
    /** Check if element in first tensor is greater than corresponding element in second tensor. */
    kGREATER(12),
    /** Check if element in first tensor is less than corresponding element in second tensor. */
    kLESS(13);

    public final int value;
    private ElementWiseOperation(int v) { this.value = v; }
    private ElementWiseOperation(ElementWiseOperation e) { this.value = e.value; }
    public ElementWiseOperation intern() { for (ElementWiseOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in ElementWiseOperation enum.
 * 
 *  @see ElementWiseOperation
 *  */

// Targeting ../nvinfer/IElementWiseLayer.java



/**
 *  \brief Control form of IGatherLayer
 * 
 *  @see IGatherLayer
 *  */
@Namespace("nvinfer1") public enum GatherMode {
    /** Similar to ONNX Gather */
    kDEFAULT(0),
    /** Similar to ONNX GatherElements */
    kELEMENT(1),
    /** Similar to ONNX GatherND */
    kND(2);

    public final int value;
    private GatherMode(int v) { this.value = v; }
    private GatherMode(GatherMode e) { this.value = e.value; }
    public GatherMode intern() { for (GatherMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in GatherMode enum.
 * 
 *  @see GatherMode
 *  */

// Targeting ../nvinfer/IGatherLayer.java



/**
 *  \enum RNNOperation
 * 
 *  \brief Enumerates the RNN operations that may be performed by an RNN layer.
 * 
 *  __Equation definitions__
 * 
 *  The equations below have the following naming convention:
 * 
 *  ~~~
 *  t := current time step
 * 
 *  i := input gate
 *  o := output gate
 *  f := forget gate
 *  z := update gate
 *  r := reset gate
 *  c := cell gate
 *  h := hidden gate
 * 
 *  g[t] denotes the output of gate g at timestep t, e.g.
 *  f[t] is the output of the forget gate f.
 * 
 *  X[t] := input tensor for timestep t
 *  C[t] := cell state for timestep t
 *  H[t] := hidden state for timestep t
 * 
 *  W[g] := W (input) parameter weight matrix for gate g
 *  R[g] := U (recurrent) parameter weight matrix for gate g
 *  Wb[g] := W (input) parameter bias vector for gate g
 *  Rb[g] := U (recurrent) parameter bias vector for gate g
 * 
 *  Unless otherwise specified, all operations apply pointwise
 *  to elements of each operand tensor.
 * 
 *  ReLU(X) := max(X, 0)
 *  tanh(X) := hyperbolic tangent of X
 *  sigmoid(X) := 1 / (1 + exp(-X))
 *  exp(X) := e^X
 * 
 *  A.B denotes matrix multiplication of A and B.
 *  A*B denotes pointwise multiplication of A and B.
 *  ~~~
 * 
 *  __Equations__
 * 
 *  Depending on the value of RNNOperation chosen, each sub-layer of the RNN
 *  layer will perform one of the following operations:
 * 
 *  ~~~
 *  ::kRELU
 * 
 *    H[t] := ReLU(W[i].X[t] + R[i].H[t-1] + Wb[i] + Rb[i])
 * 
 *  ::kTANH
 * 
 *    H[t] := tanh(W[i].X[t] + R[i].H[t-1] + Wb[i] + Rb[i])
 * 
 *  ::kLSTM
 * 
 *    i[t] := sigmoid(W[i].X[t] + R[i].H[t-1] + Wb[i] + Rb[i])
 *    f[t] := sigmoid(W[f].X[t] + R[f].H[t-1] + Wb[f] + Rb[f])
 *    o[t] := sigmoid(W[o].X[t] + R[o].H[t-1] + Wb[o] + Rb[o])
 *    c[t] :=    tanh(W[c].X[t] + R[c].H[t-1] + Wb[c] + Rb[c])
 * 
 *    C[t] := f[t]*C[t-1] + i[t]*c[t]
 *    H[t] := o[t]*tanh(C[t])
 * 
 *  ::kGRU
 * 
 *    z[t] := sigmoid(W[z].X[t] + R[z].H[t-1] + Wb[z] + Rb[z])
 *    r[t] := sigmoid(W[r].X[t] + R[r].H[t-1] + Wb[r] + Rb[r])
 *    h[t] := tanh(W[h].X[t] + r[t]*(R[h].H[t-1] + Rb[h]) + Wb[h])
 * 
 *    H[t] := (1 - z[t])*h[t] + z[t]*H[t-1]
 *  ~~~
 * 
 *  @see IRNNv2Layer
 *  */
@Namespace("nvinfer1") public enum RNNOperation {
    /** Single gate RNN w/ ReLU activation function. */
    kRELU(0),
    /** Single gate RNN w/ TANH activation function. */
    kTANH(1),
    /** Four-gate LSTM network w/o peephole connections. */
    kLSTM(2),
    /** Three-gate network consisting of Gated Recurrent Units. */
    kGRU(3);

    public final int value;
    private RNNOperation(int v) { this.value = v; }
    private RNNOperation(RNNOperation e) { this.value = e.value; }
    public RNNOperation intern() { for (RNNOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in RNNOperation enum.
 * 
 *  @see RNNOperation
 *  */


/**
 *  \enum RNNDirection
 * 
 *  \brief Enumerates the RNN direction that may be performed by an RNN layer.
 * 
 *  @see IRNNv2Layer
 *  */
@Namespace("nvinfer1") public enum RNNDirection {
    /** Network iterations from first input to last input. */
    kUNIDIRECTION(0),
    /** Network iterates from first to last and vice versa and outputs concatenated. */
    kBIDIRECTION(1);

    public final int value;
    private RNNDirection(int v) { this.value = v; }
    private RNNDirection(RNNDirection e) { this.value = e.value; }
    public RNNDirection intern() { for (RNNDirection e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in RNNDirection enum.
 * 
 *  @see RNNDirection
 *  */


/**
 *  \enum RNNInputMode
 * 
 *  \brief Enumerates the RNN input modes that may occur with an RNN layer.
 * 
 *  If the RNN is configured with RNNInputMode::kLINEAR, then for each gate {@code g} in the first layer of the RNN,
 *  the input vector {@code X[t]} (length {@code E}) is left-multiplied by the gate's corresponding weight matrix {@code W[g]}
 *  (dimensions {@code HxE}) as usual, before being used to compute the gate output as described by \ref RNNOperation.
 * 
 *  If the RNN is configured with RNNInputMode::kSKIP, then this initial matrix multiplication is "skipped"
 *  and {@code W[g]} is conceptually an identity matrix.  In this case, the input vector {@code X[t]} must have length {@code H}
 *  (the size of the hidden state).
 * 
 *  @see IRNNv2Layer
 *  */
@Namespace("nvinfer1") public enum RNNInputMode {
    /** Perform the normal matrix multiplication in the first recurrent layer. */
    kLINEAR(0),
    /** No operation is performed on the first recurrent layer. */
    kSKIP(1);

    public final int value;
    private RNNInputMode(int v) { this.value = v; }
    private RNNInputMode(RNNInputMode e) { this.value = e.value; }
    public RNNInputMode intern() { for (RNNInputMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in RNNInputMode enum.
 * 
 *  @see RNNInputMode
 *  */


/**
 *  \enum RNNGateType
 * 
 *  \brief Identifies an individual gate within an RNN cell.
 * 
 *  @see RNNOperation
 *  */
@Namespace("nvinfer1") public enum RNNGateType {
    /** Input gate  (i). */
    kINPUT(0),
    /** Output gate (o). */
    kOUTPUT(1),
    /** Forget gate (f). */
    kFORGET(2),
    /** Update gate (z). */
    kUPDATE(3),
    /** Reset gate  (r). */
    kRESET(4),
    /** Cell gate   (c). */
    kCELL(5),
    /** Hidden gate (h). */
    kHIDDEN(6);

    public final int value;
    private RNNGateType(int v) { this.value = v; }
    private RNNGateType(RNNGateType e) { this.value = e.value; }
    public RNNGateType intern() { for (RNNGateType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in RNNGateType enum.
 * 
 *  @see RNNGateType
 *  */

// Targeting ../nvinfer/IRNNv2Layer.java


// Targeting ../nvinfer/IPluginV2Layer.java



/**
 *  \enum UnaryOperation
 * 
 *  \brief Enumerates the unary operations that may be performed by a Unary layer.
 * 
 *  Operations kNOT must have inputs of DataType::kBOOL.
 * 
 *  Operation kSIGN must have inputs of DataType::kFLOAT, DataType::kHALF, DataType::kINT8, or DataType::kINT32.
 * 
 *  Operation kISINF must have inputs of DataType::kFLOAT or DataType::kHALF.
 * 
 *  All other operations must have inputs of DataType::kFLOAT, DataType::kHALF, or DataType::kINT8.
 * 
 *  Operations kSIGN and kROUND are not supported in implicit batch mode.
 * 
 *  @see IUnaryLayer
 *  */
@Namespace("nvinfer1") public enum UnaryOperation {
    /** Exponentiation. */
    kEXP(0),
    /** Log (base e). */
    kLOG(1),
    /** Square root. */
    kSQRT(2),
    /** Reciprocal. */
    kRECIP(3),
    /** Absolute value. */
    kABS(4),
    /** Negation. */
    kNEG(5),
    /** Sine. */
    kSIN(6),
    /** Cosine. */
    kCOS(7),
    /** Tangent. */
    kTAN(8),
    /** Hyperbolic sine. */
    kSINH(9),
    /** Hyperbolic cosine. */
    kCOSH(10),
    /** Inverse sine. */
    kASIN(11),
    /** Inverse cosine. */
    kACOS(12),
    /** Inverse tangent. */
    kATAN(13),
    /** Inverse hyperbolic sine. */
    kASINH(14),
    /** Inverse hyperbolic cosine. */
    kACOSH(15),
    /** Inverse hyperbolic tangent. */
    kATANH(16),
    /** Ceiling. */
    kCEIL(17),
    /** Floor. */
    kFLOOR(18),
    /** Gauss error function. */
    kERF(19),
    /** Logical NOT. */
    kNOT(20),
    /** Sign, If input > 0, output 1; if input < 0, output -1; if input == 0, output 0. */
    kSIGN(21),
    /** Round to nearest even for floating-point data type. */
    kROUND(22),
    /** Return true if input value equals +/- infinity for floating-point data type. */
    kISINF(23);

    public final int value;
    private UnaryOperation(int v) { this.value = v; }
    private UnaryOperation(UnaryOperation e) { this.value = e.value; }
    public UnaryOperation intern() { for (UnaryOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in UnaryOperation enum.
 * 
 *  @see UnaryOperation
 *  */

// Targeting ../nvinfer/IUnaryLayer.java



/**
 *  \enum ReduceOperation
 * 
 *  \brief Enumerates the reduce operations that may be performed by a Reduce layer.
 * 
 *  The table shows the result of reducing across an empty volume of a given type.
 * 
 *  Operation | kFLOAT and kHALF  | kINT32  | kINT8
 *  --------- | ----------------- | ------- | -----
 *  kSUM      | 0                 | 0       | 0
 *  kPROD     | 1                 | 1       | 1
 *  kMAX      | negative infinity | INT_MIN | -128
 *  kMIN      | positive infinity | INT_MAX | 127
 *  kAVG      | NaN               | 0       | -128
 * 
 *  The current version of TensorRT usually performs reduction for kINT8 via kFLOAT or kHALF.
 *  The kINT8 values show the quantized representations of the floating-point values.
 *  */
@Namespace("nvinfer1") public enum ReduceOperation {
    kSUM(0),
    kPROD(1),
    kMAX(2),
    kMIN(3),
    kAVG(4);

    public final int value;
    private ReduceOperation(int v) { this.value = v; }
    private ReduceOperation(ReduceOperation e) { this.value = e.value; }
    public ReduceOperation intern() { for (ReduceOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in ReduceOperation enum.
 * 
 *  @see ReduceOperation
 *  */

// Targeting ../nvinfer/IReduceLayer.java


// Targeting ../nvinfer/IPaddingLayer.java


// Targeting ../nvinfer/Permutation.java


// Targeting ../nvinfer/IShuffleLayer.java



/**
 *  \brief Controls how ISliceLayer and IGridSample handle out-of-bounds coordinates.
 * 
 *  @see ISliceLayer and IGridSample
 *  */
@Namespace("nvinfer1") public enum SampleMode {
    /** Fail with error when the coordinates are out of bounds. */
    kSTRICT_BOUNDS(0),
    kDEFAULT(kSTRICT_BOUNDS.value), /** @deprecated Use kSTRICT_BOUNDS. */
    /** Coordinates wrap around periodically. */
    kWRAP(1),
    /** Out of bounds indices are clamped to bounds. */
    kCLAMP(2),
    /** Use fill input value when coordinates are out of bounds. */
    kFILL(3),
    /** Coordinates reflect. The axis of reflection is the middle of the perimeter pixel and the
 *  reflections are repeated indefinitely within the padded regions. Repeats values for a single
 *  pixel and throws error for zero pixels. */
    kREFLECT(4);

    public final int value;
    private SampleMode(int v) { this.value = v; }
    private SampleMode(SampleMode e) { this.value = e.value; }
    public SampleMode intern() { for (SampleMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** @deprecated Deprecated in TensorRT 8.5. Superseded by SampleMode. */


//!
//!
//!

/**
 *  Maximum number of elements in SampleMode enum.
 * 
 *  @see SampleMode
 *  */

// Targeting ../nvinfer/ISliceLayer.java


// Targeting ../nvinfer/IShapeLayer.java



/**
 *  \enum TopKOperation
 * 
 *  \brief Enumerates the operations that may be performed by a TopK layer.
 *  */
@Namespace("nvinfer1") public enum TopKOperation {
    /** Maximum of the elements. */
    kMAX(0),
    /** Minimum of the elements. */
    kMIN(1);

    public final int value;
    private TopKOperation(int v) { this.value = v; }
    private TopKOperation(TopKOperation e) { this.value = e.value; }
    public TopKOperation intern() { for (TopKOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in TopKOperation enum.
 * 
 *  @see TopKOperation
 *  */

// Targeting ../nvinfer/ITopKLayer.java



/**
 *  \enum MatrixOperation
 * 
 *  \brief Enumerates the operations that may be performed on a tensor
 *         by IMatrixMultiplyLayer before multiplication.
 *  */
@Namespace("nvinfer1") public enum MatrixOperation {
    /** Treat x as a matrix if it has two dimensions, or as a collection of
     *  matrices if x has more than two dimensions, where the last two dimensions
     *  are the matrix dimensions. x must have at least two dimensions. */
    kNONE(0),

    /** Like kNONE, but transpose the matrix dimensions. */
    
//!
//!
    kTRANSPOSE(1),

    /** Treat x as a vector if it has one dimension, or as a collection of
     *  vectors if x has more than one dimension. x must have at least one dimension.
     * 
     *  The first input tensor with dimensions [M,K] used with MatrixOperation::kVECTOR is equivalent to a tensor
     *  with dimensions [M, 1, K] with MatrixOperation::kNONE, i.e. is treated as M row vectors of length K,
     *  or dimensions [M, K, 1] with MatrixOperation::kTRANSPOSE.
     * 
     *  The second input tensor with dimensions [M,K] used with MatrixOperation::kVECTOR is equivalent to a tensor
     *  with dimensions [M, K, 1] with MatrixOperation::kNONE, i.e. is treated as M column vectors of length K,
     *  or dimensions [M, 1, K] with MatrixOperation::kTRANSPOSE. */
    kVECTOR(2);

    public final int value;
    private MatrixOperation(int v) { this.value = v; }
    private MatrixOperation(MatrixOperation e) { this.value = e.value; }
    public MatrixOperation intern() { for (MatrixOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in MatrixOperation enum.
 * 
 *  @see DataType
 *  */

// Targeting ../nvinfer/IMatrixMultiplyLayer.java


// Targeting ../nvinfer/INonZeroLayer.java


// Targeting ../nvinfer/IRaggedSoftMaxLayer.java


// Targeting ../nvinfer/IIdentityLayer.java


// Targeting ../nvinfer/ICastLayer.java


// Targeting ../nvinfer/IConstantLayer.java


// Targeting ../nvinfer/IParametricReLULayer.java



/** \enum InterpolationMode
 * 
 *  \brief Enumerates various modes of interpolation
 * 
 *  */
@Namespace("nvinfer1") public enum InterpolationMode {
    /** ND (0 < N <= 8) nearest neighbor resizing. */
    kNEAREST(0),
    /** Supports linear (1D), bilinear (2D), and trilinear (3D) interpolation */
    kLINEAR(1),
    /** Supports bicubic (2D) interpolation */
    kCUBIC(2);

    public final int value;
    private InterpolationMode(int v) { this.value = v; }
    private InterpolationMode(InterpolationMode e) { this.value = e.value; }
    public InterpolationMode intern() { for (InterpolationMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/** @deprecated Deprecated in TensorRT 8.5. Superseded by InterpolationMode. */
/**
 *  Maximum number of elements in InterpolationMode enum.
 * 
 *  @see InterpolationMode
 *  */
 // namespace impl

/**
 *  \enum ResizeCoordinateTransformation
 * 
 *  \brief The resize coordinate transformation function.
 * 
 *  @see IResizeLayer::setCoordinateTransformation()
 *  */
@Namespace("nvinfer1") public enum ResizeCoordinateTransformation {
    /** Think of each value in the tensor as a unit volume, and the coordinate is a point inside this volume.
     *  The coordinate point is drawn as a star {@code (*)} in the below diagram, and multiple values range has a length.
     *  Define {@code x_origin} as the coordinate of axis x in the input tensor, {@code x_resized} as the coordinate of axis x in
     *  the output tensor, {@code length_origin} as length of the input tensor in axis x, and {@code length_resize} as length of the
     *  output tensor in axis x.
     * 
     *      |<--------------length---------->|
     *      |    0     |    1     |    2     |    3     |
     *      *          *          *          *
     * 
     *      x_origin = x_resized * (length_origin - 1) / (length_resize - 1)
     *  */
    
//!
//!
    kALIGN_CORNERS(0),

    /**     |<--------------length--------------------->|
     *      |    0     |    1     |    2     |    3     |
     *      *          *          *          *
     * 
     *      x_origin = x_resized * (length_origin / length_resize)
     *  */
    
//!
//!
    kASYMMETRIC(1),

    /**     |<--------------length--------------------->|
     *      |    0     |    1     |    2     |    3     |
     *           *          *          *          *
     * 
     *      x_origin = (x_resized + 0.5) * (length_origin / length_resize) - 0.5
     *  */
    kHALF_PIXEL(2);

    public final int value;
    private ResizeCoordinateTransformation(int v) { this.value = v; }
    private ResizeCoordinateTransformation(ResizeCoordinateTransformation e) { this.value = e.value; }
    public ResizeCoordinateTransformation intern() { for (ResizeCoordinateTransformation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in ResizeCoordinateTransformation enum.
 * 
 *  @see ResizeCoordinateTransformation
 *  */
 // namespace impl

/**
 *  \enum ResizeSelector
 * 
 *  \brief The coordinate selector when resize to single pixel output.
 * 
 *  @see IResizeLayer::setSelectorForSinglePixel()
 *  */
@Namespace("nvinfer1") public enum ResizeSelector {
    /** Use formula to map the original index. */
    kFORMULA(0),

    /** Select the upper left pixel. */
    kUPPER(1);

    public final int value;
    private ResizeSelector(int v) { this.value = v; }
    private ResizeSelector(ResizeSelector e) { this.value = e.value; }
    public ResizeSelector intern() { for (ResizeSelector e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in ResizeSelector enum.
 * 
 *  @see ResizeSelector
 *  */
 // namespace impl

/**
 *  \enum ResizeRoundMode
 * 
 *  \brief The rounding mode for nearest neighbor resize.
 * 
 *  @see IResizeLayer::setNearestRounding()
 *  */
@Namespace("nvinfer1") public enum ResizeRoundMode {
    /** Round half up. */
    kHALF_UP(0),

    /** Round half down. */
    kHALF_DOWN(1),

    /** Round to floor. */
    kFLOOR(2),

    /** Round to ceil. */
    kCEIL(3);

    public final int value;
    private ResizeRoundMode(int v) { this.value = v; }
    private ResizeRoundMode(ResizeRoundMode e) { this.value = e.value; }
    public ResizeRoundMode intern() { for (ResizeRoundMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in ResizeRoundMode enum.
 * 
 *  @see ResizeRoundMode
 *  */

// Targeting ../nvinfer/IResizeLayer.java



/** Enum that describes kinds of loop outputs. */
@Namespace("nvinfer1") public enum LoopOutput {
    /** Output value is value of tensor for last iteration. */
    kLAST_VALUE(0),

    /** Output value is concatenation of values of tensor for each iteration, in forward order. */
    kCONCATENATE(1),

    /** Output value is concatenation of values of tensor for each iteration, in reverse order. */
    kREVERSE(2);

    public final int value;
    private LoopOutput(int v) { this.value = v; }
    private LoopOutput(LoopOutput e) { this.value = e.value; }
    public LoopOutput intern() { for (LoopOutput e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in LoopOutput enum.
 * 
 *  @see DataType
 *  */


/** Enum that describes kinds of trip limits. */
@Namespace("nvinfer1") public enum TripLimit {

    /** Tensor is scalar of type kINT32 that contains the trip count. */
    kCOUNT(0),
    /** Tensor is a scalar of type kBOOL. Loop terminates when value is false. */
    kWHILE(1);

    public final int value;
    private TripLimit(int v) { this.value = v; }
    private TripLimit(TripLimit e) { this.value = e.value; }
    public TripLimit intern() { for (TripLimit e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in TripLimit enum.
 * 
 *  @see DataType
 *  */

// Targeting ../nvinfer/ILoopBoundaryLayer.java


// Targeting ../nvinfer/IIfConditionalBoundaryLayer.java


// Targeting ../nvinfer/IConditionLayer.java


// Targeting ../nvinfer/IIfConditionalOutputLayer.java


// Targeting ../nvinfer/IIfConditionalInputLayer.java


// Targeting ../nvinfer/IIfConditional.java


// Targeting ../nvinfer/IRecurrenceLayer.java


// Targeting ../nvinfer/ILoopOutputLayer.java


// Targeting ../nvinfer/ITripLimitLayer.java


// Targeting ../nvinfer/IIteratorLayer.java


// Targeting ../nvinfer/ILoop.java


// Targeting ../nvinfer/ISelectLayer.java


// Targeting ../nvinfer/IAssertionLayer.java



/**
 *  \enum FillOperation
 * 
 *  \brief Enumerates the tensor fill operations that may performed by a fill layer.
 * 
 *  @see IFillLayer
 *  */
@Namespace("nvinfer1") public enum FillOperation {
    /** Generate evenly spaced numbers over a specified interval. */
    kLINSPACE(0),
    /** Generate a tensor with random values drawn from a uniform distribution. */
    kRANDOM_UNIFORM(1),
    /** Generate a tensor with random values drawn from a normal distribution. */
    kRANDOM_NORMAL(2);

    public final int value;
    private FillOperation(int v) { this.value = v; }
    private FillOperation(FillOperation e) { this.value = e.value; }
    public FillOperation intern() { for (FillOperation e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in FillOperation enum.
 * 
 *  @see FillOperation
 *  */

// Targeting ../nvinfer/IFillLayer.java


// Targeting ../nvinfer/IQuantizeLayer.java


// Targeting ../nvinfer/IDequantizeLayer.java


// Targeting ../nvinfer/IEinsumLayer.java



/**
 *  \brief Control form of IScatterLayer
 * 
 *  @see IScatterLayer
 *  */
@Namespace("nvinfer1") public enum ScatterMode {
    /** Similar to ONNX ScatterElements */
    kELEMENT(0),
    /** Similar to ONNX ScatterND */
    kND(1);

    public final int value;
    private ScatterMode(int v) { this.value = v; }
    private ScatterMode(ScatterMode e) { this.value = e.value; }
    public ScatterMode intern() { for (ScatterMode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in ScatterMode enum.
 * 
 *  @see ScatterMode
 *  */

// Targeting ../nvinfer/IScatterLayer.java


// Targeting ../nvinfer/IOneHotLayer.java


// Targeting ../nvinfer/IGridSampleLayer.java

 // class IGridSampleLayer

/**
 *  \brief Representation of bounding box data used for the Boxes input tensor in INMSLayer
 * 
 *  @see INMSLayer
 *  */
@Namespace("nvinfer1") public enum BoundingBoxFormat {
    /** (x1, y1, x2, y2) where (x1, y1) and (x2, y2) are any pair of diagonal corners */
    kCORNER_PAIRS(0),
    /** (x_center, y_center, width, height) where (x_center, y_center) is the center point of the box */
    kCENTER_SIZES(1);

    public final int value;
    private BoundingBoxFormat(int v) { this.value = v; }
    private BoundingBoxFormat(BoundingBoxFormat e) { this.value = e.value; }
    public BoundingBoxFormat intern() { for (BoundingBoxFormat e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in BoundingBoxFormat enum.
 * 
 *  @see BoundingBoxFormat
 *  */

// Targeting ../nvinfer/INMSLayer.java


// Targeting ../nvinfer/IReverseSequenceLayer.java


// Targeting ../nvinfer/INormalizationLayer.java


// Targeting ../nvinfer/INetworkDefinition.java



/**
 *  enum CalibrationAlgoType
 * 
 *  \brief Version of calibration algorithm to use.
 *  */
@Namespace("nvinfer1") public enum CalibrationAlgoType {
    kLEGACY_CALIBRATION(0),
    kENTROPY_CALIBRATION(1),
    kENTROPY_CALIBRATION_2(2),
    kMINMAX_CALIBRATION(3);

    public final int value;
    private CalibrationAlgoType(int v) { this.value = v; }
    private CalibrationAlgoType(CalibrationAlgoType e) { this.value = e.value; }
    public CalibrationAlgoType intern() { for (CalibrationAlgoType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in CalibrationAlgoType enum.
 * 
 *  @see DataType
 *  */

// Targeting ../nvinfer/IInt8Calibrator.java


// Targeting ../nvinfer/IInt8EntropyCalibrator.java


// Targeting ../nvinfer/IInt8EntropyCalibrator2.java


// Targeting ../nvinfer/IInt8MinMaxCalibrator.java


// Targeting ../nvinfer/IInt8LegacyCalibrator.java


// Targeting ../nvinfer/IAlgorithmIOInfo.java


// Targeting ../nvinfer/IAlgorithmVariant.java


// Targeting ../nvinfer/IAlgorithmContext.java


// Targeting ../nvinfer/IAlgorithm.java


// Targeting ../nvinfer/IAlgorithmSelector.java



/**
 *  \brief Represents one or more QuantizationFlag values using binary OR
 *  operations.
 * 
 *  @see IBuilderConfig::getQuantizationFlags(), IBuilderConfig::setQuantizationFlags()
 *  */


//!
//!
//!
//!

/**
 *  \enum QuantizationFlag
 * 
 *  \brief List of valid flags for quantizing the network to int8
 * 
 *  @see IBuilderConfig::setQuantizationFlag(), IBuilderConfig::getQuantizationFlag()
 *  */
@Namespace("nvinfer1") public enum QuantizationFlag {
    /** Run int8 calibration pass before layer fusion. Only valid for IInt8LegacyCalibrator and
     *  IInt8EntropyCalibrator. The builder always runs the int8 calibration pass before layer fusion for
     *  IInt8MinMaxCalibrator and IInt8EntropyCalibrator2. Disabled by default. */
    kCALIBRATE_BEFORE_FUSION(0);

    public final int value;
    private QuantizationFlag(int v) { this.value = v; }
    private QuantizationFlag(QuantizationFlag e) { this.value = e.value; }
    public QuantizationFlag intern() { for (QuantizationFlag e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of quantization flags in QuantizationFlag enum.
 * 
 *  @see QuantizationFlag
 *  */


/**
 *  \brief Represents one or more BuilderFlag values using binary OR
 *  operations, e.g., 1U << BuilderFlag::kFP16 | 1U << BuilderFlag::kDEBUG.
 * 
 *  @see IBuilderConfig::setFlags(), IBuilderConfig::getFlags()
 *  */


//!
//!
//!
//!

/**
 *  \enum BuilderFlag
 * 
 *  \brief List of valid modes that the builder can enable when creating an engine from a network definition.
 * 
 *  @see IBuilderConfig::setFlags(), IBuilderConfig::getFlags()
 *  */
@Namespace("nvinfer1") public enum BuilderFlag {
    /** Enable FP16 layer selection, with FP32 fallback. */
    kFP16(0),
    /** Enable Int8 layer selection, with FP32 fallback with FP16 fallback if kFP16 also specified. */
    kINT8(1),
    /** Enable debugging of layers via synchronizing after every layer. */
    kDEBUG(2),
    /** Enable layers marked to execute on GPU if layer cannot execute on DLA.
//!
//!
//!
//! */
    kGPU_FALLBACK(3),

    /** Legacy flag with effect similar to setting all of these three flags:
     * 
     *  * kPREFER_PRECISION_CONSTRAINTS
     *  * kDIRECT_IO
     *  * kREJECT_EMPTY_ALGORITHMS
     * 
     *  except that if the direct I/O requirement cannot be met and kDIRECT_IO was not explicitly set,
     *  instead of the build failing, the build falls back as if kDIRECT_IO was not set.
     * 
     *  @deprecated Deprecated in TensorRT 8.2.
     *  */
    kSTRICT_TYPES(4),

    /** Enable building a refittable engine. */
    kREFIT(5),
    /** Disable reuse of timing information across identical layers. */
    kDISABLE_TIMING_CACHE(6),

    /** Allow (but not require) computations on tensors of type DataType::kFLOAT to use TF32.
     *  TF32 computes inner products by rounding the inputs to 10-bit mantissas before
     *  multiplying, but accumulates the sum using 23-bit mantissas. Enabled by default. */
    kTF32(7),

    /** Allow the builder to examine weights and use optimized functions when weights have suitable sparsity. */
    
//!
    kSPARSE_WEIGHTS(8),

    /** Change the allowed parameters in the EngineCapability::kSTANDARD flow to
     *  match the restrictions that EngineCapability::kSAFETY check against for DeviceType::kGPU
     *  and EngineCapability::kDLA_STANDALONE check against the DeviceType::kDLA case. This flag
     *  is forced to true if EngineCapability::kSAFETY at build time if it is unset.
     * 
     *  This flag is only supported in NVIDIA Drive(R) products. */
    kSAFETY_SCOPE(9),

    /** Require that layers execute in specified precisions. Build fails otherwise. */
    kOBEY_PRECISION_CONSTRAINTS(10),

    /** Prefer that layers execute in specified precisions.
     *  Fall back (with warning) to another precision if build would otherwise fail. */
    kPREFER_PRECISION_CONSTRAINTS(11),

    /** Require that no reformats be inserted between a layer and a network I/O tensor
     *  for which ITensor::setAllowedFormats was called.
     *  Build fails if a reformat is required for functional correctness. */
    kDIRECT_IO(12),

    /** Fail if IAlgorithmSelector::selectAlgorithms returns an empty set of algorithms. */
    
//!
    kREJECT_EMPTY_ALGORITHMS(13),

    /** Enable heuristic-based tactic selection for shorter engine generation time. The engine may not
     *  be as performant as when built with a profiling-based builder.
     * 
     *  This flag is only supported by NVIDIA Ampere and later GPUs.
     *  @deprecated Superseded by builder optimization level 2. Deprecated in TensorRT 8.6 */
    
//!
    kENABLE_TACTIC_HEURISTIC(14),

    /** Restrict to lean runtime operators to provide version forward compatibility
     *  for the plan.
     * 
     *  Using this flag with ICudaEngine::serialize() and BuilderFlag::kREFIT would result in error.
     *  This flag is only supported by NVIDIA Volta and later GPUs.
     *  This flag is not supported in NVIDIA Drive(R) products.
     *  This flag is not supported with implicit batch mode. Network must be created with
     *  NetworkDefinitionCreationFlag::kEXPLICIT_BATCH. */
    
//!
//!
    kVERSION_COMPATIBLE(15),

    /** Exclude lean runtime from the plan when version forward compatability is enabled.
     *  By default, this flag is unset, so the lean runtime will be included in the plan.
     * 
     *  If BuilderFlag::kVERSION_COMPATIBLE is not set then the value of this flag will be ignored.
     * 
     *  This flag is not supported with implicit batch mode. Network must be created with
     *  NetworkDefinitionCreationFlag::kEXPLICIT_BATCH. */
    kEXCLUDE_LEAN_RUNTIME(16),

    /** Enable FP8 layer selection, with FP32 fallback.
     *  \warning kFP8 is not supported yet and will result in an error or undefined behavior. */
    kFP8(17);

    public final int value;
    private BuilderFlag(int v) { this.value = v; }
    private BuilderFlag(BuilderFlag e) { this.value = e.value; }
    public BuilderFlag intern() { for (BuilderFlag e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of builder flags in BuilderFlag enum.
 * 
 *  @see BuilderFlag
 *  */

// Targeting ../nvinfer/ITimingCache.java



/**
 *  \enum MemoryPoolType
 * 
 *  \brief The type for memory pools used by TensorRT.
 * 
 *  @see IBuilderConfig::setMemoryPoolLimit, IBuilderConfig::getMemoryPoolLimit
 *  */
@Namespace("nvinfer1") public enum MemoryPoolType {
    /**
     *  kWORKSPACE is used by TensorRT to store intermediate buffers within an operation.
     *  This is equivalent to the deprecated IBuilderConfig::setMaxWorkspaceSize and overrides that value.
     *  This defaults to max device memory. Set to a smaller value to restrict tactics that use over the
     *  threshold en masse. For more targeted removal of tactics use the IAlgorithmSelector
     *  interface.
     *  */
    

//!
//!
    kWORKSPACE(0),

    /**
     *  kDLA_MANAGED_SRAM is a fast software managed RAM used by DLA to communicate within a layer.
     *  The size of this pool must be at least 4 KiB and must be a power of 2.
     *  This defaults to 1 MiB.
     *  Orin has capacity of 1 MiB per core, and Xavier shares 4 MiB across all of its accelerator cores.
     *  */
    

//!
//!
    kDLA_MANAGED_SRAM(1),

    /**
     *  kDLA_LOCAL_DRAM is host RAM used by DLA to share intermediate tensor data across operations.
     *  The size of this pool must be at least 4 KiB and must be a power of 2.
     *  This defaults to 1 GiB.
     *  */
    

//!
//!
    kDLA_LOCAL_DRAM(2),

    /**
     *  kDLA_GLOBAL_DRAM is host RAM used by DLA to store weights and metadata for execution.
     *  The size of this pool must be at least 4 KiB and must be a power of 2.
     *  This defaults to 512 MiB.
     *  */
    

//!
//!
    kDLA_GLOBAL_DRAM(3),

    /**
     *  kTACTIC_DRAM is the device DRAM used by the optimizer to
     *  run tactics. On embedded devices, where host and device memory are unified, this includes all host
     *  memory required by TensorRT to build the network up to the point of each memory allocation.
     *  This defaults to 75% of totalGlobalMem as reported by cudaGetDeviceProperties when
     *  cudaGetDeviceProperties.embedded is true, and 100% otherwise.
     *  */
    kTACTIC_DRAM(4);

    public final int value;
    private MemoryPoolType(int v) { this.value = v; }
    private MemoryPoolType(MemoryPoolType e) { this.value = e.value; }
    public MemoryPoolType intern() { for (MemoryPoolType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of memory pool types in the MemoryPoolType enum.
 * 
 *  @see MemoryPoolType
 *  */


/**
 *  \enum PreviewFeature
 * 
 *  \brief Define preview features
 * 
 *  Preview Features have been fully tested but are not yet as stable as other features in TensorRT.
 *  They are provided as opt-in features for at least one release.
 *  */
@Namespace("nvinfer1") public enum PreviewFeature {
    /**
     *  Optimize runtime dimensions with TensorRT's DL Compiler.
     *  Potentially reduces run time and decreases device memory usage and engine size.
     *  Models most likely to benefit from enabling kFASTER_DYNAMIC_SHAPES_0805 are transformer-based models,
     *  and models containing dynamic control flows.
     * 
     *  The default value for this flag is on.
     * 
     *  @deprecated Turning it off is deprecated in TensorRT 8.6. The flag kFASTER_DYNAMIC_SHAPES_0805 will be removed in 9.0.
     *  */
    

//!
//!
//!
//!
//!
//!
    kFASTER_DYNAMIC_SHAPES_0805(0),

    /**
     *  Disable usage of cuDNN/cuBLAS/cuBLASLt tactics in the TensorRT core library.
     * 
     *  When the flag is enabled, TensorRT core will not use these tactics even if they are specified in
     *  \ref IBuilderConfig::setTacticSources(), but cudnnContext and cublasContext handles will still be passed to
     *  plugins via IPluginV2Ext::attachToContext() if the appropriate tactic sources are set.
     * 
     *  This allows users to experiment with disabling external library tactics without having to modify their
     *  application's plugins to support nullptr handles.
     * 
     *  The default value for this flag is on.
     * 
     *  @see TacticSource
     *  */
    

//!
//!
    kDISABLE_EXTERNAL_TACTIC_SOURCES_FOR_CORE_0805(1),

    /**
     *  Allows optimization profiles to be shared across execution contexts.
     *  This flag defaults to false and will become the default behavior in TensorRT 9.0.
     *  At that point this flag will do nothing.
     *  */
    kPROFILE_SHARING_0806(2);

    public final int value;
    private PreviewFeature(int v) { this.value = v; }
    private PreviewFeature(PreviewFeature e) { this.value = e.value; }
    public PreviewFeature intern() { for (PreviewFeature e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in PreviewFeature enum.
 * 
 *  @see PreviewFeature
 *  */
 // namespace impl

/** Describes requirements of compatibility with GPU architectures other than that of the GPU on which the engine was
 *  built. Levels except kNONE are only supported for engines built on NVIDIA Ampere and later GPUs.
 *  Note that compatibility with future hardware depends on CUDA forward compatibility support. */
@Namespace("nvinfer1") public enum HardwareCompatibilityLevel {
    /** Do not require hardware compatibility with GPU architectures other than that of the GPU on which the engine was
     *  built. */
    kNONE(0),

    /** Require that the engine is compatible with Ampere and newer GPUs. This will limit the max shared memory usage to
     *  48KiB, may reduce the number of available tactics for each layer, and may prevent some fusions from occurring.
     *  Thus this can decrease the performance, especially for tf32 models.
     *  This option will disable cuDNN, cuBLAS, and cuBLAS LT as tactic sources. */
    kAMPERE_PLUS(1);

    public final int value;
    private HardwareCompatibilityLevel(int v) { this.value = v; }
    private HardwareCompatibilityLevel(HardwareCompatibilityLevel e) { this.value = e.value; }
    public HardwareCompatibilityLevel intern() { for (HardwareCompatibilityLevel e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
/**
 *  Maximum number of elements in HardwareCompatibilityLevel enum.
 * 
 *  @see HardwareCompatibilityLevel
 *  */

// Targeting ../nvinfer/IBuilderConfig.java



/** \brief Represents one or more NetworkDefinitionCreationFlag flags
 *  using binary OR operations.
 *   e.g., 1U << NetworkDefinitionCreationFlag::kEXPLICIT_BATCH
 * 
 *  @see IBuilder::createNetworkV2
 *  */

//!
//!
//!

/** \enum NetworkDefinitionCreationFlag
 * 
 *  \brief List of immutable network properties expressed at network creation time.
 *  NetworkDefinitionCreationFlag is used with createNetworkV2() to specify immutable properties of the network.
 *  Creating a network without NetworkDefinitionCreationFlag::kEXPLICIT_BATCH flag has been deprecated.
 * 
 *  @see IBuilder::createNetworkV2
 *  */
@Namespace("nvinfer1") public enum NetworkDefinitionCreationFlag {
    /** Mark the network to be an explicit batch network.
     *  Dynamic shape support requires that the kEXPLICIT_BATCH flag is set.
     *  With dynamic shapes, any of the input dimensions can vary at run-time,
     *  and there are no implicit dimensions in the network specification.
     *  Varying dimensions are specified by using the wildcard dimension value -1. */
    
//!
    kEXPLICIT_BATCH(0),

    /** Deprecated. This flag has no effect now, but is only kept for backward compatability.
     *  */
    kEXPLICIT_PRECISION(1);

    public final int value;
    private NetworkDefinitionCreationFlag(int v) { this.value = v; }
    private NetworkDefinitionCreationFlag(NetworkDefinitionCreationFlag e) { this.value = e.value; }
    public NetworkDefinitionCreationFlag intern() { for (NetworkDefinitionCreationFlag e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

/**
 *  Maximum number of elements in NetworkDefinitionCreationFlag enum.
 * 
 *  @see NetworkDefinitionCreationFlag
 *  */

// Targeting ../nvinfer/IBuilder.java



 // namespace nvinfer1

/**
 *  Internal C entry point for creating IBuilder.
 *  \private
 *  */
public static native @NoException(true) Pointer createInferBuilder_INTERNAL(Pointer logger, int version);

/**
 *  \brief Create an instance of an IBuilder class.
 * 
 *  @param logger The logging class for the builder.
 * 
 *  unnamed namespace avoids linkage surprises when linking objects built with different versions of this header.
 *  */
@Namespace("nvinfer1") public static native @NoException(true) IBuilder createInferBuilder(@ByRef ILogger logger);

 // namespace

/**
 *  \brief Return the plugin registry for building a Standard engine, or nullptr if no registry exists.
 * 
 *  Also return nullptr if the input argument is not EngineCapability::kSTANDARD.
 *  Engine capabilities EngineCapability::kSTANDARD and EngineCapability::kSAFETY have distinct plugin registries.
 *  When building a Safety engine, use nvinfer1::getBuilderSafePluginRegistry().
 *  Use IPluginRegistry::registerCreator from the registry to register plugins.
 *  Plugins registered in a registry associated with a specific engine capability are only available when
 *  building engines with that engine capability.
 * 
 *  There is no plugin registry for EngineCapability::kDLA_STANDALONE.
 *  */
@Namespace("nvinfer1") public static native @NoException(true) IPluginRegistry getBuilderPluginRegistry(
    EngineCapability capability);
@Namespace("nvinfer1") public static native @NoException(true) IPluginRegistry getBuilderPluginRegistry(
    @Cast("nvinfer1::EngineCapability") int capability);
// Targeting ../nvinfer/SafeIPluginRegistry.java


 // namespace safe

/**
 *  \brief Return the plugin registry for building a Safety engine, or nullptr if no registry exists.
 * 
 *  Also return nullptr if the input argument is not EngineCapability::kSAFETY.
 *  When building a Standard engine, use nvinfer1::getBuilderPluginRegistry().
 *  Use safe::IPluginRegistry::registerCreator from the registry to register plugins.
 *  */
@Namespace("nvinfer1") public static native @NoException(true) SafeIPluginRegistry getBuilderSafePluginRegistry(
    EngineCapability capability);
@Namespace("nvinfer1") public static native @NoException(true) SafeIPluginRegistry getBuilderSafePluginRegistry(
    @Cast("nvinfer1::EngineCapability") int capability);

 // namespace nvinfer1

// #endif // NV_INFER_H


// Parsed from NvInferImpl.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_INFER_IMPL_H
// #define NV_INFER_IMPL_H

// #include "NvInferLegacyDims.h"
// #include "NvInferRuntimeCommon.h"
// Targeting ../nvinfer/IPlugin.java


// Targeting ../nvinfer/IPluginExt.java


// Targeting ../nvinfer/IPluginLayer.java



/** enum class nvinfer1::ActivationType */
;
/** enum class nvinfer1::BoundingBoxFormat */
;
/** enum class nvinfer1::BuilderFlag */
;
/** enum class nvinfer1::CalibrationAlgoType */
;
/** enum class nvinfer1::DeviceType */
;
/** enum class nvinfer1::DimensionOperation */
;
/** enum class nvinfer1::ElementWiseOperation */
;
/** enum class nvinfer1::EngineCapability */
;
/** enum class nvinfer1::FillOperation */
;
/** enum class nvinfer1::GatherMode */
;
/** enum class nvinfer1::LayerInformationFormat */
;
/** enum class nvinfer1::LayerType */
;
/** enum class nvinfer1::LoopOutput */
;
/** enum class nvinfer1::MatrixOperation */
;
/** enum class nvinfer1::MemoryPoolType */
;
/** enum class nvinfer1::NetworkDefinitionCreationFlag */
;
/** enum class nvinfer1::OptProfileSelector */
;
/** enum class nvinfer1::PaddingMode */
;
/** enum class nvinfer1::PoolingType */
;
/** enum class nvinfer1::ProfilingVerbosity */
;
/** enum class nvinfer1::QuantizationFlag */
;
/** enum class nvinfer1::ReduceOperation */
;
/** enum class nvinfer1::ResizeCoordinateTransformation */
;
/** enum class nvinfer1::InterpolationMode */
;
/** enum class nvinfer1::ResizeRoundMode */
;
/** enum class nvinfer1::ResizeSelector */
;
/** enum class nvinfer1::RNNDirection */
;
/** enum class nvinfer1::RNNGateType */
;
/** enum class nvinfer1::RNNInputMode */
;
/** enum class nvinfer1::RNNOperation */
;
/** enum class nvinfer1::ScaleMode */
;
/** enum class nvinfer1::ScatterMode */
;
/** enum class nvinfer1::SampleMode */
;
/** enum class nvinfer1::TensorIOMode */
;
/** enum class nvinfer1::TensorLocation */
;
/** enum class nvinfer1::TopKOperation */
;
/** enum class nvinfer1::TripLimit */
;
/** enum class nvinfer1::UnaryOperation */
;
/** enum class nvinfer1::WeightsRole */
;
/** enum class nvinfer1::PreviewFeature */
;
/** enum class nvinfer1::HardwareCompatibilityLevel */
;


//!
//!
//!
// Targeting ../nvinfer/VRoot.java


// Targeting ../nvinfer/VHostMemory.java


// Targeting ../nvinfer/VDimensionExpr.java


// Targeting ../nvinfer/VExprBuilder.java


// Targeting ../nvinfer/VRuntime.java


// Targeting ../nvinfer/VRefitter.java


// Targeting ../nvinfer/VOptimizationProfile.java


// Targeting ../nvinfer/VCudaEngine.java


// Targeting ../nvinfer/VExecutionContext.java


// Targeting ../nvinfer/VEngineInspector.java


// Targeting ../nvinfer/VTensor.java


// Targeting ../nvinfer/VLayer.java


// Targeting ../nvinfer/VConvolutionLayer.java


// Targeting ../nvinfer/VFullyConnectedLayer.java


// Targeting ../nvinfer/VActivationLayer.java


// Targeting ../nvinfer/VPoolingLayer.java


// Targeting ../nvinfer/VLRNLayer.java


// Targeting ../nvinfer/VScaleLayer.java


// Targeting ../nvinfer/VSoftMaxLayer.java


// Targeting ../nvinfer/VConcatenationLayer.java


// Targeting ../nvinfer/VDeconvolutionLayer.java


// Targeting ../nvinfer/VElementWiseLayer.java


// Targeting ../nvinfer/VGatherLayer.java


// Targeting ../nvinfer/VRNNv2Layer.java


// Targeting ../nvinfer/VPluginLayer.java


// Targeting ../nvinfer/VPluginV2Layer.java


// Targeting ../nvinfer/VUnaryLayer.java


// Targeting ../nvinfer/VReduceLayer.java


// Targeting ../nvinfer/VPaddingLayer.java


// Targeting ../nvinfer/VShuffleLayer.java


// Targeting ../nvinfer/VSliceLayer.java


// Targeting ../nvinfer/VShapeLayer.java


// Targeting ../nvinfer/VTopKLayer.java


// Targeting ../nvinfer/VMatrixMultiplyLayer.java


// Targeting ../nvinfer/VNonZeroLayer.java


// Targeting ../nvinfer/VRaggedSoftMaxLayer.java


// Targeting ../nvinfer/VIdentityLayer.java


// Targeting ../nvinfer/VCastLayer.java


// Targeting ../nvinfer/VConstantLayer.java


// Targeting ../nvinfer/VParametricReLULayer.java


// Targeting ../nvinfer/VResizeLayer.java


// Targeting ../nvinfer/VLoopBoundaryLayer.java


// Targeting ../nvinfer/VRecurrenceLayer.java


// Targeting ../nvinfer/VLoopOutputLayer.java


// Targeting ../nvinfer/VTripLimitLayer.java


// Targeting ../nvinfer/VIteratorLayer.java


// Targeting ../nvinfer/VLoop.java


// Targeting ../nvinfer/VConditionalBoundaryLayer.java


// Targeting ../nvinfer/VConditionLayer.java


// Targeting ../nvinfer/VConditionalInputLayer.java


// Targeting ../nvinfer/VConditionalOutputLayer.java


// Targeting ../nvinfer/VIfConditional.java


// Targeting ../nvinfer/VSelectLayer.java


// Targeting ../nvinfer/VAssertionLayer.java


// Targeting ../nvinfer/VFillLayer.java


// Targeting ../nvinfer/VQuantizeLayer.java


// Targeting ../nvinfer/VDequantizeLayer.java


// Targeting ../nvinfer/VScatterLayer.java


// Targeting ../nvinfer/VEinsumLayer.java


// Targeting ../nvinfer/VOneHotLayer.java


// Targeting ../nvinfer/VGridSampleLayer.java


// Targeting ../nvinfer/VNMSLayer.java


// Targeting ../nvinfer/VReverseSequenceLayer.java


// Targeting ../nvinfer/VNormalizationLayer.java


// Targeting ../nvinfer/VNetworkDefinition.java


// Targeting ../nvinfer/VAlgorithmIOInfo.java


// Targeting ../nvinfer/VAlgorithmVariant.java


// Targeting ../nvinfer/VAlgorithmContext.java


// Targeting ../nvinfer/VAlgorithm.java


// Targeting ../nvinfer/VTimingCache.java


// Targeting ../nvinfer/VBuilderConfig.java


// Targeting ../nvinfer/VBuilder.java



 // namespace apiv
 // namespace nvinfer1

// @endcond

// #endif // NV_INFER_RUNTIME_IMPL_H


// Parsed from NvUtils.h

/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

// #ifndef NV_UTILS_H
// #define NV_UTILS_H



//!
//!
//!
// #include "NvInfer.h"

/**
 *  \file NvUtils.h
 * 
 *  This file includes various utility functions
 *  */

/**
 *  @param input The input weights to reshape.
 *  @param shape The shape of the weights.
 *  @param shapeOrder The order of the dimensions to process for the output.
 *  @param data The location where the output data is placed.
 *  @param nbDims The number of dimensions to process.
 * 
 *  \brief Reformat the input weights of the given shape based on the new
 *  order of dimensions.
 * 
 *  Take the weights specified by \p input with the dimensions specified by
 *  \p shape and re-order the weights based on the new dimensions specified
 *  by \p shapeOrder. The size of each dimension and the input data is not
 *  modified. The output volume pointed to by \p data must be the same as
 *  he \p input volume.
 * 
 *  Example usage:
 *  float *out = new float[N*C*H*W];
 *  Weights input{DataType::kFLOAT, {0 ... N*C*H*W-1}, N*C*H*W size};
 *  int32_t order[4]{1, 0, 3, 2};
 *  int32_t shape[4]{C, N, W, H};
 *  reshapeWeights(input, shape, order, out, 4);
 *  Weights reshaped{input.type, out, input.count};
 * 
 *  Input Matrix{3, 2, 3, 2}:
 *  { 0  1}, { 2  3}, { 4  5} <-- {0, 0, *, *}
 *  { 6  7}, { 8  9}, {10 11} <-- {0, 1, *, *}
 *  {12 13}, {14 15}, {16 17} <-- {1, 0, *, *}
 *  {18 19}, {20 21}, {22 23} <-- {1, 1, *, *}
 *  {24 25}, {26 27}, {28 29} <-- {2, 0, *, *}
 *  {30 31}, {32 33}, {34 35} <-- {2, 1, *, *}
 * 
 *  Output Matrix{2, 3, 2, 3}:
 *  { 0  2  4}, { 1  3  5} <-- {0, 0, *, *}
 *  {12 14 16}, {13 15 17} <-- {0, 1, *, *}
 *  {24 26 28}, {25 27 29} <-- {0, 2, *, *}
 *  { 6  8 10}, { 7  9 11} <-- {1, 0, *, *}
 *  {18 20 22}, {19 21 23} <-- {1, 1, *, *}
 *  {30 32 34}, {31 33 35} <-- {1, 2, *, *}
 * 
 *  @return True on success, false on failure.
 * 
 *  @deprecated Deprecated in TensorRT 8.0.
 * 
 *  \warning This file will be removed in TensorRT 10.0.
 *  */


//!
//!
//!
//!
//!
//!
//!
//!
//!
//!
//!
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean reshapeWeights(
    @Const @ByRef Weights input, @Const IntPointer shape, @Const IntPointer shapeOrder, Pointer data, int nbDims);
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean reshapeWeights(
    @Const @ByRef Weights input, @Const IntBuffer shape, @Const IntBuffer shapeOrder, Pointer data, int nbDims);
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean reshapeWeights(
    @Const @ByRef Weights input, @Const int[] shape, @Const int[] shapeOrder, Pointer data, int nbDims);

/**
 *  @param input The input data to re-order.
 *  @param order The new order of the data sub-buffers.
 *  @param num The number of data sub-buffers to re-order.
 *  @param size The size of each data sub-buffer in bytes.
 * 
 *  \brief Takes an input stream and re-orders \p num chunks of the data
 *  given the \p size and \p order.
 * 
 *  In some frameworks, the ordering of the sub-buffers within a dimension
 *  is different than the way that TensorRT expects them.
 *  TensorRT expects the gate/bias sub-buffers for LSTM's to be in fico order.
 *  TensorFlow however formats the sub-buffers in icfo order.
 *  This helper function solves this in a generic fashion.
 * 
 *  Example usage output of reshapeWeights above:
 *  int32_t indir[1]{1, 0}
 *  int32_t stride = W*H;
 *  for (int32_t x = 0, y = N*C; x < y; ++x)
 *  reorderSubBuffers(out + x * stride, indir, H, W);
 * 
 *  Input Matrix{2, 3, 2, 3}:
 *  { 0  2  4}, { 1  3  5} <-- {0, 0, *, *}
 *  {12 14 16}, {13 15 17} <-- {0, 1, *, *}
 *  {24 26 28}, {25 27 29} <-- {0, 2, *, *}
 *  { 6  8 10}, { 7  9 11} <-- {1, 0, *, *}
 *  {18 20 22}, {19 21 23} <-- {1, 1, *, *}
 *  {30 32 34}, {31 33 35} <-- {1, 2, *, *}
 * 
 *  Output Matrix{2, 3, 2, 3}:
 *  { 1  3  5}, { 0  2  4} <-- {0, 0, *, *}
 *  {13 15 17}, {12 14 16} <-- {0, 1, *, *}
 *  {25 27 29}, {24 26 28} <-- {0, 2, *, *}
 *  { 7  9 11}, { 6  8 10} <-- {1, 0, *, *}
 *  {19 21 23}, {18 20 22} <-- {1, 1, *, *}
 *  {31 33 35}, {30 32 34} <-- {1, 2, *, *}
 * 
 *  @return True on success, false on failure.
 * 
 *  @see reshapeWeights()
 * 
 *  @deprecated Deprecated in TensorRT 8.0.
 * 
 *  \warning This file will be removed in TensorRT 10.0.
 *  */


//!
//!
//!
//!
//!
//!
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean reorderSubBuffers(
    Pointer input, @Const IntPointer order, int num, int size);
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean reorderSubBuffers(
    Pointer input, @Const IntBuffer order, int num, int size);
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean reorderSubBuffers(
    Pointer input, @Const int[] order, int num, int size);

/**
 *  @param input The input data to transpose.
 *  @param type The type of the data to transpose.
 *  @param num The number of data sub-buffers to transpose.
 *  @param height The size of the height dimension to transpose.
 *  @param width The size of the width dimension to transpose.
 * 
 *  \brief Transpose \p num sub-buffers of \p height * \p width.
 * 
 *  @return True on success, false on failure.
 * 
 *  @deprecated Deprecated in TensorRT 8.0.
 * 
 *  \warning This file will be removed in TensorRT 10.0.
 *  */
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean transposeSubBuffers(
    Pointer input, DataType type, int num, int height, int width);
@Namespace("nvinfer1::utils") public static native @Cast("bool") @Deprecated @NoException(true) boolean transposeSubBuffers(
    Pointer input, @Cast("nvinfer1::DataType") int type, int num, int height, int width);

 // namespace utils
 // namespace nvinfer1
// #endif // NV_UTILS_H


}
