/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch.presets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;
import org.bytedeco.openblas.presets.openblas;

@Properties(inherit={openblas.class}, value={@Platform(value={"linux", "macosx", "windows"}, compiler={"cpp17"}, define={"SHARED_PTR_NAMESPACE std", "UNIQUE_PTR_NAMESPACE std"}, include={"torch/torch.h", "torch/script.h", "torch/csrc/jit/runtime/instruction.h", "torch/csrc/jit/serialization/source_range_serialization.h", "torch/csrc/jit/frontend/resolver.h", "torch/csrc/jit/frontend/tree_views.h", "torch/csrc/jit/serialization/storage_context.h", "datasets.h", "pytorch_adapters.h"}, exclude={"openblas_config.h", "cblas.h", "lapacke_config.h", "lapacke_mangling.h", "lapack.h", "lapacke.h", "lapacke_utils.h"}, link={"c10", "torch_cpu", "torch"}, preload={"gomp@.1", "iomp5", "omp", "tbb@.2", "asmjit", "fbgemm"}), @Platform(value={"linux", "macosx", "windows"}, link={"c10", "c10_cuda", "torch_cpu", "torch_cuda", "torch"}, preload={"gomp@.1", "iomp5", "omp", "tbb@.2", "asmjit", "fbgemm", "cupti@.12"}, includepath={"/usr/local/cuda/include", "C:/Program Files/NVIDIA GPU Computing Toolkit/CUDA/v12.3/include/"}, preloadpath={"/usr/local/cuda-12.3/lib64/", "/usr/local/cuda-12.3/extras/CUPTI/lib64/", "/usr/local/cuda/lib64/", "/usr/local/cuda/extras/CUPTI/lib64/", "/usr/lib64/", "C:/Program Files/NVIDIA GPU Computing Toolkit/CUDA/v12.3/lib/x64/", "C:/Program Files/NVIDIA GPU Computing Toolkit/CUDA/v12.3/extras/CUPTI/lib64/", "C:/Program Files/NVIDIA Corporation/NvToolsExt/bin/x64/"}, extension={"-gpu"})}, target="org.bytedeco.pytorch", global="org.bytedeco.pytorch.global.torch")
public class torch
implements LoadEnabled,
InfoMapper {
    static void initIncludes(Class thisClass, ClassProperties properties) {
        if (Loader.getCallerClass((int)5).getName().equals("org.bytedeco.javacpp.tools.Parser")) {
            properties.put((Object)"platform.include", new ArrayList());
            Class presets = (Class)properties.getEffectiveClasses().get(0);
            InputStream includesStream = thisClass.getResourceAsStream(presets.getSimpleName() + "_include.h");
            if (includesStream == null) {
                throw new RuntimeException("Cannot find parse list for " + presets);
            }
            Pattern re = Pattern.compile("^#include\\s+[\"<]([^\">]+)[\">]");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(includesStream));){
                String line;
                while ((line = br.readLine()) != null) {
                    Matcher m = re.matcher(line);
                    if (!m.find()) continue;
                    properties.addAll("platform.include", new String[]{m.group(1)});
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void init(ClassProperties properties) {
        String[] libs;
        String platform = properties.getProperty("platform");
        String extension = properties.getProperty("platform.extension");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        torch.initIncludes(this.getClass(), properties);
        if (!Loader.isLoadLibraries() || extension == null || !extension.endsWith("-gpu")) {
            return;
        }
        int i = 0;
        if (platform.startsWith("windows")) {
            preloads.add(i++, "zlibwapi");
        }
        for (String lib : libs = new String[]{"cudart", "cublasLt", "cublas", "cufft", "curand", "nvJitLink", "cusparse", "cusolver", "cudnn", "nccl", "nvrtc", "myelin", "nvinfer", "cudnn_ops_infer", "cudnn_ops_train", "cudnn_adv_infer", "cudnn_adv_train", "cudnn_cnn_infer", "cudnn_cnn_train"}) {
            if (platform.startsWith("linux")) {
                lib = lib + (lib.startsWith("cudnn") ? "@.8" : (lib.equals("nccl") ? "@.2" : (lib.equals("myelin") ? "@.1" : (lib.equals("nvinfer") ? "@.8" : (lib.equals("cufft") ? "@.11" : (lib.equals("curand") ? "@.10" : (lib.equals("cusolver") ? "@.11" : "@.12")))))));
            } else {
                if (!platform.startsWith("windows")) continue;
                lib = lib + (lib.startsWith("cudnn") ? "64_8" : (lib.equals("nccl") ? "64_2" : (lib.equals("myelin") ? "64_1" : (lib.equals("nvinfer") ? "64_8" : (lib.equals("cufft") ? "64_11" : (lib.equals("curand") ? "64_10" : (lib.equals("cusolver") ? "64_11" : (lib.equals("nvrtc") ? "64_120_0" : (lib.equals("nvJitLink") ? "_120_0" : "64_12")))))))));
            }
            if (preloads.contains(lib)) continue;
            preloads.add(i++, lib);
        }
        preloads.add("nvToolsExt@.1");
        preloads.add("nvToolsExt64_1");
        if (i > 0) {
            resources.add("/org/bytedeco/cuda/");
            resources.add("/org/bytedeco/tensorrt/");
        }
    }

    public void mapModule(InfoMap infoMap, String name) {
        this.mapModule(infoMap, name, null, null, true);
    }

    public void mapModule(InfoMap infoMap, String name, boolean anyModuleCompatible) {
        this.mapModule(infoMap, name, null, null, anyModuleCompatible);
    }

    public void mapModule(InfoMap infoMap, String name, String base) {
        this.mapModule(infoMap, name, base, null, true);
    }

    public void mapModule(InfoMap infoMap, String name, String base, String baseBase) {
        this.mapModule(infoMap, name, base, baseBase, true);
    }

    public void mapModule(InfoMap infoMap, String name, String base, String baseBase, boolean anyModuleCompatible) {
        if (baseBase != null) {
            infoMap.put(new Info(new String[]{baseBase}).pointerTypes(new String[]{name + "ImplBaseBase"}));
        }
        if (base != null) {
            infoMap.put(new Info(new String[]{base}).pointerTypes(new String[]{name + "ImplBase"}));
        }
        infoMap.put(new Info(new String[]{"torch::nn::" + name + "Impl"})).put(new Info(new String[]{"torch::nn::" + name + "Impl::" + name + "Impl"}).annotations(new String[]{"@SharedPtr", "@Name(\"std::make_shared<torch::nn::" + name + "Impl>\")"})).put(new Info(new String[]{"torch::nn::Cloneable<torch::nn::" + name + "Impl>"}).pointerTypes(new String[]{name + "ImplCloneable"}).purify()).put(new Info(new String[]{"torch::nn::ModuleHolder<torch::nn::" + name + "Impl>"}).skip()).put(new Info(new String[]{"torch::nn::" + name}).skip());
        if (anyModuleCompatible) {
            infoMap.put(new Info(new String[]{"torch::nn::AnyModule::AnyModule<torch::nn::" + name + "Impl>(ModuleType*)", "torch::nn::AnyModule::AnyModule<torch::nn::" + name + "Impl>(torch::nn::" + name + "Impl*)"}).define().javaText("public AnyModule(" + name + "Impl module) { super((Pointer)null); allocate(module); }\nprivate native void allocate(@SharedPtr @Cast({\"\", \"std::shared_ptr<torch::nn::" + name + "Impl>\"}) " + name + "Impl module);\n")).put(new Info(new String[]{"torch::nn::SequentialImpl::push_back<torch::nn::" + name + "Impl>"}).javaNames(new String[]{"push_back"}));
        }
    }

    public static void sharedMap(InfoMap infoMap) {
        infoMap.put(new Info().enumerate().friendly()).put(new Info(new String[]{"auto", "c10::reverse_iterator", "ska::flat_hash_map", "std::conditional", "std::iterator_traits", "std::initializer_list", "std::integral_constant", "std::mutex", "std::reverse_iterator", "std::weak_ptr"}).skip());
        infoMap.put(new Info(new String[]{"TORCH_API", "C10_API", "C10_EXPORT", "C10_HIDDEN", "C10_IMPORT", "C10_API_ENUM", "EXPORT_IF_NOT_GCC", "TORCH_CUDA_CU_API", "TORCH_CUDA_CPP_API", "TORCH_HIP_API", "TORCH_PYTHON_API", "__ubsan_ignore_float_divide_by_zero__", "__ubsan_ignore_undefined__", "__ubsan_ignore_signed_int_overflow__", "__ubsan_ignore_function__", "C10_CLANG_DIAGNOSTIC_IGNORE", "C10_CLANG_DIAGNOSTIC_PUSH", "C10_CLANG_DIAGNOSTIC_POP", "C10_ATTR_VISIBILITY_HIDDEN", "C10_ERASE", "C10_UID", "C10_NODISCARD", "C10_UNUSED", "C10_USED", "C10_RESTRICT", "C10_NOINLINE", "C10_ALWAYS_INLINE", "C10_FALLTHROUGH", "C10_HOST_DEVICE", "C10_DEVICE", "C10_HOST", "C10_LAUNCH_BOUNDS_0", "C10_HIP_HOST_DEVICE", "C10_WARP_SIZE", "C10_IOS", "C10_MOBILE", "C10_HOST_CONSTEXPR", "CONSTEXPR_EXCEPT_WIN_CUDA", "C10_HOST_CONSTEXPR_EXCEPT_WIN_CUDA", "C10_ALWAYS_INLINE_UNLESS_MOBILE", "alignas", "COMPLEX_INTEGER_OP_TEMPLATE_CONDITION", "C10_DEVICE_HOST_FUNCTION", "FORCE_INLINE_APPLE", "ERROR_UNSUPPORTED_CAST", "LEGACY_CONTIGUOUS_MEMORY_FORMAT", "GFLAGS_DLL_DEFINE_FLAG", "GFLAGS_DLL_DECLARE_FLAG", "AT_X", "DEFINE_KEY", "C10_DISPATCHER_INLINE_UNLESS_MOBILE", "TH_DISALLOW_COPY_AND_ASSIGN", "__device__", "TORCH_DSA_KERNEL_ARGS", "TORCH_DSA_KERNEL_ARGS_PASS", "C10_CUDA_API", "C10_CUDA_IMPORT", "C10_CUDA_EXPORT", "__ubsan_ignore_float_divide_by_zero__", "__ubsan_ignore_undefined__", "__ubsan_ignore_signed_int_overflow__", "__ubsan_ignore_pointer_overflow__", "__ubsan_ignore_function__"}).cppTypes(new String[0]).annotations(new String[0])).put(new Info(new String[]{"defined(__CUDACC__) || defined(__HIPCC__)", "defined(__CUDACC__) && !defined(USE_ROCM)", "defined(SYCL_EXT_ONEAPI_BFLOAT16_MATH_FUNCTIONS)", "defined(_MSC_VER) && _MSC_VER <= 1900", "defined(NDEBUG)", "defined(__ANDROID__)", "defined(__APPLE__)", "defined(__HIP_PLATFORM_HCC__)", "defined(_MSC_VER)", "_WIN32", "defined(USE_ROCM)", "USE_ROCM", "SYCL_LANGUAGE_VERSION", "defined(CUDA_VERSION) && CUDA_VERSION >= 11000", "defined ENABLE_RECORD_KERNEL_FUNCTION_DTYPE", "__OBJC__"}).define(false)).put(new Info(new String[]{"C10_DEFINE_DEPRECATED_USING"}).cppText("#define C10_DEFINE_DEPRECATED_USING(TypeName, TypeThingy)").cppTypes(new String[0])).put(new Info(new String[]{"C10_DEPRECATED_MESSAGE"}).cppText("#define C10_DEPRECATED_MESSAGE() deprecated").cppTypes(new String[0])).put(new Info(new String[]{"C10_DEPRECATED"}).cppText("#define C10_DEPRECATED deprecated").cppTypes(new String[0])).put(new Info(new String[]{"deprecated"}).annotations(new String[]{"@Deprecated"})).put(new Info(new String[]{"CAFFE2_LOG_THRESHOLD"}).translate(false)).put(new Info(new String[]{"TORCH_CHECK"}).cppText("#define TORCH_CHECK(cond, ...)").define()).put(new Info(new String[]{"DEFINE_SYMBOL"}).cppText("#define DEFINE_SYMBOL(ns, s) namespace ns { constexpr Symbol s; }").define()).put(new Info(new String[]{"TORCH_ENUM_DECLARE"}).cppText("#define TORCH_ENUM_DECLARE(name) namespace torch { namespace enumtype { struct k##name { k##name() {} }; } }").define());
    }

    /*
     * Opcode count of 21545 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * WARNING - void declaration
     */
    public void map(InfoMap infoMap) {
        void var7_49;
        String[] abstracts;
        int i;
        int n;
        String[] virtuals;
        void var5_25;
        String[] factories;
        torch.sharedMap(infoMap);
        infoMap.put(new Info(new String[]{"ordered_dict.h"}).linePatterns(new String[]{".*class Item;.*"}).skip()).put(new Info(new String[]{"util.h"}).linePatterns(new String[]{".*using approx_time_t = decltype.*"}).skip()).put(new Info().javaText("import org.bytedeco.pytorch.Allocator;")).put(new Info().javaText("import org.bytedeco.pytorch.Function;")).put(new Info().javaText("import org.bytedeco.pytorch.functions.*;")).put(new Info().javaText("import org.bytedeco.pytorch.Module;")).put(new Info().javaText("import org.bytedeco.javacpp.annotation.Cast;")).put(new Info(new String[]{"basic/containers"}).cppTypes(new String[]{"c10::optional", "torch::optional", "c10::variant"})).put(new Info(new String[]{"std::nullptr_t"}).cast().pointerTypes(new String[]{"PointerPointer"})).put(new Info(new String[]{"at::CheckedFrom"}).cast().valueTypes(new String[]{"BytePointer", "String"}).pointerTypes(new String[]{"PointerPointer"})).put(new Info(new String[]{"c10::IValue", "at::IValue", "decltype(auto)"}).pointerTypes(new String[]{"IValue"})).put(new Info(new String[]{"std::size_t", "c10::Dict<c10::IValue,c10::IValue>::size_type", "c10::Dict<std::string,c10::impl::GenericList>::size_type"}).cast().valueTypes(new String[]{"long"}).pointerTypes(new String[]{"SizeTPointer"})).put(new Info(new String[]{"approx_time_t"}).cast().valueTypes(new String[]{"long"}).pointerTypes(new String[]{"LongPointer"})).put(new Info(new String[]{"torch::ExpandingArray<1>", "torch::ExpandingArray<2>", "torch::ExpandingArray<3>", "torch::ExpandingArray<4>", "torch::ExpandingArray<D*2>", "torch::ExpandingArray<1*2>", "torch::ExpandingArray<2*2>", "torch::ExpandingArray<3*2>"}).cast().pointerTypes(new String[]{"LongPointer"})).put(new Info(new String[]{"torch::ExpandingArray<1,double>", "torch::ExpandingArray<2,double>", "torch::ExpandingArray<3,double>"}).cast().pointerTypes(new String[]{"DoublePointer"})).put(new Info(new String[]{"torch::ExpandingArrayWithOptionalElem<2>", "torch::ExpandingArrayWithOptionalElem<3>"}).cast().pointerTypes(new String[]{"LongOptional"})).put(new Info(new String[]{"std::pair<std::string,c10::IValue>"}).pointerTypes(new String[]{"EnumNameValue"}).define()).put(new Info(new String[]{"c10::ClassType::Property"}).pointerTypes(new String[]{"ClassType.Property"})).put(new Info(new String[]{"std::list<std::pair<at::RecordFunctionHandle,int> >"}).pointerTypes(new String[]{"RecordFunctionHandleIntList"}).define()).put(new Info(new String[]{"at::RecordFunctionHandle"}).valueTypes(new String[]{"long"})).put(new Info(new String[]{"c10::ivalue::Future::FutureError::FutureError"}).skip()).put(new Info(new String[]{"operator const std::string&()"}).javaText("public native @Const @ByRef @Name(\"operator const std::string&\") @StdString @Override String toString();")).put(new Info(new String[]{"c10::weak_intrusive_ptr<c10::StorageImpl>"}).pointerTypes(new String[]{"WeakStorage"})).put(new Info(new String[]{"torch::monitor::Stat<double>"}).pointerTypes(new String[]{"DoubleStat"})).put(new Info(new String[]{"torch::monitor::Stat<int64_t>"}).pointerTypes(new String[]{"LongStat"})).put(new Info(new String[]{"torch::jit::generic_graph_node_list<torch::jit::Node>"}).pointerTypes(new String[]{"graph_node_list"})).put(new Info(new String[]{"torch::jit::generic_graph_node_list_iterator<torch::jit::Node>"}).pointerTypes(new String[]{"graph_node_list_iterator"})).put(new Info(new String[]{"torch::autograd::Function<torch::nn::CrossMapLRN2d>"}).pointerTypes(new String[]{"FunctionCrossMapLRN2d"})).put(new Info(new String[]{"strong::type<int64_t,_VulkanID,strong::regular,strong::convertible_to<int64_t>,strong::hashable>"}).pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"c10::VaryingShape<int64_t>"}).pointerTypes(new String[]{"LongVaryingShape"})).put(new Info(new String[]{"c10::VaryingShape<c10::Stride>"}).pointerTypes(new String[]{"StrideVaryingShape"})).put(new Info(new String[]{"torch::detail::SelectiveStr<false>"}).pointerTypes(new String[]{"DisabledStr"})).put(new Info(new String[]{"torch::detail::SelectiveStr<true>"}).pointerTypes(new String[]{"EnabledStr"})).put(new Info(new String[]{"torch::detail::SelectiveStr<false>::operator const char*", "torch::detail::SelectiveStr<true>::operator const char*"}).javaText("public native @Name(\"operator const char*\") @Cast(\"const char*\") BytePointer asBytePointer();")).put(new Info(new String[]{"fbgemm::bfloat16", "__nv_bfloat16", "sycl::ext::oneapi::bfloat16"}).pointerTypes(new String[]{"BFloat16"}).valueTypes(new String[]{"short", "short", "short"})).put(new Info(new String[]{"decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::Bool>::t)"}).cast().valueTypes(new String[]{"boolean"}).pointerTypes(new String[]{"BoolPointer"})).put(new Info(new String[]{"decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::Half>::t)"}).pointerTypes(new String[]{"Half"})).put(new Info(new String[]{"decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::BFloat16>::t)"}).pointerTypes(new String[]{"BFloat16"})).put(new Info(new String[]{"decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::Float8_e5m2>::t)"}).pointerTypes(new String[]{"Float8_e5m2"})).put(new Info(new String[]{"decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::Float8_e4m3fn>::t)"}).pointerTypes(new String[]{"Float8_e4m3fn"})).put(new Info(new String[]{"c10::DataPtr", "at::DataPtr"}).valueTypes(new String[]{"@Cast({\"\", \"c10::DataPtr&&\"}) @StdMove DataPtr"}).pointerTypes(new String[]{"DataPtr"})).put(new Info(new String[]{"c10::Storage", "at::Storage"}).valueTypes(new String[]{"@Cast({\"\", \"c10::Storage&&\"}) @StdMove Storage"}).pointerTypes(new String[]{"Storage"})).put(new Info(new String[]{"c10::ClassType"}).purify().pointerTypes(new String[]{"ClassType"})).put(new Info(new String[]{"c10::EnumType"}).purify().pointerTypes(new String[]{"EnumType"})).put(new Info(new String[]{"c10::NamedType"}).purify().pointerTypes(new String[]{"NamedType"})).put(new Info(new String[]{"c10::MaybeOwned<at::Tensor>"}).valueTypes(new String[]{"@Cast({\"\", \"c10::MaybeOwned<at::Tensor>&&\"}) @StdMove TensorMaybeOwned"}).pointerTypes(new String[]{"TensorMaybeOwned"})).put(new Info(new String[]{"c10::MaybeOwned<at::TensorBase>"}).valueTypes(new String[]{"@Cast({\"\", \"c10::MaybeOwned<at::TensorBase>&&\"}) @StdMove TensorBaseMaybeOwned"}).pointerTypes(new String[]{"TensorBaseMaybeOwned"})).put(new Info(new String[]{"at::InferExpandGeometryResult<at::DimVector>"}).pointerTypes(new String[]{"DimVectorInferExpandGeometryResult"})).put(new Info(new String[]{"at::namedinference::TensorName"}).valueTypes(new String[]{"@Cast({\"\", \"at::namedinference::TensorName&&\"}) @StdMove TensorName"}).pointerTypes(new String[]{"TensorName"})).put(new Info(new String[]{"c10::remove_symint<c10::SymInt>::type"}).valueTypes(new String[]{"long"})).put(new Info(new String[]{"std::aligned_storage_t<sizeof(IValue),alignof(IValue)>"}).pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"c10::TensorImpl::identity<c10::SymInt>"}).pointerTypes(new String[]{"SymIntIdentity"})).put(new Info(new String[]{"c10::TensorImpl::identity<int64_t>"}).pointerTypes(new String[]{"LongIdentity"})).put(new Info(new String[]{"c10::requires_grad", "at::range", "at::bernoulli_out", "at::normal_out", "at::stft"}).skipDefaults()).put(new Info(new String[]{"c10::prim::requires_grad"}).javaNames(new String[]{"requires_grad"})).put(new Info(new String[]{"c10::aten::clone"}).javaNames(new String[]{"_clone"})).put(new Info(new String[]{"at::TensorBase"}).base("AbstractTensor").pointerTypes(new String[]{"TensorBase"}));
        infoMap.put(new Info(new String[]{"c10::ScalarType", "at::ScalarType", "torch::Dtype"}).enumerate().valueTypes(new String[]{"ScalarType"}).pointerTypes(new String[]{"@Cast(\"c10::ScalarType*\") BytePointer"})).put(new Info(new String[]{"torch::jit::AttributeKind"}).enumerate().valueTypes(new String[]{"JitAttributeKind"})).put(new Info(new String[]{"torch::jit::PickleOpCode"}).enumerate().translate(false).valueTypes(new String[]{"PickleOpCode"}));
        infoMap.put(new Info(new String[]{"c10::optional<bool>"}).pointerTypes(new String[]{"BoolOptional"}).define()).put(new Info(new String[]{"c10::optional<int8_t>", "c10::optional<c10::DeviceIndex>"}).pointerTypes(new String[]{"ByteOptional"}).define()).put(new Info(new String[]{"c10::optional<int>", "c10::optional<int32_t>"}).pointerTypes(new String[]{"IntOptional"}).define()).put(new Info(new String[]{"c10::optional<int64_t>", "c10::remove_symint<c10::optional<c10::SymInt> >::type"}).pointerTypes(new String[]{"LongOptional"}).define()).put(new Info(new String[]{"c10::optional<float>"}).pointerTypes(new String[]{"FloatOptional"}).define()).put(new Info(new String[]{"c10::optional<double>"}).pointerTypes(new String[]{"DoubleOptional"}).define()).put(new Info(new String[]{"c10::optional<size_t>"}).pointerTypes(new String[]{"SizeTOptional"}).define()).put(new Info(new String[]{"c10::optional<std::string>"}).pointerTypes(new String[]{"StringOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<bool> >"}).pointerTypes(new String[]{"BoolVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<int64_t> >"}).pointerTypes(new String[]{"LongVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<double> >"}).pointerTypes(new String[]{"DoubleVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<size_t> >"}).pointerTypes(new String[]{"SizeTVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<std::string> >"}).pointerTypes(new String[]{"StringVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<c10::Stride> >"}).pointerTypes(new String[]{"StrideVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<c10::ShapeSymbol> >"}).pointerTypes(new String[]{"ShapeSymbolVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<torch::Tensor> >"}).pointerTypes(new String[]{"TensorVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::Device>", "c10::optional<at::Device>", "c10::optional<torch::Device>"}).pointerTypes(new String[]{"DeviceOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::ArrayRef<int64_t> >", "c10::optional<c10::IntArrayRef>", "c10::optional<at::IntArrayRef>", "c10::OptionalArrayRef<int64_t>", "c10::OptionalIntArrayRef", "at::OptionalIntArrayRef", "c10::remove_symint<at::OptionalSymIntArrayRef>::type"}).pointerTypes(new String[]{"LongArrayRefOptional", "@Cast({\"int64_t*\", \"c10::ArrayRef<int64_t>\", \"std::vector<int64_t>&\"}) @StdVector long..."}).define()).put(new Info(new String[]{"c10::optional<c10::ArrayRef<int64_t> >::swap"}).skip()).put(new Info(new String[]{"c10::optional<c10::ArrayRef<double> >", "c10::optional<at::ArrayRef<double> >", "c10::OptionalArrayRef<double>"}).pointerTypes(new String[]{"DoubleArrayRefOptional", "@Cast({\"double*\", \"c10::ArrayRef<double>\", \"std::vector<double>&\"}) @StdVector double..."}).define()).put(new Info(new String[]{"c10::optional<c10::ArrayRef<c10::SymInt> >", "c10::optional<at::ArrayRef<c10::SymInt> >", "c10::OptionalArrayRef<c10::SymInt>", "c10::OptionalSymIntArrayRef", "at::OptionalSymIntArrayRef", "c10::optional<c10::SymIntArrayRef>"}).pointerTypes(new String[]{"SymIntArrayRefOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::Layout>", "c10::optional<at::Layout>"}).pointerTypes(new String[]{"LayoutOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::MemoryFormat>", "c10::optional<at::MemoryFormat>"}).pointerTypes(new String[]{"MemoryFormatOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::Scalar>", "c10::optional<at::Scalar>"}).pointerTypes(new String[]{"ScalarOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::ScalarType>", "c10::optional<at::ScalarType>", "c10::optional<torch::Dtype>"}).pointerTypes(new String[]{"ScalarTypeOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::AliasInfo>"}).pointerTypes(new String[]{"AliasInfoOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::IValue>"}).pointerTypes(new String[]{"IValueOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::impl::CppSignature>"}).pointerTypes(new String[]{"CppSignatureOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::DispatchKey>"}).pointerTypes(new String[]{"DispatchKeyOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::OperatorHandle>"}).pointerTypes(new String[]{"OperatorHandleOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::OperatorName>"}).pointerTypes(new String[]{"OperatorNameOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::QualifiedName>"}).pointerTypes(new String[]{"QualifiedNameOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::Stream>"}).pointerTypes(new String[]{"StreamOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::Stride>"}).pointerTypes(new String[]{"StrideOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::TypePtr>"}).pointerTypes(new String[]{"TypePtrOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::ClassType::Property>"}).pointerTypes(new String[]{"ClassTypePropertyOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::AliasTypeSet>"}).pointerTypes(new String[]{"AliasTypeSetOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::FunctionSchema>"}).pointerTypes(new String[]{"FunctionSchemaOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::SymDimVector>", "c10::optional<at::SymDimVector>"}).pointerTypes(new String[]{"SymDimVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<c10::SymInt>"}).pointerTypes(new String[]{"SymIntOptional"}).define()).put(new Info(new String[]{"c10::optional<at::IValue>"}).pointerTypes(new String[]{"IValueOptional"}).define()).put(new Info(new String[]{"c10::optional<at::DimVector>"}).pointerTypes(new String[]{"DimVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<at::Dimname>"}).pointerTypes(new String[]{"DimnameOptional"}).define()).put(new Info(new String[]{"c10::optional<at::DimnameList>"}).pointerTypes(new String[]{"DimnameListOptional"}).define()).put(new Info(new String[]{"c10::optional<at::Generator>"}).pointerTypes(new String[]{"GeneratorOptional"}).define()).put(new Info(new String[]{"c10::optional<at::Tensor>", "c10::optional<torch::Tensor>", "c10::optional<at::Tensor>", "c10::optional<torch::TensorBase>", "c10::optional<torch::autograd::Variable>"}).pointerTypes(new String[]{"TensorOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::TensorList>", "c10::optional<at::TensorList>"}).pointerTypes(new String[]{"TensorArrayRefOptional"}).define()).put(new Info(new String[]{"c10::optional<caffe2::TypeMeta>"}).pointerTypes(new String[]{"TypeMetaOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::ExecutorExecutionMode>"}).pointerTypes(new String[]{"ExecutorExecutionModeOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::ExecutorExecutionMode>::operator ->"}).skip()).put(new Info(new String[]{"c10::optional<torch::jit::InlinedCallStack>", "c10::optional<torch::jit::InlinedCallStackPtr>"}).cast().pointerTypes(new String[]{"InlinedCallStackOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::Scope>", "c10::optional<torch::jit::ScopePtr>"}).cast().pointerTypes(new String[]{"ScopeOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::ModuleInstanceInfo>"}).pointerTypes(new String[]{"ModuleInstanceInfoOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::SourceRange>"}).pointerTypes(new String[]{"SourceRangeOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::Method>"}).pointerTypes(new String[]{"MethodOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::NamedValue>", "c10::optional<NamedValue>"}).pointerTypes(new String[]{"NamedValueOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::jit::Value*>"}).pointerTypes(new String[]{"ValueOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::ExpandingArray<1> >", "c10::optional<torch::ExpandingArray<2> >", "c10::optional<torch::ExpandingArray<3> >"}).cast().pointerTypes(new String[]{"LongExpandingArrayOptional"}).define()).put(new Info(new String[]{"c10::optional<torch::ExpandingArray<1,double> >", "c10::optional<torch::ExpandingArray<2,double> >", "c10::optional<torch::ExpandingArray<3,double> >", "c10::optional<torch::nn::FractionalMaxPoolOptions<1>::ExpandingArrayDouble>", "c10::optional<torch::nn::FractionalMaxPoolOptions<2>::ExpandingArrayDouble>", "c10::optional<torch::nn::FractionalMaxPoolOptions<3>::ExpandingArrayDouble>"}).cast().pointerTypes(new String[]{"DoubleExpandingArrayOptional"}).define()).put(new Info(new String[]{"c10::optional<std::tuple<std::string,size_t,size_t> >"}).pointerTypes(new String[]{"T_StringSizeTSizeT_TOptional"}).define()).put(new Info(new String[]{"torch::optional<std::tuple<torch::Tensor,torch::Tensor> >"}).pointerTypes(new String[]{"T_TensorTensor_TOptional"}).define()).put(new Info(new String[]{"c10::optional<std::tuple<c10::TypePtr,int32_t> >", "c10::optional<std::pair<c10::TypePtr,int32_t> >"}).pointerTypes(new String[]{"T_TypePtrLong_TOptional"}).cast().define()).put(new Info(new String[]{"c10::optional<c10::string_view>"}).pointerTypes(new String[]{"StringViewOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<c10::string_view> >"}).pointerTypes(new String[]{"StringViewVectorOptional"}).define()).put(new Info(new String[]{"c10::optional<std::pair<void*,void*> >", "c10::optional<std::pair<torch::jit::BackendMetaPtr,torch::jit::BackendMetaPtr> >"}).pointerTypes(new String[]{"PointerPairOptional"}).define()).put(new Info(new String[]{"c10::optional<std::vector<c10::weak_intrusive_ptr<c10::StorageImpl> > >", "c10::optional<std::vector<c10::ivalue::Future::WeakStorage> >"}).pointerTypes(new String[]{"WeakStorageVectorOptional"}).define());
        infoMap.put(new Info(new String[]{"c10::Type::SingletonOrSharedTypePtr<c10::Type>", "c10::TypePtr", "c10::Type::TypePtr", "at::TypePtr", "torch::jit::TypeAttr::ConstructorType", "torch::jit::TypeAttr::ValueType"}).pointerTypes(new String[]{"Type.TypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::Type>"}).pointerTypes(new String[]{"SingletonTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::AnyType>"}).pointerTypes(new String[]{"AnyTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::AnyEnumType>"}).pointerTypes(new String[]{"AnyEnumTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::NumberType>"}).pointerTypes(new String[]{"NumberTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::FloatType>"}).pointerTypes(new String[]{"FloatTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::ComplexType>"}).pointerTypes(new String[]{"ComplexTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::IntType>"}).pointerTypes(new String[]{"IntTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::BoolType>"}).pointerTypes(new String[]{"BoolTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::StringType>"}).pointerTypes(new String[]{"StringTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::StorageType>"}).pointerTypes(new String[]{"StorageTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::NoneType>"}).pointerTypes(new String[]{"NoneTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::GeneratorType>"}).pointerTypes(new String[]{"GeneratorTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::QuantizerType>"}).pointerTypes(new String[]{"QuantizerTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::QSchemeType>"}).pointerTypes(new String[]{"QSchemeTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::DeviceObjType>"}).pointerTypes(new String[]{"DeviceObjTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::StreamObjType>"}).pointerTypes(new String[]{"StreamObjTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::CapsuleType>"}).pointerTypes(new String[]{"CapsuleTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::PyObjectType>"}).pointerTypes(new String[]{"PyObjectTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::LayoutType>"}).pointerTypes(new String[]{"LayoutTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::ScalarTypeType>"}).pointerTypes(new String[]{"ScalarTypeTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::AnyListType>"}).pointerTypes(new String[]{"AnyListTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::AnyTupleType>"}).pointerTypes(new String[]{"AnyTupleTypePtr"})).put(new Info(new String[]{"c10::SingletonTypePtr<c10::AnyClassType>"}).pointerTypes(new String[]{"AnyClassTypePtr"}));
        infoMap.put(new Info(new String[]{"c10::variant<torch::enumtype::kLinear,torch::enumtype::kConv1D,torch::enumtype::kConv2D,torch::enumtype::kConv3D,torch::enumtype::kConvTranspose1D,torch::enumtype::kConvTranspose2D,torch::enumtype::kConvTranspose3D,torch::enumtype::kSigmoid,torch::enumtype::kTanh,torch::enumtype::kReLU,torch::enumtype::kLeakyReLU>", "torch::nn::init::NonlinearityType"}).pointerTypes(new String[]{"Nonlinearity"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kFanIn,torch::enumtype::kFanOut>", "torch::nn::init::FanModeType"}).pointerTypes(new String[]{"FanModeType"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kZeros,torch::enumtype::kReflect,torch::enumtype::kReplicate,torch::enumtype::kCircular>", "torch::nn::ConvOptions<1>::padding_mode_t", "torch::nn::ConvOptions<2>::padding_mode_t", "torch::nn::ConvOptions<3>::padding_mode_t", "torch::nn::ConvTransposeOptions<1>::padding_mode_t", "torch::nn::ConvTransposeOptions<2>::padding_mode_t", "torch::nn::ConvTransposeOptions<3>::padding_mode_t", "torch::nn::detail::conv_padding_mode_t"}).pointerTypes(new String[]{"ConvPaddingMode"}).define()).put(new Info(new String[]{"c10::variant<torch::ExpandingArray<1>,torch::enumtype::kValid,torch::enumtype::kSame>", "torch::nn::ConvOptions<1>::padding_t", "torch::nn::detail::ConvNdOptions<1>::padding_t", "torch::nn::functional::ConvFuncOptions<1>::padding_t", "torch::nn::functional::Conv1dFuncOptions::padding_t"}).purify().pointerTypes(new String[]{"Conv1dPadding"}).define()).put(new Info(new String[]{"c10::variant<torch::ExpandingArray<2>,torch::enumtype::kValid,torch::enumtype::kSame>", "torch::nn::ConvOptions<2>::padding_t", "torch::nn::detail::ConvNdOptions<2>::padding_t", "torch::nn::functional::ConvFuncOptions<2>::padding_t", "torch::nn::functional::Conv2dFuncOptions::padding_t"}).purify().pointerTypes(new String[]{"Conv2dPadding"}).define()).put(new Info(new String[]{"c10::variant<torch::ExpandingArray<3>,torch::enumtype::kValid,torch::enumtype::kSame>", "torch::nn::ConvOptions<3>::padding_t", "torch::nn::detail::ConvNdOptions<3>::padding_t", "torch::nn::functional::ConvFuncOptions<3>::padding_t", "torch::nn::functional::Conv3dFuncOptions::padding_t"}).purify().pointerTypes(new String[]{"Conv3dPadding"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kSum,torch::enumtype::kMean,torch::enumtype::kMax>", "torch::nn::EmbeddingBagMode"}).pointerTypes(new String[]{"EmbeddingBagMode"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kConstant,torch::enumtype::kReflect,torch::enumtype::kReplicate,torch::enumtype::kCircular>", "torch::nn::functional::PadFuncOptions::mode_t"}).pointerTypes(new String[]{"PaddingMode"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kNone,torch::enumtype::kMean,torch::enumtype::kSum>", "torch::nn::L1LossOptions::reduction_t", "torch::nn::functional::L1LossFuncOptions::reduction_t", "torch::nn::MSELossOptions::reduction_t", "torch::nn::functional::MSELossFuncOptions::reduction_t", "torch::nn::BCELossOptions::reduction_t", "torch::nn::functional::BinaryCrossEntropyFuncOptions::reduction_t", "torch::nn::HingeEmbeddingLossOptions::reduction_t", "torch::nn::functional::HingeEmbeddingLossFuncOptions::reduction_t", "torch::nn::MultiMarginLossOptions::reduction_t", "torch::nn::functional::MultiMarginLossFuncOptions::reduction_t", "torch::nn::CosineEmbeddingLossOptions::reduction_t", "torch::nn::functional::CosineEmbeddingLossFuncOptions::reduction_t", "torch::nn::MultiLabelMarginLossOptions::reduction_t", "torch::nn::functional::MultilabelMarginLossFuncOptions::reduction_t", "torch::nn::SoftMarginLossOptions::reduction_t", "torch::nn::functional::SoftMarginLossFuncOptions::reduction_t", "torch::nn::MultiLabelSoftMarginLossOptions::reduction_t", "torch::nn::functional::MultilabelSoftMarginLossFuncOptions::reduction_t", "torch::nn::TripletMarginLossOptions::reduction_t", "torch::nn::functional::TripletMarginLossFuncOptions::reduction_t", "torch::nn::TripletMarginWithDistanceLossOptions::reduction_t", "torch::nn::functional::TripletMarginWithDistanceLossFuncOptions::reduction_t", "torch::nn::CTCLossOptions::reduction_t", "torch::nn::functional::CTCLossFuncOptions::reduction_t", "torch::nn::SmoothL1LossOptions::reduction_t", "torch::nn::functional::SmoothL1LossFuncOptions::reduction_t", "torch::nn::HuberLossOptions::reduction_t", "torch::nn::functional::HuberLossFuncOptions::reduction_t", "torch::nn::PoissonNLLLossOptions::reduction_t", "torch::nn::functional::PoissonNLLLossFuncOptions::reduction_t", "torch::nn::MarginRankingLossOptions::reduction_t", "torch::nn::functional::MarginRankingLossFuncOptions::reduction_t", "torch::nn::NLLLossOptions::reduction_t", "torch::nn::functional::NLLLossFuncOptions::reduction_t", "torch::nn::CrossEntropyLossOptions::reduction_t", "torch::nn::functional::CrossEntropyFuncOptions::reduction_t", "torch::nn::BCEWithLogitsLossOptions::reduction_t", "torch::nn::functional::BinaryCrossEntropyWithLogitsFuncOptions::reduction_t"}).pointerTypes(new String[]{"LossReduction"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kNone,torch::enumtype::kBatchMean,torch::enumtype::kSum,torch::enumtype::kMean>", "torch::nn::KLDivLossOptions::reduction_t", "torch::nn::functional::KLDivFuncOptions::reduction_t"}).pointerTypes(new String[]{"KLDivLossReduction"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kBilinear,torch::enumtype::kNearest>", "torch::nn::functional::GridSampleFuncOptions::mode_t"}).pointerTypes(new String[]{"GridSampleMode"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kZeros,torch::enumtype::kBorder,torch::enumtype::kReflection>", "torch::nn::functional::GridSampleFuncOptions::padding_mode_t"}).pointerTypes(new String[]{"GridSamplePaddingMode"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kLSTM,torch::enumtype::kGRU,torch::enumtype::kRNN_TANH,torch::enumtype::kRNN_RELU>", "torch::nn::detail::RNNOptionsBase::rnn_options_base_mode_t"}).pointerTypes(new String[]{"RNNBaseMode"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kTanh,torch::enumtype::kReLU>", "torch::nn::RNNOptions::nonlinearity_t", "torch::nn::RNNCellOptions::nonlinearity_t"}).pointerTypes(new String[]{"RNNNonlinearity"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kNearest,torch::enumtype::kLinear,torch::enumtype::kBilinear,torch::enumtype::kBicubic,torch::enumtype::kTrilinear>", "torch::nn::UpsampleOptions::mode_t"}).pointerTypes(new String[]{"UpsampleMode"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kNearest,torch::enumtype::kLinear,torch::enumtype::kBilinear,torch::enumtype::kBicubic,torch::enumtype::kTrilinear,torch::enumtype::kArea,torch::enumtype::kNearestExact>", "torch::nn::functional::InterpolateFuncOptions::mode_t"}).pointerTypes(new String[]{"InterpolateMode"}).define()).put(new Info(new String[]{"c10::variant<torch::enumtype::kReLU,torch::enumtype::kGELU,std::function<torch::Tensor(const torch::Tensor&)> >", "torch::nn::activation_t", "torch::nn::TransformerOptions::activation_t"}).pointerTypes(new String[]{"TransformerActivation"}));
        infoMap.put(new Info(new String[]{"std::array<bool,2>", "std::array<bool,3>", "std::array<bool,4>"}).cast().pointerTypes(new String[]{"BoolPointer"})).put(new Info(new String[]{"std::array<c10::detail::infer_schema::ArgumentDef,0>"}).cast().pointerTypes(new String[]{"ArgumentDef"})).put(new Info(new String[]{"std::array<const char*,2>"}).pointerTypes(new String[]{"PointerPointer<BytePointer>"})).put(new Info(new String[]{"std::array<c10::FunctionalityOffsetAndMask,c10::num_functionality_keys>"}).cast().pointerTypes(new String[]{"FunctionalityOffsetAndMask"})).put(new Info(new String[]{"std::array<uint32_t,at::MERSENNE_STATE_N>"}).pointerTypes(new String[]{"IntPointer"}).cast()).put(new Info(new String[]{"std::array<c10::optional<std::pair<torch::jit::BackendMetaPtr,torch::jit::BackendMetaPtr> >,at::COMPILE_TIME_MAX_DEVICE_TYPES>"}).pointerTypes(new String[]{"PointerPairOptional"}).cast());
        infoMap.put(new Info(new String[]{"std::vector<bool>"}).pointerTypes(new String[]{"BoolVector"}).define()).put(new Info(new String[]{"std::vector<const char*>"}).pointerTypes(new String[]{"BytePointerVector"}).define()).put(new Info(new String[]{"std::vector<int64_t>", "std::tuple<std::vector<int64_t>,std::vector<int64_t> >"}).cast().pointerTypes(new String[]{"LongVector"}).define()).put(new Info(new String[]{"std::vector<double>"}).cast().pointerTypes(new String[]{"DoubleVector"}).define()).put(new Info(new String[]{"std::vector<size_t>"}).cast().pointerTypes(new String[]{"SizeTVector"}).define()).put(new Info(new String[]{"std::vector<std::string>"}).pointerTypes(new String[]{"StringVector"}).define()).put(new Info(new String[]{"std::vector<c10::string_view>"}).pointerTypes(new String[]{"StringViewVector"}).define()).put(new Info(new String[]{"std::vector<std::pair<std::string,int64_t> >"}).pointerTypes(new String[]{"StringLongVector"}).define()).put(new Info(new String[]{"std::vector<c10::IValue>", "torch::jit::Stack"}).pointerTypes(new String[]{"IValueVector"}).define()).put(new Info(new String[]{"std::vector<c10::IValue>::const_iterator", "torch::jit::Stack::const_iterator"}).pointerTypes(new String[]{"IValueVector.Iterator"})).put(new Info(new String[]{"std::vector<c10::QEngine>", "std::vector<at::QEngine>"}).pointerTypes(new String[]{"QEngineVector"}).define()).put(new Info(new String[]{"std::vector<c10::ScalarType>"}).pointerTypes(new String[]{"ScalarTypeVector"}).define()).put(new Info(new String[]{"std::vector<c10::Symbol>"}).pointerTypes(new String[]{"SymbolVector"}).define()).put(new Info(new String[]{"std::vector<c10::optional<int64_t> >"}).pointerTypes(new String[]{"LongOptionalVector"}).define()).put(new Info(new String[]{"std::vector<c10::optional<at::IValue> >"}).pointerTypes(new String[]{"IValueOptionalVector"}).define()).put(new Info(new String[]{"std::vector<std::shared_ptr<c10::ClassType> >", "std::vector<c10::ClassTypePtr>"}).pointerTypes(new String[]{"SharedClassTypeVector"}).define()).put(new Info(new String[]{"std::vector<c10::Type::SingletonOrSharedTypePtr<c10::Type> >", "std::vector<c10::TypePtr>", "std::vector<c10::Type::TypePtr>", "c10::AliasTypeSet"}).pointerTypes(new String[]{"TypeVector"}).define()).put(new Info(new String[]{"const std::vector<at::Dimname>", "std::vector<at::Dimname>"}).valueTypes(new String[]{"@StdMove DimnameVector"}).pointerTypes(new String[]{"DimnameVector"}).define()).put(new Info(new String[]{"std::vector<c10::Stride>"}).pointerTypes(new String[]{"StrideVector"}).define()).put(new Info(new String[]{"std::vector<c10::ShapeSymbol>"}).pointerTypes(new String[]{"ShapeSymbolVector"}).define()).put(new Info(new String[]{"std::vector<c10::TensorImpl*>"}).pointerTypes(new String[]{"TensorImplVector"}).define()).put(new Info(new String[]{"std::vector<torch::autograd::Edge>", "torch::autograd::edge_list"}).valueTypes(new String[]{"@Cast({\"\", \"std::vector<torch::autograd::Edge>\"}) @StdMove EdgeVector"}).pointerTypes(new String[]{"EdgeVector"}).define()).put(new Info(new String[]{"std::vector<torch::Tensor>", "std::vector<at::Tensor>", "std::vector<torch::autograd::Variable>", "torch::autograd::variable_list"}).valueTypes(new String[]{"@Cast({\"\", \"std::vector<torch::Tensor>\"}) @StdMove TensorVector"}).pointerTypes(new String[]{"TensorVector"}).define()).put(new Info(new String[]{"std::vector<at::indexing::TensorIndex>", "std::vector<at::indexing::TensorIndex,A>"}).pointerTypes(new String[]{"TensorIndexVector"}).define()).put(new Info(new String[]{"std::vector<c10::optional<torch::autograd::Variable> >"}).pointerTypes(new String[]{"TensorOptionalVector"}).define()).put(new Info(new String[]{"const std::vector<std::unique_ptr<torch::autograd::FunctionPreHook> >", "std::vector<std::unique_ptr<torch::autograd::FunctionPreHook> >"}).pointerTypes(new String[]{"FunctionPreHookVector"}).define()).put(new Info(new String[]{"const std::vector<std::unique_ptr<torch::autograd::FunctionPostHook> >", "std::vector<std::unique_ptr<torch::autograd::FunctionPostHook> >"}).pointerTypes(new String[]{"FunctionPostHookVector"}).define()).put(new Info(new String[]{"const std::vector<torch::jit::Def>", "std::vector<torch::jit::Def>"}).pointerTypes(new String[]{"DefVector"}).define()).put(new Info(new String[]{"const std::vector<torch::jit::Property>", "std::vector<torch::jit::Property>"}).pointerTypes(new String[]{"PropertyVector"}).define()).put(new Info(new String[]{"const std::vector<torch::optim::OptimizerParamGroup>", "std::vector<torch::optim::OptimizerParamGroup>"}).pointerTypes(new String[]{"OptimizerParamGroupVector"}).define()).put(new Info(new String[]{"std::vector<torch::jit::Function*>"}).pointerTypes(new String[]{"FunctionVector"}).define()).put(new Info(new String[]{"std::vector<std::shared_ptr<torch::jit::Graph> >"}).pointerTypes(new String[]{"GraphVector"}).define()).put(new Info(new String[]{"std::vector<std::shared_ptr<torch::jit::Operator> >"}).pointerTypes(new String[]{"OperatorVector"}).define()).put(new Info(new String[]{"std::vector<std::shared_ptr<torch::jit::Resolver> >", "std::vector<torch::jit::ResolverPtr>"}).pointerTypes(new String[]{"ResolverVector"}).define()).put(new Info(new String[]{"std::vector<torch::jit::Value*>", "std::vector<Value*>"}).pointerTypes(new String[]{"ValueVector"}).define()).put(new Info(new String[]{"std::vector<const torch::jit::Node*>"}).pointerTypes(new String[]{"JitNodeVector"}).define()).put(new Info(new String[]{"std::vector<torch::nn::Module>::iterator"}).pointerTypes(new String[]{"ModuleVector.Iterator"})).put(new Info(new String[]{"std::vector<torch::nn::AnyModule>"}).pointerTypes(new String[]{"AnyModuleVector"}).define()).put(new Info(new String[]{"std::vector<torch::nn::AnyModule>::iterator"}).pointerTypes(new String[]{"AnyModuleVector.Iterator"})).put(new Info(new String[]{"std::vector<std::shared_ptr<torch::nn::Module> >"}).pointerTypes(new String[]{"SharedModuleVector"}).define()).put(new Info(new String[]{"std::vector<std::shared_ptr<torch::nn::Module> >::iterator"}).pointerTypes(new String[]{"SharedModuleVector.Iterator"})).put(new Info(new String[]{"std::vector<std::pair<std::string,torch::Tensor> >"}).pointerTypes(new String[]{"StringTensorVector"}).define()).put(new Info(new String[]{"std::vector<std::pair<std::string,torch::nn::AnyModule> >"}).pointerTypes(new String[]{"StringAnyModuleVector"}).define()).put(new Info(new String[]{"std::vector<std::pair<std::string,std::shared_ptr<torch::nn::Module> > >"}).pointerTypes(new String[]{"StringSharedModuleVector"}).define()).put(new Info(new String[]{"std::vector<std::pair<torch::jit::FusionBehavior,size_t> >", "torch::jit::FusionStrategy"}).pointerTypes(new String[]{"FusionStrategy"}).define()).put(new Info(new String[]{"std::vector<c10::SymInt>"}).pointerTypes(new String[]{"SymIntVector"}).define()).put(new Info(new String[]{"std::vector<std::shared_ptr<torch::jit::SugaredValue> >"}).pointerTypes(new String[]{"SharedSugaredValueVector"}).define()).put(new Info(new String[]{"const std::vector<const c10::FunctionSchema*>"}).pointerTypes(new String[]{"FunctionSchemaVector"}).define()).put(new Info(new String[]{"const std::vector<at::DataPtr>", "std::vector<at::DataPtr>"}).pointerTypes(new String[]{"DataPtrVector"}).define()).put(new Info(new String[]{"const std::vector<c10::weak_intrusive_ptr<c10::StorageImpl> >", "std::vector<c10::weak_intrusive_ptr<c10::StorageImpl> >"}).pointerTypes(new String[]{"WeakStorageVector"}).define());
        for (ArrayInfo arrayInfo : new ArrayInfo[]{new ArrayInfo("Argument").elementTypes("c10::Argument"), new ArrayInfo("ArgumentDef").elementTypes("c10::detail::infer_schema::ArgumentDef"), new ArrayInfo("BFloat16").elementTypes("decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::BFloat16>::t)"), new ArrayInfo("Block").elementTypes("torch::jit::Block*").itPointerType("PointerPointer<Block>"), new ArrayInfo("Bool").itPointerType("BoolPointer").elementTypes("bool", "decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::Bool>::t)").elementValueType("boolean"), new ArrayInfo("Byte").itPointerType("BytePointer").elementTypes("jbyte", "int8_t", "uint8_t").elementValueType("byte"), new ArrayInfo("Dimname").otherCppNames("at::DimnameList").elementTypes("at::Dimname").otherPointerTypes("DimnameVector"), new ArrayInfo("Double").itPointerType("DoublePointer").elementTypes("double"), new ArrayInfo("DoubleComplex").elementTypes("c10::complex<double>"), new ArrayInfo("EnumNameValue").elementTypes("c10::EnumNameValue"), new ArrayInfo("Float").itPointerType("FloatPointer").elementTypes("float").elementValueType("float"), new ArrayInfo("FloatComplex").elementTypes("c10::complex<float>"), new ArrayInfo("FuturePtr").elementTypes("c10::intrusive_ptr<c10::ivalue::Future>"), new ArrayInfo("Half").elementTypes("decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::Half>::t)"), new ArrayInfo("IValue").elementTypes("c10::IValue", "const at::IValue").otherPointerTypes("IValueVector"), new ArrayInfo("Int").itPointerType("IntPointer").elementTypes("jint", "int", "int32_t", "uint32_t").elementValueType("int"), new ArrayInfo("Tag").itPointerType("BytePointer").elementTypes("at::Tag"), new ArrayInfo("Long").otherCppNames("c10::IntArrayRef", "torch::IntArrayRef", "at::IntArrayRef", "c10::OptionalArray<int64_t>", "c10::remove_symint<c10::SymIntArrayRef>::type").itPointerType("LongPointer").elementTypes("int64_t", "jlong").elementValueType("long"), new ArrayInfo("LongOptional").elementTypes("c10::optional<int64_t>").otherPointerTypes("LongOptionalVector"), new ArrayInfo("NamedValue").elementTypes("torch::jit::NamedValue"), new ArrayInfo("Scalar").elementTypes("at::Scalar"), new ArrayInfo("ScalarType").itPointerType("@Cast(\"c10::ScalarType*\") BytePointer").elementTypes("c10::ScalarType", "at::ScalarType").otherPointerTypes("ScalarTypeVector"), new ArrayInfo("Short").itPointerType("ShortPointer").elementTypes("jshort", "int16_t", "uint16_t").elementValueType("short"), new ArrayInfo("SizeT").itPointerType("SizeTPointer").elementTypes("size_t").elementValueType("long"), new ArrayInfo("Stride").elementTypes("c10::Stride").otherPointerTypes("StrideVector"), new ArrayInfo("String").itPointerType("PointerPointer<BytePointer>").elementTypes("std::string").otherPointerTypes("StringVector"), new ArrayInfo("SymInt").otherCppNames("c10::SymIntArrayRef").elementTypes("c10::SymInt"), new ArrayInfo("SymNode").elementTypes("c10::SymNode", "c10::intrusive_ptr<c10::SymNodeImpl>"), new ArrayInfo("Symbol").elementTypes("c10::Symbol").otherPointerTypes("SymbolVector"), new ArrayInfo("Tensor").otherCppNames("torch::TensorList", "at::TensorList", "at::ITensorListRef").elementTypes("torch::Tensor", "at::Tensor").otherPointerTypes("TensorVector"), new ArrayInfo("TensorArg").elementTypes("torch::TensorArg", "at::TensorArg"), new ArrayInfo("TensorIndex").elementTypes("at::indexing::TensorIndex").otherPointerTypes("TensorIndexVector"), new ArrayInfo("TensorOptional").elementTypes("c10::optional<at::Tensor>", "c10::optional<torch::Tensor>", "c10::optional<torch::autograd::Variable>").otherPointerTypes("TensorOptionalVector"), new ArrayInfo("Type").itPointerType("Type.TypePtr").elementTypes("c10::TypePtr", "c10::Type::TypePtr").otherPointerTypes("TypeVector"), new ArrayInfo("Value").elementTypes("torch::jit::Value*").otherPointerTypes("ValueVector")}) {
            arrayInfo.mapArrayRef(infoMap);
        }
        infoMap.put(new Info(new String[]{"c10::ArrayRef<std::string>::begin()"}).javaText("public native @Const PointerPointer<BytePointer> begin();")).put(new Info(new String[]{"c10::ArrayRef<std::string>::end()"}).javaText("public native @Const PointerPointer<BytePointer> end();")).put(new Info(new String[]{"c10::ArrayRef<std::string>::cbegin()"}).javaText("public native @Const PointerPointer<BytePointer> cbegin();")).put(new Info(new String[]{"c10::ArrayRef<std::string>::cend()"}).javaText("public native @Const PointerPointer<BytePointer> cend();")).put(new Info(new String[]{"c10::ArrayRef<std::string>::data()"}).javaText("public native @Const PointerPointer<BytePointer> data();")).put(new Info(new String[]{"c10::ArrayRef<std::string>(const std::string*, size_t)"}).javaText("public StringArrayRef(PointerPointer<BytePointer> data, long length) { super((Pointer)null); allocate(data, length); }\nprivate native void allocate(@Cast(\"const std::string*\") PointerPointer<BytePointer> data, @Cast(\"size_t\") long length);")).put(new Info(new String[]{"c10::ArrayRef<std::string>(const std::string*, const std::string*)"}).javaText("public StringArrayRef(PointerPointer<BytePointer> begin, PointerPointer<BytePointer> end) { super((Pointer)null); allocate(begin, end); }\nprivate native void allocate(@Cast(\"const std::string*\") PointerPointer<BytePointer> begin, @Cast(\"const std::string*\") PointerPointer<BytePointer> end);"));
        infoMap.put(new Info(new String[]{"c10::ArrayRef<at::Tag>::begin()"}).javaText("public native @Const IntPointer begin();")).put(new Info(new String[]{"c10::ArrayRef<at::Tag>::end()"}).javaText("public native @Const IntPointer end();")).put(new Info(new String[]{"c10::ArrayRef<at::Tag>::cbegin()"}).javaText("public native @Const IntPointer cbegin();")).put(new Info(new String[]{"c10::ArrayRef<at::Tag>::cend()"}).javaText("public native @Const IntPointer cend();")).put(new Info(new String[]{"c10::ArrayRef<at::Tag>::data()"}).javaText("public native @Const IntPointer data();")).put(new Info(new String[]{"c10::ArrayRef<at::Tag>(const at::Tag*, size_t)"}).javaText("public TagArrayRef(IntPointer data, long length) { super((Pointer)null); allocate(data, length); }\nprivate native void allocate(@Cast(\"const at::Tag*\") IntPointer data, @Cast(\"size_t\") long length);")).put(new Info(new String[]{"c10::ArrayRef<at::Tag>(const at::Tag*, const at::Tag*)"}).javaText("public TagArrayRef(IntPointer begin, IntPointer end) { super((Pointer)null); allocate(begin, end); }\nprivate native void allocate(@Cast(\"const at::Tag*\") IntPointer begin, @Cast(\"const at::Tag*\") IntPointer end);")).put(new Info(new String[]{"c10::ArrayRef<at::Tag>::vec()"}).skip());
        for (ArrayInfo arrayInfo : new ArrayInfo[]{new ArrayInfo("DoubleComplex").elementTypes("c10::complex<double>"), new ArrayInfo("Boolean").elementTypes("bool").elementValueType("boolean"), new ArrayInfo("Long").elementTypes("int64_t").elementValueType("long"), new ArrayInfo("Double").elementTypes("double").elementValueType("double"), new ArrayInfo("TensorOptional").elementTypes("c10::optional<at::Tensor>"), new ArrayInfo("Tensor").elementTypes("at::Tensor"), new ArrayInfo("FuturePtr").elementTypes("c10::intrusive_ptr<c10::ivalue::Future>"), new ArrayInfo("Generic").elementTypes("c10::IValue").itPointerType("IValue").elementValueType("@ByVal IValue")}) {
            arrayInfo.mapList(infoMap);
        }
        infoMap.put(new Info(new String[]{"impl::ptr_to_first_element(const c10::List<c10::IValue>&)"}).javaNames(new String[]{"ptr_to_first_element"}).annotations(new String[]{"@Name(\"c10::impl::ptr_to_first_element\")"}).friendly());
        infoMap.put(new Info(new String[]{"torch::autograd::Node"}).pointerTypes(new String[]{"Node"}).purify());
        infoMap.put(new Info(new String[]{"c10::SymInt"}).pointerTypes(new String[]{"SymInt"}));
        for (ArrayInfo arrayInfo : new String[][]{{"SymInt", "SymInt", "@ByVal SymInt", "c10::SymInt", "at::kDimVectorStaticSize", "at::SymDimVector", "SymDimVector"}, {"Long", "LongPointer", "long", "int64_t", "at::kDimVectorStaticSize", "at::DimVector", "DimVector"}}) {
            infoMap.put(new Info(new String[]{torch.template("c10::SmallVectorBase", torch.template("c10::SmallVectorSizeType", new String[]{arrayInfo[3]}))}).pointerTypes(new String[]{"IntSizedSmallVectorBase"})).put(new Info(new String[]{torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]})}).pointerTypes(new String[]{(String)((Object)arrayInfo[0]) + "SmallVectorCommon"})).put(new Info(new String[]{torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]}) + "::size_type", torch.template("c10::SmallVectorImpl", new String[]{arrayInfo[3]}) + "::size_type"}).valueTypes(new String[]{"long"})).put(new Info(new String[]{torch.template("c10::SmallVectorTemplateBase", new String[]{arrayInfo[3]})}).pointerTypes(new String[]{(String)((Object)arrayInfo[0]) + "SmallVectorBase"})).put(new Info(new String[]{torch.template("c10::SmallVectorImpl", new String[]{arrayInfo[3]})}).pointerTypes(new String[]{(String)((Object)arrayInfo[0]) + "SmallVectorImpl"})).put(new Info(new String[]{torch.template("c10::SmallVectorImpl", new String[]{arrayInfo[3]}) + "::iterator", torch.template("c10::SmallVectorImpl", new String[]{arrayInfo[3]}) + "::const_iterator", torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]}) + "::iterator", torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]}) + "::pointer"}).cast().pointerTypes(new String[]{arrayInfo[1]})).put(new Info(new String[]{torch.template("c10::SmallVector", new String[]{arrayInfo[3], arrayInfo[4]}) + "(" + torch.template("c10::SmallVectorImpl", new String[]{arrayInfo[3]}) + "&&)", torch.template("c10::SmallVector", new String[]{arrayInfo[3], arrayInfo[4]}) + "::operator =(" + torch.template("c10::SmallVectorImpl", new String[]{arrayInfo[3]}) + "&&)"}).skip()).put(new Info(new String[]{torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]}) + "::reference", torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]}) + "::const_reference"}).pointerTypes(new String[]{arrayInfo[1]}).valueTypes(new String[]{arrayInfo[2]})).put(new Info(new String[]{torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]}) + "::reverse_iterator", torch.template("c10::SmallVectorTemplateCommon", new String[]{arrayInfo[3]}) + "::const_reverse_iterator"}).skip()).put(new Info(new String[]{torch.template("c10::SmallVectorImpl", new String[]{arrayInfo[3]}) + "::ValueParamT"}).valueTypes(new String[]{arrayInfo[2]}));
            if (arrayInfo[5] == null) {
                infoMap.put(new Info(new String[]{torch.template("c10::SmallVector", new String[]{arrayInfo[3], arrayInfo[4]}), torch.template("at::SmallVector", new String[]{arrayInfo[3], arrayInfo[4]})}).pointerTypes(new String[]{arrayInfo[6]}));
                continue;
            }
            infoMap.put(new Info(new String[]{torch.template("c10::SmallVector", new String[]{arrayInfo[3], arrayInfo[4]}), torch.template("at::SmallVector", new String[]{arrayInfo[3], arrayInfo[4]}), arrayInfo[5]}).pointerTypes(new String[]{arrayInfo[6]}));
        }
        infoMap.put(new Info(new String[]{"std::map<std::string,std::string>"}).pointerTypes(new String[]{"StringStringMap"}).define()).put(new Info(new String[]{"std::map<std::string,int64_t>"}).pointerTypes(new String[]{"StringLongMap"}).define());
        infoMap.put(new Info(new String[]{"std::unordered_set<std::string>"}).pointerTypes(new String[]{"StringSet"}).define()).put(new Info(new String[]{"std::unordered_set<c10::IValue,c10::IValue::HashAliasedIValue,c10::IValue::CompAliasedIValues>"}).pointerTypes(new String[]{"HashAliasedIValues"}).define()).put(new Info(new String[]{"std::unordered_set<c10::Symbol>"}).pointerTypes(new String[]{"SymbolSet"}).define()).put(new Info(new String[]{"std::unordered_set<torch::TensorImpl*>", "std::unordered_set<at::TensorImpl*>"}).pointerTypes(new String[]{"TensorImplSet"}).define()).put(new Info(new String[]{"std::unordered_set<torch::autograd::Node*>"}).pointerTypes(new String[]{"NodeSet"}).define()).put(new Info(new String[]{"std::unordered_set<c10::DeviceType>"}).pointerTypes(new String[]{"DeviceTypeSet"}).define()).put(new Info(new String[]{"std::set<torch::profiler::impl::ActivityType>"}).pointerTypes(new String[]{"ActivityTypeSet"}).define());
        infoMap.put(new Info(new String[]{"std::unordered_map<c10::IValue,c10::IValue,c10::IValue::HashAliasedIValue,c10::IValue::CompAliasedIValues>"}).pointerTypes(new String[]{"HashAliasedIValueMap"}).define()).put(new Info(new String[]{"std::unordered_map<std::string,bool>"}).pointerTypes(new String[]{"StringBoolMap"}).define()).put(new Info(new String[]{"std::unordered_map<std::string,size_t>"}).pointerTypes(new String[]{"StringSizeTMap"}).define()).put(new Info(new String[]{"std::unordered_map<std::string,std::string>"}).pointerTypes(new String[]{"ExtraFilesMap"}).define()).put(new Info(new String[]{"std::unordered_map<std::string,c10::TypePtr>"}).pointerTypes(new String[]{"TypeEnv"}).define()).put(new Info(new String[]{"std::unordered_map<std::string,c10::IValue>", "std::unordered_map<std::string,at::IValue>"}).pointerTypes(new String[]{"StringIValueMap"}).define()).put(new Info(new String[]{"std::unordered_map<std::string,torch::jit::Value*>"}).pointerTypes(new String[]{"StringValueMap"}).define()).put(new Info(new String[]{"std::unordered_map<torch::jit::Value*,torch::jit::Value*>"}).pointerTypes(new String[]{"ValueValueMap"}).define()).put(new Info(new String[]{"std::unordered_map<torch::jit::ArgumentSpec,torch::jit::ExecutionPlan>"}).pointerTypes(new String[]{"ArgumentSpecExecutionPlanMap"}).define()).put(new Info(new String[]{"std::unordered_map<torch::jit::TreeRef,std::string>"}).pointerTypes(new String[]{"TreeRefStringMap"}).define());
        infoMap.put(new Info(new String[]{"std::atomic_bool", "std::atomic<bool>"}).cast().valueTypes(new String[]{"boolean"}).pointerTypes(new String[]{"BoolPointer"})).put(new Info(new String[]{"std::atomic_uint64_t", "std::atomic<uint64_t>", "std::atomic<long unsigned int>", "std::atomic_size_t", "std::atomic<size_t>"}).cast().valueTypes(new String[]{"long"}).pointerTypes(new String[]{"LongPointer"})).put(new Info(new String[]{"std::atomic<const c10::impl::DeviceGuardImplInterface*>"}).cast().pointerTypes(new String[]{"DeviceGuardImplInterface"}));
        infoMap.put(new Info(new String[]{"std::tuple<int,int>"}).pointerTypes(new String[]{"T_IntInt_T"}).define()).put(new Info(new String[]{"std::tuple<int64_t,int64_t>"}).pointerTypes(new String[]{"T_LongLong_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,torch::Tensor>", "std::tuple<at::Tensor,at::Tensor>", "std::tuple<torch::Tensor,torch::Tensor>", "std::tuple<at::Tensor&,at::Tensor&>"}).pointerTypes(new String[]{"T_TensorTensor_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,torch::Tensor,torch::Tensor>", "std::tuple<at::Tensor,at::Tensor,at::Tensor>", "std::tuple<at::Tensor&,at::Tensor&,at::Tensor&>"}).pointerTypes(new String[]{"T_TensorTensorTensor_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,torch::Tensor,torch::Tensor,torch::Tensor>", "std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor>", "std::tuple<at::Tensor&,at::Tensor&,at::Tensor&,at::Tensor&>"}).pointerTypes(new String[]{"T_TensorTensorTensorTensor_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,torch::Tensor,torch::Tensor,torch::Tensor,torch::Tensor>", "std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor>", "std::tuple<at::Tensor&,at::Tensor&,at::Tensor&,at::Tensor&,at::Tensor&>"}).pointerTypes(new String[]{"T_TensorTensorTensorTensorTensor_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,torch::Tensor,torch::Tensor,torch::Tensor,torch::Tensor,torch::Tensor,torch::Tensor>", "std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor>", "std::tuple<at::Tensor&,at::Tensor&,at::Tensor&,at::Tensor&,at::Tensor&,at::Tensor&,at::Tensor&>"}).pointerTypes(new String[]{"T_TensorTensorTensorTensorTensorTensorTensor_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,torch::Tensor,torch::Tensor,std::vector<torch::Tensor> >", "std::tuple<at::Tensor,at::Tensor,at::Tensor,std::vector<at::Tensor> >"}).pointerTypes(new String[]{"T_TensorTensorTensorTensorVector_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,torch::Tensor,double,int64_t>", "std::tuple<at::Tensor,at::Tensor,double,int64_t>"}).pointerTypes(new String[]{"T_TensorTensorDoubleLong_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor> >"}).pointerTypes(new String[]{"T_TensorT_TensorTensor_T_T"}).define()).put(new Info(new String[]{"std::tuple<c10::MaybeOwned<at::Tensor>,c10::MaybeOwned<at::Tensor> >"}).pointerTypes(new String[]{"T_TensorMaybeOwnedTensorMaybeOwned_T"}).define()).put(new Info(new String[]{"std::tuple<c10::MaybeOwned<at::Tensor>,c10::MaybeOwned<at::Tensor>,c10::MaybeOwned<at::Tensor> >"}).pointerTypes(new String[]{"T_TensorMaybeOwnedTensorMaybeOwnedTensorMaybeOwned_T"}).define()).put(new Info(new String[]{"std::tuple<torch::nn::utils::rnn::PackedSequence,torch::Tensor>"}).purify().pointerTypes(new String[]{"T_PackedSequenceTensor_T"}).define()).put(new Info(new String[]{"std::tuple<torch::nn::utils::rnn::PackedSequence,std::tuple<torch::Tensor,torch::Tensor> >"}).purify().pointerTypes(new String[]{"T_PackedSequenceT_TensorTensor_T_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor&,torch::Tensor&>", "std::tuple<torch::Tensor&,torch::Tensor&,torch::Tensor&>", "std::tuple<torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&>", "std::tuple<torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&>", "std::tuple<torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&>", "std::tuple<torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&,torch::Tensor&>"}).cast().pointerTypes(new String[]{"PointerPointer<Tensor>"})).put(new Info(new String[]{"std::tuple<std::string,size_t,size_t>"}).pointerTypes(new String[]{"T_StringSizeTSizeT_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,std::vector<torch::Tensor> >", "std::tuple<at::Tensor,std::vector<at::Tensor> >"}).pointerTypes(new String[]{"T_TensorTensorVector_T"}).define()).put(new Info(new String[]{"std::tuple<torch::Tensor,std::vector<torch::Tensor>,std::vector<torch::Tensor> >", "std::tuple<at::Tensor,std::vector<at::Tensor>,std::vector<at::Tensor> >"}).pointerTypes(new String[]{"T_TensorTensorVectorTensorVector_T"}).define()).put(new Info(new String[]{"const std::tuple<at::DataPtr,size_t>", "std::tuple<at::DataPtr,size_t>"}).pointerTypes(new String[]{"T_DataPtrSizeT_T"}).define()).put(new Info(new String[]{"std::tuple<c10::TypePtr,int32_t>", "std::pair<c10::TypePtr,int32_t>"}).pointerTypes(new String[]{"T_TypePtrLong_T"}).define());
        infoMap.put(new Info(new String[]{"std::type_index"}).pointerTypes(new String[]{"@Cast(\"std::type_index*\") Pointer"})).put(new Info(new String[]{"std::deque<torch::Tensor>"}).pointerTypes(new String[]{"TensorDeque"}).define()).put(new Info(new String[]{"std::bitset<64>", "std::bitset<at::kVmapNumLevels>", "std::bitset<dim_bitset_size>", "std::bitset<at::kVmapMaxTensorDims>", "std::bitset<at::dim_bitset_size>"}).valueTypes(new String[]{"long"})).put(new Info(new String[]{"std::basic_string<char>"}).annotations(new String[]{"@StdString"}).valueTypes(new String[]{"BytePointer"}).pointerTypes(new String[]{"@Cast({\"char*\", \"std::string\"}) BytePointer"}));
        for (ArrayInfo arrayInfo : new String[][]{{"ExprList", "torch::jit::Expr", "Expr"}, {"StmtList", "torch::jit::Stmt", "Stmt"}, {"WithItemList", "torch::jit::WithItem", "WithItem"}, {"PropertyList", "torch::jit::Property", "Property"}, {"AssignList", "torch::jit::Assign", "Assign"}, {"ParamList", "torch::jit::Param", "Param"}, {"IdentList", "torch::jit::Ident", "Ident"}, {"AttributeList", "torch::jit::Attribute", "Attribute"}}) {
            infoMap.put(new Info(new String[]{torch.template("torch::jit::List", new String[]{arrayInfo[1]})}).pointerTypes(new String[]{arrayInfo[0]})).put(new Info(new String[]{torch.template("torch::jit::ListIterator", new String[]{arrayInfo[1]})}).pointerTypes(new String[]{(String)((Object)arrayInfo[0]) + "Iterator"})).put(new Info(new String[]{torch.template("torch::jit::List", new String[]{arrayInfo[1]}) + "::map"}).skip());
        }
        infoMap.put(new Info(new String[]{"torch::jit::TreeList::const_iterator"}).cast().pointerTypes(new String[]{"TreeRef"}));
        infoMap.put(new Info(new String[]{"c10::Dict<c10::IValue,c10::IValue>"}).purify().pointerTypes(new String[]{"GenericDict"})).put(new Info(new String[]{"c10::impl::DictEntryRef<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>"}).pointerTypes(new String[]{"GenericDictEntryRef"})).put(new Info(new String[]{"c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>", "c10::Dict<c10::IValue,c10::IValue>::iterator"}).purify().pointerTypes(new String[]{"GenericDictIterator"}).friendly()).put(new Info(new String[]{"c10::Dict<std::string,c10::impl::GenericList>"}).pointerTypes(new String[]{"StringGenericListDict"})).put(new Info(new String[]{"c10::Dict<std::string,c10::impl::GenericList>(c10::TypePtr, c10::TypePtr)"}).skip()).put(new Info(new String[]{"c10::impl::DictIterator::operator -(const c10::impl::DictIterator&, const c10::impl::DictIterator&)", "c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>::operator -"}).skip()).put(new Info(new String[]{"c10::Dict::iterator::operator <(const c10::Dict::iterator&, const c10::Dict::iterator&)"}).skip()).put(new Info(new String[]{"c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>::operator <(const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&, const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&)"}).skip()).put(new Info(new String[]{"c10::Dict::iterator::operator <=(const c10::Dict::iterator&, const c10::Dict::iterator&)"}).skip()).put(new Info(new String[]{"c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>::operator <=(const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&, const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&)"}).skip()).put(new Info(new String[]{"c10::Dict::iterator::operator >=(const c10::Dict::iterator&, const c10::Dict::iterator&)"}).skip()).put(new Info(new String[]{"c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>::operator >=(const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&, const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&)"}).skip()).put(new Info(new String[]{"c10::Dict::iterator::operator >(const c10::Dict::iterator&, const c10::Dict::iterator&)"}).skip()).put(new Info(new String[]{"c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>::operator >(const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&, const c10::impl::DictIterator<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator>&)"}).skip());
        for (ArrayInfo arrayInfo : new String[][]{{"std::string", "torch::Tensor", "StringTensor"}, {"std::string", "torch::nn::AnyModule", "StringAnyModule"}, {"std::string", "std::shared_ptr<torch::nn::Module>", "StringSharedModule"}}) {
            infoMap.put(new Info(new String[]{torch.template("torch::OrderedDict", new String[]{arrayInfo[0], arrayInfo[1]})}).pointerTypes(new String[]{(String)((Object)arrayInfo[2]) + "Dict"})).put(new Info(new String[]{torch.template("torch::OrderedDict<Key,Value>::Item", new String[]{arrayInfo[0], arrayInfo[1]}), torch.template("torch::OrderedDict", new String[]{arrayInfo[0], arrayInfo[1]}) + "::Item"}).pointerTypes(new String[]{(String)((Object)arrayInfo[2]) + "DictItem"})).put(new Info(new String[]{"const " + torch.template("std::vector", torch.template("torch::OrderedDict", new String[]{arrayInfo[0], arrayInfo[1]}) + "::Item")}).pointerTypes(new String[]{(String)((Object)arrayInfo[2]) + "DictItemVector"}).define());
        }
        infoMap.put(new Info(new String[]{"std::pair<std::string,torch::Tensor>", "std::pair<std::string,torch::Tensor>"}).cast().pointerTypes(new String[]{"StringTensorPair"}).define()).put(new Info(new String[]{"std::pair<std::string,torch::nn::AnyModule>"}).pointerTypes(new String[]{"StringAnyModulePair"}).define()).put(new Info(new String[]{"std::pair<std::string,std::shared_ptr<torch::nn::Module> >"}).pointerTypes(new String[]{"StringSharedModulePair"}).define()).put(new Info(new String[]{"std::pair<at::RecordFunctionHandle,int>"}).pointerTypes(new String[]{"RecordFunctionHandleIntPair"}).define()).put(new Info(new String[]{"std::pair<void*,void*>", "std::pair<torch::jit::BackendMetaPtr,torch::jit::BackendMetaPtr>"}).pointerTypes(new String[]{"PointerPair"}).define()).put(new Info(new String[]{"std::pair<size_t,torch::jit::MatchedSchema>"}).pointerTypes(new String[]{"SizeTMatchedSchemaPair"}).define());
        for (PointerInfo pointerInfo : new PointerInfo[]{new PointerInfo("c10::ivalue::Tuple"), new PointerInfo("c10::ivalue::Future", "at::ivalue::Future"), new PointerInfo("c10::ivalue::ConstantString"), new PointerInfo("c10::GeneratorImpl"), new PointerInfo("at::Quantizer"), new PointerInfo("c10::ivalue::Await"), new PointerInfo("c10::RRefInterface"), new PointerInfo("c10::ivalue::PyObjectHolder"), new PointerInfo("c10::ivalue::EnumHolder"), new PointerInfo("c10::TensorImpl"), new PointerInfo("c10::TensorImpl,c10::UndefinedTensorImpl").javaBaseName("TensorImpl"), new PointerInfo("torch::jit::Tree").javaName("TreeRef"), new PointerInfo("c10::StorageImpl", "c10::StorageImpl,NullType"), new PointerInfo("c10::SymNodeImpl").javaName("SymNode"), new PointerInfo("c10::BackendMeta").javaName("BackendMetaRef")}) {
            String[] cppNames = new String[pointerInfo.argumentNames.length + pointerInfo.otherCppNames.length];
            int n2 = 0;
            for (String n3 : pointerInfo.argumentNames) {
                String ipn = torch.template("c10::intrusive_ptr", n3);
                cppNames[n2++] = ipn;
                infoMap.put(new Info(new String[]{ipn + "(" + n3 + "*)"}).skip());
            }
            for (String n3 : pointerInfo.otherCppNames) {
                cppNames[n2++] = n3;
            }
            infoMap.put(new Info(cppNames).pointerTypes(new String[]{pointerInfo.javaName == null ? pointerInfo.javaBaseName + "Ptr" : pointerInfo.javaName}));
        }
        infoMap.put(new Info(new String[]{"c10::Error", "c10::IndexError", "c10::LinAlgError", "c10::ValueError", "c10::TypeError", "c10::NotImplementedError", "c10::EnforceFiniteError", "c10::OutOfMemoryError", "c10::OnnxfiBackendSystemError", "c10::DistBackendError", "c10::SharedType", "c10::StrongTypePtr", "c10::WeakTypePtr", "torch::autograd::CppFunctionPreHook", "torch::autograd::DifferentiableViewMeta", "torch::autograd::TraceableFunction", "torch::jit::Instruction", "torch::jit::Method", "torch::jit::ModuleInstanceInfo", "torch::jit::Object::Property", "torch::jit::OperatorSet", "torch::jit::SourceRangePickler", "torch::jit::Unpickler", "torch::jit::Operator", "c10::CuDNNError"}).purify());
        infoMap.put(new Info(new String[]{"c10::guts::is_fundamental", "c10::detail::CaptureKernelCall", "c10::detail::DictImpl", "c10::detail::MultiDispatchKeySet", "c10::ExclusivelyOwnedTraits", "c10::FunctionSchema::dump", "c10::domain_prefix", "c10::C10FlagsRegistry", "c10::enforce_detail::EnforceFailMessage", "c10::impl::build_feature_required_feature_not_available", "c10::detail::getMaybeFakeTypePtr_", "c10::complex_literals::operator \"\"_if", "c10::complex_literals::operator \"\"_id", "decltype(::c10::impl::ScalarTypeToCPPType<::c10::ScalarType::ComplexHalf>::t)", "c10::BoxedKernel", "c10::ExtraMeta", "c10::remove_symint", "c10::InefficientStdFunctionContext", "c10::DataPtr::move_context", "c10::detail::UniqueVoidPtr::move_context", "QuantizerPtr", "c10::IValue::toModule", "c10::toBackendComponent", "c10::optional<THPObjectPtr>", "c10::asIntArrayRefSlow", "c10::standardizeVectorForUnion", "c10::impl::ExcludeDispatchKeyGuard", "c10::impl::ScalarTypeToCPPType", "c10::impl::AnnotatedKernel", "c10::impl::OperatorEntry", "c10::StorageImpl(c10::StorageImpl)", "c10::StorageImpl::operator =", "c10::TensorImpl(c10::TensorImpl)", "c10::TensorImpl::operator =", "caffe2::Blob(caffe2::Blob)", "caffe2::Blob::operator =", "c10::detail::infer_schema::bool_t", "torch::serialize::InputArchive(torch::serialize::InputArchive)", "torch::serialize::InputArchive::operator =", "torch::serialize::OutputArchive(torch::serialize::OutputArchive)", "torch::serialize::OutputArchive::operator =", "at::_test_serialization_subcmul", "at::_test_optional_intlist", "at::_test_optional_filled_intlist", "at::_test_optional_floatlist", "at::_test_string_default", "at::_test_ambiguous_defaults", "at::TensorBase::expect_contiguous", "torch::Tensor::print", "at::borrow_from_optional_tensor", "at::MaterializedITensorListRef", "at::impl::check_names_valid_for", "at::internal::launch_no_thread_state", "at::checkSameNumel", "at::check_names_valid_for", "at::default_names", "at::get_device", "at::detail::scalar_fill", "at::namedinference::compute_diagonal_outnames", "torch::Tensor::packed_accessor", "torch::optim::serialize", "torch::none_of", "torch::CountTensors", "torch::CountVariables", "torch::autograd::ExtractVariables", "torch::autograd::detail::MakeNextFunctionList", "torch::autograd::AutogradMeta::hooks_", "torch::autograd::AutogradMeta::cpp_hooks_list_", "torch::autograd::VariableType::unpack", "torch::autograd::VariableType::unpack_opt", "torch::jit::parseSchemaOrName", "torch::jit::trace", "torch::jit::tracer::TracingState::lookup_var_name_fn", "torch::jit::tracer::ArgumentStash", "torch::jit::constant_not_supported_error", "torch::jit::ObjectAttributeError", "torch::jit::utils::get_module_info", "torch::jit::operator <<(std::ostream&, torch::jit::Instruction)", "torch::jit::toString(torch::jit::OpCode)", "torch::jit::PropertyPropBase::processLoop", "torch::jit::PropertyPropBase::processIf", "torch::jit::PropertyPropBase::propagateBlock", "torch::jit::getMobileInterfaceCallExport", "torch::jit::OperatorSet::getOps", "torch::jit::SourceView::findSourceRangeThatGenerated", "at::namedinference::propagate_names_if_present_and_nonempty", "torch::jit::_load_jit_module_from_flatbuffer_bytes", "torch::jit::_save_jit_module_to", "torch::jit::checkHasValidSetGetState", "torch::jit::getTypeTags", "torch::jit::setTypeTags", "torch::jit::getStorageKey", "torch::jit::getUnresolvedClassAttributes", "torch::jit::isOpSupportedInMobile", "torch::jit::restoreAccurateTypeTags", "torch::jit::detail::getDifferentiableGraphOpExecutor", "torch::jit::detail::getGradExecutor", "torch::jit::Graph::createPythonOp", "torch::jit::Graph::createDifferentiableSubgraph", "torch::jit::NamedValue::type", "torch::jit::ProfileOp", "torch::jit::Value::isValidName", "torch::jit::EqualType::operator ()", "torch::jit::HashType::operator ()", "torch::jit::InterpreterContinuation::operator ()", "torch::jit::Object(c10::QualifiedName, torch::jit::CompilationUnit*, bool)", "torch::jit::Source::findSourceRangeThatGenerated", "torch::jit::SourceRangeDeserializer::deserialize", "torch::jit::SourceRangePickler::pickle", "torch::jit::Pickler::pushEmptyDict", "torch::jit::PrintDepsTable::add", "torch::jit::printerHasSpecialCaseFor", "ONNX_NAMESPACE::ModelProto", "torch::jit::export_onnx", "torch::jit::Function::call", "torch::jit::GraphFunction::call", "torch::jit::GraphFunction::function_creator", "torch::jit::getOptionsFromGlobal", "torch::jit::serialize_model_proto_to_string", "torch::onnx::IR_VERSION", "torch::onnx::PRODUCER_VERSION", "TORCH_DISALLOW_TEMPORARIES", "TORCH_DISALLOW_TEMPORARIES_IMPL", "DEFINE_CASTING(TAG, ...)", "TORCH_ILISTREF_FORALL_TAGS", "torch::autograd::GraphTask::ExecInfo::Capture::DO_NOT_USE_DEPRECATED_get_capture_hooks", "torch::autograd::GraphTask::ExecInfo::Capture::DO_NOT_USE_DEPRECATED_register_capture_hook", "c10::detail::IListRefTagImplBase<IListRefTag::Unboxed,T,ListElemT>", "c10::detail::IListRefTagImpl<IListRefTag::Unboxed,torch::Tensor>", "c10::IValue::TagType<c10::Type>", "std::conjunction<>", "std::disjunction<>", "std::numeric_limits<c10::BFloat16>", "torch::profiler::impl::ApproximateClockToUnixTimeConverter", "basic_string_view<CharT>::npos", "c10::impl::boxed_size_one<c10::TensorOptions>", "torch::detail::check_not_lvalue_references", "c10::guts::false_higher_t"}).skip());
        infoMap.put(new Info(new String[]{"c10::complex<double>"}).pointerTypes(new String[]{"DoubleComplex"})).put(new Info(new String[]{"c10::complex<float>"}).pointerTypes(new String[]{"FloatComplex"})).put(new Info(new String[]{"c10::complex<c10::Half>"}).pointerTypes(new String[]{"HalfComplex"})).put(new Info(new String[]{"c10::complex<double>::real", "c10::complex<double>::imag", "c10::complex<float>::real", "c10::complex<float>::imag", "c10::complex<c10::Half>::real", "c10::complex<c10::Half>::imag"}).annotations(new String[]{"@org.bytedeco.javacpp.annotation.Function"})).put(new Info(new String[]{"c10::complex<c10::Half>::operator =(c10::Half)", "c10::complex<c10::Half>::real(c10::Half)", "c10::complex<c10::Half>::imag(c10::Half)", "c10::complex<c10::Half>::operator const bool()", "c10::complex<c10::Half>::operator +=(c10::Half)", "c10::complex<c10::Half>::operator -=(c10::Half)", "c10::complex<c10::Half>::operator *=(c10::Half)", "c10::complex<c10::Half>::operator /=(c10::Half)"}).skip()).put(new Info(new String[]{"c10::complex<c10::Half>::complex(const c10::Half&, const c10::Half&)"}).javaText("public HalfComplex(Half re, Half im) { super((Pointer)null); allocate(re, im); }\nprivate native void allocate(@Const @ByRef Half re, @Const @ByRef(nullValue = \"c10::Half()\") Half im);\npublic HalfComplex(@Const @ByRef FloatComplex value) { super((Pointer)null); allocate(value); }\nprivate native void allocate(@Const @ByRef FloatComplex value);\n\n// Conversion operator\npublic native @ByVal @Name(\"operator c10::complex<float>\") FloatComplex asFloatComplex();\n\npublic native @ByRef @Name(\"operator +=\") HalfComplex addPut(@Const @ByRef HalfComplex other);\n\npublic native @ByRef @Name(\"operator -=\") HalfComplex subtractPut(@Const @ByRef HalfComplex other);\n\npublic native @ByRef @Name(\"operator *=\") HalfComplex multiplyPut(@Const @ByRef HalfComplex other);"));
        infoMap.put(new Info(new String[]{"c10::EnumerationType<c10::TypeKind::LayoutType>"}).pointerTypes(new String[]{"LayoutEnumerationType"})).put(new Info(new String[]{"c10::EnumerationType<c10::TypeKind::ScalarTypeType>"}).pointerTypes(new String[]{"ScalarTypeEnumerationType"})).put(new Info(new String[]{"c10::EnumerationType<c10::TypeKind::MemoryFormatType>"}).pointerTypes(new String[]{"MemoryFormattEnumerationType"})).put(new Info(new String[]{"c10::SingleElementType<c10::TypeKind::AwaitType,c10::AwaitType>"}).pointerTypes(new String[]{"AwaitSingleElementType"})).put(new Info(new String[]{"c10::SingleElementType<c10::TypeKind::ListType,c10::ListType>"}).pointerTypes(new String[]{"ListSingleElementType"})).put(new Info(new String[]{"c10::SingleElementType<c10::TypeKind::RRefType,c10::RRefType>"}).pointerTypes(new String[]{"RRefSingleElementType"})).put(new Info(new String[]{"c10::SingleElementType<c10::TypeKind::FutureType,c10::FutureType>"}).pointerTypes(new String[]{"FutureSingleElementType"})).put(new Info(new String[]{"c10::SingleElementType<c10::TypeKind::AwaitType,c10::AwaitType>"}).pointerTypes(new String[]{"AwaitSingleElementType"}));
        infoMap.put(new Info(new String[]{"torch::jit::ComplexAttr::ConstructorType", "torch::jit::ComplexAttr::ValueType"}).cast().pointerTypes(new String[]{"DoublePointer"})).put(new Info(new String[]{"torch::jit::ComplexValsAttr::ConstructorType", "torch::jit::ComplexValsAttr::ValueType"}).cast().pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"torch::jit::FloatAttr::ConstructorType", "torch::jit::FloatAttr::ValueType"}).cast().valueTypes(new String[]{"double"}).pointerTypes(new String[]{"DoublePointer"})).put(new Info(new String[]{"torch::jit::FloatsAttr::ConstructorType", "torch::jit::FloatsAttr::ValueType"}).cast().pointerTypes(new String[]{"DoubleVector"})).put(new Info(new String[]{"torch::jit::IntAttr::ConstructorType", "torch::jit::IntAttr::ValueType"}).cast().valueTypes(new String[]{"long"}).pointerTypes(new String[]{"LongPointer"})).put(new Info(new String[]{"torch::jit::IntsAttr::ConstructorType", "torch::jit::IntsAttr::ValueType"}).cast().pointerTypes(new String[]{"LongVector"})).put(new Info(new String[]{"torch::jit::StringAttr::ConstructorType", "torch::jit::StringAttr::ValueType"}).annotations(new String[]{"@StdString"}).pointerTypes(new String[]{"BytePointer"})).put(new Info(new String[]{"torch::jit::StringsAttr::ConstructorType", "torch::jit::StringsAttr::ValueType"}).cast().pointerTypes(new String[]{"StringVector"})).put(new Info(new String[]{"torch::jit::TensorAttr::ConstructorType", "torch::jit::TensorAttr::ValueType"}).cast().pointerTypes(new String[]{"Tensor"})).put(new Info(new String[]{"torch::jit::TensorsAttr::ConstructorType", "torch::jit::TensorsAttr::ValueType"}).cast().pointerTypes(new String[]{"TensorVector"})).put(new Info(new String[]{"torch::jit::TypesAttr::ConstructorType", "torch::jit::TypesAttr::ValueType"}).cast().pointerTypes(new String[]{"TypeVector"})).put(new Info(new String[]{"torch::jit::IValueAttr::ConstructorType", "torch::jit::IValueAttr::ValueType"}).cast().pointerTypes(new String[]{"IValue"}));
        for (String[] stringArray : new String[][]{{"Module", "JitModule", "torch::jit::Module"}, {"Parameter", "Tensor", "torch::Tensor"}, {"Attribute", "IValue", "c10::IValue"}, {"Buffer", "Tensor", "torch::Tensor"}}) {
            infoMap.put(new Info(new String[]{"torch::jit::slot_list_impl<torch::jit::detail::" + (String)stringArray[0] + "Policy>", "torch::jit::" + ((String)stringArray[0]).toLowerCase() + "_list"}).pointerTypes(new String[]{((String)stringArray[0]).toLowerCase() + "_list"})).put(new Info(new String[]{"torch::jit::slot_iterator_impl<torch::jit::detail::" + (String)stringArray[0] + "Policy>"}).pointerTypes(new String[]{((String)stringArray[0]).toLowerCase() + "_iterator"})).put(new Info(new String[]{"torch::jit::slot_iterator_impl<torch::jit::detail::" + (String)stringArray[0] + "Policy>::value_type"}).pointerTypes(new String[]{stringArray[1]})).put(new Info(new String[]{"torch::jit::Named<" + (String)stringArray[2] + ">"}).pointerTypes(new String[]{"Named" + (String)stringArray[1]})).put(new Info(new String[]{"torch::jit::slot_list_impl<torch::jit::detail::NamedPolicy<torch::jit::detail::" + (String)stringArray[0] + "Policy> >", "torch::jit::named_" + ((String)stringArray[0]).toLowerCase() + "_list"}).pointerTypes(new String[]{"named_" + ((String)stringArray[0]).toLowerCase() + "_list"})).put(new Info(new String[]{"torch::jit::slot_iterator_impl<torch::jit::detail::NamedPolicy<torch::jit::detail::" + (String)stringArray[0] + "Policy> >"}).pointerTypes(new String[]{"named_" + ((String)stringArray[0]).toLowerCase() + "_iterator"})).put(new Info(new String[]{"torch::jit::slot_iterator_impl<torch::jit::detail::NamedPolicy<torch::jit::detail::" + (String)stringArray[0] + "Policy> >::value_type"}).pointerTypes(new String[]{"Named" + (String)stringArray[1]}));
        }
        infoMap.put(new Info(new String[]{"torch::jit::Maybe<torch::jit::Def>"}).pointerTypes(new String[]{"DefMaybe"})).put(new Info(new String[]{"torch::jit::Maybe<torch::jit::Expr>"}).pointerTypes(new String[]{"ExprMaybe"})).put(new Info(new String[]{"torch::jit::Maybe<torch::jit::Var>"}).pointerTypes(new String[]{"VarMaybe"})).put(new Info(new String[]{"torch::jit::Maybe<torch::jit::List<torch::jit::Property> >"}).pointerTypes(new String[]{"PropertyListMaybe"})).put(new Info(new String[]{"torch::jit::Maybe<torch::jit::List<torch::jit::Assign> >"}).pointerTypes(new String[]{"AssignListMaybe"})).put(new Info(new String[]{"torch::jit::Compound::map", "torch::jit::Tree::map", "torch::jit::Maybe<torch::jit::Def>::map", "torch::jit::Maybe<torch::jit::Expr>::map", "torch::jit::Maybe<torch::jit::Var>::map", "torch::jit::Maybe<torch::jit::List<torch::jit::Assign> >::map", "torch::jit::Maybe<torch::jit::List<torch::jit::Property> >::map"}).skip()).put(new Info(new String[]{"torch::jit::Wrap<torch::jit::Block>"}).pointerTypes(new String[]{"BlockWrap"})).put(new Info(new String[]{"torch::jit::Wrap<torch::jit::Node>"}).pointerTypes(new String[]{"JitNodeWrap"})).put(new Info(new String[]{"torch::jit::Wrap<torch::jit::Value>"}).pointerTypes(new String[]{"ValueWrap"}));
        infoMap.put(new Info(new String[]{"torch::data::example::NoTarget"})).put(new Info(new String[]{"torch::data::Example<torch::Tensor,torch::data::example::NoTarget>::Example"}).javaText("public TensorExample(@ByVal Tensor data) { super((Pointer)null); allocate(data); }\nprivate native void allocate(@ByVal Tensor data);\n")).put(new Info(new String[]{"torch::data::Example<torch::Tensor,torch::data::example::NoTarget>::target"}).skip()).put(new Info(new String[]{"torch::data::samplers::Sampler<std::vector<size_t> >", "torch::data::samplers::Sampler<>"}).pointerTypes(new String[]{"Sampler"})).put(new Info(new String[]{"torch::data::samplers::Sampler<torch::data::samplers::BatchSize>"}).pointerTypes(new String[]{"BatchSizeSampler"})).put(new Info(new String[]{"torch::data::samplers::RandomSampler"}).pointerTypes(new String[]{"RandomSampler"})).put(new Info(new String[]{"torch::data::samplers::DistributedSampler<std::vector<size_t> >", "torch::data::samplers::DistributedSampler<>"}).purify().pointerTypes(new String[]{"DistributedSampler"})).put(new Info(new String[]{"c10::optional<torch::data::samplers::BatchSize>"}).pointerTypes(new String[]{"BatchSizeOptional"}).define()).put(new Info(new String[]{"torch::data::DataLoaderBase<torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >,torch::data::Example<torch::Tensor,torch::Tensor>,std::vector<size_t> >", "torch::data::DataLoaderBase<torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >,torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >::BatchType,torch::data::samplers::RandomSampler::BatchRequestType>"}).purify().pointerTypes(new String[]{"MNISTRandomDataLoaderBase"})).put(new Info(new String[]{"torch::data::StatelessDataLoader<torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >,torch::data::samplers::RandomSampler>"}).pointerTypes(new String[]{"MNISTRandomDataLoader"})).put(new Info(new String[]{"torch::data::datasets::Dataset<torch::data::datasets::MNIST,torch::data::Example<torch::Tensor,torch::Tensor> >", "torch::data::datasets::Dataset<MNIST>"}).pointerTypes(new String[]{"MNISTDataset"})).put(new Info(new String[]{"torch::data::datasets::BatchDataset<torch::data::datasets::MNIST,std::vector<torch::data::Example<torch::Tensor,torch::Tensor> >,at::ArrayRef<size_t> >", "torch::data::datasets::BatchDataset<torch::data::datasets::MNIST,std::vector<torch::data::Example<torch::Tensor,torch::Tensor> > >"}).pointerTypes(new String[]{"MNISTBatchDataset"})).put(new Info(new String[]{"torch::data::datasets::BatchDataset<torch::data::datasets::MNIST,std::vector<torch::data::Example<torch::Tensor,torch::Tensor> >,at::ArrayRef<size_t> >::map"}).javaText("public native @ByVal MNISTMapDataset map(@ByVal ExampleStack transform);")).put(new Info(new String[]{"torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >"}).pointerTypes(new String[]{"MNISTMapDataset"})).put(new Info(new String[]{"torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >::reset"}).skip()).put(new Info(new String[]{"torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >::DatasetType"}).pointerTypes(new String[]{"MNIST"})).put(new Info(new String[]{"torch::data::datasets::BatchDataset<torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >,std::vector<torch::data::Example<torch::Tensor,torch::Tensor> >,at::ArrayRef<size_t> >", "torch::data::datasets::BatchDataset<torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >,torch::data::datasets::detail::optional_if_t<torch::data::datasets::MNIST::is_stateful,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> >::OutputBatchType>,torch::data::datasets::MNIST::BatchRequestType>"}).pointerTypes(new String[]{"MNISTMapBatchDataset"})).put(new Info(new String[]{"torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >::get_batch"}).javaText("public native @Name(\"get_batch\") @ByVal Example get_batch_example(@ByVal SizeTArrayRef indices);\npublic native @Name(\"get_batch\") @ByVal Example get_batch_example(@ByVal @Cast({\"size_t*\", \"c10::ArrayRef<size_t>\", \"std::vector<size_t>&\"}) @StdVector long... indices);")).put(new Info(new String[]{"torch::data::datasets::TensorDataset"})).put(new Info(new String[]{"torch::data::datasets::Dataset<torch::data::datasets::TensorDataset,torch::data::TensorExample>"}).pointerTypes(new String[]{"TensorDatasetBase"})).put(new Info(new String[]{"torch::data::datasets::BatchDataset<torch::data::datasets::TensorDataset,std::vector<torch::data::TensorExample> >"}).pointerTypes(new String[]{"TensorBatchDataset"})).put(new Info(new String[]{"torch::data::datasets::Dataset<torch::data::datasets::TensorDataset,torch::data::TensorExample>::get_batch", "torch::data::datasets::BatchDataset<torch::data::datasets::TensorDataset,std::vector<torch::data::TensorExample> >::get_batch"}).javaText("public native @ByVal TensorExampleVector get_batch(@ByVal SizeTArrayRef request);\npublic native @ByVal TensorExampleVector get_batch(@ByVal @Cast({\"size_t*\", \"c10::ArrayRef<size_t>\", \"std::vector<size_t>&\"}) @StdVector(\"size_t\") long... request);"));
        for (String[] stringArray : new String[][]{{"", "torch::Tensor", "torch::Tensor"}, {"Tensor", "torch::Tensor", "torch::data::example::NoTarget"}}) {
            String example = stringArray[2] == null ? torch.template("torch::data::Example", new String[]{stringArray[1]}) : torch.template("torch::data::Example", new String[]{stringArray[1], stringArray[2]});
            Object object = stringArray[0];
            String chunkDataReader = torch.template("torch::data::datasets::ChunkDataReader", example, torch.template("std::vector", example));
            String mangledChunkDataReader = torch.mangle(chunkDataReader);
            String mangledJavaDataset = torch.mangle(torch.template("javacpp::Dataset", new String[]{stringArray[1], stringArray[2]}));
            String mangledJavaStreamDataset = torch.mangle(torch.template("javacpp::StreamDataset", new String[]{stringArray[1], stringArray[2]}));
            String mangledJavaStatefulDataset = torch.mangle(torch.template("javacpp::StatefulDataset", new String[]{stringArray[1], stringArray[2]}));
            infoMap.put(new Info(new String[]{example, torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)) + "::OutputBatchType"}).pointerTypes(new String[]{(String)object + "Example"})).put(new Info(new String[]{torch.template("std::vector", example), torch.template("std::vector", torch.template("torch::data::datasets::Dataset", torch.template("javacpp::Dataset", new String[]{stringArray[1], stringArray[2]}), example) + "::ExampleType"), torch.template("std::vector", torch.template("torch::data::datasets::Dataset", torch.template("javacpp::StreamDataset", new String[]{stringArray[1], stringArray[2]}), example) + "::ExampleType"), torch.template("std::vector", torch.template("torch::data::datasets::Dataset", torch.template("javacpp::StatefulDataset", new String[]{stringArray[1], stringArray[2]}), example) + "::ExampleType"), torch.template("std::vector", torch.template("torch::data::datasets::Dataset", mangledJavaDataset, example) + "::ExampleType"), torch.template("std::vector", torch.template("torch::data::datasets::Dataset", mangledJavaStreamDataset, example) + "::ExampleType"), torch.template("std::vector", torch.template("torch::data::datasets::Dataset", mangledJavaStatefulDataset, example) + "::ExampleType")}).pointerTypes(new String[]{(String)object + "ExampleVector"}).define()).put(new Info(new String[]{torch.template("c10::optional", example)}).pointerTypes(new String[]{(String)object + "ExampleOptional"}).define()).put(new Info(new String[]{torch.template("c10::optional", torch.template("std::vector", example)), torch.template("c10::optional", mangledChunkDataReader + "::BatchType"), torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler") + "::BatchType", mangledJavaStreamDataset + "::BatchType"}).pointerTypes(new String[]{(String)object + "ExampleVectorOptional"}).define()).put(new Info(new String[]{torch.template("torch::data::Iterator", example), torch.template("torch::data::Iterator", mangledJavaDataset + "::BatchType::value_type")}).pointerTypes(new String[]{(String)object + "ExampleIterator"}).purify()).put(new Info(new String[]{torch.template("torch::data::Iterator", torch.template("std::vector", example)), torch.template("torch::data::Iterator", mangledJavaDataset + "::BatchType"), torch.template("torch::data::Iterator", mangledJavaStreamDataset + "::BatchType"), torch.template("torch::data::Iterator", mangledJavaStatefulDataset + "::BatchType::value_type")}).purify().pointerTypes(new String[]{(String)object + "ExampleVectorIterator"})).put(new Info(new String[]{torch.template("torch::data::transforms::BatchTransform", torch.template("std::vector", example), example), torch.template("torch::data::transforms::Collation", example)}).pointerTypes(new String[]{(String)object + "ExampleCollation"})).put(new Info(new String[]{torch.template("torch::data::transforms::Stack", example)}).pointerTypes(new String[]{(String)object + "ExampleStack"}).base((String)object + "ExampleCollation")).put(new Info(new String[]{chunkDataReader}).pointerTypes(new String[]{"Chunk" + (String)object + "DataReader"}).virtualize()).put(new Info(new String[]{torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")}).pointerTypes(new String[]{"Chunk" + (String)object + "Dataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler") + "::ChunkDataset"}).javaText("public Chunk" + (String)object + "Dataset(\n      Chunk" + (String)object + "DataReader chunk_reader,\n      RandomSampler chunk_sampler,\n      RandomSampler example_sampler,\n      ChunkDatasetOptions options) { super((Pointer)null); allocate(chunk_reader, chunk_sampler, example_sampler, options, null); }\npublic Chunk" + (String)object + "Dataset(\n      Chunk" + (String)object + "DataReader chunk_reader,\n      RandomSampler chunk_sampler,\n      RandomSampler example_sampler,\n      ChunkDatasetOptions options,\n      Pointer preprocessing_policy) { super((Pointer)null); allocate(chunk_reader, chunk_sampler, example_sampler, options, preprocessing_policy); }\nprivate native void allocate(\n      @ByVal @Cast(\"" + mangledChunkDataReader + "*\") Chunk" + (String)object + "DataReader chunk_reader,\n      @ByVal RandomSampler chunk_sampler,\n      @ByVal RandomSampler example_sampler,\n      @ByVal ChunkDatasetOptions options,\n      @ByVal(nullValue = \"std::function<void(std::vector<" + example + ">&)>()\") @Cast(\"std::function<void(std::vector<" + example + ">&)>*\") Pointer preprocessing_policy);\n")).put(new Info(new String[]{torch.template("torch::data::datasets::StatefulDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler"), mangledChunkDataReader + "::BatchType", "size_t")}).pointerTypes(new String[]{"ChunkStateful" + (String)object + "Dataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::BatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler"), torch.template("c10::optional", mangledChunkDataReader + "::BatchType"), "size_t"), torch.template("torch::data::datasets::BatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler"), torch.template("std::vector", example))}).pointerTypes(new String[]{"Chunk" + (String)object + "BatchDataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::BatchDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("c10::optional", mangledChunkDataReader + "::BatchType"), "size_t"), torch.template("torch::data::datasets::BatchDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler") + "::BatchType", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler") + "::BatchRequestType")}).pointerTypes(new String[]{"ChunkBatchShared" + (String)object + "BatchDataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::BatchDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("c10::optional", mangledChunkDataReader + "::BatchType"), "size_t") + "::map"}).javaText("public native @ByVal ChunkMap" + (String)object + "Dataset map(@ByVal " + (String)object + "ExampleStack transform);")).put(new Info(new String[]{torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler"))}).pointerTypes(new String[]{"ChunkShared" + (String)object + "BatchDataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example))}).pointerTypes(new String[]{"ChunkMap" + (String)object + "Dataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)) + "::reset"}).skip()).put(new Info(new String[]{torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)) + "::DatasetType"}).pointerTypes(new String[]{"ChunkShared" + (String)object + "BatchDataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::BatchDataset", torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)), torch.template("std::vector", example), "at::ArrayRef<size_t>"), torch.template("torch::data::datasets::BatchDataset", torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)), torch.template("torch::data::datasets::detail::optional_if_t", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")) + "::is_stateful", torch.template("torch::data::transforms::Stack", example) + "::OutputBatchType"), torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")) + "::BatchRequestType")}).pointerTypes(new String[]{"ChunkMap" + (String)object + "BatchDataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)) + "::BatchRequestType", torch.template("torch::data::datasets::BatchDataset", mangledJavaDataset, torch.template("std::vector", example)) + "::BatchRequest", torch.template("torch::data::datasets::BatchDataset", torch.template("javacpp::Dataset", new String[]{stringArray[1], stringArray[2]}), torch.template("std::vector", example)) + "::BatchRequest"}).pointerTypes(new String[]{"SizeTArrayRef", "@Cast({\"size_t*\", \"c10::ArrayRef<size_t>\", \"std::vector<size_t>&\"}) @StdVector(\"size_t\") long..."})).put(new Info(new String[]{torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)) + "::get_batch"}).javaText("public native @Name(\"get_batch\") @ByVal " + (String)object + "ExampleOptional get_batch_example(@Cast(\"size_t\") long indices);")).put(new Info(new String[]{torch.template("torch::data::DataLoaderBase", torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)), example, "size_t"), torch.template("torch::data::DataLoaderBase", torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)), torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)) + "::BatchType::value_type", torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)) + "::BatchRequestType")}).purify().pointerTypes(new String[]{"ChunkRandom" + (String)object + "DataLoaderBase"})).put(new Info(new String[]{torch.template("torch::data::StatefulDataLoader", torch.template("torch::data::datasets::MapDataset", torch.template("torch::data::datasets::SharedBatchDataset", torch.template("torch::data::datasets::ChunkDataset", mangledChunkDataReader, "torch::data::samplers::RandomSampler", "torch::data::samplers::RandomSampler")), torch.template("torch::data::transforms::Stack", example)))}).pointerTypes(new String[]{"ChunkRandom" + (String)object + "DataLoader"})).put(new Info(new String[]{torch.template("torch::data::datasets::BatchDataset", torch.template("javacpp::Dataset", new String[]{stringArray[1], stringArray[2]}), torch.template("std::vector", example))}).pointerTypes(new String[]{"Java" + (String)object + "BatchDataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::Dataset", torch.template("javacpp::Dataset", new String[]{stringArray[1], stringArray[2]}), example)}).pointerTypes(new String[]{"Java" + (String)object + "DatasetBase"}).purify()).put(new Info(new String[]{torch.template("torch::data::StatelessDataLoader", mangledJavaDataset, "torch::data::samplers::RandomSampler")}).pointerTypes(new String[]{"JavaRandom" + (String)object + "DataLoader"})).put(new Info(new String[]{torch.template("torch::data::DataLoaderBase", mangledJavaDataset, mangledJavaDataset + "::BatchType", "torch::data::samplers::RandomSampler::BatchRequestType")}).pointerTypes(new String[]{"JavaRandom" + (String)object + "DataLoaderBase"}).purify()).put(new Info(new String[]{torch.template("torch::data::StatelessDataLoader", mangledJavaDataset, "torch::data::samplers::DistributedRandomSampler")}).pointerTypes(new String[]{"JavaDistributedRandom" + (String)object + "DataLoader"})).put(new Info(new String[]{torch.template("torch::data::DataLoaderBase", mangledJavaDataset, mangledJavaDataset + "::BatchType", "torch::data::samplers::DistributedRandomSampler::BatchRequestType")}).pointerTypes(new String[]{"JavaDistributedRandom" + (String)object + "DataLoaderBase"}).purify()).put(new Info(new String[]{torch.template("torch::data::StatelessDataLoader", mangledJavaDataset, "torch::data::samplers::DistributedSequentialSampler")}).pointerTypes(new String[]{"JavaDistributedSequential" + (String)object + "DataLoader"})).put(new Info(new String[]{torch.template("torch::data::DataLoaderBase", mangledJavaDataset, mangledJavaDataset + "::BatchType", "torch::data::samplers::DistributedSequentialSampler::BatchRequestType")}).pointerTypes(new String[]{"JavaDistributedSequential" + (String)object + "DataLoaderBase"}).purify()).put(new Info(new String[]{torch.template("torch::data::StatelessDataLoader", mangledJavaDataset, "torch::data::samplers::SequentialSampler")}).pointerTypes(new String[]{"JavaSequential" + (String)object + "DataLoader"})).put(new Info(new String[]{torch.template("torch::data::DataLoaderBase", mangledJavaDataset, mangledJavaDataset + "::BatchType", "torch::data::samplers::SequentialSampler::BatchRequestType")}).pointerTypes(new String[]{"JavaSequential" + (String)object + "DataLoaderBase"}).purify()).put(new Info(new String[]{torch.template("torch::data::datasets::BatchDataset", torch.template("javacpp::StreamDataset", new String[]{stringArray[1], stringArray[2]}), torch.template("std::vector", example), "size_t")}).pointerTypes(new String[]{"JavaStream" + (String)object + "BatchDataset"})).put(new Info(new String[]{torch.template("torch::data::StatelessDataLoader", mangledJavaStreamDataset, "torch::data::samplers::StreamSampler")}).pointerTypes(new String[]{"JavaStream" + (String)object + "DataLoader"})).put(new Info(new String[]{torch.template("torch::data::DataLoaderBase", mangledJavaStreamDataset, mangledJavaStreamDataset + "::BatchType", "torch::data::samplers::StreamSampler::BatchRequestType")}).pointerTypes(new String[]{"JavaStream" + (String)object + "DataLoaderBase"}).purify()).put(new Info(new String[]{torch.template("javacpp::Dataset", new String[]{stringArray[1], stringArray[2]})}).pointerTypes(new String[]{"Java" + (String)object + "Dataset"}).virtualize()).put(new Info(new String[]{mangledJavaDataset}).pointerTypes(new String[]{"@Cast(\"" + mangledJavaDataset + "*\") Java" + (String)object + "Dataset"})).put(new Info(new String[]{torch.template("javacpp::StreamDataset", new String[]{stringArray[1], stringArray[2]})}).pointerTypes(new String[]{"JavaStream" + (String)object + "Dataset"}).virtualize()).put(new Info(new String[]{mangledJavaStreamDataset}).pointerTypes(new String[]{"@Cast(\"" + mangledJavaStreamDataset + "*\") JavaStream" + (String)object + "Dataset"})).put(new Info(new String[]{torch.template("javacpp::StatefulDataset", new String[]{stringArray[1], stringArray[2]})}).pointerTypes(new String[]{"JavaStateful" + (String)object + "Dataset"}).virtualize()).put(new Info(new String[]{mangledJavaStatefulDataset}).pointerTypes(new String[]{"@Cast(\"" + mangledJavaStatefulDataset + "*\") JavaStateful" + (String)object + "Dataset"})).put(new Info(new String[]{torch.template("torch::data::datasets::StatefulDataset", torch.template("javacpp::StatefulDataset", new String[]{stringArray[1], stringArray[2]}), torch.template("std::vector", example), "size_t")}).pointerTypes(new String[]{"JavaStateful" + (String)object + "DatasetBase"}).purify()).put(new Info(new String[]{torch.template("torch::data::StatefulDataLoader", mangledJavaStatefulDataset)}).pointerTypes(new String[]{"JavaStateful" + (String)object + "DataLoader"})).put(new Info(new String[]{torch.template("torch::data::DataLoaderBase", mangledJavaStatefulDataset, mangledJavaStatefulDataset + "::BatchType::value_type", mangledJavaStatefulDataset + "::BatchRequestType")}).pointerTypes(new String[]{"JavaStateful" + (String)object + "DataLoaderBase"}).purify()).put(new Info(new String[]{torch.template("torch::data::datasets::BatchDataset", torch.template("javacpp::StatefulDataset", new String[]{stringArray[1], stringArray[2]}), torch.template("c10::optional", torch.template("std::vector", example)), "size_t")}).pointerTypes(new String[]{"JavaStateful" + (String)object + "BatchDataset"}).purify());
        }
        torch.addCppName(infoMap, "std::vector<torch::data::Example<torch::Tensor,torch::Tensor> >", "std::vector<torch::data::datasets::Dataset<torch::data::datasets::MNIST,torch::data::Example<torch::Tensor,torch::Tensor> >::ExampleType>");
        torch.addCppName(infoMap, "torch::data::Example<torch::Tensor,torch::Tensor>", "torch::data::Example<>");
        torch.addCppName(infoMap, "torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> >", "torch::data::transforms::Stack<torch::data::Example<> >");
        torch.addCppName(infoMap, "torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::data::example::NoTarget> >", "torch::data::transforms::Stack<torch::data::TensorExample>");
        torch.addCppName(infoMap, "torch::data::transforms::Collation<torch::data::Example<torch::Tensor,torch::Tensor>,std::vector<torch::data::Example<torch::Tensor,torch::Tensor> > >", "torch::data::transforms::Collation<torch::data::Example<> >");
        String[] stringArray = factories = new String[]{"_cudnn_init_dropout_state", "arange", "bartlett_window", "blackman_window", "empty", "_empty_affine_quantized", "_empty_per_channel_affine_quantized", "empty_quantized", "empty_like", "empty_strided", "eye", "full", "full_like", "from_file", "hann_window", "hamming_window", "kaiser_window", "linspace", "logspace", "ones", "ones_like", "scalar_tensor", "rand", "rand_like", "randint", "randint_like", "randn", "randn_like", "randperm", "range", "zeros", "_efficientzerotensor", "zeros_like", "sparse_compressed_tensor", "sparse_csr_tensor", "sparse_csc_tensor", "sparse_bsr_tensor", "sparse_bsc_tensor", "_sparse_compressed_tensor_unsafe", "_sparse_csr_tensor_unsafe", "_sparse_csc_tensor_unsafe", "_sparse_bsr_tensor_unsafe", "_sparse_bsc_tensor_unsafe", "sparse_coo_tensor", "_sparse_coo_tensor_unsafe", "_sparse_coo_tensor_with_dims", "_sparse_coo_tensor_with_dims_and_tensors", "_to_copy", "tril_indices", "triu_indices", "normal", "fft_fftfreq", "fft_rfftfreq"};
        int n4 = stringArray.length;
        boolean bl = false;
        while (var5_25 < n4) {
            String factory = stringArray[var5_25];
            infoMap.put(new Info(new String[]{"torch::" + factory}).javaNames(new String[]{"torch_" + factory}).skipDefaults(factory.equals("range"))).put(new Info(new String[]{"torch::autograd::" + factory})).put(new Info(new String[]{"torch::jit::" + factory})).put(new Info(new String[]{"torch::nn::" + factory}));
            ++var5_25;
        }
        infoMap.put(new Info(new String[]{"torch::nn::detail::ConvNdOptions<1>"}).pointerTypes(new String[]{"DetailConv1dOptions"})).put(new Info(new String[]{"torch::nn::detail::ConvNdOptions<2>"}).pointerTypes(new String[]{"DetailConv2dOptions"})).put(new Info(new String[]{"torch::nn::detail::ConvNdOptions<3>"}).pointerTypes(new String[]{"DetailConv3dOptions"})).put(new Info(new String[]{"torch::nn::ConvOptions<1>"}).pointerTypes(new String[]{"Conv1dOptions"})).put(new Info(new String[]{"torch::nn::ConvOptions<2>"}).pointerTypes(new String[]{"Conv2dOptions"})).put(new Info(new String[]{"torch::nn::ConvOptions<3>"}).pointerTypes(new String[]{"Conv3dOptions"})).put(new Info(new String[]{"torch::nn::functional::ConvFuncOptions<1>"}).pointerTypes(new String[]{"Conv1dFuncOptions"})).put(new Info(new String[]{"torch::nn::functional::ConvFuncOptions<2>"}).pointerTypes(new String[]{"Conv2dFuncOptions"})).put(new Info(new String[]{"torch::nn::functional::ConvFuncOptions<3>"}).pointerTypes(new String[]{"Conv3dFuncOptions"})).put(new Info(new String[]{"torch::nn::ConvTransposeOptions<1>"}).pointerTypes(new String[]{"ConvTranspose1dOptions"})).put(new Info(new String[]{"torch::nn::ConvTransposeOptions<2>"}).pointerTypes(new String[]{"ConvTranspose2dOptions"})).put(new Info(new String[]{"torch::nn::ConvTransposeOptions<3>"}).pointerTypes(new String[]{"ConvTranspose3dOptions"})).put(new Info(new String[]{"torch::nn::functional::ConvTransposeFuncOptions<1>"}).pointerTypes(new String[]{"ConvTranspose1dFuncOptions"})).put(new Info(new String[]{"torch::nn::functional::ConvTransposeFuncOptions<2>"}).pointerTypes(new String[]{"ConvTranspose2dFuncOptions"})).put(new Info(new String[]{"torch::nn::functional::ConvTransposeFuncOptions<3>"}).pointerTypes(new String[]{"ConvTranspose3dFuncOptions"})).put(new Info(new String[]{"torch::nn::ReflectionPadOptions<1>"}).pointerTypes(new String[]{"ReflectionPad1dOptions"})).put(new Info(new String[]{"torch::nn::ReflectionPadOptions<2>"}).pointerTypes(new String[]{"ReflectionPad2dOptions"})).put(new Info(new String[]{"torch::nn::ReflectionPadOptions<3>"}).pointerTypes(new String[]{"ReflectionPad3dOptions"})).put(new Info(new String[]{"torch::nn::ReplicationPadOptions<1>"}).pointerTypes(new String[]{"ReplicationPad1dOptions"})).put(new Info(new String[]{"torch::nn::ReplicationPadOptions<2>"}).pointerTypes(new String[]{"ReplicationPad2dOptions"})).put(new Info(new String[]{"torch::nn::ReplicationPadOptions<3>"}).pointerTypes(new String[]{"ReplicationPad3dOptions"})).put(new Info(new String[]{"torch::nn::ConstantPadOptions<1>"}).pointerTypes(new String[]{"ConstantPad1dOptions"})).put(new Info(new String[]{"torch::nn::ConstantPadOptions<2>"}).pointerTypes(new String[]{"ConstantPad2dOptions"})).put(new Info(new String[]{"torch::nn::ConstantPadOptions<3>"}).pointerTypes(new String[]{"ConstantPad3dOptions"})).put(new Info(new String[]{"torch::nn::ZeroPadOptions<1>"}).pointerTypes(new String[]{"ZeroPad1dOptions"})).put(new Info(new String[]{"torch::nn::ZeroPadOptions<2>"}).pointerTypes(new String[]{"ZeroPad2dOptions"})).put(new Info(new String[]{"torch::nn::ZeroPadOptions<3>"}).pointerTypes(new String[]{"ZeroPad3dOptions"})).put(new Info(new String[]{"torch::nn::AvgPoolOptions<1>", "torch::nn::functional::AvgPool1dFuncOptions"}).pointerTypes(new String[]{"AvgPool1dOptions"})).put(new Info(new String[]{"torch::nn::AvgPoolOptions<2>", "torch::nn::functional::AvgPool2dFuncOptions"}).pointerTypes(new String[]{"AvgPool2dOptions"})).put(new Info(new String[]{"torch::nn::AvgPoolOptions<3>", "torch::nn::functional::AvgPool3dFuncOptions"}).pointerTypes(new String[]{"AvgPool3dOptions"})).put(new Info(new String[]{"torch::nn::MaxPoolOptions<1>", "torch::nn::functional::MaxPool1dFuncOptions"}).pointerTypes(new String[]{"MaxPool1dOptions"})).put(new Info(new String[]{"torch::nn::MaxPoolOptions<2>", "torch::nn::functional::MaxPool2dFuncOptions"}).pointerTypes(new String[]{"MaxPool2dOptions"})).put(new Info(new String[]{"torch::nn::MaxPoolOptions<3>", "torch::nn::functional::MaxPool3dFuncOptions"}).pointerTypes(new String[]{"MaxPool3dOptions"})).put(new Info(new String[]{"torch::nn::AdaptiveAvgPoolOptions<torch::ExpandingArray<1> >", "torch::nn::functional::AdaptiveAvgPool1dFuncOptions"}).pointerTypes(new String[]{"AdaptiveAvgPool1dOptions"})).put(new Info(new String[]{"torch::nn::AdaptiveAvgPoolOptions<torch::ExpandingArrayWithOptionalElem<2> >", "torch::nn::functional::AdaptiveAvgPool2dFuncOptions"}).pointerTypes(new String[]{"AdaptiveAvgPool2dOptions"})).put(new Info(new String[]{"torch::nn::AdaptiveAvgPoolOptions<torch::ExpandingArrayWithOptionalElem<3> >", "torch::nn::functional::AdaptiveAvgPool3dFuncOptions"}).pointerTypes(new String[]{"AdaptiveAvgPool3dOptions"})).put(new Info(new String[]{"torch::nn::AdaptiveMaxPoolOptions<torch::ExpandingArray<1> >", "torch::nn::functional::AdaptiveMaxPool1dFuncOptions"}).pointerTypes(new String[]{"AdaptiveMaxPool1dOptions"})).put(new Info(new String[]{"torch::nn::AdaptiveMaxPoolOptions<torch::ExpandingArrayWithOptionalElem<2> >", "torch::nn::functional::AdaptiveMaxPool2dFuncOptions"}).pointerTypes(new String[]{"AdaptiveMaxPool2dOptions"})).put(new Info(new String[]{"torch::nn::AdaptiveMaxPoolOptions<torch::ExpandingArrayWithOptionalElem<3> >", "torch::nn::functional::AdaptiveMaxPool3dFuncOptions"}).pointerTypes(new String[]{"AdaptiveMaxPool3dOptions"})).put(new Info(new String[]{"torch::nn::MaxUnpoolOptions<1>"}).pointerTypes(new String[]{"MaxUnpool1dOptions"})).put(new Info(new String[]{"torch::nn::MaxUnpoolOptions<2>"}).pointerTypes(new String[]{"MaxUnpool2dOptions"})).put(new Info(new String[]{"torch::nn::MaxUnpoolOptions<3>"}).pointerTypes(new String[]{"MaxUnpool3dOptions"})).put(new Info(new String[]{"torch::nn::functional::MaxUnpoolFuncOptions<1>"}).pointerTypes(new String[]{"MaxUnpool1dFuncOptions"})).put(new Info(new String[]{"torch::nn::functional::MaxUnpoolFuncOptions<2>"}).pointerTypes(new String[]{"MaxUnpool2dFuncOptions"})).put(new Info(new String[]{"torch::nn::functional::MaxUnpoolFuncOptions<3>"}).pointerTypes(new String[]{"MaxUnpool3dFuncOptions"})).put(new Info(new String[]{"torch::nn::FractionalMaxPoolOptions<1>", "torch::nn::functional::FractionalMaxPool1dFuncOptions"}).pointerTypes(new String[]{"FractionalMaxPool1dOptions"})).put(new Info(new String[]{"torch::nn::FractionalMaxPoolOptions<2>", "torch::nn::functional::FractionalMaxPool2dFuncOptions"}).pointerTypes(new String[]{"FractionalMaxPool2dOptions"})).put(new Info(new String[]{"torch::nn::FractionalMaxPoolOptions<3>", "torch::nn::functional::FractionalMaxPool3dFuncOptions"}).pointerTypes(new String[]{"FractionalMaxPool3dOptions"})).put(new Info(new String[]{"torch::nn::LPPoolOptions<1>", "torch::nn::functional::LPPool1dFuncOptions"}).pointerTypes(new String[]{"LPPool1dOptions"})).put(new Info(new String[]{"torch::nn::LPPoolOptions<2>", "torch::nn::functional::LPPool2dFuncOptions"}).pointerTypes(new String[]{"LPPool2dOptions"})).put(new Info(new String[]{"torch::nn::LPPoolOptions<3>", "torch::nn::functional::LPPool3dFuncOptions"}).pointerTypes(new String[]{"LPPool3dOptions"}));
        infoMap.put(new Info(new String[]{"torch::nn::Module::register_module<torch::nn::Module>"}).javaText("private native @Name(\"register_module<torch::nn::Module>\") void _register_module(@StdString BytePointer name, @SharedPtr @ByVal Module module);\npublic <M extends Module> M register_module(BytePointer name, M module) { asModule()._register_module(name, module.asModule()); return module; }\nprivate native @Name(\"register_module<torch::nn::Module>\") void _register_module(@StdString String name, @SharedPtr @ByVal Module module);\npublic <M extends Module> M register_module(String name, M module) { asModule()._register_module(name, module.asModule()); return module; }")).put(new Info(new String[]{"torch::nn::Module"}).upcast());
        String[] stringArray2 = virtuals = new String[]{"train", "is_training", "to", "zero_grad", "save", "load", "pretty_print", "is_serializable"};
        int n5 = stringArray2.length;
        for (n = 0; n < n5; ++n) {
            String string = stringArray2[n];
            infoMap.put(new Info(new String[]{"torch::nn::Module::" + string}).virtualize().annotations(new String[]{"@Virtual(subclasses=false, method=\"" + string + "\")"}));
        }
        infoMap.put(new Info(new String[]{"torch::nn::Module::clone"}).virtualize().annotations(new String[]{"@Virtual(subclasses=false, method=\"clone\")", "@Cast({\"\", \"std::shared_ptr<torch::nn::Module>\"})"}));
        this.mapModule(infoMap, "ModuleDict", false);
        this.mapModule(infoMap, "ModuleList", false);
        this.mapModule(infoMap, "Sequential", false);
        this.mapModule(infoMap, "ParameterDict", false);
        this.mapModule(infoMap, "ParameterList", false);
        this.mapModule(infoMap, "AdaptiveLogSoftmaxWithLoss");
        for (i = 1; i <= 3; ++i) {
            this.mapModule(infoMap, "BatchNorm" + i + "d", "torch::nn::BatchNormImplBase<" + i + ",torch::nn::BatchNorm" + i + "dImpl>", "torch::nn::NormImplBase<" + i + ",torch::nn::BatchNorm" + i + "dImpl,torch::nn::BatchNormOptions>");
            this.mapModule(infoMap, "InstanceNorm" + i + "d", "torch::nn::InstanceNormImpl<" + i + ",torch::nn::InstanceNorm" + i + "dImpl>", "torch::nn::NormImplBase<" + i + ",torch::nn::InstanceNorm" + i + "dImpl,torch::nn::InstanceNormOptions>");
            this.mapModule(infoMap, "Conv" + i + "d", "torch::nn::ConvNdImpl<" + i + ",torch::nn::Conv" + i + "dImpl>");
            this.mapModule(infoMap, "ConvTranspose" + i + "d", "torch::nn::ConvTransposeNdImpl<" + i + ",torch::nn::ConvTranspose" + i + "dImpl>", "torch::nn::ConvNdImpl<" + i + ",torch::nn::ConvTranspose" + i + "dImpl>");
            this.mapModule(infoMap, "Dropout" + (i > 1 ? i + "d" : ""), "torch::nn::detail::_DropoutNd<torch::nn::Dropout" + (i > 1 ? i + "d" : "") + "Impl>");
        }
        this.mapModule(infoMap, "AlphaDropout", "torch::nn::detail::_DropoutNd<torch::nn::AlphaDropoutImpl>");
        this.mapModule(infoMap, "FeatureAlphaDropout", "torch::nn::detail::_DropoutNd<torch::nn::FeatureAlphaDropoutImpl>");
        this.mapModule(infoMap, "CosineSimilarity");
        this.mapModule(infoMap, "PairwiseDistance");
        this.mapModule(infoMap, "Embedding");
        this.mapModule(infoMap, "EmbeddingBag");
        this.mapModule(infoMap, "Fold");
        this.mapModule(infoMap, "Unfold");
        this.mapModule(infoMap, "Identity");
        this.mapModule(infoMap, "Linear");
        this.mapModule(infoMap, "Bilinear");
        this.mapModule(infoMap, "Flatten");
        this.mapModule(infoMap, "Unflatten");
        this.mapModule(infoMap, "L1Loss");
        this.mapModule(infoMap, "KLDivLoss");
        this.mapModule(infoMap, "MSELoss");
        this.mapModule(infoMap, "BCELoss");
        this.mapModule(infoMap, "HingeEmbeddingLoss");
        this.mapModule(infoMap, "MultiMarginLoss");
        this.mapModule(infoMap, "CosineEmbeddingLoss");
        this.mapModule(infoMap, "SmoothL1Loss");
        this.mapModule(infoMap, "HuberLoss");
        this.mapModule(infoMap, "MultiLabelMarginLoss");
        this.mapModule(infoMap, "SoftMarginLoss");
        this.mapModule(infoMap, "MultiLabelSoftMarginLoss");
        this.mapModule(infoMap, "TripletMarginLoss");
        this.mapModule(infoMap, "TripletMarginWithDistanceLoss");
        this.mapModule(infoMap, "CTCLoss");
        this.mapModule(infoMap, "PoissonNLLLoss");
        this.mapModule(infoMap, "MarginRankingLoss");
        this.mapModule(infoMap, "NLLLoss");
        this.mapModule(infoMap, "CrossEntropyLoss");
        this.mapModule(infoMap, "BCEWithLogitsLoss");
        for (i = 1; i <= 3; ++i) {
            this.mapModule(infoMap, "ReflectionPad" + i + "d", "torch::nn::ReflectionPadImpl<" + i + ",torch::nn::ReflectionPad" + i + "dImpl>");
            this.mapModule(infoMap, "ReplicationPad" + i + "d", "torch::nn::ReplicationPadImpl<" + i + ",torch::nn::ReplicationPad" + i + "dImpl>");
            this.mapModule(infoMap, "ConstantPad" + i + "d", "torch::nn::ConstantPadImpl<" + i + ",torch::nn::ConstantPad" + i + "dImpl>");
            this.mapModule(infoMap, "ZeroPad" + i + "d", "torch::nn::ZeroPadImpl<" + i + ",torch::nn::ZeroPad" + i + "dImpl>");
            this.mapModule(infoMap, "AvgPool" + i + "d", "torch::nn::AvgPoolImpl<" + i + ",torch::nn::AvgPool" + i + "dImpl>");
            this.mapModule(infoMap, "MaxPool" + i + "d", "torch::nn::MaxPoolImpl<" + i + ",torch::nn::MaxPool" + i + "dImpl>");
            this.mapModule(infoMap, "AdaptiveAvgPool" + i + "d", "torch::nn::AdaptiveAvgPoolImpl<" + i + ",torch::ExpandingArray" + (i > 1 ? "WithOptionalElem<" : "<") + i + ">,torch::nn::AdaptiveAvgPool" + i + "dImpl>");
            this.mapModule(infoMap, "AdaptiveMaxPool" + i + "d", "torch::nn::AdaptiveMaxPoolImpl<" + i + ",torch::ExpandingArray" + (i > 1 ? "WithOptionalElem<" : "<") + i + ">,torch::nn::AdaptiveMaxPool" + i + "dImpl>");
            this.mapModule(infoMap, "MaxUnpool" + i + "d", "torch::nn::MaxUnpoolImpl<" + i + ",torch::nn::MaxUnpool" + i + "dImpl>");
            if (i > 1) {
                this.mapModule(infoMap, "FractionalMaxPool" + i + "d", "torch::nn::FractionalMaxPoolImpl<" + i + ",torch::nn::FractionalMaxPool" + i + "dImpl>");
            }
            if (i >= 3) continue;
            this.mapModule(infoMap, "LPPool" + i + "d", "torch::nn::LPPoolImpl<" + i + ",torch::nn::LPPool" + i + "dImpl>");
        }
        this.mapModule(infoMap, "RNN", "torch::nn::detail::RNNImplBase<torch::nn::RNNImpl>");
        this.mapModule(infoMap, "LSTM", "torch::nn::detail::RNNImplBase<torch::nn::LSTMImpl>");
        this.mapModule(infoMap, "GRU", "torch::nn::detail::RNNImplBase<torch::nn::GRUImpl>");
        this.mapModule(infoMap, "RNNCell", "torch::nn::detail::RNNCellImplBase<torch::nn::RNNCellImpl>");
        this.mapModule(infoMap, "LSTMCell", "torch::nn::detail::RNNCellImplBase<torch::nn::LSTMCellImpl>");
        this.mapModule(infoMap, "GRUCell", "torch::nn::detail::RNNCellImplBase<torch::nn::GRUCellImpl>");
        this.mapModule(infoMap, "PixelShuffle");
        this.mapModule(infoMap, "PixelUnshuffle");
        this.mapModule(infoMap, "Upsample");
        this.mapModule(infoMap, "ELU");
        this.mapModule(infoMap, "SELU");
        this.mapModule(infoMap, "Hardshrink");
        this.mapModule(infoMap, "Hardtanh");
        this.mapModule(infoMap, "LeakyReLU");
        this.mapModule(infoMap, "LogSigmoid");
        this.mapModule(infoMap, "Softmax");
        this.mapModule(infoMap, "Softmin");
        this.mapModule(infoMap, "LogSoftmax");
        this.mapModule(infoMap, "Softmax2d");
        this.mapModule(infoMap, "PReLU");
        this.mapModule(infoMap, "ReLU");
        this.mapModule(infoMap, "ReLU6");
        this.mapModule(infoMap, "RReLU");
        this.mapModule(infoMap, "CELU");
        this.mapModule(infoMap, "GLU");
        this.mapModule(infoMap, "GELU");
        this.mapModule(infoMap, "SiLU");
        this.mapModule(infoMap, "Mish");
        this.mapModule(infoMap, "Sigmoid");
        this.mapModule(infoMap, "Softplus");
        this.mapModule(infoMap, "Softshrink");
        this.mapModule(infoMap, "Softsign");
        this.mapModule(infoMap, "Tanh");
        this.mapModule(infoMap, "Tanhshrink");
        this.mapModule(infoMap, "Threshold");
        this.mapModule(infoMap, "MultiheadAttention");
        this.mapModule(infoMap, "LayerNorm");
        this.mapModule(infoMap, "LocalResponseNorm");
        this.mapModule(infoMap, "CrossMapLRN2d");
        this.mapModule(infoMap, "GroupNorm");
        this.mapModule(infoMap, "TransformerEncoderLayer");
        this.mapModule(infoMap, "TransformerDecoderLayer");
        this.mapModule(infoMap, "TransformerEncoder");
        this.mapModule(infoMap, "TransformerDecoder");
        this.mapModule(infoMap, "Transformer");
        infoMap.put(new Info(new String[]{"torch::nn::AnyModule::any_forward"}).javaText("public native @ByVal AnyValue any_forward(@Const @ByRef AnyValue input);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6, @Const @ByRef Tensor input7, @Const @ByRef Tensor input8);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @ByRef(nullValue = \"c10::optional<at::IntArrayRef>(c10::nullopt)\") @Cast({\"int64_t*\", \"c10::ArrayRef<int64_t>\", \"std::vector<int64_t>&\"}) @StdVector long... output_size);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @Const @ByRef(nullValue = \"c10::optional<at::IntArrayRef>(c10::nullopt)\") LongArrayRefOptional output_size);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @Const @ByRef Tensor indices, @Const @ByRef(nullValue = \"c10::optional<std::vector<int64_t> >(c10::nullopt)\") LongVectorOptional output_size);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @ByVal(nullValue = \"torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}\") T_TensorTensor_TOptional hx_opt);\npublic native @ByVal AnyValue any_forward(@Const @ByRef Tensor query, @Const @ByRef Tensor key, @Const @ByRef Tensor value, @Const @ByRef(nullValue = \"torch::Tensor{}\") Tensor key_padding_mask, @Cast(\"bool\") boolean need_weights/*=true*/, @Const @ByRef(nullValue = \"torch::Tensor{}\") Tensor attn_mask, @Cast(\"bool\") boolean average_attn_weights/*=true*/);\n")).put(new Info(new String[]{"torch::nn::AnyModule::forward", "torch::nn::SequentialImpl::forward"}).javaText("public native @ByVal Tensor forward(@Const @ByRef Tensor input);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6, @Const @ByRef Tensor input7, @Const @ByRef Tensor input8);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input, @ByRef(nullValue = \"c10::optional<at::IntArrayRef>(c10::nullopt)\") @Cast({\"int64_t*\", \"c10::ArrayRef<int64_t>\", \"std::vector<int64_t>&\"}) @StdVector long... output_size);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input, @Const @ByRef(nullValue = \"c10::optional<at::IntArrayRef>(c10::nullopt)\") LongArrayRefOptional output_size);\npublic native @ByVal Tensor forward(@Const @ByRef Tensor input, @Const @ByRef Tensor indices, @Const @ByRef(nullValue = \"c10::optional<std::vector<int64_t> >(c10::nullopt)\") LongVectorOptional output_size);\npublic native @ByVal @Name(\"forward<std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor>>>\") T_TensorT_TensorTensor_T_T forwardT_TensorT_TensorTensor_T_T(@Const @ByRef Tensor input);\npublic native @ByVal @Name(\"forward<std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor>>>\") T_TensorT_TensorTensor_T_T forwardT_TensorT_TensorTensor_T_T(@Const @ByRef Tensor input, @ByVal(nullValue = \"torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}\") T_TensorTensor_TOptional hx_opt);\npublic native @ByVal @Name(\"forward<std::tuple<torch::Tensor,torch::Tensor>>\") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input);\npublic native @ByVal @Name(\"forward<std::tuple<torch::Tensor,torch::Tensor>>\") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);\npublic native @ByVal @Name(\"forward<std::tuple<torch::Tensor,torch::Tensor>>\") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);\npublic native @ByVal @Name(\"forward<std::tuple<torch::Tensor,torch::Tensor>>\") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input, @ByVal(nullValue = \"torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}\") T_TensorTensor_TOptional hx_opt);\npublic native @ByVal @Name(\"forward<std::tuple<torch::Tensor,torch::Tensor>>\") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor query, @Const @ByRef Tensor key, @Const @ByRef Tensor value, @Const @ByRef(nullValue = \"torch::Tensor{}\") Tensor key_padding_mask, @Cast(\"bool\") boolean need_weights/*=true*/, @Const @ByRef(nullValue = \"torch::Tensor{}\") Tensor attn_mask, @Cast(\"bool\") boolean average_attn_weights/*=true*/);\npublic native @ByVal @Name(\"forward<torch::nn::ASMoutput>\") ASMoutput forwardASMoutput(@Const @ByRef Tensor input, @Const @ByRef Tensor target);\n"));
        for (String[] stringArray3 : new String[][]{{"at::Tensor", "Tensor"}, {"torch::nn::ASMoutput", "ASMoutput"}, {"std::tuple<at::Tensor,at::Tensor>", "T_TensorTensor_T"}, {"std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor> >", "T_TensorT_TensorTensor_T_T"}}) {
            infoMap.put(new Info(new String[]{torch.template("torch::nn::AnyValue::get", stringArray3[0])}).javaNames(new String[]{"get" + stringArray3[1]})).put(new Info(new String[]{torch.template("torch::nn::AnyValue::try_get", stringArray3[0])}).javaNames(new String[]{"try_get" + stringArray3[1]}));
        }
        for (String[] stringArray4 : new PointerInfo[]{new PointerInfo("torch::jit::Graph"), new PointerInfo("torch::jit::Operator"), new PointerInfo("torch::jit::Resolver"), new PointerInfo("c10::ClassType"), new PointerInfo("c10::TensorType").otherCppNames("c10::TensorTypePtr", "at::TensorTypePtr", "torch::TensorTypePtr"), new PointerInfo("torch::nn::Module"), new PointerInfo("const at::functorch::FuncTorchTLSBase"), new PointerInfo("const torch::jit::CompilationUnit"), new PointerInfo("torch::jit::SugaredValue")}) {
            stringArray4.makeShared(infoMap);
        }
        for (String[] stringArray5 : new String[]{"Adagrad", "Adam", "AdamW", "LBFGS", "RMSprop", "SGD"}) {
            infoMap.put(new Info(new String[]{"torch::optim::" + (String)stringArray5 + "Options", "torch::optim::" + (String)stringArray5 + "ParamState"})).put(new Info(new String[]{"torch::optim::OptimizerCloneableOptions<torch::optim::" + (String)stringArray5 + "Options>"}).pointerTypes(new String[]{"OptimizerCloneable" + (String)stringArray5 + "Options"})).put(new Info(new String[]{"torch::optim::OptimizerCloneableParamState<torch::optim::" + (String)stringArray5 + "ParamState>"}).pointerTypes(new String[]{"OptimizerCloneable" + (String)stringArray5 + "ParamState"}));
            new PointerInfo("torch::optim::" + (String)stringArray5 + "Options").makeUnique(infoMap);
            new PointerInfo("torch::optim::OptimizerCloneableParamState<torch::optim::" + (String)stringArray5 + "ParamState>").javaBaseName("OptimizerCloneable" + (String)stringArray5 + "AdagradParamState").makeUnique(infoMap);
            new PointerInfo("torch::optim::OptimizerCloneableOptions<torch::optim::" + (String)stringArray5 + "Options>").javaBaseName("OptimizerCloneable" + (String)stringArray5 + "Options").makeUnique(infoMap);
            new PointerInfo("torch::optim::" + (String)stringArray5 + "Options").makeUnique(infoMap);
            new PointerInfo("torch::optim::" + (String)stringArray5 + "ParamState").makeUnique(infoMap);
        }
        for (String[] stringArray6 : new PointerInfo[]{new PointerInfo("torch::optim::OptimizerOptions"), new PointerInfo("torch::optim::OptimizerParamState"), new PointerInfo("torch::autograd::AutogradMeta"), new PointerInfo("torch::jit::GraphAttr"), new PointerInfo("torch::jit::Graph"), new PointerInfo("c10::NamedTensorMeta"), new PointerInfo("c10::FunctionSchema"), new PointerInfo("c10::SafePyObject"), new PointerInfo("at::CPUGeneratorImpl"), new PointerInfo("at::TensorIterator"), new PointerInfo("caffe2::serialize::IStreamAdapter"), new PointerInfo("torch::autograd::FunctionPreHook"), new PointerInfo("torch::autograd::FunctionPostHook")}) {
            stringArray6.makeUnique(infoMap);
        }
        infoMap.put(new Info(new String[]{"std::unique_ptr<torch::jit::AttributeValue>", "torch::jit::GraphAttr::Ptr"}).annotations(new String[]{"@UniquePtr"}).pointerTypes(new String[]{"AttributeValue"})).put(new Info(new String[]{"torch::autograd::AutogradMeta::post_acc_grad_hooks_"}).annotations(new String[]{"@UniquePtr", "@Cast({\"\", \"\", \"std::unique_ptr<torch::autograd::PostAccumulateGradHook>&&\"})"}));
        infoMap.put(new Info(new String[]{"c10::MaybeOwnedTraitsGenericImpl<std::shared_ptr<at::Tensor> >::assignBorrow", "c10::MaybeOwnedTraitsGenericImpl<std::shared_ptr<at::Tensor> >::destroyBorrow", "torch::autograd::profiler::ProfilerResult", "torch::profiler::impl::ProfilerEventStub", "torch::autograd::profiler::enableProfiler", "torch::autograd::profiler::enableProfilerWithEventPostProcess", "torch::profiler::impl::ProfilerStateBase", "torch::profiler::impl::ProfilerStubs", "torch::autograd::profiler::KinetoEvent", "at::Tensor::wrap_tensor_impl(c10::TensorImpl*)", "c10::impl::list_element_to_const_ref", "c10::unpackSymInt(at::OptionalSymIntArrayRef)", "c10::detail::infer_schema::make_function_schema(std::string&&, std::string&&, c10::ArrayRef<c10::detail::infer_schema::ArgumentDef>, c10::ArrayRef<c10::detail::infer_schema::ArgumentDef>)", "torch::autograd::_wrap_outputs", "torch::autograd::Node::retains_grad_hooks", "c10::impl::GPUTrace", "torch::jit::IterableTree", "c10::cuda::CaptureStatus", "c10::IValue::repr", "c10::IValue::visit", "at::TensorIteratorBase::foreach_reduced_elt", "at::TensorIteratorBase::parallel_reduce", "at::TensorIteratorBase::serial_for_each", "at::TensorIteratorBase::for_each", "torch::autograd::get_current_graph_task_exec_info"}).skip());
        for (String[] stringArray7 : new String[]{"c10::DDPLoggingData::strs_map", "c10::DDPLoggingData::ints_map", "torch::jit::Object::Property::setter_func", "torch::jit::Object::Property::getter_func", "torch::jit::Object::Property::name", "torch::jit::Named<torch::jit::Module>::name", "torch::jit::Named<torch::jit::Module>::value", "torch::jit::detail::SlotCursor::i_", "torch::jit::detail::SlotCursor::module_", "torch::jit::StackEntry::filename", "torch::jit::StackEntry::range", "torch::jit::Call::fn_name", "torch::jit::Call::caller_range", "c10::SymbolicShapeMeta::sizes_", "c10::SymbolicShapeMeta::strides_", "c10::SymbolicShapeMeta::numel_", "c10::SymbolicShapeMeta::storage_offset_", "c10::SymbolicShapeMeta::is_contiguous_", "c10::SymbolicShapeMeta::is_channels_last_contiguous_", "c10::SymbolicShapeMeta::is_channels_last_3d_contiguous_", "c10::SymbolicShapeMeta::is_channels_last_", "c10::SymbolicShapeMeta::is_channels_last_3d_", "c10::SymbolicShapeMeta::is_non_overlapping_and_dense_"}) {
            Info i3 = infoMap.getFirst((String)stringArray7, false);
            if (i3 == null) {
                i3 = new Info(new String[]{stringArray7});
                infoMap.put(i3);
            }
            i3.annotations(new String[]{"@NoOffset"});
        }
        infoMap.put(new Info(new String[]{"caffe2::TypeIdentifier", "c10::util::crc64_t", "c10::util::type_index"}).base("Pointer"));
        infoMap.put(new Info(new String[]{"at::RecordFunction::_setAsync", "at::RecordFunction::_setStaticRuntimeOutVariant", "at::Tensor(c10::TensorImpl*)", "at::Tensor::_set_fw_grad", "at::Tensor::_fw_grad", "at::TensorBase(c10::intrusive_ptr<at::TensorImpl,c10::UndefinedTensorImpl>", "at::TensorBase::_set_fw_grad", "at::TensorBase::_fw_grad", "at::TensorImpl::_set_fw_grad", "at::TensorImpl::_fw_grad", "c10::KernelFunction::_equalsBoxedAndUnboxed", "c10::RegisterOperators::Options::catchAllKernel()", "c10::RegisterOperators::Options::kernel(c10::DispatchKey)", "c10::RegisterOperators::Options::schema(c10::FunctionSchema&&)", "c10::RegisterOperators::op(c10::FunctionSchema,c10::Options&&)", "c10::ThreadLocalDebugInfo::_forceCurrentDebugInfo", "c10::impl::_force_tls_local_dispatch_key_set", "torch::jit::CompilationUnit::_clear_python_cu", "torch::jit::GraphFunction::_set_initial_executor_execution_mode", "torch::jit::GraphFunction::_set_ignore_amp", "c10::detail::_str"}).skip());
        infoMap.put(new Info(new String[]{"c10::detail::deprecated_AT_ERROR", "c10::detail::deprecated_AT_ASSERT", "c10::detail::deprecated_AT_ASSERTM", "detail::deprecated_AT_DISPATCH_ALL_TYPES_AND_HALF", "detail::deprecated_AT_DISPATCH_ALL_TYPES_AND_HALF_AND_COMPLEX", "detail::scalar_type(const at::DeprecatedTypeProperties&)", "at::DeprecatedTypeProperties", "c10::Scalar::isIntegral()", "c10::isIntegralType(c10::ScalarType)", "at::Tensor::type()", "at::Tensor::is_variable()"}).skip());
        infoMap.put(new Info(new String[]{"c10::RegisterOperators::Options", "c10::impl::device_guard_impl_registry", "torch::autograd::graph_task_id", "c10::getLessThanComparator", "c10::getGreaterThanComparator"}).skip());
        infoMap.put(new Info(new String[]{"at::native::RNNDescriptor::dropout_desc_"}).skip());
        infoMap.put(new Info(new String[]{"c10_complex_math::_detail::sqrt", "c10_complex_math::_detail::acos", "c10::__ldg", "c10::impl::raw_local_dispatch_key_set"}).skip());
        infoMap.put(new Info(new String[]{"at::SplitUntil32Bit::iterator::vec", "c10::ArrayRef<c10::detail::infer_schema::ArgumentDef>::equals", "c10::ArrayRef<torch::jit::NamedValue>::equals", "c10::ArrayRef<at::Scalar>::equals", "c10::ArrayRef<torch::TensorArg>::equals", "c10::ArrayRef<torch::Tensor>::equals", "c10::ArrayRef<at::indexing::TensorIndex>::equals", "c10::ArrayRef<c10::optional<at::Tensor> >::equals"}).skip());
        infoMap.put(new Info(new String[]{"c10::ComplexType::get"}).javaNames(new String[]{"getComplexTypePtr"})).put(new Info(new String[]{"c10::FloatType::get"}).javaNames(new String[]{"getFloatTypePtr"})).put(new Info(new String[]{"c10::IntType::get"}).javaNames(new String[]{"getIntTypePtr"})).put(new Info(new String[]{"c10::NumberType::get"}).javaNames(new String[]{"getNumberIntTypePtr"})).put(new Info(new String[]{"c10::GeneratorImpl::clone"}).javaNames(new String[]{"clonePtr"})).put(new Info(new String[]{"c10::IValue::toString", "at::IValue::toString"}).javaNames(new String[]{"toConstantString"})).put(new Info(new String[]{"torch::jit::TreeView::get"}).skip()).put(new Info(new String[]{"torch::cuda::device_count"}).javaNames(new String[]{"cuda_device_count"})).put(new Info(new String[]{"torch::cuda::is_available"}).javaNames(new String[]{"cuda_is_available"})).put(new Info(new String[]{"torch::cuda::manual_seed"}).javaNames(new String[]{"cuda_manual_seed"})).put(new Info(new String[]{"torch::cuda::manual_seed_all"}).javaNames(new String[]{"cuda_manual_seed_all"})).put(new Info(new String[]{"torch::cuda::synchronize"}).javaNames(new String[]{"cuda_synchronize"})).put(new Info(new String[]{"torch::jit::Const"}).pointerTypes(new String[]{"ConstExpr"})).put(new Info(new String[]{"torch::jit::Node"}).pointerTypes(new String[]{"JitNode"})).put(new Info(new String[]{"torch::jit::Module"}).pointerTypes(new String[]{"JitModule"})).put(new Info(new String[]{"torch::jit::Object"}).pointerTypes(new String[]{"JitObject"})).put(new Info(new String[]{"torch::jit::String"}).pointerTypes(new String[]{"JitString"}));
        for (String[] stringArray8 : new String[]{"exp", "log", "log10", "log2", "sqrt", "pow", "sin", "cos", "tan", "asin", "acos", "atan", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "log1p"}) {
            infoMap.put(new Info(new String[]{"c10_complex_math::" + (String)stringArray8 + "<float>"}).javaNames(new String[]{stringArray8})).put(new Info(new String[]{"c10_complex_math::" + (String)stringArray8 + "<double>"}).javaNames(new String[]{stringArray8})).put(new Info(new String[]{"at::" + (String)stringArray8}).javaNames(new String[]{stringArray8}));
        }
        infoMap.put(new Info(new String[]{"ska::detailv3::log2"}).javaNames(new String[]{"log2"})).put(new Info(new String[]{"c10_complex_math::pow(c10::complex<T>&, c10::complex<U>&)"}).javaText("@Namespace(\"c10_complex_math\") public static native @ByVal @Name(\"pow<double,float>\") DoubleComplex pow(@Const @ByRef DoubleComplex x, @Const @ByRef FloatComplex y);\n@Namespace(\"c10_complex_math\") public static native @ByVal @Name(\"pow<float,double>\") DoubleComplex pow(@Const @ByRef FloatComplex x, @Const @ByRef DoubleComplex y);\n")).put(new Info(new String[]{"c10_complex_math::pow(c10::complex<T>&, U&)"}).javaText("@Namespace(\"c10_complex_math\") public static native @ByVal @Name(\"pow<double,float>\") DoubleComplex pow(@Const @ByRef DoubleComplex x, @Const @ByRef float y);\n@Namespace(\"c10_complex_math\") public static native @ByVal @Name(\"pow<float,double>\") DoubleComplex pow(@Const @ByRef FloatComplex x, @Const @ByRef double y);\n")).put(new Info(new String[]{"c10_complex_math::pow(T&, c10::complex<U>&)"}).javaText("@Namespace(\"c10_complex_math\") public static native @ByVal @Name(\"pow<double,float>\") DoubleComplex pow(@Const @ByRef double x, @Const @ByRef FloatComplex y);\n@Namespace(\"c10_complex_math\") public static native @ByVal @Name(\"pow<float,double>\") DoubleComplex pow(@Const @ByRef float x, @Const @ByRef DoubleComplex y);\n")).put(new Info(new String[]{"c10::util::get_type_index<std::string>"}).javaNames(new String[]{"get_type_index_string"})).put(new Info(new String[]{"at::TensorBase::data_ptr<bool>"}).javaNames(new String[]{"data_ptr_bool"})).put(new Info(new String[]{"at::TensorBase::data_ptr<int8_t>"}).javaNames(new String[]{"data_ptr_char"})).put(new Info(new String[]{"at::TensorBase::data_ptr<uint8_t>"}).javaNames(new String[]{"data_ptr_byte"})).put(new Info(new String[]{"at::TensorBase::data_ptr<int16_t>"}).javaNames(new String[]{"data_ptr_short"})).put(new Info(new String[]{"at::TensorBase::data_ptr<int>"}).javaNames(new String[]{"data_ptr_int"})).put(new Info(new String[]{"at::TensorBase::data_ptr<int64_t>"}).javaNames(new String[]{"data_ptr_long"})).put(new Info(new String[]{"at::TensorBase::data_ptr<float>"}).javaNames(new String[]{"data_ptr_float"})).put(new Info(new String[]{"at::TensorBase::data_ptr<double>"}).javaNames(new String[]{"data_ptr_double"})).put(new Info(new String[]{"at::Tensor::item<bool>"}).javaNames(new String[]{"item_bool"})).put(new Info(new String[]{"at::Tensor::item<int8_t>"}).javaNames(new String[]{"item_char"})).put(new Info(new String[]{"at::Tensor::item<uint8_t>"}).javaNames(new String[]{"item_byte"})).put(new Info(new String[]{"at::Tensor::item<int16_t>"}).javaNames(new String[]{"item_short"})).put(new Info(new String[]{"at::Tensor::item<int>"}).javaNames(new String[]{"item_int"})).put(new Info(new String[]{"at::Tensor::item<int64_t>"}).javaNames(new String[]{"item_long"})).put(new Info(new String[]{"at::Tensor::item<float>"}).javaNames(new String[]{"item_float"})).put(new Info(new String[]{"at::Tensor::item<double>"}).javaNames(new String[]{"item_double"})).put(new Info(new String[]{"at::make_generator"}).javaText("@Namespace(\"at\") public static native @ByVal @Name(\"make_generator<at::CPUGeneratorImpl>\") Generator make_generator_cpu();\n@Namespace(\"at\") public static native @ByVal @Name(\"make_generator<at::CPUGeneratorImpl,uint64_t>\") Generator make_generator_cpu(@Cast(\"uint64_t&&\") long seed_in);")).put(new Info(new String[]{"c10::TensorOptions::TensorOptions<c10::Device>"}).javaNames(new String[]{"XXX"}));
        for (String[] stringArray9 : new String[][]{{"c10::qint8", "qint8"}, {"c10::quint8", "quint8"}, {"c10::qint32", "quint32"}, {"c10::quint4x2", "quint4x2"}, {"c10::quint2x4", "quint2x4"}, {"int8_t", "byte"}, {"int16_t", "short"}, {"int", "int"}, {"int64_t", "long"}, {"at::Half", "Half"}, {"float", "float"}, {"double", "double"}, {"c10::complex<float>", "ComplexFloat"}, {"c10::complex<double>", "ComplexDouble"}, {"bool", "boolean"}, {"at::BFloat16", "BFloat16"}, {"at::Float8_e4m3fn", "Float8_e4m3fn"}, {"at::Float8_e5m2", "Float8_e5m2"}}) {
            infoMap.put(new Info(new String[]{torch.template("c10::fetch_and_cast", stringArray9[0])}).javaNames(new String[]{"fetch_and_cast_to_" + stringArray9[1]})).put(new Info(new String[]{torch.template("c10::cast_and_store", stringArray9[0])}).javaNames(new String[]{"cast_and_store_from_" + stringArray9[1]}));
        }
        infoMap.put(new Info(new String[]{"c10::basic_string_view<char>", "c10::string_view"}).annotations(new String[]{"@StringView"}).valueTypes(new String[]{"BytePointer", "String"}));
        infoMap.put(new Info(new String[]{"c10::ThreadPoolRegistry()", "c10::CUDAHooksRegistry()"}).skip());
        infoMap.put(new Info(new String[]{"c10::Argument"}).pointerTypes(new String[]{"Argument"}));
        infoMap.put(new Info(new String[]{"CUevent_st", "mz_zip_archive", "ModuleHolderIndicator", "at::MTIAHooksArgs", "at::ObserverContext", "at::Range", "at::StepCallbacks::StartEndPair", "at::TensorBase::unsafe_borrow_t", "at::internal::OpaqueOptionalTensorRef", "at::impl::VariableHooksRegisterer", "at::TensorRef", "at::OptionalTensorRef", "at::tracer::impl::NoTracerDispatchMode", "c10::_CopyBytesFunctionRegisterer", "c10::AlignedCharArray<1,Size>::", "c10::AlignedCharArray<2,Size>::", "c10::AlignedCharArray<4,Size>::", "c10::AlignedCharArray<8,Size>::", "c10::Capsule", "c10::DeviceGuard", "c10::DispatchTraceNestingGuard", "c10::Dispatcher::OperatorDef", "c10::DynamicType", "c10::DynamicType::", "c10::DynamicType::Arguments", "c10::DynamicType::LabeledDynamicType", "c10::DynamicTypeTrait<c10::TensorType>", "c10::Event", "c10::ExclusivelyOwned::", "c10::IListRef::Payload", "c10::IListRefIterator::Payload", "c10::IValue::CompAliasedIValues", "c10::IValue::HashAliasedIValue", "c10::IValue::Payload", "c10::IValue::Payload::TriviallyCopyablePayload", "c10::IValue::Payload::TriviallyCopyablePayload::", "c10::MaybeOwnedTraits", "c10::MultiStreamGuard", "c10::OpTableOffsetAndMask", "c10::OperatorNameView", "c10::OptionalStreamGuard", "c10::PyHandleCache", "c10::RegisterOperators::Options::KernelRegistrationConfig", "c10::Registry<std::string,std::shared_ptr<c10::TaskThreadPoolBase>,int>", "c10::Registry<std::string,std::unique_ptr<at::CUDAHooksInterface>,at::CUDAHooksArgs>", "c10::Registry<std::string,std::unique_ptr<at::HIPHooksInterface>,at::HIPHooksArgs>", "c10::Registry<std::string,std::unique_ptr<at::MPSHooksInterface>,at::MPSHooksArgs>", "c10::Registry<std::string,std::unique_ptr<at::ORTHooksInterface>,at::ORTHooksArgs>", "c10::SchemaRegistrationHandleRAII", "c10::Scalar::v_t", "c10::StreamGuard", "c10::Type::SingletonOrSharedTypePtr::Repr", "c10::Type::SingletonOrSharedTypePtr::Repr::RawRepr", "c10::Type::SingletonOrSharedTypePtr::Repr::SingletonRepr", "c10::Type::SingletonOrSharedTypePtr::SharedPtrWrapper", "c10::Type::SingletonOrSharedTypePtr<c10::Type>::Repr", "c10::Type::SingletonOrSharedTypePtr<c10::Type>::Repr::RawRepr", "c10::Type::SingletonOrSharedTypePtr<c10::Type>::Repr::SingletonRepr", "c10::Type::SingletonOrSharedTypePtr<c10::Type>::SharedPtrWrapper", "c10::TypeFactoryBase<c10::DynamicType>", "c10::VarType", "c10::VariableVersion::VersionCounter", "c10::arrayref_optional_base::storage", "c10::arrayref_optional_base::storage::raw", "c10::bad_optional_access", "c10::basic_string_view::charIsEqual_", "c10::basic_string_view::charIsNotEqual_", "c10::basic_string_view::stringViewContainsChar_", "c10::basic_string_view::stringViewDoesNotContainChar_", "c10::basic_string_view<char>", "c10::basic_string_view<char>::charIsEqual_", "c10::basic_string_view<char>::charIsNotEqual_", "c10::basic_string_view<char>::stringViewContainsChar_", "c10::basic_string_view<char>::stringViewDoesNotContainChar_", "c10::detail::DictKeyEqualTo", "c10::detail::DictKeyHash", "c10::detail::ListElementFrom<c10::IValue>", "c10::detail::ListImpl", "c10::detail::LoadImpl<bool>", "c10::detail::_guarded_unsigned_long_unique_dummy", "c10::detail::_str_wrapper<std::string>", "c10::detail::getTypePtr_<at::IValue>", "c10::detail::infer_schema::createReturns<void,void>", "c10::detail::infer_schema::createReturns<std::tuple<>,void><void>", "c10::detail::ivalue_to_const_ref_overload_return<at::Tensor>", "c10::detail::RegistrationListenerList", "c10::either::", "c10::either<c10::OperatorName,c10::FunctionSchema>", "c10::either<c10::OperatorName,c10::FunctionSchema>::", "c10::guts::conjunction", "c10::guts::detail::DummyClassForToString", "c10::guts::detail::__array_traits<_Tp,0>::_Type", "c10::guts::detail::_identity", "c10::guts::detail::_if_constexpr<true>", "c10::guts::disjunction", "c10::guts::typelist::concat<>", "c10::guts::typelist::concat<c10::guts::typelist::typelist<> >", "c10::guts::typelist::concat<c10::guts::typelist::typelist<> ><>", "c10::guts::typelist::reverse<c10::guts::typelist::typelist<> >", "c10::guts::typelist::concat<c10::guts::typelist::typelist<>,c10::guts::typelist::typelist<> >", "c10::guts::typelist::concat<c10::guts::typelist::typelist<>,c10::guts::typelist::typelist<> ><>", "c10::hash<std::tuple<> >::tuple_hash<0><std::tuple<> >", "c10::hash<std::tuple<> >::tuple_hash<std::tuple<> >", "c10::impl::AnnotatedSchema", "c10::impl::ListElementConstReferenceTraits<c10::optional<std::string> >", "c10::impl::SizesAndStrides::", "c10::impl::VirtualGuardImpl", "c10::impl::decay_if_not_tensor<at::Tensor&>", "c10::impl::is_mutable_tensor_ref<at::Tensor&>", "c10::in_place_t", "c10::ivalue::ComplexHolder", "c10::ivalue::Object", "c10::ivalue::StreamData3Holder", "c10::ivalue::TupleElements::", "c10::ivalue::TupleTypeFactory<c10::TupleType>", "c10::once_flag", "c10::sha1", "c10::static_cast_with_inter_type<c10::complex<c10::Half>,c10::BFloat16>", "c10::trivial_init_t", "caffe2::detail::_Uninitialized", "caffe2::detail::TypeMetaData", "ska::detailv3::sherwood_v3_entry::", "ska::detailv3::sherwood_v3_table::convertible_to_iterator", "ska::fibonacci_hash_policy", "ska::power_of_two_hash_policy", "ska::prime_number_hash_policy", "ska_ordered::fibonacci_hash_policy", "ska_ordered::prime_number_hash_policy", "ska_ordered::detailv3::sherwood_v3_entry::", "ska_ordered::detailv3::sherwood_v3_table::convertible_to_iterator", "ska_ordered::order_preserving_flat_hash_map::convertible_to_value", "ska_ordered::power_of_two_hash_policy", "std::hash<c10::Device>", "std::hash<c10::DeviceType>", "std::hash<c10::Stream>", "std::hash<c10::Symbol>", "torch::Indices", "torch::MakeIndices<0>", "torch::NoInferSchemaTag", "torch::all_of", "torch::any_of<>", "torch::autograd::CppFunctionSingleTensorPreHook", "torch::autograd::CppFunctionTensorPreHook", "torch::autograd::GraphTask", "torch::autograd::GraphTask::ExecInfo", "torch::autograd::GraphTask::ExecInfo::Capture", "torch::autograd::GraphTask::ExecInfo::Capture::GradCaptureHook", "torch::autograd::GraphTaskGuard", "torch::autograd::InputBuffer", "torch::autograd::InputMetadata", "torch::autograd::NodeGuard", "torch::autograd::ReadyQueue", "torch::autograd::TraceableFunction", "torch::autograd::TypeAndSize", "torch::autograd::SavedVariable", "torch::autograd::VariableHooks", "torch::data::DataLoaderBase::Job", "torch::data::DataLoaderBase::QuitWorker", "torch::data::DataLoaderBase::Result", "torch::data::DataLoaderBase::Sequenced", "torch::data::WorkerException", "torch::data::datasets::detail::BatchDataBuffer::UnwrappedBatchData", "torch::detail::ClassNotSelected", "torch::detail::TorchLibraryInit", "torch::enumtype::_compute_enum_name", "torch::jit::CompleteArgumentInfo", "torch::jit::CompleteArgumentInfoPOD", "torch::jit::CompleteArgumentSpec", "torch::jit::IRAttributeError", "torch::jit::InterpreterContinuation", "torch::jit::InterpreterState", "torch::jit::InterpreterStateImpl", "torch::jit::Lexer", "torch::jit::Operator::C10Operator", "torch::jit::Operator::JitOnlyOperator", "torch::jit::Operator::UnparsedFunctionSchema", "torch::jit::OwnedSourceRange", "torch::jit::RecursiveMethodCallError", "torch::jit::StrongFunctionPtr", "torch::jit::Suspend", "torch::jit::TokenTrie", "torch::jit::TaggedRange", "torch::jit::WithCurrentScope", "torch::jit::WithInsertPoint", "torch::jit::variable_tensor_list", "torch::nn::AnyModuleHolder::CheckedGetter", "torch::nn::AnyModuleHolder::InvokeForward", "torch::nn::AnyModulePlaceholder", "torch::nn::AnyValue::Placeholder", "torch::nn::NamedAnyModule", "torch::nn::functions::CrossMapLRN2d", "torch::profiler::impl::HashCombine", "torch::profiler::impl::kineto::ActivityTraceWrapper", "torch::profiler::impl::ProfilerVoidEventStub", "torch::autograd::_jvp_fn_t", "torch::autograd::profiler::post_process_t", "at::StringView"}).skip());
        infoMap.put(new Info(new String[]{"at::TensorIteratorBase::apply_perm_and_mul", "at::assert_no_partial_overlap(c10::TensorImpl*, c10::TensorImpl*)", "at::impl::VariableHooksInterface::_register_hook", "at::native::get_numel_from_nested_size_tensor", "at::operator <<(std::ostream&, at::Range&)", "c10::cuda::CUDACachingAllocator::format_size", "c10::detail::makeBaseType", "c10::ivalue::Await::operator <<", "c10::ivalue::ConstantString::operator <<", "c10::ivalue::EnumHolder::is", "c10::ivalue::EnumHolder::operator <<", "c10::ivalue::EnumHolder::operator ==", "c10::ivalue::EnumHolder::unqualifiedClassName", "c10::ivalue::Future::operator <<", "c10::operator <<(std::ostream&, c10::SourceLocation&)", "caffe2::serialize::detail::getPadding", "torch::autograd::add_node_to_current_graph_task_exec_info", "torch::detail::constructSchemaOrName", "torch::jit::ClassDef::create", "torch::jit::Code::operator <<(std::ostream&, const torch::jit::Code&)", "torch::profiler::impl::getNvtxStr", "c10::merge_primitive"}).skip());
        infoMap.put(new Info(new String[]{"at::Device", "torch::Device"})).put(new Info(new String[]{"torch::Tensor", "at::Tensor"})).put(new Info(new String[]{"std::function<PyObject*(void*)>", "torch::jit::BackendMetaPtr", "std::function<void(const at::Tensor&, std::unordered_map<std::string, bool>&)>"}).pointerTypes(new String[]{"Pointer"}).cast()).put(new Info(new String[]{"c10::intrusive_ptr_target", "c10::nullopt", "c10::nullopt_t", "c10::impl::PyObjectSlot", "_object", "PyObject", "THPObjectPtr", "pyobj_list", "std::chrono::milliseconds", "std::exception_ptr", "std::type_info", "std::pair<PyObject*,PyObject*>", "std::stack<std::pair<PyObject*,PyObject*> >", "torch::autograd::utils::DelayWarningHandler", "std::is_same<torch::detail::pack<true>,torch::detail::pack<true> >", "at::cuda::NVRTC", "at::RecordFunctionCallback", "at::StepCallbacks", "THCState", "THHState", "torch::autograd::ViewInfo", "torch::jit::InlinedCallStackPtr", "InlinedCallStackPtr", "torch::jit::ScopePtr", "torch::jit::BackendDebugInfoRecorder", "torch::detail::TensorDataContainer", "at::ArrayRef<torch::detail::TensorDataContainer>", "std::shared_ptr<caffe2::serialize::PyTorchStreamReader>", "caffe2::serialize::PyTorchStreamWriter", "c10::detail::DictImpl::dict_map_type::iterator", "std::iterator<std::forward_iterator_tag,c10::impl::DictEntryRef<c10::IValue,c10::IValue,c10::detail::DictImpl::dict_map_type::iterator> >", "c10::optional<PyObject*>", "c10::optional<std::chrono::milliseconds>", "c10::intrusive_ptr<torch::CustomClassHolder>", "c10::intrusive_ptr<caffe2::Blob>", "c10::intrusive_ptr<c10::ivalue::Object>", "c10::ArrayRef<c10::intrusive_ptr<c10::ivalue::Object> >", "torch::jit::DetachedBuffer::UniqueDetachedBuffer", "c10::optional<at::StepCallbacks>", "c10::optional<c10::VaryingShape<int64_t>::ListOfOptionalElements>", "c10::optional<c10::VaryingShape<c10::Stride>::ListOfOptionalElements>", "c10::optional<torch::autograd::ViewInfo>", "c10::optional<std::reference_wrapper<const std::string> >", "c10::optional<torch::nn::TripletMarginWithDistanceLossOptions::distance_function_t>", "c10::optional<torch::nn::functional::TripletMarginWithDistanceLossFuncOptions::distance_function_t>", "std::tuple<torch::Tensor,c10::optional<std::vector<int64_t> >,c10::optional<std::vector<double> >,c10::optional<bool> >", "c10::optional<std::shared_ptr<torch::jit::CompilationUnit> >", "c10::optional<std::weak_ptr<torch::jit::CompilationUnit> >", "std::vector<std::shared_ptr<std::string> >", "std::reference_wrapper<const c10::FunctionSchema>", "std::enable_shared_from_this<torch::jit::tensorexpr::Expr>", "std::enable_shared_from_this<c10::Type>", "std::enable_shared_from_this<c10::SharedType>", "std::enable_shared_from_this<c10::SymbolicIntNode>", "std::enable_shared_from_this<torch::autograd::ForwardGrad>", "std::enable_shared_from_this<torch::autograd::GraphTask>", "std::enable_shared_from_this<GraphTask>", "std::enable_shared_from_this<torch::jit::Graph>", "std::enable_shared_from_this<torch::autograd::Node>", "std::enable_shared_from_this<torch::jit::Graph>", "std::enable_shared_from_this<torch::jit::SugaredValue>", "std::enable_shared_from_this<SugaredValue>", "std::enable_shared_from_this<torch::jit::tracer::TracingState>", "std::enable_shared_from_this<TracingState>", "std::enable_shared_from_this<torch::nn::Module>", "std::enable_shared_from_this<Module>"}).pointerTypes(new String[]{"Pointer"}).cast()).put(new Info(new String[]{"MTLCommandBuffer_t", "DispatchQueue_t"}).valueTypes(new String[]{"Pointer"}).pointerTypes(new String[]{"PointerPointer"}).skip());
        infoMap.put(new Info(new String[]{"at::Tensor::toString", "at::TensorBase::toString", "torch::Tensor::toString", "torch::TensorBase::toString", "torch::jit::Graph::toString"}).javaText("public native @StdString String toString();")).put(new Info(new String[]{"torch::jit::ProfileOp::getCallback()", "torch::jit::ProfileIValueOp::getCallback()"}).javaText("public native @ByVal @Cast(\"std::function<void(std::vector<c10::IValue>&)>*\") Pointer getCallback();")).put(new Info(new String[]{"torch::optim::AdamOptions::betas", "torch::optim::AdamWOptions::betas"}).javaText("public native @Cast(\"std::tuple<double,double>*\") @ByRef @NoException DoublePointer betas();")).put(new Info(new String[]{"torch::optim::Adagrad::step", "torch::optim::Adam::step", "torch::optim::AdamW::step", "torch::optim::LBFG::step", "torch::optim::RMSprop::step", "torch::optim::SGD::step"}).javaText("public native @ByVal Tensor step(@ByVal(nullValue = \"torch::optim::Optimizer::LossClosure(nullptr)\") LossClosure closure);\npublic native @ByVal Tensor step();\n"));
        String[] stringArray10 = abstracts = new String[]{"torch::nn::InstanceNormImpl<1,torch::nn::InstanceNorm1dImpl>", "torch::nn::InstanceNormImpl<2,torch::nn::InstanceNorm2dImpl>", "torch::nn::InstanceNormImpl<3,torch::nn::InstanceNorm3dImpl>", "torch::nn::InstanceNormImpl<3,torch::nn::InstanceNorm3dImpl>", "torch::nn::BatchNormImplBase<1,torch::nn::BatchNorm1dImpl>", "torch::nn::BatchNormImplBase<2,torch::nn::BatchNorm2dImpl>", "torch::nn::BatchNormImplBase<3,torch::nn::BatchNorm3dImpl>"};
        n = stringArray10.length;
        boolean bl2 = false;
        while (var7_49 < n) {
            String a = stringArray10[var7_49];
            infoMap.getFirst(a, false).purify();
            ++var7_49;
        }
        infoMap.put(new Info(new String[]{"at::TensorIteratorBase", "c10::NamedTensorMetaInterface"}).purify());
        infoMap.put(new Info(new String[]{"void (*)(void*)", "c10::DeleterFnPtr", "torch::Deleter", "at::ContextDeleter", "caffe2::TypeMeta::Delete", "std::function<void(void*)>"}).pointerTypes(new String[]{"PointerConsumer"}).valueTypes(new String[]{"PointerConsumer"}).skip()).put(new Info(new String[]{"void* (*)()", "caffe2::TypeMeta::New"}).pointerTypes(new String[]{"PointerSupplier"}).valueTypes(new String[]{"PointerSupplier"}).skip()).put(new Info(new String[]{"std::function<void()>"}).pointerTypes(new String[]{"Func"})).put(new Info(new String[]{"std::function<std::string(void)>"}).pointerTypes(new String[]{"StringSupplier"})).put(new Info(new String[]{"std::function<void(const std::string&)>"}).pointerTypes(new String[]{"StringConsumer"})).put(new Info(new String[]{"std::function<void(const c10::DDPLoggingData&)>", "std::function<void(const DDPLoggingData&)>"}).pointerTypes(new String[]{"DDPLogger"})).put(new Info(new String[]{"std::function<c10::TypePtr(c10::TypePtr)>"}).pointerTypes(new String[]{"TypeMapper"})).put(new Info(new String[]{"c10::detail::infer_schema::ArgumentDef::GetTypeFn"}).pointerTypes(new String[]{"TypeSupplier"}).skip()).put(new Info(new String[]{"c10::TypePtr (*)()", "c10::detail::infer_schema::ArgumentDef::GetTypeFn*"}).pointerTypes(new String[]{"TypeSupplier"}).valueTypes(new String[]{"TypeSupplier"}).skip()).put(new Info(new String[]{"std::function<torch::jit::Value*(torch::jit::Value*)>"}).pointerTypes(new String[]{"ValueMapper"})).put(new Info(new String[]{"std::function<void(torch::jit::GraphFunction&)>"}).pointerTypes(new String[]{"GraphFunctionCreator"})).put(new Info(new String[]{"torch::nn::Module::ModuleApplyFunction", "torch::nn::Module::ConstModuleApplyFunction", "std::function<void(const torch::nn::Module&)>", "std::function<void(torch::nn::Module&)>"}).pointerTypes(new String[]{"ModuleApplyFunction"})).put(new Info(new String[]{"std::function<void(const torch::jit::Module&)>", "std::function<void(torch::jit::Module&)>"}).pointerTypes(new String[]{"JitModuleApplyFunction"})).put(new Info(new String[]{"torch::nn::NamedModuleApplyFunction", "torch::nn::ConstNamedModuleApplyFunction", "std::function<void(const std::string&,const torch::nn::Module&)>", "std::function<void(const std::string&,torch::nn::Module&)>"}).pointerTypes(new String[]{"NamedModuleApplyFunction"})).put(new Info(new String[]{"torch::nn::ModulePointerApplyFunction", "std::function<void(const std::shared_ptr<torch::nn::Module>&)>"}).pointerTypes(new String[]{"SharedModuleApplyFunction"})).put(new Info(new String[]{"torch::nn::Module::NamedModulePointerApplyFunction", "std::function<void(const std::string&,const std::shared_ptr<torch::nn::Module>&)>"}).pointerTypes(new String[]{"NamedSharedModuleApplyFunction"})).put(new Info(new String[]{"std::function<void(std::vector<c10::IValue>&)>"}).pointerTypes(new String[]{"IValueVectorConsumer"})).put(new Info(new String[]{"std::function<c10::IValue()>"}).pointerTypes(new String[]{"IValueSupplier"})).put(new Info(new String[]{"std::function<size_t(uint64_t,void*,size_t)>"}).pointerTypes(new String[]{"Reader"})).put(new Info(new String[]{"std::function<size_t(const void*,size_t)>"}).pointerTypes(new String[]{"ArchiveWriter"})).put(new Info(new String[]{"std::function<void(const char*,size_t)>"}).pointerTypes(new String[]{"PickleWriter"})).put(new Info(new String[]{"std::function<size_t(char*,size_t)>"}).pointerTypes(new String[]{"PickleReader"})).put(new Info(new String[]{"std::function<c10::QualifiedName(const std::shared_ptr<c10::ClassType>&)>"}).pointerTypes(new String[]{"TypeRenamer"})).put(new Info(new String[]{"std::function<std::string(const at::Tensor&)>"}).pointerTypes(new String[]{"TensorIdGetter"})).put(new Info(new String[]{"std::function<size_t(void)>"}).pointerTypes(new String[]{"SizeTSupplier"})).put(new Info(new String[]{"std::function<torch::Tensor()>"}).pointerTypes(new String[]{"LossClosure"})).put(new Info(new String[]{"std::function<torch::Tensor(const torch::Tensor&,const torch::Tensor&)>", "torch::nn::TripletMarginWithDistanceLossOptions::distance_function_t", "torch::nn::functional::TripletMarginWithDistanceLossFuncOptions::distance_function_t"}).pointerTypes(new String[]{"DistanceFunction"})).put(new Info(new String[]{"std::function<void(void*,const void*,size_t)>"}).pointerTypes(new String[]{"MemCopyFunction"})).put(new Info(new String[]{"std::function<void(std::function<void()>)>"}).pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"at::TensorBase::register_hook<std::function<void(at::TensorBase)> >"}).javaNames(new String[]{"register_hook"})).put(new Info(new String[]{"at::TensorBase::register_hook<std::function<at::TensorBase(at::TensorBase)> >"}).javaNames(new String[]{"register_hook"})).put(new Info(new String[]{"std::function<void(at::TensorBase)>"}).pointerTypes(new String[]{"VoidTensorHook"})).put(new Info(new String[]{"std::function<at::TensorBase(at::TensorBase)>"}).pointerTypes(new String[]{"TensorTensorHook"})).put(new Info(new String[]{"std::function<at::TensorBase(const at::TensorBase&)>"}).pointerTypes(new String[]{"TensorTensorRefHook"})).put(new Info(new String[]{"std::function<torch::Tensor(const torch::Tensor&)>"}).pointerTypes(new String[]{"TensorMapper"})).put(new Info(new String[]{"at::TensorBase::hook_return_void_t<std::function<void(at::TensorBase)> > ", "at::TensorBase::hook_return_void_t<std::function<at::TensorBase(at::TensorBase)> >"}).valueTypes(new String[]{"int"})).put(new Info(new String[]{"std::function<void(const std::string&,const std::map<std::string,std::string>&)>"}).pointerTypes(new String[]{"MetadataLogger"})).put(new Info(new String[]{"std::function<c10::StrongTypePtr(const c10::QualifiedName&)>", "torch::jit::TypeResolver"}).pointerTypes(new String[]{"TypeResolver"})).put(new Info(new String[]{"std::function<c10::TypePtr(const std::string&)>", "torch::jit::TypeParserT", "c10::TypePtr (*)(const std::string&)", "c10::Type::SingletonOrSharedTypePtr<c10::Type> (*)(const std::string&)"}).pointerTypes(new String[]{"TypeParser"}).skip()).put(new Info(new String[]{"c10::intrusive_ptr<c10::StorageImpl> (*)(c10::StorageImpl::use_byte_size_t, c10::SymInt, c10::Allocator*, bool)"}).pointerTypes(new String[]{"StorageImplCreateHelper"}).skip()).put(new Info(new String[]{"std::function<c10::optional<std::string>(const c10::Type&)>"}).pointerTypes(new String[]{"TypePrinter"})).put(new Info(new String[]{"void (*)(void*, size_t)", "c10::PlacementDtor", "caffe2::TypeMeta::PlacementNew", "caffe2::TypeMeta::PlacementDelete"}).pointerTypes(new String[]{"PlacementConsumer"}).valueTypes(new String[]{"PlacementConsumer"}).skip()).put(new Info(new String[]{"void (*)(const void*, void*, size_t)", "caffe2::TypeMeta::Copy"}).pointerTypes(new String[]{"PlacementCopier"}).valueTypes(new String[]{"PlacementCopier"}).skip()).put(new Info(new String[]{"torch::jit::Operation (*)(const torch::jit::Node*)", "torch::jit::OperationCreator"}).pointerTypes(new String[]{"OperationCreator"}).valueTypes(new String[]{"OperationCreator"}).skip());
        infoMap.put(new Info(new String[]{"caffe2::TypeMeta::deleteFn"}).javaText("public native @NoException(true) PointerConsumer deleteFn();"));
    }

    private static String template(String t, String ... args) {
        StringBuilder sb = new StringBuilder(t);
        sb.append('<');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(args[i]);
        }
        if (args[args.length - 1].endsWith(">")) {
            sb.append(' ');
        }
        sb.append('>');
        return sb.toString();
    }

    private static String mangle(String name) {
        StringBuilder mangledName = new StringBuilder(2 * name.length());
        mangledName.append("JavaCPP_");
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                mangledName.append(c);
                continue;
            }
            if (c == '_') {
                mangledName.append("_1");
                continue;
            }
            if (c == ';') {
                mangledName.append("_2");
                continue;
            }
            if (c == '[') {
                mangledName.append("_3");
                continue;
            }
            if (c == '.' || c == '/') {
                mangledName.append("_");
                continue;
            }
            String code = Integer.toHexString(c);
            mangledName.append("_0");
            switch (code.length()) {
                case 1: {
                    mangledName.append("0");
                }
                case 2: {
                    mangledName.append("0");
                }
                case 3: {
                    mangledName.append("0");
                }
            }
            mangledName.append(code);
        }
        return mangledName.toString();
    }

    private static void addCppName(InfoMap infoMap, String ... n) {
        Info i = new Info(infoMap.getFirst(n[0]));
        i.cppNames(n);
        infoMap.put(i);
    }

    @Namespace(value="std")
    @MemberGetter
    @ByRef
    @Cast(value={"std::istream*"})
    public static native Pointer cin();

    @Namespace(value="std")
    @MemberGetter
    @ByRef
    @Cast(value={"std::ostream*"})
    public static native Pointer cout();

    @Namespace(value="std")
    @MemberGetter
    @ByRef
    @Cast(value={"std::ostream*"})
    public static native Pointer cerr();

    @Namespace(value="std")
    @MemberGetter
    @ByRef
    @Cast(value={"std::ostream*"})
    public static native Pointer clog();

    static {
        Loader.checkVersion((String)"org.bytedeco", (String)"pytorch");
    }

    static class PointerInfo {
        String javaBaseName;
        String javaName;
        final String[] argumentNames;
        String[] otherCppNames = new String[0];

        PointerInfo(String ... an) {
            this.argumentNames = an;
            this.javaBaseName = an[0].substring(an[0].lastIndexOf(58) + 1);
        }

        PointerInfo otherCppNames(String ... n) {
            this.otherCppNames = n;
            return this;
        }

        PointerInfo javaBaseName(String jn) {
            this.javaBaseName = jn;
            return this;
        }

        PointerInfo javaName(String jn) {
            this.javaName = jn;
            return this;
        }

        void makeShared(InfoMap infoMap) {
            String[] cppNames = new String[this.argumentNames.length + this.otherCppNames.length];
            int i = 0;
            for (String n : this.argumentNames) {
                cppNames[i++] = torch.template("std::shared_ptr", new String[]{n});
            }
            for (String n : this.otherCppNames) {
                cppNames[i++] = n;
            }
            infoMap.put(new Info(cppNames).annotations(new String[]{"@SharedPtr(\"" + this.argumentNames[0] + "\")"}).pointerTypes(new String[]{this.javaBaseName}));
            String n = this.argumentNames[0].substring(this.argumentNames[0].lastIndexOf(32) + 1);
            String n2 = n.equals("torch::nn::Module") ? "JavaCPP_torch_0003a_0003ann_0003a_0003aModule" : n;
            infoMap.put(new Info(new String[]{n + n.substring(n.lastIndexOf("::"))}).annotations(new String[]{"@SharedPtr", "@Name(\"std::make_shared<" + n2 + ">\")"}));
        }

        void makeUnique(InfoMap infoMap) {
            String[] cppNames = new String[this.argumentNames.length + this.otherCppNames.length];
            int i = 0;
            for (String n : this.argumentNames) {
                cppNames[i++] = torch.template("std::unique_ptr", new String[]{n});
            }
            for (String n : this.otherCppNames) {
                cppNames[i++] = n;
            }
            infoMap.put(new Info(cppNames).annotations(new String[]{"@UniquePtr"}).pointerTypes(new String[]{this.javaBaseName}));
            String n = this.argumentNames[0].substring(this.argumentNames[0].lastIndexOf(32) + 1);
            infoMap.put(new Info(new String[]{n + n.substring(n.lastIndexOf("::"))}).annotations(new String[]{"@UniquePtr", "@Name(\"std::make_unique<" + n + ">\")"}));
        }
    }

    static class ArrayInfo {
        String baseJavaName;
        String[] elementTypes = new String[0];
        String[] otherCppNames = new String[0];
        String itPointerType;
        String[] otherPointerTypes = new String[0];
        String elementValueType;

        ArrayInfo(String b) {
            this.baseJavaName = b;
            this.itPointerType = "@ByPtr " + b;
            this.elementValueType = "@ByVal " + b;
        }

        ArrayInfo elementTypes(String ... vt) {
            this.elementTypes = vt;
            return this;
        }

        ArrayInfo otherCppNames(String ... jn) {
            this.otherCppNames = jn;
            return this;
        }

        ArrayInfo itPointerType(String p) {
            this.itPointerType = p;
            return this;
        }

        ArrayInfo elementValueType(String t) {
            this.elementValueType = t;
            return this;
        }

        ArrayInfo otherPointerTypes(String ... p) {
            this.otherPointerTypes = p;
            return this;
        }

        void mapArrayRef(InfoMap infoMap) {
            String[] cppNames = new String[this.elementTypes.length * 3 + this.otherCppNames.length];
            String[] cppNamesIterator = new String[cppNames.length * 2];
            String[] cppNamesRIterator = new String[cppNames.length * 2];
            int n = 0;
            for (String vt : this.elementTypes) {
                int n2 = n++;
                String string = torch.template("c10::ArrayRef", new String[]{vt});
                cppNames[n2] = string;
                String mainName = string;
                cppNames[n++] = torch.template("at::ArrayRef", new String[]{vt});
                cppNames[n++] = torch.template("torch::ArrayRef", new String[]{vt});
                infoMap.put(new Info(new String[]{mainName + "(const " + vt + "&)"}).skip()).put(new Info(new String[]{mainName + "(" + vt + "&)"}).skip());
            }
            for (String on : this.otherCppNames) {
                cppNames[n++] = on;
            }
            n = 0;
            for (String cn : cppNames) {
                cppNamesIterator[n++] = cn + "::iterator";
                cppNamesIterator[n++] = cn + "::const_iterator";
            }
            n = 0;
            for (String cn : cppNames) {
                cppNamesRIterator[n++] = cn + "::reverse_iterator";
                cppNamesRIterator[n++] = cn + "::const_reverse_iterator";
            }
            boolean variadicPointerType = this.elementValueType.equals("byte") || this.elementValueType.equals("short") || this.elementValueType.equals("int") || this.elementValueType.equals("long") || this.elementValueType.equals("float") || this.elementValueType.equals("double");
            String[] pt = new String[this.otherPointerTypes.length + (variadicPointerType ? 2 : 1)];
            pt[0] = this.baseJavaName + "ArrayRef";
            System.arraycopy(this.otherPointerTypes, 0, pt, 1, this.otherPointerTypes.length);
            if (variadicPointerType) {
                pt[this.otherPointerTypes.length + 1] = "@Cast({\"" + this.elementTypes[0] + "*\", \"" + cppNames[0] + "\", \"std::vector<" + this.elementTypes[0] + ">&\"}) @StdVector(\"" + this.elementTypes[0] + "\") " + this.elementValueType + "...";
            }
            Info info = new Info(cppNames).pointerTypes(pt);
            if (this.baseJavaName.contains("@Cast")) {
                info.cast();
            }
            infoMap.put(info);
            info = new Info(cppNamesIterator).valueTypes(new String[]{"@Const " + this.itPointerType});
            infoMap.put(info);
            infoMap.put(new Info(cppNamesRIterator).skip());
            Info vectorInfo = infoMap.getFirst(torch.template("std::vector", new String[]{this.elementTypes[0]}), false);
            if (vectorInfo != null && !this.elementTypes[0].equals("bool")) {
                infoMap.put(new Info(new String[]{torch.template(cppNames[0] + "::ArrayRef", new String[]{torch.template("std::allocator", new String[]{this.elementTypes[0]})}) + "(" + this.elementTypes[0] + "*)"}).javaNames(new String[]{"XXX"}).javaText("public " + this.baseJavaName + "ArrayRef(@ByRef " + this.baseJavaName + "Vector vec) { super((Pointer)null); allocate(vec); }\nprivate native void allocate(@ByRef " + this.baseJavaName + "Vector vec);"));
            }
        }

        void mapList(InfoMap infoMap) {
            String t = this.elementTypes[0];
            infoMap.put(new Info(new String[]{torch.template("c10::List", new String[]{t})}).pointerTypes(new String[]{this.baseJavaName + "List"})).put(new Info(new String[]{torch.template("c10::impl::ListElementReference", new String[]{t, "typename c10::detail::ListImpl::list_type::iterator"}), torch.template("c10::impl::ListElementReference", new String[]{t, "c10::detail::ListImpl::list_type::iterator"}), torch.template("c10::impl::ListElementReference", new String[]{t, torch.template("std::vector", new String[]{t}) + "::iterator"})}).pointerTypes(new String[]{this.baseJavaName + "ElementReference"})).put(new Info(new String[]{torch.template("c10::impl::ListIterator", new String[]{t, "typename c10::detail::ListImpl::list_type::iterator"}), torch.template("c10::impl::ListIterator", new String[]{t, "c10::detail::ListImpl::list_type::iterator"})}).pointerTypes(new String[]{this.baseJavaName + "ListIterator"})).put(new Info(new String[]{torch.template("c10::List", new String[]{t}) + "::value_type"}).valueTypes(new String[]{this.elementValueType})).put(new Info(new String[]{torch.template("operator std::conditional_t", new String[]{torch.template("std::is_reference", new String[]{torch.template("c10::detail::ivalue_to_const_ref_overload_return", new String[]{t}) + "::type"}) + "::value", "const " + t + "&", t}) + "()"}).javaNames(new String[]{"get" + this.baseJavaName})).put(new Info(new String[]{torch.template("c10::List", new String[]{t}) + "::size_type"}).valueTypes(new String[]{"long"})).put(new Info(new String[]{torch.template("c10::impl::ListElementReference", new String[]{t, "c10::detail::ListImpl::list_type::iterator"}) + "::" + torch.template("swap", new String[]{t, "c10::detail::ListImpl::list_type::iterator"})}).javaNames(new String[]{"swap"}).friendly());
            infoMap.put(new Info(new String[]{torch.template("c10::List", new String[]{t}) + "::operator []"}).skip()).put(new Info(new String[]{torch.template("c10::impl::ListIterator", new String[]{t, "c10::detail::ListImpl::list_type::iterator"}) + "::operator []", torch.template("c10::impl::ListIterator", new String[]{t, "c10::detail::ListImpl::list_type::iterator"}) + "::operator *"}).skip()).put(new Info(new String[]{torch.template("std::conditional_t", new String[]{torch.template("std::is_reference", new String[]{torch.template("c10::detail::ivalue_to_const_ref_overload_return", new String[]{t}) + "::type"}) + "::value", "const " + t + "&", t})}).pointerTypes(new String[]{this.itPointerType}).valueTypes(new String[]{this.elementValueType})).put(new Info(new String[]{torch.template("c10::impl::swap", new String[]{t, "typename c10::detail::ListImpl::list_type::iterator"})}).javaNames(new String[]{"swap"}));
            if (this.baseJavaName.equals("Generic")) {
                infoMap.put(new Info(new String[]{torch.template("c10::List", new String[]{t}) + "(" + torch.template("std::initializer_list", new String[]{t}) + ")", torch.template("c10::List", new String[]{t}) + "(" + torch.template("c10::ArrayRef", new String[]{t}) + ")", torch.template("c10::List", new String[]{t}) + "()"}).skip());
            } else if (!this.baseJavaName.equals("Future")) {
                infoMap.put(new Info(new String[]{torch.template("c10::List", new String[]{t}) + "(c10::TypePtr)"}).skip());
            }
        }
    }
}

