/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.Value;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<torch::jit::Value*>"})
@Properties(inherit={torch.class})
public class ValueVector
extends Pointer {
    public ValueVector(Pointer p) {
        super(p);
    }

    public ValueVector(Value value) {
        this(1L);
        this.put(0L, value);
    }

    public ValueVector(Value ... array) {
        this(array.length);
        this.put(array);
    }

    public ValueVector() {
        this.allocate();
    }

    public ValueVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native ValueVector put(@ByRef ValueVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Value front() {
        return this.get(0L);
    }

    public Value back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    public native Value get(@Cast(value={"size_t"}) long var1);

    public native ValueVector put(@Cast(value={"size_t"}) long var1, Value var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, Value var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Value[] get() {
        Value[] array = new Value[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Value pop_back() {
        long size = this.size();
        Value value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public ValueVector push_back(Value value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public ValueVector put(Value value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public ValueVector put(Value ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Const
        public native Value get();
    }
}

