/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<size_t>"})
@Properties(inherit={torch.class})
public class SizeTVector
extends Pointer {
    public SizeTVector(Pointer p) {
        super(p);
    }

    public SizeTVector(long ... array) {
        this((long)array.length);
        this.put(array);
    }

    public SizeTVector() {
        this.allocate();
    }

    public SizeTVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native SizeTVector put(@ByRef SizeTVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public long front() {
        return this.get(0L);
    }

    public long back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @Cast(value={"size_t"})
    public native long get(@Cast(value={"size_t"}) long var1);

    public native SizeTVector put(@Cast(value={"size_t"}) long var1, long var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"size_t"}) long var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public long[] get() {
        long[] array = new long[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public long pop_back() {
        long size = this.size();
        long value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public SizeTVector push_back(long value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public SizeTVector put(long value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public SizeTVector put(long ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put((long)i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Cast(value={"size_t"})
        public native long get();
    }
}

