/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.JitNode;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<const torch::jit::Node*>"})
@Properties(inherit={torch.class})
public class JitNodeVector
extends Pointer {
    public JitNodeVector(Pointer p) {
        super(p);
    }

    public JitNodeVector(JitNode value) {
        this(1L);
        this.put(0L, value);
    }

    public JitNodeVector(JitNode ... array) {
        this(array.length);
        this.put(array);
    }

    public JitNodeVector() {
        this.allocate();
    }

    public JitNodeVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native JitNodeVector put(@ByRef JitNodeVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public JitNode front() {
        return this.get(0L);
    }

    public JitNode back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @Const
    public native JitNode get(@Cast(value={"size_t"}) long var1);

    public native JitNodeVector put(@Cast(value={"size_t"}) long var1, JitNode var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Const JitNode var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public JitNode[] get() {
        JitNode[] array = new JitNode[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public JitNode pop_back() {
        long size = this.size();
        JitNode value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public JitNodeVector push_back(JitNode value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public JitNodeVector put(JitNode value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public JitNodeVector put(JitNode ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Const
        public native JitNode get();
    }
}

