package org.bytedeco.pytorch.functions;

import org.bytedeco.javacpp.FunctionPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.Module;

@Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class ModuleApplyFunction extends FunctionPointer {
    static {
        Loader.load();
    }

    /**
     * Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}.
     */
    public ModuleApplyFunction(Pointer p) {
        super(p);
    }

    protected ModuleApplyFunction() {
        allocate();
    }

    private native void allocate();

    public native void call(@ByRef Module m);
}
