// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch.cuda;

import org.bytedeco.pytorch.*;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Error;
import org.bytedeco.pytorch.global.torch.DeviceType;
import org.bytedeco.pytorch.global.torch.ScalarType;
import org.bytedeco.pytorch.global.torch.MemoryFormat;
import org.bytedeco.pytorch.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.pytorch.*;
import static org.bytedeco.pytorch.global.torch.*;

import static org.bytedeco.pytorch.global.torch_cuda.*;


// Struct containing memory allocator summary statistics for a device.
@Namespace("c10::cuda::CUDACachingAllocator") @Properties(inherit = org.bytedeco.pytorch.presets.torch_cuda.class)
public class DeviceStats extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public DeviceStats() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DeviceStats(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DeviceStats(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public DeviceStats position(long position) {
        return (DeviceStats)super.position(position);
    }
    @Override public DeviceStats getPointer(long i) {
        return new DeviceStats((Pointer)this).offsetAddress(i);
    }

  // COUNT: allocations requested by client code
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat allocation(); public native DeviceStats allocation(Stat setter);
  // COUNT: number of allocated segments from cudaMalloc().
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat segment(); public native DeviceStats segment(Stat setter);
  // COUNT: number of active memory blocks (allocated or used by stream)
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat active(); public native DeviceStats active(Stat setter);
  // COUNT: number of inactive, split memory blocks (unallocated but can't be
  // released via cudaFree)
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat inactive_split(); public native DeviceStats inactive_split(Stat setter);

  // SUM: bytes allocated by this memory alocator
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat allocated_bytes(); public native DeviceStats allocated_bytes(Stat setter);
  // SUM: bytes reserved by this memory allocator (both free and used)
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat reserved_bytes(); public native DeviceStats reserved_bytes(Stat setter);
  // SUM: bytes within active memory blocks
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat active_bytes(); public native DeviceStats active_bytes(Stat setter);
  // SUM: bytes within inactive, split memory blocks
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat inactive_split_bytes(); public native DeviceStats inactive_split_bytes(Stat setter);
  // SUM: bytes requested by client code
  public native @ByRef @Cast("c10::cuda::CUDACachingAllocator::StatArray*") Stat requested_bytes(); public native DeviceStats requested_bytes(Stat setter);

  // COUNT: total number of failed calls to CUDA malloc necessitating cache
  // flushes.
  public native @Cast("int64_t") long num_alloc_retries(); public native DeviceStats num_alloc_retries(long setter);

  // COUNT: total number of OOMs (i.e. failed calls to CUDA after cache flush)
  public native @Cast("int64_t") long num_ooms(); public native DeviceStats num_ooms(long setter);

  // COUNT: total number of oversize blocks allocated from pool
  public native @ByRef Stat oversize_allocations(); public native DeviceStats oversize_allocations(Stat setter);

  // COUNT: total number of oversize blocks requiring malloc
  public native @ByRef Stat oversize_segments(); public native DeviceStats oversize_segments(Stat setter);

  // SIZE: maximum block size that is allowed to be split.
  public native @Cast("int64_t") long max_split_size(); public native DeviceStats max_split_size(long setter);
}
