// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch.cuda;

import org.bytedeco.pytorch.*;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Error;
import org.bytedeco.pytorch.global.torch.DeviceType;
import org.bytedeco.pytorch.global.torch.ScalarType;
import org.bytedeco.pytorch.global.torch.MemoryFormat;
import org.bytedeco.pytorch.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.pytorch.*;
import static org.bytedeco.pytorch.global.torch.*;

import static org.bytedeco.pytorch.global.torch_cuda.*;


// Value object representing a CUDA stream.  This is just a wrapper
// around c10::Stream, but it comes with a little extra CUDA-specific
// functionality (conversion to cudaStream_t), and a guarantee that
// the wrapped c10::Stream really is a CUDA stream.
@Namespace("c10::cuda") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch_cuda.class)
public class CUDAStream extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUDAStream(Pointer p) { super(p); }

  public enum Unchecked { UNCHECKED(0);

      public final int value;
      private Unchecked(int v) { this.value = v; }
      private Unchecked(Unchecked e) { this.value = e.value; }
      public Unchecked intern() { for (Unchecked e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  /** Construct a CUDAStream from a Stream.  This construction is checked,
   *  and will raise an error if the Stream is not, in fact, a CUDA stream. */
  public CUDAStream(@ByVal Stream stream) { super((Pointer)null); allocate(stream); }
  private native void allocate(@ByVal Stream stream);

  /** Construct a CUDAStream from a Stream with no error checking.
   *  This constructor uses the "named" constructor idiom, and can
   *  be invoked as: CUDAStream(CUDAStream::UNCHECKED, stream) */
  public CUDAStream(Unchecked arg0, @ByVal Stream stream) { super((Pointer)null); allocate(arg0, stream); }
  private native void allocate(Unchecked arg0, @ByVal Stream stream);
  public CUDAStream(@Cast("c10::cuda::CUDAStream::Unchecked") int arg0, @ByVal Stream stream) { super((Pointer)null); allocate(arg0, stream); }
  private native void allocate(@Cast("c10::cuda::CUDAStream::Unchecked") int arg0, @ByVal Stream stream);

  public native @Cast("bool") @Name("operator ==") @NoException(true) boolean equals(@Const @ByRef CUDAStream other);

  public native @Cast("bool") @Name("operator !=") @NoException(true) boolean notEquals(@Const @ByRef CUDAStream other);

  /** Implicit conversion to cudaStream_t. */
  public native @Cast("cudaStream_t") @Name("operator cudaStream_t") Pointer asPointer();

  /** Implicit conversion to Stream (a.k.a., forget that the stream is a
   *  CUDA stream). */
  public native @ByVal @Name("operator c10::Stream") Stream asStream();

  /** Used to avoid baking in device type explicitly to Python-side API. */
  public native @ByVal DeviceType device_type();

  /** Get the CUDA device index that this stream is associated with. */
  public native byte device_index();

  /** Get the full Device that this stream is associated with.  The Device
   *  is guaranteed to be a CUDA device. */
  public native @ByVal Device device();

  /** Return the stream ID corresponding to this particular stream. */
  public native long id();

  public native @Cast("bool") boolean query();

  public native void synchronize();

  public native int priority();

  /** Explicit conversion to cudaStream_t. */
  public native @Cast("cudaStream_t") Pointer stream();

  /** Explicit conversion to Stream. */
  
  ///
  public native @ByVal Stream unwrap();

  /** Reversibly pack a CUDAStream into a struct representation.
   *  Previously the stream's data was packed into a single int64_t,
   *  as it was assumed the fields would not require more than
   *  64 bits of storage in total.
   *  See https://github.com/pytorch/pytorch/issues/75854
   *  for more information regarding newer platforms that may violate
   *  this assumption.
   * 
   *  The CUDAStream can be unpacked using unpack(). */
  public native @ByVal StreamData3 pack3();

  // Unpack a CUDAStream from the 3 fields generated by pack().
  public static native @ByVal CUDAStream unpack3(
        long stream_id,
        byte device_index,
        @ByVal DeviceType device_type);

  public static native @ByVal T_IntInt_T priority_range();
}
