// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch.cuda;

import org.bytedeco.pytorch.*;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Error;
import org.bytedeco.pytorch.global.torch.DeviceType;
import org.bytedeco.pytorch.global.torch.ScalarType;
import org.bytedeco.pytorch.global.torch.MemoryFormat;
import org.bytedeco.pytorch.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.pytorch.*;
import static org.bytedeco.pytorch.global.torch.*;

import static org.bytedeco.pytorch.global.torch_cuda.*;


// This code is kind of boilerplatey.  See Note [Whither the DeviceGuard
// boilerplate]

/** A variant of DeviceGuard that is specialized for CUDA.  It accepts
 *  integer indices (interpreting them as CUDA devices) and is a little
 *  more efficient than DeviceGuard (it compiles to straight line
 *  cudaSetDevice/cudaGetDevice calls); however, it can only be used
 *  from code that links against CUDA directly. */
@Namespace("c10::cuda") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch_cuda.class)
public class CUDAGuard extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUDAGuard(Pointer p) { super(p); }

  /** No default constructor; see Note [Omitted default constructor from RAII] */
  

  /** Set the current CUDA device to the passed device index. */
  public CUDAGuard(byte device_index) { super((Pointer)null); allocate(device_index); }
  private native void allocate(byte device_index);

  /** Sets the current CUDA device to the passed device.  Errors if the passed
   *  device is not a CUDA device. */
  public CUDAGuard(@ByVal Device device) { super((Pointer)null); allocate(device); }
  private native void allocate(@ByVal Device device);

  // Copy is not allowed
  
  

  // Move is not allowed (there is no uninitialized state)
  
  

  /** Sets the CUDA device to the given device.  Errors if the given device
   *  is not a CUDA device. */
  public native void set_device(@ByVal Device device);

  /** Sets the CUDA device to the given device.  Errors if the given device
   *  is not a CUDA device.  (This method is provided for uniformity with
   *  DeviceGuard). */
  public native void reset_device(@ByVal Device device);

  /** Sets the CUDA device to the given device index. */
  public native void set_index(byte device_index);

  /** Returns the device that was set upon construction of the guard */
  public native @ByVal Device original_device();

  /** Returns the last device that was set via {@code set_device}, if any, otherwise
   *  the device passed during construction. */
  public native @ByVal Device current_device();
}
