// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


@Name("c10::weak_intrusive_ptr<c10::StorageImpl>") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class WeakStorage extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public WeakStorage(Pointer p) { super(p); }


  public WeakStorage(@Const @ByRef StorageImplPtr ptr) { super((Pointer)null); allocate(ptr); }
  private native void allocate(@Const @ByRef StorageImplPtr ptr);

  public WeakStorage(@ByRef(true) WeakStorage rhs) { super((Pointer)null); allocate(rhs); }
  @NoException(true) private native void allocate(@ByRef(true) WeakStorage rhs);

  public native @ByRef @Name("operator =") @NoException(true) WeakStorage put(@ByRef(true) WeakStorage rhs);

  public native @ByRef @Name("operator =") @NoException(true) WeakStorage put(
        @Const @ByRef StorageImplPtr rhs);

  public native @NoException(true) void reset();

  public native @NoException(true) void swap(@ByRef WeakStorage rhs);

  // NB: This should ONLY be used by the std::hash implementation
  // for weak_intrusive_ptr.  Another way you could do this is
  // friend std::hash<weak_intrusive_ptr>, but this triggers two
  // bugs:
  //
  //  (1) It triggers an nvcc bug, where std::hash in a friend class
  //      declaration gets preprocessed into hash, which then cannot
  //      actually be found.  The error in this case looks like:
  //
  //        error: no template named 'hash'; did you mean 'std::hash'?
  //
  //  (2) On OS X, std::hash is declared as a struct, not a class.
  //      This twings:
  //
  //        error: class 'hash' was previously declared as a struct
  //        [-Werror,-Wmismatched-tags]
  //
  // Both of these are work-aroundable, but on the whole, I decided
  // it would be simpler and easier to make work if we just expose
  // an unsafe getter for target_
  //
  public native @NoException(true) StorageImpl _unsafe_get_target();

  public native @Cast("size_t") @NoException(true) long use_count();

  public native @Cast("size_t") @NoException(true) long weak_use_count();

  public native @Cast("bool") @NoException(true) boolean expired();

  public native @ByVal @NoException(true) StorageImplPtr lock();

  /**
   * Returns an owning (but still only weakly referenced) pointer to the
   * underlying object and makes the weak_intrusive_ptr instance invalid.
   * That means the weakcount is not decreased.
   * You *must* put the returned pointer back into a weak_intrusive_ptr using
   * weak_intrusive_ptr::reclaim(ptr) to properly destruct it.
   * This is helpful for C APIs.
   */
  public native @NoException(true) StorageImpl release();

  /**
   * Takes an owning (but must be weakly referenced) pointer to TTarget* and
   * creates a weak_intrusive_ptr that takes over ownership.
   * This means that the weakcount is not increased.
   * This is the counter-part to weak_intrusive_ptr::release() and the pointer
   * passed in *must* have been created using weak_intrusive_ptr::release().
   */
  public static native @ByVal WeakStorage reclaim(StorageImpl owning_weak_ptr);

  /**
   * Takes a pointer to TTarget* (may be weak or strong) and creates a
   * new weak_intrusive_ptr representing a new weak reference, i.e.
   * the raw pointer retains ownership.
   */
  public static native @ByVal WeakStorage reclaim_copy(StorageImpl owning_ptr);

  
  
}
