// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


// A detail::UniqueVoidPtr is an owning smart pointer like unique_ptr, but
// with three major differences:
//
//    1) It is specialized to void
//
//    2) It is specialized for a function pointer deleter
//       void(void* ctx); i.e., the deleter doesn't take a
//       reference to the data, just to a context pointer
//       (erased as void*).  In fact, internally, this pointer
//       is implemented as having an owning reference to
//       context, and a non-owning reference to data; this is why
//       you release_context(), not release() (the conventional
//       API for release() wouldn't give you enough information
//       to properly dispose of the object later.)
//
//    3) The deleter is guaranteed to be called when the unique
//       pointer is destructed and the context is non-null; this is different
//       from std::unique_ptr where the deleter is not called if the
//       data pointer is null.
//
// Some of the methods have slightly different types than std::unique_ptr
// to reflect this.
//
@Namespace("c10::detail") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class UniqueVoidPtr extends Pointer {
    static { Loader.load(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public UniqueVoidPtr(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public UniqueVoidPtr position(long position) {
        return (UniqueVoidPtr)super.position(position);
    }
    @Override public UniqueVoidPtr getPointer(long i) {
        return new UniqueVoidPtr((Pointer)this).offsetAddress(i);
    }

  public UniqueVoidPtr() { super((Pointer)null); allocate(); }
  private native void allocate();
  public UniqueVoidPtr(Pointer data) { super((Pointer)null); allocate(data); }
  private native void allocate(Pointer data);
  public UniqueVoidPtr(Pointer data, Pointer ctx, PointerConsumer ctx_deleter) { super((Pointer)null); allocate(data, ctx, ctx_deleter); }
  private native void allocate(Pointer data, Pointer ctx, PointerConsumer ctx_deleter);
  public native @Name("operator ->") Pointer access();
  public native void clear();
  public native Pointer get();
  public native Pointer get_context();
  public native Pointer release_context();
  
  public native @Cast("bool") boolean compare_exchange_deleter(
        PointerConsumer expected_deleter,
        PointerConsumer new_deleter);
  public native @Cast("bool") @Name("operator bool") boolean asBoolean();
  public native PointerConsumer get_deleter();
}
