// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


@Namespace("c10::ivalue") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class TupleElements extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TupleElements(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TupleElements(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TupleElements position(long position) {
        return (TupleElements)super.position(position);
    }
    @Override public TupleElements getPointer(long i) {
        return new TupleElements((Pointer)this).offsetAddress(i);
    }


  public TupleElements() { super((Pointer)null); allocate(); }
  private native void allocate();

  public TupleElements(@ByVal IValueVector elements) { super((Pointer)null); allocate(elements); }
  private native void allocate(@ByVal IValueVector elements);

  public TupleElements(@ByVal IValueArrayRef elements) { super((Pointer)null); allocate(elements); }
  private native void allocate(@ByVal IValueArrayRef elements);

  public TupleElements(@ByRef(true) IValue e1) { super((Pointer)null); allocate(e1); }
  private native void allocate(@ByRef(true) IValue e1);

  public TupleElements(@ByRef(true) IValue e1, @ByRef(true) IValue e2) { super((Pointer)null); allocate(e1, e2); }
  private native void allocate(@ByRef(true) IValue e1, @ByRef(true) IValue e2);

  public TupleElements(@ByRef(true) IValue e1, @ByRef(true) IValue e2, @ByRef(true) IValue e3) { super((Pointer)null); allocate(e1, e2, e3); }
  private native void allocate(@ByRef(true) IValue e1, @ByRef(true) IValue e2, @ByRef(true) IValue e3);

  // It would be nice to make this noncopyable to prevent people from
  // writing code like `auto output =
  // forward(...).toTupleRef().elements()` (which does refcount bumps on
  // each element, unlike the more efficient but verbose
  // ```
  // auto outputIntrusivePtr = forward(...).toTuple();
  // const auto& output = outputIntrusivePtr->elements();
  // ```
  // ), but there is simply an overwhelming amount of code that does
  // it the inefficient way.
  // See also operator std::vector below.
  public TupleElements(@Const @ByRef TupleElements rhs) { super((Pointer)null); allocate(rhs); }
  private native void allocate(@Const @ByRef TupleElements rhs);

  public native @ByRef @Name("operator =") TupleElements put(@Const @ByRef TupleElements rhs);

  public native @ByVal IValueArrayRef asArrayRef();

  // Mimic implicit conversion from std::vector to ArrayRef.
  public native @ByVal @Name("operator c10::ArrayRef<c10::IValue>") IValueArrayRef asIValueArrayRef();

  public static native @Cast("size_t") long hash(@Const @ByRef TupleElements v);

  public native void setContents(@ByRef(true) IValueVector contents);

  public native @Cast("bool") boolean empty();

  public native @Cast("size_t") long size();

  public native @ByRef @Name("operator []") IValue get(@Cast("size_t") long idx);

  public native @ByRef IValue at(@Cast("size_t") long idx);

  public native @Cast("c10::ivalue::TupleElements::iterator") IValue begin();

  public native @Cast("c10::ivalue::TupleElements::iterator") IValue end();

  public native @Cast("c10::ivalue::TupleElements::const_iterator") IValue cbegin();

  public native @Cast("c10::ivalue::TupleElements::const_iterator") IValue cend();

  public native @ByVal IValueVector vec();

  public native @ByRef IValue back();

  

  // More compatibility shims for the overwhelming amount of code that
  // likes to copy tuple elements into a vector; see comment above the
  // copy constructor.
  public native @ByVal @Name("operator std::vector<c10::IValue>") IValueVector asIValueVector();

  
}
