// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ TransformerEncoder
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/** TransformerEncoder module.
 *  See
 *  https://pytorch.org/docs/master/generated/torch.nn.TransformerEncoder.html
 *  to learn abouut the exact behavior of this encoder layer module.
 * 
 *  See the documentation for {@code torch::nn::TransformerEncoder} class to learn
 *  what constructor arguments are supported for this encoder module.
 * 
 *  Example:
 *  <pre>{@code
 *  TransformerEncoderLayer encoderLayer(TransformerEncoderLayerOptions(512,
 *  8).dropout(0.1)); TransformerEncoder
 *  encoder(TransformerEncoderOptions(encoderLayer,
 *  6).norm(LayerNorm(LayerNormOptions({2}))));
 *  }</pre> */
@Namespace("torch::nn") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class TransformerEncoderImpl extends TransformerEncoderImplCloneable {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TransformerEncoderImpl(Pointer p) { super(p); }
    /** Downcast constructor. */
    public TransformerEncoderImpl(Module pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @SharedPtr @Name("SHARED_PTR_NAMESPACE::dynamic_pointer_cast<torch::nn::TransformerEncoderImpl, torch::nn::Module>") void allocate(@SharedPtr Module pointer);

  public TransformerEncoderImpl(@ByVal TransformerEncoderOptions options_) { super((Pointer)null); allocate(options_); }
  @SharedPtr @Name("std::make_shared<torch::nn::TransformerEncoderImpl>") private native void allocate(@ByVal TransformerEncoderOptions options_);

  public native @ByVal Tensor forward(
        @Const @ByRef Tensor src,
        @Const @ByRef(nullValue = "torch::Tensor{}") Tensor src_mask,
        @Const @ByRef(nullValue = "torch::Tensor{}") Tensor src_key_padding_mask);
  public native @ByVal Tensor forward(
        @Const @ByRef Tensor src);

  public native void reset();

  public native void reset_parameters();
  /** options with which this {@code TransformerEncoder} was constructed */
  public native @ByRef TransformerEncoderOptions options(); public native TransformerEncoderImpl options(TransformerEncoderOptions setter);

  /** module list that contains all the encoder layers */

  /** optional normalization module */
  public native @ByRef AnyModule norm(); public native TransformerEncoderImpl norm(AnyModule setter);
}
