// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


// Tensor is a "generic" object holding a pointer to the underlying TensorImpl object, which
// has an embedded reference count. In this way, Tensor is similar to boost::intrusive_ptr.
//
// For example:
//
// void func(Tensor a) {
//   Tensor b = a;
//   ...
// }
//
// In this example, when we say Tensor b = a, we are creating a new object that points to the
// same underlying TensorImpl, and bumps its reference count. When b goes out of scope, the
// destructor decrements the reference count by calling release() on the TensorImpl it points to.
// The existing constructors, operator overloads, etc. take care to implement the correct semantics.
//
// Note that Tensor can also be NULL, i.e. it is not associated with any underlying TensorImpl, and
// special care must be taken to handle this.
@Namespace("at") @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class Tensor extends TensorBase {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Tensor(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Tensor(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Tensor position(long position) {
        return (Tensor)super.position(position);
    }
    @Override public Tensor getPointer(long i) {
        return new Tensor((Pointer)this).offsetAddress(i);
    }

  public Tensor() { super((Pointer)null); allocate(); }
  private native void allocate();
  // This constructor should not be used by end users and is an implementation
  // detail invoked by autogenerated code.
  public Tensor(
        @ByVal TensorImplPtr tensor_impl) { super((Pointer)null); allocate(tensor_impl); }
  private native void allocate(
        @ByVal TensorImplPtr tensor_impl);
  public Tensor(@Const @ByRef Tensor tensor) { super((Pointer)null); allocate(tensor); }
  private native void allocate(@Const @ByRef Tensor tensor);

  // Implicitly move-constructible from TensorBase, but must be explicit to increase refcount
  public Tensor(@Const @ByRef TensorBase base) { super((Pointer)null); allocate(base); }
  private native void allocate(@Const @ByRef TensorBase base);
  /*implicit*/

  // Creates a new wrapper from TensorImpl. Intentionally a free method because
  // it should be used with care. Checks necessary invariants
  public static native @ByVal Tensor wrap_tensor_impl(
        @ByVal TensorImplPtr tensor_impl);

  public native @ByVal Tensor contiguous(MemoryFormat memory_format/*=c10::MemoryFormat::Contiguous*/);
  public native @ByVal Tensor contiguous();
  public native @ByVal Tensor contiguous(@Cast("c10::MemoryFormat") byte memory_format/*=c10::MemoryFormat::Contiguous*/);

  public native @ByVal Tensor conj();

  // Aliased by Dimname overloads, so need explicit using

  /** Should be used if *this can reasonably be expected to be contiguous and
   *  performance is important.
   *  Compared to contiguous, it saves a reference count
   *  increment/decrement if *this is already contiguous, at the cost
   *  in all cases of an extra pointer of stack usage, an extra branch
   *  to access, and an extra branch at destruction time. */
  public native @Cast({"", "c10::MaybeOwned<at::Tensor>&&"}) @StdMove TensorMaybeOwned expect_contiguous(MemoryFormat memory_format/*=c10::MemoryFormat::Contiguous*/);
  public native @Cast({"", "c10::MaybeOwned<at::Tensor>&&"}) @StdMove TensorMaybeOwned expect_contiguous();
  public native @Cast({"", "c10::MaybeOwned<at::Tensor>&&"}) @StdMove TensorMaybeOwned expect_contiguous(@Cast("c10::MemoryFormat") byte memory_format/*=c10::MemoryFormat::Contiguous*/);

  // Use .contiguous() instead. Trying to borrow from a prvalue Tensor
  // will only lead to trouble and dangling references.
  

  // The following overloads are very intruiging.  Consider the following
  // program:
  //
  //    x[1] = 3;
  //
  // We would expect that the first entry of x is written to 3.  But how can we
  // actually achieve this?  x[1] evaluates to a tensor...
  //
  // The answer is, using a ref-qualifier.  x[1] is an rvalue, which cannot be
  // (profitably) assigned to in the traditional sense, so we overload
  // assignment to mean, "Actually, copy 3 into the tensor data."  This is done
  // with an rvalue-reference ref-qualified overload (the methods with && at the
  // end of their type.)
  //
  // There's one more fly in the ointment: We also want
  //
  //    Tensor x = y;
  //
  // to work, and we want it NOT to copy.  So we need a traditional operator=
  // overload.  But we MUST specify a mutable lvalue ref-qualifier, to
  // disambiguate the traditional overload from the rvalue-reference
  // ref-qualified overload.  Otherwise, it will be ambiguous, because
  // a non ref-qualified method is eligible for all situations.

  // Unfortunately, we have to write these constructors out manually
  // to work around an MSVC bug:
  //    error C2580: 'at::Tensor &at::Tensor::operator =(const at::Tensor &) &':
  //    multiple versions of a defaulted special member functions are not allowed
  // Tensor& operator=(const Tensor&) & = default;
  // Tensor& operator=(Tensor&&) & = default;

  // Also MSVC will wrongly issue the following warning with the aforementioned fix
  //    warning C4522: 'at::Tensor': multiple assignment operators specified
  // Let's just skip the warning.
  //
  // TODO: temporarily disabled

  public native @ByRef @Name("operator =") Tensor put(@Const @ByRef TensorBase x);

  public native @ByRef @Name("operator =") Tensor put(@Const @ByRef Tensor x);

  
  
  

  

  public native @ByVal Tensor toType(ScalarType t);

  // TODO: Deprecate me
  public native @ByVal Tensor toBackend(Backend b);
  public native @ByVal Tensor toBackend(@Cast("c10::Backend") int b);

  

  public native @Cast("bool") @Name("item<bool>") boolean item_bool();

  public native @Name("item<int8_t>") byte item_char();

  public native @Cast("uint8_t") @Name("item<uint8_t>") byte item_byte();

  public native @Name("item<int16_t>") short item_short();

  public native @Name("item<int>") int item_int();

  public native @Cast("int64_t") @Name("item<int64_t>") long item_long();

  public native @Name("item<float>") float item_float();

  public native @Name("item<double>") double item_double();
  

  public native @ByVal @Name("operator ~") Tensor not();
  public native @ByVal @Name("operator -") Tensor subtract();
  public native @ByRef @Name("operator +=") Tensor addPut(@Const @ByRef Tensor other);
  public native @ByRef @Name("operator +=") Tensor addPut(@Const @ByRef Scalar other);
  public native @ByRef @Name("operator -=") Tensor subtractPut(@Const @ByRef Tensor other);
  public native @ByRef @Name("operator -=") Tensor subtractPut(@Const @ByRef Scalar other);
  public native @ByRef @Name("operator *=") Tensor multiplyPut(@Const @ByRef Tensor other);
  public native @ByRef @Name("operator *=") Tensor multiplyPut(@Const @ByRef Scalar other);
  public native @ByRef @Name("operator /=") Tensor dividePut(@Const @ByRef Tensor other);
  public native @ByRef @Name("operator /=") Tensor dividePut(@Const @ByRef Scalar other);
  public native @ByRef @Name("operator &=") Tensor andPut(@Const @ByRef Tensor other);
  public native @ByRef @Name("operator |=") Tensor orPut(@Const @ByRef Tensor other);
  public native @ByRef @Name("operator ^=") Tensor xorPut(@Const @ByRef Tensor other);
  public native @ByVal @Name("operator []") Tensor get(@Const @ByRef Scalar index);
  public native @ByVal @Name("operator []") Tensor get(@Const @ByRef Tensor index);
  public native @ByVal @Name("operator []") Tensor get(@Cast("int64_t") long index);

  public native @ByVal Tensor index(@ByVal TensorIndexArrayRef indices);
  public native @ByVal Tensor index(@ByVal TensorIndexVector indices);

  public native @ByRef Tensor index_put_(@ByVal TensorIndexArrayRef indices, @Const @ByRef Tensor rhs);
  public native @ByRef Tensor index_put_(@ByVal TensorIndexVector indices, @Const @ByRef Tensor rhs);
  public native @ByRef Tensor index_put_(@ByVal TensorIndexArrayRef indices, @Const @ByRef Scalar v);
  public native @ByRef Tensor index_put_(@ByVal TensorIndexVector indices, @Const @ByRef Scalar v);

  public native @ByVal Tensor cpu();

  // TODO: The Python version also accepts arguments
  public native @ByVal Tensor cuda();

  public native @ByVal Tensor hip();

  public native @ByVal Tensor ve();

  public native @ByVal Tensor vulkan();

  public native @ByVal Tensor metal();

  
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  public native @ByVal Tensor meta();

  // ~~~~~ Autograd API ~~~~~

  /** \fn bool is_leaf() const;
   * 
   *  All Tensors that have {@code requires_grad()} which is {@code }false{@code } will be leaf Tensors by convention.
   * 
   *  For Tensors that have {@code requires_grad()} which is {@code }true{@code }, they will be leaf Tensors if they were
   *  created by the user. This means that they are not the result of an operation and so
   *  {@code grad_fn()} is {@code nullptr}.
   * 
   *  Only leaf Tensors will have their {@code grad()} populated during a call to {@code backward()}.
   *  To get {@code grad()} populated for non-leaf Tensors, you can use {@code retain_grad()}.
   * 
   *  Example:
   *  <pre>{@code
   *  auto a = torch::rand(10, torch::requires_grad());
   *  std::cout << a.is_leaf() << std::endl; // prints `true`
   * 
   *  auto b = torch::rand(10, torch::requires_grad()).to(torch::kCUDA);
   *  std::cout << b.is_leaf() << std::endl; // prints `false`
   *  // b was created by the operation that cast a cpu Tensor into a cuda Tensor
   * 
   *  auto c = torch::rand(10, torch::requires_grad()) + 2;
   *  std::cout << c.is_leaf() << std::endl; // prints `false`
   *  // c was created by the addition operation
   * 
   *  auto d = torch::rand(10).cuda();
   *  std::cout << d.is_leaf() << std::endl; // prints `true`
   *  // d does not require gradients and so has no operation creating it (that is tracked by the autograd engine)
   * 
   *  auto e = torch::rand(10).cuda().requires_grad_();
   *  std::cout << e.is_leaf() << std::endl; // prints `true`
   *  // e requires gradients and has no operations creating it
   * 
   *  auto f = torch::rand(10, torch::device(torch::kCUDA).requires_grad(true));
   *  std::cout << f.is_leaf() << std::endl; // prints `true`
   *  // f requires grad, has no operation creating it
   *  }</pre>
   <p>
   *  \fn void backward(const Tensor & gradient={}, c10::optional<bool> retain_graph=c10::nullopt, bool create_graph=false, c10::optional<TensorList> inputs=c10::nullopt) const;
   * 
   *  Computes the gradient of current tensor with respect to graph leaves.
   * 
   *  The graph is differentiated using the chain rule. If the tensor is
   *  non-scalar (i.e. its data has more than one element) and requires
   *  gradient, the function additionally requires specifying {@code }gradient{@code }.
   *  It should be a tensor of matching type and location, that contains
   *  the gradient of the differentiated function w.r.t. this Tensor.
   * 
   *  This function accumulates gradients in the leaves - you might need to
   *  zero them before calling it.
   * 
   *  @param gradient Gradient w.r.t. the
   *      tensor. If it is a tensor, it will be automatically converted
   *      to a Tensor that does not require grad unless {@code }create_graph{@code } is True.
   *      None values can be specified for scalar Tensors or ones that
   *      don't require grad. If a None value would be acceptable then
   *      this argument is optional.
   *  @param retain_graph If {@code }false{@code }, the graph used to compute
   *      the grads will be freed. Note that in nearly all cases setting
   *      this option to True is not needed and often can be worked around
   *      in a much more efficient way. Defaults to the value of
   *      {@code }create_graph{@code }.
   *  @param create_graph If {@code }true{@code }, graph of the derivative will
   *      be constructed, allowing to compute higher order derivative
   *      products. Defaults to {@code }false{@code }.
   *  @param inputs Inputs w.r.t. which the gradient will be accumulated into
   *      {@code }at::Tensor::grad{@code }. All other Tensors will be ignored. If not
   *      provided, the gradient is accumulated into all the leaf Tensors
   *      that were used to compute the current tensor.
   *      When inputs are provided and a given input is not a leaf,
   *      the current implementation will call its grad_fn (even though it is not strictly needed to get this gradients).
   *      It is an implementation detail on which the user should not rely.
   *      See https://github.com/pytorch/pytorch/pull/60521#issuecomment-867061780 for more details. */
  
  ///
  ///
  ///
  ///
  public native void backward(@Const @ByRef(nullValue = "at::Tensor{}") Tensor gradient, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional retain_graph, @Cast("bool") boolean create_graph/*=false*/, @ByVal(nullValue = "c10::optional<at::TensorList>(c10::nullopt)") TensorArrayRefOptional inputs);
  public native void backward();

  /** \fn Tensor detach() const;
   * 
   *  Returns a new Tensor, detached from the current graph.
   *  The result will never require gradient.
   <p>
   *  \fn Tensor & detach_() const;
   * 
   *  Detaches the Tensor from the graph that created it, making it a leaf.
   *  Views cannot be detached in-place.
   <p>
   *  \fn void retain_grad() const;
   * 
   *  Enables this Tensor to have their :attr:{@code grad} populated during
   *  :func:{@code backward}. This is a no-op for leaf tensors.
   <p>
   *  \fn bool retains_grad() const;
   * 
   *  Is {@code }true{@code } if this Tensor is non-leaf and its :attr:{@code grad} is enabled to be
   *  populated during :func:{@code backward}, {@code }false{@code } otherwise. */

  public native @Const @ByRef Tensor set_requires_grad(@Cast("bool") boolean requires_grad);

  /** Return a mutable reference to the gradient. This is conventionally
   *  used as {@code t.grad() = x} to set a gradient to a completely new tensor.
   *  Note that this function work with a non-const Tensor and is not
   *  thread safe. */
  public native @ByRef Tensor mutable_grad();

  /** This function returns an undefined tensor by default and returns a defined tensor
   *  the first time a call to {@code backward()} computes gradients for this Tensor.
   *  The attribute will then contain the gradients computed and future calls
   *  to {@code backward()} will accumulate (add) gradients into it. */
  public native @Const @ByRef Tensor grad();

  // The Forward AD API functions below are low level and are not to be used by end
  // users who should use the API provided in torch/csrc/autograd.h

  /** This function returns the forward gradient for this Tensor at the given level. */
  

  /** This function can be used to set the value of the forward grad.
   *  Note that the given new_grad might not be used directly if it has different
   *  metadata (size/stride/storage offset) compared to this Tensor. In that case,
   *  new_grad content will be copied into a new Tensor */
  


  // STOP.  Thinking of adding a method here, which only makes use
  // of other ATen methods?  Define it in native_functions.yaml.

  //example
  //Tensor * add(Tensor & b);
  public native void __dispatch__backward(@ByVal TensorArrayRef inputs, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional gradient, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional retain_graph, @Cast("bool") boolean create_graph/*=false*/);
  public native void __dispatch__backward(@ByVal TensorArrayRef inputs);
  public native void __dispatch__backward(@ByVal TensorVector inputs, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional gradient, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional retain_graph, @Cast("bool") boolean create_graph/*=false*/);
  public native void __dispatch__backward(@ByVal TensorVector inputs);
  public native void __dispatch_set_data(@Const @ByRef Tensor new_data);
  public native @ByVal Tensor __dispatch_data();
  public native @Cast("bool") boolean __dispatch_is_leaf();
  public native @Cast("int64_t") long __dispatch_output_nr();
  public native @Cast("int64_t") long __dispatch__version();
  public native @ByRef Tensor __dispatch_requires_grad_(@Cast("bool") boolean requires_grad/*=true*/);
  public native @ByRef Tensor __dispatch_requires_grad_();
  public native void __dispatch_retain_grad();
  public native @Cast("bool") boolean __dispatch_retains_grad();
  public native @ByVal Tensor _fw_primal(@Cast("int64_t") long level);
  public native @ByRef Tensor rename_(@ByVal DimnameListOptional names);
  public native @ByVal Tensor rename(@ByVal DimnameListOptional names);
  public native @ByVal Tensor align_to(@ByVal DimnameArrayRef names);
  public native @ByVal Tensor align_to(@ByVal DimnameVector names);
  public native @ByVal Tensor align_to(@ByVal DimnameArrayRef order, @Cast("int64_t") long ellipsis_idx);
  public native @ByVal Tensor align_to(@ByVal DimnameVector order, @Cast("int64_t") long ellipsis_idx);
  public native @ByVal Tensor align_as(@Const @ByRef Tensor other);
  public native @ByVal Tensor refine_names(@ByVal DimnameArrayRef names);
  public native @ByVal Tensor refine_names(@ByVal DimnameVector names);
  public native @ByVal Tensor abs();
  public native @ByRef Tensor abs_();
  public native @ByVal Tensor absolute();
  public native @ByRef Tensor absolute_();
  public native @ByVal Tensor angle();
  public native @ByVal Tensor sgn();
  public native @ByRef Tensor sgn_();
  public native @ByVal Tensor chalf(@ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @ByVal Tensor chalf();
  public native @ByVal Tensor _conj();
  public native @ByVal Tensor __dispatch_conj();
  public native @ByVal Tensor _conj_physical();
  public native @ByVal Tensor conj_physical();
  public native @ByRef Tensor conj_physical_();
  public native @ByVal Tensor resolve_conj();
  public native @ByVal Tensor resolve_neg();
  public native @ByVal Tensor _neg_view();
  public native @ByVal Tensor acos();
  public native @ByRef Tensor acos_();
  public native @ByVal Tensor arccos();
  public native @ByRef Tensor arccos_();
  public native @ByVal Tensor add(@Const @ByRef Tensor other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor add(@Const @ByRef Tensor other);
  public native @ByRef Tensor add_(@Const @ByRef Tensor other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor add_(@Const @ByRef Tensor other);
  public native @ByVal Tensor add(@Const @ByRef Scalar other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor add(@Const @ByRef Scalar other);
  public native @ByRef Tensor add_(@Const @ByRef Scalar other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor add_(@Const @ByRef Scalar other);
  public native @ByVal Tensor addmv(@Const @ByRef Tensor mat, @Const @ByRef Tensor vec, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor addmv(@Const @ByRef Tensor mat, @Const @ByRef Tensor vec);
  public native @ByRef Tensor addmv_(@Const @ByRef Tensor mat, @Const @ByRef Tensor vec, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor addmv_(@Const @ByRef Tensor mat, @Const @ByRef Tensor vec);
  public native @ByVal Tensor addr(@Const @ByRef Tensor vec1, @Const @ByRef Tensor vec2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor addr(@Const @ByRef Tensor vec1, @Const @ByRef Tensor vec2);
  public native @ByRef Tensor addr_(@Const @ByRef Tensor vec1, @Const @ByRef Tensor vec2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor addr_(@Const @ByRef Tensor vec1, @Const @ByRef Tensor vec2);
  public native @ByVal Tensor _is_all_true();
  public native @ByVal Tensor _is_any_true();
  public native @ByVal Tensor all(@Cast("int64_t") long dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor all(@Cast("int64_t") long dim);
  public native @ByVal Tensor all(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor all(@ByVal Dimname dim);
  public native @Cast("bool") boolean allclose(@Const @ByRef Tensor other, double rtol/*=1e-05*/, double atol/*=1e-08*/, @Cast("bool") boolean equal_nan/*=false*/);
  public native @Cast("bool") boolean allclose(@Const @ByRef Tensor other);
  public native @ByVal Tensor any(@Cast("int64_t") long dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor any(@Cast("int64_t") long dim);
  public native @ByVal Tensor any(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor any(@ByVal Dimname dim);
  public native @ByVal Tensor argmax(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor argmax();
  public native @ByVal Tensor argmin(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor argmin();
  public native @ByVal Tensor acosh();
  public native @ByRef Tensor acosh_();
  public native @ByVal Tensor arccosh();
  public native @ByRef Tensor arccosh_();
  public native @ByVal Tensor asinh();
  public native @ByRef Tensor asinh_();
  public native @ByVal Tensor arcsinh();
  public native @ByRef Tensor arcsinh_();
  public native @ByVal Tensor atanh();
  public native @ByRef Tensor atanh_();
  public native @ByVal Tensor arctanh();
  public native @ByRef Tensor arctanh_();
  public native @ByVal Tensor as_strided(@ByVal LongArrayRef size, @ByVal LongArrayRef stride, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional storage_offset);
  public native @ByVal Tensor as_strided(@ByVal LongArrayRef size, @ByVal LongArrayRef stride);
  public native @ByVal Tensor as_strided(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] stride, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional storage_offset);
  public native @ByVal Tensor as_strided(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... stride);
  public native @ByVal Tensor as_strided_symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride, @ByVal(nullValue = "c10::optional<c10::SymInt>(c10::nullopt)") SymIntOptional storage_offset);
  public native @ByVal Tensor as_strided_symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride);
  public native @Const @ByRef Tensor as_strided_(@ByVal LongArrayRef size, @ByVal LongArrayRef stride, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional storage_offset);
  public native @Const @ByRef Tensor as_strided_(@ByVal LongArrayRef size, @ByVal LongArrayRef stride);
  public native @Const @ByRef Tensor as_strided_(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] stride, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional storage_offset);
  public native @Const @ByRef Tensor as_strided_(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... stride);
  public native @Const @ByRef Tensor as_strided__symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride, @ByVal(nullValue = "c10::optional<c10::SymInt>(c10::nullopt)") SymIntOptional storage_offset);
  public native @Const @ByRef Tensor as_strided__symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride);
  public native @ByVal Tensor asin();
  public native @ByRef Tensor asin_();
  public native @ByVal Tensor arcsin();
  public native @ByRef Tensor arcsin_();
  public native @ByVal Tensor atan();
  public native @ByRef Tensor atan_();
  public native @ByVal Tensor arctan();
  public native @ByRef Tensor arctan_();
  public native @ByVal Tensor baddbmm(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor baddbmm(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2);
  public native @ByRef Tensor baddbmm_(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor baddbmm_(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2);
  public native @ByVal Tensor bernoulli(@ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByVal Tensor bernoulli();
  public native @ByRef Tensor bernoulli_(@Const @ByRef Tensor p, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor bernoulli_(@Const @ByRef Tensor p);
  public native @ByRef Tensor bernoulli_(double p/*=0.5*/, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor bernoulli_();
  public native @ByVal Tensor bernoulli(double p, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByVal Tensor bernoulli(double p);
  public native @ByVal Tensor bincount(@Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional weights, @Cast("int64_t") long minlength/*=0*/);
  public native @ByVal Tensor bincount();
  public native @ByVal Tensor bitwise_not();
  public native @ByRef Tensor bitwise_not_();
  public native @ByVal Tensor copysign(@Const @ByRef Tensor other);
  public native @ByRef Tensor copysign_(@Const @ByRef Tensor other);
  public native @ByVal Tensor copysign(@Const @ByRef Scalar other);
  public native @ByRef Tensor copysign_(@Const @ByRef Scalar other);
  public native @ByVal Tensor logical_not();
  public native @ByRef Tensor logical_not_();
  public native @ByVal Tensor logical_xor(@Const @ByRef Tensor other);
  public native @ByRef Tensor logical_xor_(@Const @ByRef Tensor other);
  public native @ByVal Tensor logical_and(@Const @ByRef Tensor other);
  public native @ByRef Tensor logical_and_(@Const @ByRef Tensor other);
  public native @ByVal Tensor logical_or(@Const @ByRef Tensor other);
  public native @ByRef Tensor logical_or_(@Const @ByRef Tensor other);
  public native @ByVal Tensor bmm(@Const @ByRef Tensor mat2);
  public native @ByVal Tensor broadcast_to(@ByVal LongArrayRef size);
  public native @ByVal Tensor broadcast_to(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByVal Tensor broadcast_to_symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor ceil();
  public native @ByRef Tensor ceil_();
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_chunk(@Cast("int64_t") long chunks, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_chunk(@Cast("int64_t") long chunks);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector chunk(@Cast("int64_t") long chunks, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector chunk(@Cast("int64_t") long chunks);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@Cast("int64_t") long sections, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@Cast("int64_t") long sections);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split_symint(@ByVal SymInt sections, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split_symint(@ByVal SymInt sections);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@ByVal LongArrayRef indices, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@ByVal LongArrayRef indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] indices, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split_symint(@ByVal SymIntArrayRef indices, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split_symint(@ByVal SymIntArrayRef indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@Const @ByRef Tensor tensor_indices_or_sections, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector tensor_split(@Const @ByRef Tensor tensor_indices_or_sections);
  public native @ByVal Tensor clamp(@Const @ByRef ScalarOptional min, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional max);
  public native @ByVal Tensor clamp(@Const @ByRef ScalarOptional min);
  public native @ByVal Tensor clamp(@Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional min, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional max);
  public native @ByVal Tensor clamp();
  public native @ByRef Tensor clamp_(@Const @ByRef ScalarOptional min, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional max);
  public native @ByRef Tensor clamp_(@Const @ByRef ScalarOptional min);
  public native @ByRef Tensor clamp_(@Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional min, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional max);
  public native @ByRef Tensor clamp_();
  public native @ByVal Tensor clamp_max(@Const @ByRef Scalar max);
  public native @ByVal Tensor clamp_max(@Const @ByRef Tensor max);
  public native @ByRef Tensor clamp_max_(@Const @ByRef Scalar max);
  public native @ByRef Tensor clamp_max_(@Const @ByRef Tensor max);
  public native @ByVal Tensor clamp_min(@Const @ByRef Scalar min);
  public native @ByVal Tensor clamp_min(@Const @ByRef Tensor min);
  public native @ByRef Tensor clamp_min_(@Const @ByRef Scalar min);
  public native @ByRef Tensor clamp_min_(@Const @ByRef Tensor min);
  public native @ByVal Tensor clip(@Const @ByRef ScalarOptional min, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional max);
  public native @ByVal Tensor clip(@Const @ByRef ScalarOptional min);
  public native @ByVal Tensor clip(@Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional min, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional max);
  public native @ByVal Tensor clip();
  public native @ByRef Tensor clip_(@Const @ByRef ScalarOptional min, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional max);
  public native @ByRef Tensor clip_(@Const @ByRef ScalarOptional min);
  public native @ByRef Tensor clip_(@Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional min, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional max);
  public native @ByRef Tensor clip_();
  public native @ByVal Tensor __dispatch_contiguous(@ByVal(nullValue = "at::MemoryFormat(c10::MemoryFormat::Contiguous)") MemoryFormat memory_format);
  public native @ByVal Tensor __dispatch_contiguous();
  public native @ByRef Tensor copy_(@Const @ByRef Tensor src, @Cast("bool") boolean non_blocking/*=false*/);
  public native @ByRef Tensor copy_(@Const @ByRef Tensor src);
  public native @ByVal Tensor cos();
  public native @ByRef Tensor cos_();
  public native @ByVal Tensor cosh();
  public native @ByRef Tensor cosh_();
  public native @ByVal Tensor count_nonzero(@ByVal LongArrayRef dim);
  public native @ByVal Tensor count_nonzero(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dim);
  public native @ByVal Tensor count_nonzero(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim);
  public native @ByVal Tensor count_nonzero();
  public native @ByVal Tensor cov(@Cast("int64_t") long correction/*=1*/, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional fweights, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional aweights);
  public native @ByVal Tensor cov();
  public native @ByVal Tensor corrcoef();
  public native @ByVal T_TensorTensor_T cummax(@Cast("int64_t") long dim);
  public native @ByVal T_TensorTensor_T cummax(@ByVal Dimname dim);
  public native @ByVal T_TensorTensor_T cummin(@Cast("int64_t") long dim);
  public native @ByVal T_TensorTensor_T cummin(@ByVal Dimname dim);
  public native @ByVal Tensor cumprod(@Cast("int64_t") long dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor cumprod(@Cast("int64_t") long dim);
  public native @ByRef Tensor cumprod_(@Cast("int64_t") long dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByRef Tensor cumprod_(@Cast("int64_t") long dim);
  public native @ByVal Tensor cumprod(@ByVal Dimname dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor cumprod(@ByVal Dimname dim);
  public native @ByRef Tensor cumprod_(@ByVal Dimname dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByRef Tensor cumprod_(@ByVal Dimname dim);
  public native @ByVal Tensor cumsum(@Cast("int64_t") long dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor cumsum(@Cast("int64_t") long dim);
  public native @ByRef Tensor cumsum_(@Cast("int64_t") long dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByRef Tensor cumsum_(@Cast("int64_t") long dim);
  public native @ByVal Tensor cumsum(@ByVal Dimname dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor cumsum(@ByVal Dimname dim);
  public native @ByRef Tensor cumsum_(@ByVal Dimname dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByRef Tensor cumsum_(@ByVal Dimname dim);
  public native @ByVal Tensor diag_embed(@Cast("int64_t") long offset/*=0*/, @Cast("int64_t") long dim1/*=-2*/, @Cast("int64_t") long dim2/*=-1*/);
  public native @ByVal Tensor diag_embed();
  public native @ByVal Tensor diagflat(@Cast("int64_t") long offset/*=0*/);
  public native @ByVal Tensor diagflat();
  public native @ByVal Tensor diagonal(@Cast("int64_t") long offset/*=0*/, @Cast("int64_t") long dim1/*=0*/, @Cast("int64_t") long dim2/*=1*/);
  public native @ByVal Tensor diagonal();
  public native @ByVal Tensor diagonal(@ByVal Dimname outdim, @ByVal Dimname dim1, @ByVal Dimname dim2, @Cast("int64_t") long offset/*=0*/);
  public native @ByVal Tensor diagonal(@ByVal Dimname outdim, @ByVal Dimname dim1, @ByVal Dimname dim2);
  public native @ByRef Tensor fill_diagonal_(@Const @ByRef Scalar fill_value, @Cast("bool") boolean wrap/*=false*/);
  public native @ByRef Tensor fill_diagonal_(@Const @ByRef Scalar fill_value);
  public native @ByVal Tensor diff(@Cast("int64_t") long n/*=1*/, @Cast("int64_t") long dim/*=-1*/, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional prepend, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional append);
  public native @ByVal Tensor diff();
  public native @ByVal Tensor div(@Const @ByRef Tensor other);
  public native @ByRef Tensor div_(@Const @ByRef Tensor other);
  public native @ByVal Tensor div(@Const @ByRef Tensor other, @ByVal StringViewOptional rounding_mode);
  public native @ByRef Tensor div_(@Const @ByRef Tensor other, @ByVal StringViewOptional rounding_mode);
  public native @ByVal Tensor div(@Const @ByRef Scalar other);
  public native @ByRef Tensor div_(@Const @ByRef Scalar other);
  public native @ByVal Tensor div(@Const @ByRef Scalar other, @ByVal StringViewOptional rounding_mode);
  public native @ByRef Tensor div_(@Const @ByRef Scalar other, @ByVal StringViewOptional rounding_mode);
  public native @ByVal Tensor divide(@Const @ByRef Tensor other);
  public native @ByRef Tensor divide_(@Const @ByRef Tensor other);
  public native @ByVal Tensor divide(@Const @ByRef Scalar other);
  public native @ByRef Tensor divide_(@Const @ByRef Scalar other);
  public native @ByVal Tensor divide(@Const @ByRef Tensor other, @ByVal StringViewOptional rounding_mode);
  public native @ByRef Tensor divide_(@Const @ByRef Tensor other, @ByVal StringViewOptional rounding_mode);
  public native @ByVal Tensor divide(@Const @ByRef Scalar other, @ByVal StringViewOptional rounding_mode);
  public native @ByRef Tensor divide_(@Const @ByRef Scalar other, @ByVal StringViewOptional rounding_mode);
  public native @ByVal Tensor true_divide(@Const @ByRef Tensor other);
  public native @ByRef Tensor true_divide_(@Const @ByRef Tensor other);
  public native @ByVal Tensor true_divide(@Const @ByRef Scalar other);
  public native @ByRef Tensor true_divide_(@Const @ByRef Scalar other);
  public native @ByVal Tensor dot(@Const @ByRef Tensor tensor);
  public native @ByVal Tensor vdot(@Const @ByRef Tensor other);
  public native @ByVal Tensor new_empty(@ByVal LongArrayRef size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_empty(@ByVal LongArrayRef size);
  public native @ByVal Tensor new_empty(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_empty(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByVal Tensor new_empty(@ByVal LongArrayRef size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_empty(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_empty_symint(@ByVal SymIntArrayRef size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_empty_symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor new_empty_symint(@ByVal SymIntArrayRef size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_empty_strided(@ByVal LongArrayRef size, @ByVal LongArrayRef stride, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_empty_strided(@ByVal LongArrayRef size, @ByVal LongArrayRef stride);
  public native @ByVal Tensor new_empty_strided(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] stride, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_empty_strided(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... stride);
  public native @ByVal Tensor new_empty_strided(@ByVal LongArrayRef size, @ByVal LongArrayRef stride, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_empty_strided(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] stride, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_empty_strided_symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_empty_strided_symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride);
  public native @ByVal Tensor new_empty_strided_symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_full(@ByVal LongArrayRef size, @Const @ByRef Scalar fill_value, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_full(@ByVal LongArrayRef size, @Const @ByRef Scalar fill_value);
  public native @ByVal Tensor new_full(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @Const @ByRef Scalar fill_value, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_full(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @Const @ByRef Scalar fill_value);
  public native @ByVal Tensor new_full(@ByVal LongArrayRef size, @Const @ByRef Scalar fill_value, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_full(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @Const @ByRef Scalar fill_value, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_full_symint(@ByVal SymIntArrayRef size, @Const @ByRef Scalar fill_value, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_full_symint(@ByVal SymIntArrayRef size, @Const @ByRef Scalar fill_value);
  public native @ByVal Tensor new_full_symint(@ByVal SymIntArrayRef size, @Const @ByRef Scalar fill_value, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_zeros(@ByVal LongArrayRef size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_zeros(@ByVal LongArrayRef size);
  public native @ByVal Tensor new_zeros(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_zeros(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByVal Tensor new_zeros(@ByVal LongArrayRef size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_zeros(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_zeros_symint(@ByVal SymIntArrayRef size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_zeros_symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor new_zeros_symint(@ByVal SymIntArrayRef size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_ones(@ByVal LongArrayRef size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_ones(@ByVal LongArrayRef size);
  public native @ByVal Tensor new_ones(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_ones(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByVal Tensor new_ones(@ByVal LongArrayRef size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_ones(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @ByVal Tensor new_ones_symint(@ByVal SymIntArrayRef size, @ByVal(nullValue = "at::TensorOptions{}") TensorOptions options);
  public native @ByVal Tensor new_ones_symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor new_ones_symint(@ByVal SymIntArrayRef size, @ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory);
  public native @Const @ByRef Tensor resize_(@ByVal LongArrayRef size, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @Const @ByRef Tensor resize_(@ByVal LongArrayRef size);
  public native @Const @ByRef Tensor resize_(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @Const @ByRef Tensor resize_(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @Const @ByRef Tensor resize__symint(@ByVal SymIntArrayRef size, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @Const @ByRef Tensor resize__symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor erf();
  public native @ByRef Tensor erf_();
  public native @ByVal Tensor erfc();
  public native @ByRef Tensor erfc_();
  public native @ByVal Tensor exp();
  public native @ByRef Tensor exp_();
  public native @ByVal Tensor exp2();
  public native @ByRef Tensor exp2_();
  public native @ByVal Tensor expm1();
  public native @ByRef Tensor expm1_();
  public native @ByVal Tensor expand(@ByVal LongArrayRef size, @Cast("bool") boolean implicit/*=false*/);
  public native @ByVal Tensor expand(@ByVal LongArrayRef size);
  public native @ByVal Tensor expand(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @Cast("bool") boolean implicit/*=false*/);
  public native @ByVal Tensor expand(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByVal Tensor expand_symint(@ByVal SymIntArrayRef size, @Cast("bool") boolean implicit/*=false*/);
  public native @ByVal Tensor expand_symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor expand_as(@Const @ByRef Tensor other);
  public native @ByVal Tensor flatten(@Cast("int64_t") long start_dim/*=0*/, @Cast("int64_t") long end_dim/*=-1*/);
  public native @ByVal Tensor flatten();
  public native @ByVal Tensor flatten(@Cast("int64_t") long start_dim, @Cast("int64_t") long end_dim, @ByVal Dimname out_dim);
  public native @ByVal Tensor flatten(@ByVal Dimname start_dim, @ByVal Dimname end_dim, @ByVal Dimname out_dim);
  public native @ByVal Tensor flatten(@ByVal DimnameArrayRef dims, @ByVal Dimname out_dim);
  public native @ByVal Tensor flatten(@ByVal DimnameVector dims, @ByVal Dimname out_dim);
  public native @ByVal Tensor unflatten(@Cast("int64_t") long dim, @ByVal LongArrayRef sizes);
  public native @ByVal Tensor unflatten(@Cast("int64_t") long dim, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... sizes);
  public native @ByVal Tensor unflatten_symint(@Cast("int64_t") long dim, @ByVal SymIntArrayRef sizes);
  public native @ByVal Tensor unflatten(@ByVal Dimname dim, @ByVal LongArrayRef sizes, @ByVal DimnameArrayRef names);
  public native @ByVal Tensor unflatten(@ByVal Dimname dim, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] sizes, @ByVal DimnameVector names);
  public native @ByVal Tensor unflatten_symint(@ByVal Dimname dim, @ByVal SymIntArrayRef sizes, @ByVal DimnameArrayRef names);
  public native @ByVal Tensor unflatten_symint(@ByVal Dimname dim, @ByVal SymIntArrayRef sizes, @ByVal DimnameVector names);
  public native @ByRef Tensor fill_(@Const @ByRef Scalar value);
  public native @ByRef Tensor fill_(@Const @ByRef Tensor value);
  public native @ByVal Tensor floor();
  public native @ByRef Tensor floor_();
  public native @ByVal Tensor floor_divide(@Const @ByRef Tensor other);
  public native @ByRef Tensor floor_divide_(@Const @ByRef Tensor other);
  public native @ByVal Tensor floor_divide(@Const @ByRef Scalar other);
  public native @ByRef Tensor floor_divide_(@Const @ByRef Scalar other);
  public native @ByVal Tensor frac();
  public native @ByRef Tensor frac_();
  public native @ByVal Tensor gcd(@Const @ByRef Tensor other);
  public native @ByRef Tensor gcd_(@Const @ByRef Tensor other);
  public native @ByVal Tensor lcm(@Const @ByRef Tensor other);
  public native @ByRef Tensor lcm_(@Const @ByRef Tensor other);
  public native @ByVal Tensor index(@Const @ByRef TensorOptionalList indices);
  public native @ByRef Tensor index_copy_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByVal Tensor index_copy(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByRef Tensor index_copy_(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByVal Tensor index_copy(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByRef Tensor index_put_(@Const @ByRef TensorOptionalList indices, @Const @ByRef Tensor values, @Cast("bool") boolean accumulate/*=false*/);
  public native @ByRef Tensor index_put_(@Const @ByRef TensorOptionalList indices, @Const @ByRef Tensor values);
  public native @ByVal Tensor index_put(@Const @ByRef TensorOptionalList indices, @Const @ByRef Tensor values, @Cast("bool") boolean accumulate/*=false*/);
  public native @ByVal Tensor index_put(@Const @ByRef TensorOptionalList indices, @Const @ByRef Tensor values);
  public native @ByVal Tensor isclose(@Const @ByRef Tensor other, double rtol/*=1e-05*/, double atol/*=1e-08*/, @Cast("bool") boolean equal_nan/*=false*/);
  public native @ByVal Tensor isclose(@Const @ByRef Tensor other);
  public native @ByVal Tensor isnan();
  public native @Cast("bool") boolean is_distributed();
  public native @Cast("bool") boolean __dispatch_is_floating_point();
  public native @Cast("bool") boolean __dispatch_is_complex();
  public native @Cast("bool") boolean __dispatch_is_conj();
  public native @Cast("bool") boolean __dispatch__is_zerotensor();
  public native @Cast("bool") boolean __dispatch_is_neg();
  public native @ByVal Tensor isreal();
  public native @Cast("bool") boolean is_nonzero();
  public native @Cast("bool") boolean is_same_size(@Const @ByRef Tensor other);
  public native @Cast("bool") boolean __dispatch_is_signed();
  public native @Cast("bool") boolean __dispatch_is_inference();
  public native @ByVal Tensor kron(@Const @ByRef Tensor other);
  public native @ByVal T_TensorTensor_T kthvalue(@Cast("int64_t") long k, @Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T kthvalue(@Cast("int64_t") long k);
  public native @ByVal T_TensorTensor_T kthvalue(@Cast("int64_t") long k, @ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T kthvalue(@Cast("int64_t") long k, @ByVal Dimname dim);
  public native @ByVal Tensor nan_to_num(@ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional nan, @ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional posinf, @ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional neginf);
  public native @ByVal Tensor nan_to_num();
  public native @ByRef Tensor nan_to_num_(@ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional nan, @ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional posinf, @ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional neginf);
  public native @ByRef Tensor nan_to_num_();
  public native @ByVal Tensor ldexp(@Const @ByRef Tensor other);
  public native @ByRef Tensor ldexp_(@Const @ByRef Tensor other);
  public native @ByVal Tensor log();
  public native @ByRef Tensor log_();
  public native @ByVal Tensor log10();
  public native @ByRef Tensor log10_();
  public native @ByVal Tensor log1p();
  public native @ByRef Tensor log1p_();
  public native @ByVal Tensor log2();
  public native @ByRef Tensor log2_();
  public native @ByVal Tensor logaddexp(@Const @ByRef Tensor other);
  public native @ByVal Tensor logaddexp2(@Const @ByRef Tensor other);
  public native @ByVal Tensor xlogy(@Const @ByRef Tensor other);
  public native @ByVal Tensor xlogy(@Const @ByRef Scalar other);
  public native @ByRef Tensor xlogy_(@Const @ByRef Tensor other);
  public native @ByRef Tensor xlogy_(@Const @ByRef Scalar other);
  public native @ByVal Tensor log_softmax(@Cast("int64_t") long dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor log_softmax(@Cast("int64_t") long dim);
  public native @ByVal Tensor log_softmax(@ByVal Dimname dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor log_softmax(@ByVal Dimname dim);
  public native @ByVal Tensor logcumsumexp(@Cast("int64_t") long dim);
  public native @ByVal Tensor logcumsumexp(@ByVal Dimname dim);
  public native @ByVal Tensor logsumexp(@ByVal LongArrayRef dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor logsumexp(@ByVal LongArrayRef dim);
  public native @ByVal Tensor logsumexp(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor logsumexp(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dim);
  public native @ByVal Tensor logsumexp(@ByVal DimnameArrayRef dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor logsumexp(@ByVal DimnameArrayRef dim);
  public native @ByVal Tensor logsumexp(@ByVal DimnameVector dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor logsumexp(@ByVal DimnameVector dim);
  public native @ByVal Tensor matmul(@Const @ByRef Tensor other);
  public native @ByVal Tensor matrix_power(@Cast("int64_t") long n);
  public native @ByVal Tensor matrix_exp();
  public native @ByVal T_TensorTensor_T aminmax(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T aminmax();
  public native @ByVal T_TensorTensor_T max(@Cast("int64_t") long dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T max(@Cast("int64_t") long dim);
  public native @ByVal T_TensorTensor_T max(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T max(@ByVal Dimname dim);
  public native @ByVal Tensor amax(@ByVal(nullValue = "at::IntArrayRef{}") LongArrayRef dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor amax();
  public native @ByVal Tensor amax(@ByVal(nullValue = "at::IntArrayRef{}") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor mean(@ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor mean();
  public native @ByVal Tensor mean(@ByVal LongArrayRefOptional dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor mean(@ByVal LongArrayRefOptional dim);
  public native @ByVal Tensor mean(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor mean(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long... dim);
  public native @ByVal Tensor mean(@ByVal DimnameArrayRef dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor mean(@ByVal DimnameArrayRef dim);
  public native @ByVal Tensor mean(@ByVal DimnameVector dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor mean(@ByVal DimnameVector dim);
  public native @ByVal Tensor nanmean(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") LongArrayRefOptional dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor nanmean();
  public native @ByVal Tensor nanmean(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor median();
  public native @ByVal T_TensorTensor_T median(@Cast("int64_t") long dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T median(@Cast("int64_t") long dim);
  public native @ByVal T_TensorTensor_T median(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T median(@ByVal Dimname dim);
  public native @ByVal Tensor nanmedian();
  public native @ByVal T_TensorTensor_T nanmedian(@Cast("int64_t") long dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T nanmedian(@Cast("int64_t") long dim);
  public native @ByVal T_TensorTensor_T nanmedian(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T nanmedian(@ByVal Dimname dim);
  public native @ByVal T_TensorTensor_T min(@Cast("int64_t") long dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T min(@Cast("int64_t") long dim);
  public native @ByVal T_TensorTensor_T min(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T min(@ByVal Dimname dim);
  public native @ByVal Tensor amin(@ByVal(nullValue = "at::IntArrayRef{}") LongArrayRef dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor amin();
  public native @ByVal Tensor amin(@ByVal(nullValue = "at::IntArrayRef{}") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor mm(@Const @ByRef Tensor mat2);
  public native @ByVal T_TensorTensor_T mode(@Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T mode();
  public native @ByVal T_TensorTensor_T mode(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal T_TensorTensor_T mode(@ByVal Dimname dim);
  public native @ByVal Tensor mul(@Const @ByRef Tensor other);
  public native @ByRef Tensor mul_(@Const @ByRef Tensor other);
  public native @ByVal Tensor mul(@Const @ByRef Scalar other);
  public native @ByRef Tensor mul_(@Const @ByRef Scalar other);
  public native @ByVal Tensor multiply(@Const @ByRef Tensor other);
  public native @ByRef Tensor multiply_(@Const @ByRef Tensor other);
  public native @ByVal Tensor multiply(@Const @ByRef Scalar other);
  public native @ByRef Tensor multiply_(@Const @ByRef Scalar other);
  public native @ByVal Tensor mv(@Const @ByRef Tensor vec);
  public native @ByVal Tensor mvlgamma(@Cast("int64_t") long p);
  public native @ByRef Tensor mvlgamma_(@Cast("int64_t") long p);
  public native @ByVal Tensor narrow_copy(@Cast("int64_t") long dim, @Cast("int64_t") long start, @Cast("int64_t") long length);
  public native @ByVal Tensor narrow_copy_symint(@Cast("int64_t") long dim, @ByVal SymInt start, @ByVal SymInt length);
  public native @ByVal Tensor narrow(@Cast("int64_t") long dim, @Cast("int64_t") long start, @Cast("int64_t") long length);
  public native @ByVal Tensor narrow_symint(@Cast("int64_t") long dim, @ByVal SymInt start, @ByVal SymInt length);
  public native @ByVal Tensor narrow(@Cast("int64_t") long dim, @Const @ByRef Tensor start, @Cast("int64_t") long length);
  public native @ByVal Tensor narrow_symint(@Cast("int64_t") long dim, @Const @ByRef Tensor start, @ByVal SymInt length);
  public native @ByVal Tensor permute(@ByVal LongArrayRef dims);
  public native @ByVal Tensor permute(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dims);
  public native @ByVal Tensor movedim(@ByVal LongArrayRef source, @ByVal LongArrayRef destination);
  public native @ByVal Tensor movedim(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] source, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... destination);
  public native @ByVal Tensor movedim(@Cast("int64_t") long source, @Cast("int64_t") long destination);
  public native @ByVal Tensor moveaxis(@ByVal LongArrayRef source, @ByVal LongArrayRef destination);
  public native @ByVal Tensor moveaxis(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] source, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... destination);
  public native @ByVal Tensor moveaxis(@Cast("int64_t") long source, @Cast("int64_t") long destination);
  public native @ByVal Tensor numpy_T();
  public native @ByVal Tensor matrix_H();
  public native @ByVal Tensor mT();
  public native @ByVal Tensor mH();
  public native @ByVal Tensor adjoint();
  public native @Cast("bool") boolean is_pinned(@ByVal(nullValue = "c10::optional<at::Device>(c10::nullopt)") DeviceOptional device);
  public native @Cast("bool") boolean is_pinned();
  public native @ByVal Tensor pin_memory(@ByVal(nullValue = "c10::optional<at::Device>(c10::nullopt)") DeviceOptional device);
  public native @ByVal Tensor pin_memory();
  public native @ByVal Tensor pinverse(double rcond/*=1e-15*/);
  public native @ByVal Tensor pinverse();
  public native @ByVal Tensor rad2deg();
  public native @ByRef Tensor rad2deg_();
  public native @ByVal Tensor deg2rad();
  public native @ByRef Tensor deg2rad_();
  public native @ByVal Tensor ravel();
  public native @ByVal Tensor reciprocal();
  public native @ByRef Tensor reciprocal_();
  public native @ByVal Tensor neg();
  public native @ByRef Tensor neg_();
  public native @ByVal Tensor negative();
  public native @ByRef Tensor negative_();
  public native @ByVal Tensor repeat(@ByVal LongArrayRef repeats);
  public native @ByVal Tensor repeat(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... repeats);
  public native @ByVal Tensor repeat_symint(@ByVal SymIntArrayRef repeats);
  public native @ByVal Tensor repeat_interleave(@Const @ByRef Tensor repeats, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional output_size);
  public native @ByVal Tensor repeat_interleave(@Const @ByRef Tensor repeats);
  public native @ByVal Tensor repeat_interleave(@Cast("int64_t") long repeats, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional output_size);
  public native @ByVal Tensor repeat_interleave(@Cast("int64_t") long repeats);
  public native @ByVal Tensor repeat_interleave_symint(@ByVal SymInt repeats, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional output_size);
  public native @ByVal Tensor repeat_interleave_symint(@ByVal SymInt repeats);
  public native @ByVal Tensor reshape(@ByVal LongArrayRef shape);
  public native @ByVal Tensor reshape(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... shape);
  public native @ByVal Tensor reshape_symint(@ByVal SymIntArrayRef shape);
  public native @ByVal Tensor _reshape_alias(@ByVal LongArrayRef size, @ByVal LongArrayRef stride);
  public native @ByVal Tensor _reshape_alias(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... stride);
  public native @ByVal Tensor _reshape_alias_symint(@ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride);
  public native @ByVal Tensor reshape_as(@Const @ByRef Tensor other);
  public native @ByVal Tensor round();
  public native @ByRef Tensor round_();
  public native @ByVal Tensor round(@Cast("int64_t") long decimals);
  public native @ByRef Tensor round_(@Cast("int64_t") long decimals);
  public native @ByVal Tensor relu();
  public native @ByRef Tensor relu_();
  public native @ByVal Tensor prelu(@Const @ByRef Tensor weight);
  public native @ByVal Tensor hardshrink(@Const @ByRef(nullValue = "at::Scalar(0.5)") Scalar lambd);
  public native @ByVal Tensor hardshrink();
  public native @ByVal Tensor hardshrink_backward(@Const @ByRef Tensor grad_out, @Const @ByRef Scalar lambd);
  public native @ByVal Tensor rsqrt();
  public native @ByRef Tensor rsqrt_();
  public native @ByVal Tensor select(@ByVal Dimname dim, @Cast("int64_t") long index);
  public native @ByVal Tensor select(@Cast("int64_t") long dim, @Cast("int64_t") long index);
  public native @ByVal Tensor select_symint(@Cast("int64_t") long dim, @ByVal SymInt index);
  public native @ByVal Tensor sigmoid();
  public native @ByRef Tensor sigmoid_();
  public native @ByVal Tensor logit(@ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional eps);
  public native @ByVal Tensor logit();
  public native @ByRef Tensor logit_(@ByVal(nullValue = "c10::optional<double>(c10::nullopt)") DoubleOptional eps);
  public native @ByRef Tensor logit_();
  public native @ByVal Tensor sin();
  public native @ByRef Tensor sin_();
  public native @ByVal Tensor sinc();
  public native @ByRef Tensor sinc_();
  public native @ByVal Tensor sinh();
  public native @ByRef Tensor sinh_();
  public native @ByVal Tensor detach();
  public native @ByRef Tensor detach_();
  public native @Cast("int64_t") long size(@ByVal Dimname dim);
  public native @ByVal Tensor slice(@Cast("int64_t") long dim/*=0*/, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional start, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional end, @Cast("int64_t") long step/*=1*/);
  public native @ByVal Tensor slice();
  public native @ByVal Tensor slice_symint(@Cast("int64_t") long dim/*=0*/, @ByVal(nullValue = "c10::optional<c10::SymInt>(c10::nullopt)") SymIntOptional start, @ByVal(nullValue = "c10::optional<c10::SymInt>(c10::nullopt)") SymIntOptional end, @ByVal(nullValue = "c10::SymInt(1)") SymInt step);
  public native @ByVal Tensor slice_symint();
  public native @ByVal Tensor slice_scatter(@Const @ByRef Tensor src, @Cast("int64_t") long dim/*=0*/, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional start, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional end, @Cast("int64_t") long step/*=1*/);
  public native @ByVal Tensor slice_scatter(@Const @ByRef Tensor src);
  public native @ByVal Tensor slice_scatter_symint(@Const @ByRef Tensor src, @Cast("int64_t") long dim/*=0*/, @ByVal(nullValue = "c10::optional<c10::SymInt>(c10::nullopt)") SymIntOptional start, @ByVal(nullValue = "c10::optional<c10::SymInt>(c10::nullopt)") SymIntOptional end, @ByVal(nullValue = "c10::SymInt(1)") SymInt step);
  public native @ByVal Tensor slice_scatter_symint(@Const @ByRef Tensor src);
  public native @ByVal Tensor select_scatter(@Const @ByRef Tensor src, @Cast("int64_t") long dim, @Cast("int64_t") long index);
  public native @ByVal Tensor select_scatter_symint(@Const @ByRef Tensor src, @Cast("int64_t") long dim, @ByVal SymInt index);
  public native @ByVal Tensor diagonal_scatter(@Const @ByRef Tensor src, @Cast("int64_t") long offset/*=0*/, @Cast("int64_t") long dim1/*=0*/, @Cast("int64_t") long dim2/*=1*/);
  public native @ByVal Tensor diagonal_scatter(@Const @ByRef Tensor src);
  public native @ByVal Tensor as_strided_scatter(@Const @ByRef Tensor src, @ByVal LongArrayRef size, @ByVal LongArrayRef stride, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional storage_offset);
  public native @ByVal Tensor as_strided_scatter(@Const @ByRef Tensor src, @ByVal LongArrayRef size, @ByVal LongArrayRef stride);
  public native @ByVal Tensor as_strided_scatter(@Const @ByRef Tensor src, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] stride, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional storage_offset);
  public native @ByVal Tensor as_strided_scatter(@Const @ByRef Tensor src, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... stride);
  public native @ByVal Tensor as_strided_scatter_symint(@Const @ByRef Tensor src, @ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride, @ByVal(nullValue = "c10::optional<c10::SymInt>(c10::nullopt)") SymIntOptional storage_offset);
  public native @ByVal Tensor as_strided_scatter_symint(@Const @ByRef Tensor src, @ByVal SymIntArrayRef size, @ByVal SymIntArrayRef stride);
  public native @ByVal Tensor smm(@Const @ByRef Tensor mat2);
  public native @ByVal Tensor softmax(@Cast("int64_t") long dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor softmax(@Cast("int64_t") long dim);
  public native @ByVal Tensor softmax(@ByVal Dimname dim, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor softmax(@ByVal Dimname dim);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split(@Cast("int64_t") long split_size, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split(@Cast("int64_t") long split_size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_symint(@ByVal SymInt split_size, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_symint(@ByVal SymInt split_size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split(@Cast("int64_t") long split_size, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split(@Cast("int64_t") long split_size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_symint(@ByVal SymInt split_size, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_symint(@ByVal SymInt split_size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split(@ByVal LongArrayRef split_size, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split(@ByVal LongArrayRef split_size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] split_size, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... split_size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_symint(@ByVal SymIntArrayRef split_size, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_symint(@ByVal SymIntArrayRef split_size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_with_sizes(@ByVal LongArrayRef split_sizes, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_with_sizes(@ByVal LongArrayRef split_sizes);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_with_sizes(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] split_sizes, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_with_sizes(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... split_sizes);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_with_sizes_symint(@ByVal SymIntArrayRef split_sizes, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unsafe_split_with_sizes_symint(@ByVal SymIntArrayRef split_sizes);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_with_sizes(@ByVal LongArrayRef split_sizes, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_with_sizes(@ByVal LongArrayRef split_sizes);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_with_sizes(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] split_sizes, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_with_sizes(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... split_sizes);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_with_sizes_symint(@ByVal SymIntArrayRef split_sizes, @Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector split_with_sizes_symint(@ByVal SymIntArrayRef split_sizes);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector hsplit(@Cast("int64_t") long sections);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector hsplit(@ByVal LongArrayRef indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector hsplit(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector vsplit(@Cast("int64_t") long sections);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector vsplit(@ByVal LongArrayRef indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector vsplit(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector dsplit(@Cast("int64_t") long sections);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector dsplit(@ByVal LongArrayRef indices);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector dsplit(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... indices);
  public native @ByVal Tensor squeeze();
  public native @ByVal Tensor squeeze(@Cast("int64_t") long dim);
  public native @ByVal Tensor squeeze(@ByVal Dimname dim);
  public native @ByVal Tensor squeeze(@ByVal LongArrayRef dim);
  public native @ByVal Tensor squeeze(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dim);
  public native @ByRef Tensor squeeze_();
  public native @ByRef Tensor squeeze_(@Cast("int64_t") long dim);
  public native @ByRef Tensor squeeze_(@ByVal LongArrayRef dim);
  public native @ByRef Tensor squeeze_(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dim);
  public native @ByRef Tensor squeeze_(@ByVal Dimname dim);
  public native @ByVal Tensor sspaddmm(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor sspaddmm(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2);
  public native @ByVal Tensor stft(@Cast("int64_t") long n_fft, @ByVal LongOptional hop_length, @ByVal LongOptional win_length, @Const @ByRef TensorOptional window, @Cast("bool") boolean normalized, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional onesided, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional return_complex);
  public native @ByVal Tensor stft(@Cast("int64_t") long n_fft, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional hop_length, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional win_length, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional window, @Cast("bool") boolean center/*=true*/, @StringView BytePointer pad_mode/*="reflect"*/, @Cast("bool") boolean normalized/*=false*/, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional onesided, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional return_complex);
  public native @ByVal Tensor stft(@Cast("int64_t") long n_fft, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional hop_length, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional win_length, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional window, @Cast("bool") boolean center/*=true*/, @StringView String pad_mode/*="reflect"*/, @Cast("bool") boolean normalized/*=false*/, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional onesided, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional return_complex);
  public native @ByVal Tensor istft(@Cast("int64_t") long n_fft, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional hop_length, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional win_length, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional window, @Cast("bool") boolean center/*=true*/, @Cast("bool") boolean normalized/*=false*/, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional onesided, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional length, @Cast("bool") boolean return_complex/*=false*/);
  public native @ByVal Tensor istft(@Cast("int64_t") long n_fft);
  public native @Cast("int64_t") long stride(@ByVal Dimname dim);
  public native @ByVal Tensor sum(@ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor sum();
  public native @ByVal Tensor sum(@ByVal LongArrayRefOptional dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor sum(@ByVal LongArrayRefOptional dim);
  public native @ByVal Tensor sum(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor sum(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long... dim);
  public native @ByVal Tensor sum(@ByVal DimnameArrayRef dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor sum(@ByVal DimnameArrayRef dim);
  public native @ByVal Tensor sum(@ByVal DimnameVector dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor sum(@ByVal DimnameVector dim);
  public native @ByVal Tensor nansum(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") LongArrayRefOptional dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor nansum();
  public native @ByVal Tensor nansum(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor sum_to_size(@ByVal LongArrayRef size);
  public native @ByVal Tensor sum_to_size(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByVal Tensor sum_to_size_symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor sqrt();
  public native @ByRef Tensor sqrt_();
  public native @ByVal Tensor square();
  public native @ByRef Tensor square_();
  public native @ByVal Tensor std(@Cast("bool") boolean unbiased);
  public native @ByVal Tensor std(@ByVal LongArrayRefOptional dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std(@ByVal LongArrayRefOptional dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor std(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor std(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") LongArrayRefOptional dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std();
  public native @ByVal Tensor std(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std(@ByVal DimnameArrayRef dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std(@ByVal DimnameArrayRef dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor std(@ByVal DimnameVector dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std(@ByVal DimnameVector dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor std(@ByVal DimnameArrayRef dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std(@ByVal DimnameArrayRef dim);
  public native @ByVal Tensor std(@ByVal DimnameVector dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor std(@ByVal DimnameVector dim);
  public native @ByVal Tensor prod(@ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor prod();
  public native @ByVal Tensor prod(@Cast("int64_t") long dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor prod(@Cast("int64_t") long dim);
  public native @ByVal Tensor prod(@ByVal Dimname dim, @Cast("bool") boolean keepdim/*=false*/, @ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor prod(@ByVal Dimname dim);
  public native @ByVal Tensor t();
  public native @ByRef Tensor t_();
  public native @ByVal Tensor tan();
  public native @ByRef Tensor tan_();
  public native @ByVal Tensor tanh();
  public native @ByRef Tensor tanh_();
  public native @ByVal Tensor tile(@ByVal LongArrayRef dims);
  public native @ByVal Tensor tile(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dims);
  public native @ByVal Tensor tile_symint(@ByVal SymIntArrayRef dims);
  public native @ByVal Tensor transpose(@Cast("int64_t") long dim0, @Cast("int64_t") long dim1);
  public native @ByVal Tensor transpose(@ByVal Dimname dim0, @ByVal Dimname dim1);
  public native @ByRef Tensor transpose_(@Cast("int64_t") long dim0, @Cast("int64_t") long dim1);
  public native @ByVal Tensor flip(@ByVal LongArrayRef dims);
  public native @ByVal Tensor flip(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dims);
  public native @ByVal Tensor fliplr();
  public native @ByVal Tensor flipud();
  public native @ByVal Tensor roll(@ByVal LongArrayRef shifts, @ByVal(nullValue = "at::IntArrayRef{}") LongArrayRef dims);
  public native @ByVal Tensor roll(@ByVal LongArrayRef shifts);
  public native @ByVal Tensor roll(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] shifts, @ByVal(nullValue = "at::IntArrayRef{}") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dims);
  public native @ByVal Tensor roll(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... shifts);
  public native @ByVal Tensor roll_symint(@ByVal SymIntArrayRef shifts, @ByVal(nullValue = "at::IntArrayRef{}") LongArrayRef dims);
  public native @ByVal Tensor roll_symint(@ByVal SymIntArrayRef shifts);
  public native @ByVal Tensor roll_symint(@ByVal SymIntArrayRef shifts, @ByVal(nullValue = "at::IntArrayRef{}") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dims);
  public native @ByVal Tensor rot90(@Cast("int64_t") long k/*=1*/, @ByVal(nullValue = "at::IntArrayRef({0,1})") LongArrayRef dims);
  public native @ByVal Tensor rot90();
  public native @ByVal Tensor rot90(@Cast("int64_t") long k/*=1*/, @ByVal(nullValue = "at::IntArrayRef({0,1})") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dims);
  public native @ByVal Tensor _nested_tensor_size();
  public native @ByVal Tensor _nested_tensor_strides();
  public native @ByVal Tensor _nested_tensor_storage_offsets();
  public native @ByVal Tensor trunc();
  public native @ByRef Tensor trunc_();
  public native @ByVal Tensor fix();
  public native @ByRef Tensor fix_();
  public native @ByVal Tensor type_as(@Const @ByRef Tensor other);
  public native @ByVal Tensor unsqueeze(@Cast("int64_t") long dim);
  public native @ByRef Tensor unsqueeze_(@Cast("int64_t") long dim);
  public native @ByVal Tensor var(@Cast("bool") boolean unbiased);
  public native @ByVal Tensor var(@ByVal LongArrayRefOptional dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var(@ByVal LongArrayRefOptional dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor var(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor var(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") LongArrayRefOptional dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var();
  public native @ByVal Tensor var(@ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var(@ByVal DimnameArrayRef dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var(@ByVal DimnameArrayRef dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor var(@ByVal DimnameVector dim, @Cast("bool") boolean unbiased, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var(@ByVal DimnameVector dim, @Cast("bool") boolean unbiased);
  public native @ByVal Tensor var(@ByVal DimnameArrayRef dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var(@ByVal DimnameArrayRef dim);
  public native @ByVal Tensor var(@ByVal DimnameVector dim, @Const @ByRef(nullValue = "c10::optional<at::Scalar>(c10::nullopt)") ScalarOptional correction, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor var(@ByVal DimnameVector dim);
  public native @ByVal Tensor view_as(@Const @ByRef Tensor other);
  public native @ByVal Tensor where(@Const @ByRef Tensor condition, @Const @ByRef Tensor other);
  public native @ByVal Tensor where(@Const @ByRef Tensor condition, @Const @ByRef Scalar other);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, ScalarType dtype);
  public native @ByVal Tensor norm(@Const @ByRef(nullValue = "at::Scalar(2)") Scalar p);
  public native @ByVal Tensor norm();
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal LongArrayRef dim, @Cast("bool") boolean keepdim, ScalarType dtype);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] dim, @Cast("bool") boolean keepdim, ScalarType dtype);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal LongArrayRef dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal LongArrayRef dim);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... dim);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal DimnameArrayRef dim, @Cast("bool") boolean keepdim, ScalarType dtype);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal DimnameVector dim, @Cast("bool") boolean keepdim, ScalarType dtype);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal DimnameArrayRef dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal DimnameArrayRef dim);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal DimnameVector dim, @Cast("bool") boolean keepdim/*=false*/);
  public native @ByVal Tensor norm(@Const @ByRef ScalarOptional p, @ByVal DimnameVector dim);
  public native @ByVal T_TensorTensor_T frexp();
  public native @ByVal Tensor clone(@ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @ByVal Tensor clone();
  public native @ByVal Tensor positive();
  public native @Const @ByRef Tensor resize_as_(@Const @ByRef Tensor the_template, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @Const @ByRef Tensor resize_as_(@Const @ByRef Tensor the_template);
  public native @Const @ByRef Tensor resize_as_sparse_(@Const @ByRef Tensor the_template);
  public native @ByRef Tensor zero_();
  public native @ByVal Tensor sub(@Const @ByRef Tensor other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor sub(@Const @ByRef Tensor other);
  public native @ByRef Tensor sub_(@Const @ByRef Tensor other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor sub_(@Const @ByRef Tensor other);
  public native @ByVal Tensor sub(@Const @ByRef Scalar other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor sub(@Const @ByRef Scalar other);
  public native @ByRef Tensor sub_(@Const @ByRef Scalar other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor sub_(@Const @ByRef Scalar other);
  public native @ByVal Tensor subtract(@Const @ByRef Tensor other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor subtract(@Const @ByRef Tensor other);
  public native @ByRef Tensor subtract_(@Const @ByRef Tensor other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor subtract_(@Const @ByRef Tensor other);
  public native @ByVal Tensor subtract(@Const @ByRef Scalar other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor subtract(@Const @ByRef Scalar other);
  public native @ByRef Tensor subtract_(@Const @ByRef Scalar other, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor subtract_(@Const @ByRef Scalar other);
  public native @ByVal Tensor heaviside(@Const @ByRef Tensor values);
  public native @ByRef Tensor heaviside_(@Const @ByRef Tensor values);
  public native @ByVal Tensor addmm(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor addmm(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2);
  public native @ByRef Tensor addmm_(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor addmm_(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2);
  public native @ByVal Tensor _addmm_activation(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha, @Cast("bool") boolean use_gelu/*=false*/);
  public native @ByVal Tensor _addmm_activation(@Const @ByRef Tensor mat1, @Const @ByRef Tensor mat2);
  public native @Const @ByRef Tensor sparse_resize_(@ByVal LongArrayRef size, @Cast("int64_t") long sparse_dim, @Cast("int64_t") long dense_dim);
  public native @Const @ByRef Tensor sparse_resize_(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @Cast("int64_t") long sparse_dim, @Cast("int64_t") long dense_dim);
  public native @Const @ByRef Tensor sparse_resize_and_clear_(@ByVal LongArrayRef size, @Cast("int64_t") long sparse_dim, @Cast("int64_t") long dense_dim);
  public native @Const @ByRef Tensor sparse_resize_and_clear_(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @Cast("int64_t") long sparse_dim, @Cast("int64_t") long dense_dim);
  public native @ByVal Tensor sparse_mask(@Const @ByRef Tensor mask);
  public native @ByVal Tensor _sparse_mask_projection(@Const @ByRef Tensor mask, @Cast("bool") boolean accumulate_matches/*=false*/);
  public native @ByVal Tensor _sparse_mask_projection(@Const @ByRef Tensor mask);
  public native @ByVal Tensor to_dense(@ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional masked_grad);
  public native @ByVal Tensor to_dense();
  public native @ByVal Tensor _to_dense(@ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype, @ByVal(nullValue = "c10::optional<bool>(c10::nullopt)") BoolOptional masked_grad);
  public native @ByVal Tensor _to_dense();
  public native @Cast("int64_t") long sparse_dim();
  public native @Cast("int64_t") long _dimI();
  public native @Cast("int64_t") long dense_dim();
  public native @Cast("int64_t") long _dimV();
  public native @Cast("int64_t") long _nnz();
  public native @ByVal Tensor coalesce();
  public native @Cast("bool") boolean is_coalesced();
  public native @ByVal Tensor _indices();
  public native @ByVal Tensor _values();
  public native @ByRef Tensor _coalesced_(@Cast("bool") boolean coalesced);
  public native @ByVal Tensor indices();
  public native @ByVal Tensor values();
  public native @ByVal Tensor crow_indices();
  public native @ByVal Tensor col_indices();
  public native @ByVal Tensor ccol_indices();
  public native @ByVal Tensor row_indices();
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unbind(@Cast("int64_t") long dim/*=0*/);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unbind();
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector unbind(@ByVal Dimname dim);
  public native @ByVal Tensor to_sparse(@Cast("int64_t") long sparse_dim);
  public native @ByVal Tensor _to_sparse(@Cast("int64_t") long sparse_dim);
  public native @ByVal Tensor to_sparse(@ByVal(nullValue = "c10::optional<at::Layout>(c10::nullopt)") LayoutOptional layout, @ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") LongArrayRefOptional blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse();
  public native @ByVal Tensor to_sparse(@ByVal(nullValue = "c10::optional<at::Layout>(c10::nullopt)") LayoutOptional layout, @ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse(@ByVal(nullValue = "c10::optional<at::Layout>(c10::nullopt)") LayoutOptional layout, @ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") LongArrayRefOptional blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse();
  public native @ByVal Tensor _to_sparse(@ByVal(nullValue = "c10::optional<at::Layout>(c10::nullopt)") LayoutOptional layout, @ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long[] blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse_csr(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse_csr();
  public native @ByVal Tensor _to_sparse_csr(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse_csr();
  public native @ByVal Tensor to_sparse_csc(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse_csc();
  public native @ByVal Tensor _to_sparse_csc(@ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse_csc();
  public native @ByVal Tensor to_sparse_bsr(@ByVal LongArrayRef blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse_bsr(@ByVal LongArrayRef blocksize);
  public native @ByVal Tensor to_sparse_bsr(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse_bsr(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... blocksize);
  public native @ByVal Tensor _to_sparse_bsr(@ByVal LongArrayRef blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse_bsr(@ByVal LongArrayRef blocksize);
  public native @ByVal Tensor _to_sparse_bsr(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse_bsr(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... blocksize);
  public native @ByVal Tensor to_sparse_bsc(@ByVal LongArrayRef blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse_bsc(@ByVal LongArrayRef blocksize);
  public native @ByVal Tensor to_sparse_bsc(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor to_sparse_bsc(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... blocksize);
  public native @ByVal Tensor _to_sparse_bsc(@ByVal LongArrayRef blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse_bsc(@ByVal LongArrayRef blocksize);
  public native @ByVal Tensor _to_sparse_bsc(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] blocksize, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dense_dim);
  public native @ByVal Tensor _to_sparse_bsc(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... blocksize);
  public native @ByVal Tensor to_mkldnn(@ByVal(nullValue = "c10::optional<at::ScalarType>(c10::nullopt)") ScalarTypeOptional dtype);
  public native @ByVal Tensor to_mkldnn();
  public native @ByVal Tensor dequantize();
  public native double q_scale();
  public native @Cast("int64_t") long q_zero_point();
  public native @ByVal Tensor q_per_channel_scales();
  public native @ByVal Tensor q_per_channel_zero_points();
  public native @Cast("int64_t") long q_per_channel_axis();
  public native @ByVal Tensor int_repr();
  public native @ByVal QScheme qscheme();
  public native @ByVal Tensor _autocast_to_reduced_precision(@Cast("bool") boolean cuda_enabled, @Cast("bool") boolean cpu_enabled, ScalarType cuda_dtype, ScalarType cpu_dtype);
  public native @ByVal Tensor _autocast_to_full_precision(@Cast("bool") boolean cuda_enabled, @Cast("bool") boolean cpu_enabled);
  public native @ByVal Tensor to(@ByVal(nullValue = "at::TensorOptions{}") TensorOptions options, @Cast("bool") boolean non_blocking/*=false*/, @Cast("bool") boolean copy/*=false*/, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @ByVal Tensor to();
  public native @ByVal Tensor to(@ByVal ScalarTypeOptional dtype, @ByVal LayoutOptional layout, @ByVal DeviceOptional device, @ByVal BoolOptional pin_memory, @Cast("bool") boolean non_blocking, @Cast("bool") boolean copy, @ByVal MemoryFormatOptional memory_format);
  public native @ByVal Tensor to(@ByVal Device device, ScalarType dtype, @Cast("bool") boolean non_blocking/*=false*/, @Cast("bool") boolean copy/*=false*/, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @ByVal Tensor to(@ByVal Device device, ScalarType dtype);
  public native @ByVal Tensor to(ScalarType dtype, @Cast("bool") boolean non_blocking/*=false*/, @Cast("bool") boolean copy/*=false*/, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @ByVal Tensor to(ScalarType dtype);
  public native @ByVal Tensor to(@Const @ByRef Tensor other, @Cast("bool") boolean non_blocking/*=false*/, @Cast("bool") boolean copy/*=false*/, @ByVal(nullValue = "c10::optional<at::MemoryFormat>(c10::nullopt)") MemoryFormatOptional memory_format);
  public native @ByVal Tensor to(@Const @ByRef Tensor other);
  public native @ByVal Scalar item();
  public native @ByRef Tensor set_(@Cast({"", "c10::Storage&&"}) @StdMove Storage source);
  public native @ByRef Tensor set_(@Cast({"", "c10::Storage&&"}) @StdMove Storage source, @Cast("int64_t") long storage_offset, @ByVal LongArrayRef size, @ByVal(nullValue = "at::IntArrayRef{}") LongArrayRef stride);
  public native @ByRef Tensor set_(@Cast({"", "c10::Storage&&"}) @StdMove Storage source, @Cast("int64_t") long storage_offset, @ByVal LongArrayRef size);
  public native @ByRef Tensor set_(@Cast({"", "c10::Storage&&"}) @StdMove Storage source, @Cast("int64_t") long storage_offset, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal(nullValue = "at::IntArrayRef{}") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... stride);
  public native @ByRef Tensor set_(@Cast({"", "c10::Storage&&"}) @StdMove Storage source, @Cast("int64_t") long storage_offset, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByRef Tensor set__symint(@Cast({"", "c10::Storage&&"}) @StdMove Storage source, @ByVal SymInt storage_offset, @ByVal SymIntArrayRef size, @ByVal(nullValue = "c10::SymIntArrayRef{}") SymIntArrayRef stride);
  public native @ByRef Tensor set__symint(@Cast({"", "c10::Storage&&"}) @StdMove Storage source, @ByVal SymInt storage_offset, @ByVal SymIntArrayRef size);
  public native @ByRef Tensor set_(@Const @ByRef Tensor source, @Cast("int64_t") long storage_offset, @ByVal LongArrayRef size, @ByVal(nullValue = "at::IntArrayRef{}") LongArrayRef stride);
  public native @ByRef Tensor set_(@Const @ByRef Tensor source, @Cast("int64_t") long storage_offset, @ByVal LongArrayRef size);
  public native @ByRef Tensor set_(@Const @ByRef Tensor source, @Cast("int64_t") long storage_offset, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long[] size, @ByVal(nullValue = "at::IntArrayRef{}") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... stride);
  public native @ByRef Tensor set_(@Const @ByRef Tensor source, @Cast("int64_t") long storage_offset, @ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByRef Tensor set__symint(@Const @ByRef Tensor source, @ByVal SymInt storage_offset, @ByVal SymIntArrayRef size, @ByVal(nullValue = "c10::SymIntArrayRef{}") SymIntArrayRef stride);
  public native @ByRef Tensor set__symint(@Const @ByRef Tensor source, @ByVal SymInt storage_offset, @ByVal SymIntArrayRef size);
  public native @ByRef Tensor set_(@Const @ByRef Tensor source);
  public native @ByRef Tensor set_();
  public native @Cast("bool") boolean is_set_to(@Const @ByRef Tensor tensor);
  public native @ByRef Tensor masked_fill_(@Const @ByRef Tensor mask, @Const @ByRef Scalar value);
  public native @ByVal Tensor masked_fill(@Const @ByRef Tensor mask, @Const @ByRef Scalar value);
  public native @ByRef Tensor masked_fill_(@Const @ByRef Tensor mask, @Const @ByRef Tensor value);
  public native @ByVal Tensor masked_fill(@Const @ByRef Tensor mask, @Const @ByRef Tensor value);
  public native @ByRef Tensor masked_scatter_(@Const @ByRef Tensor mask, @Const @ByRef Tensor source);
  public native @ByVal Tensor masked_scatter(@Const @ByRef Tensor mask, @Const @ByRef Tensor source);
  public native @ByVal Tensor view(@ByVal LongArrayRef size);
  public native @ByVal Tensor view(@ByVal @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector("int64_t") long... size);
  public native @ByVal Tensor view_symint(@ByVal SymIntArrayRef size);
  public native @ByVal Tensor view(ScalarType dtype);
  public native @ByRef Tensor put_(@Const @ByRef Tensor index, @Const @ByRef Tensor source, @Cast("bool") boolean accumulate/*=false*/);
  public native @ByRef Tensor put_(@Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByVal Tensor put(@Const @ByRef Tensor index, @Const @ByRef Tensor source, @Cast("bool") boolean accumulate/*=false*/);
  public native @ByVal Tensor put(@Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByRef Tensor index_add_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor index_add_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByVal Tensor index_add(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor index_add(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByVal Tensor index_add(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor index_add(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source);
  public native @ByRef Tensor index_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView BytePointer reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByRef Tensor index_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView BytePointer reduce);
  public native @ByRef Tensor index_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView String reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByRef Tensor index_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView String reduce);
  public native @ByVal Tensor index_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView BytePointer reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByVal Tensor index_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView BytePointer reduce);
  public native @ByVal Tensor index_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView String reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByVal Tensor index_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor source, @StringView String reduce);
  public native @ByRef Tensor index_fill_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value);
  public native @ByVal Tensor index_fill(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value);
  public native @ByRef Tensor index_fill_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor value);
  public native @ByVal Tensor index_fill(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor value);
  public native @ByRef Tensor index_fill_(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value);
  public native @ByRef Tensor index_fill_(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor value);
  public native @ByVal Tensor index_fill(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value);
  public native @ByVal Tensor index_fill(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor value);
  public native @ByVal Tensor scatter(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src);
  public native @ByRef Tensor scatter_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src);
  public native @ByVal Tensor scatter(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value);
  public native @ByRef Tensor scatter_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value);
  public native @ByVal Tensor scatter(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView BytePointer reduce);
  public native @ByVal Tensor scatter(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView String reduce);
  public native @ByRef Tensor scatter_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView BytePointer reduce);
  public native @ByRef Tensor scatter_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView String reduce);
  public native @ByVal Tensor scatter(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value, @StringView BytePointer reduce);
  public native @ByVal Tensor scatter(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value, @StringView String reduce);
  public native @ByRef Tensor scatter_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value, @StringView BytePointer reduce);
  public native @ByRef Tensor scatter_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value, @StringView String reduce);
  public native @ByVal Tensor scatter(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src);
  public native @ByVal Tensor scatter(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Scalar value);
  public native @ByVal Tensor scatter_add(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src);
  public native @ByRef Tensor scatter_add_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src);
  public native @ByVal Tensor scatter_add(@ByVal Dimname dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src);
  public native @ByVal Tensor scatter_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView BytePointer reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByVal Tensor scatter_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView BytePointer reduce);
  public native @ByVal Tensor scatter_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView String reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByVal Tensor scatter_reduce(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView String reduce);
  public native @ByRef Tensor scatter_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView BytePointer reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByRef Tensor scatter_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView BytePointer reduce);
  public native @ByRef Tensor scatter_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView String reduce, @Cast("bool") boolean include_self/*=true*/);
  public native @ByRef Tensor scatter_reduce_(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Const @ByRef Tensor src, @StringView String reduce);
  public native @ByRef Tensor eq_(@Const @ByRef Scalar other);
  public native @ByRef Tensor eq_(@Const @ByRef Tensor other);
  public native @ByVal Tensor bitwise_and(@Const @ByRef Scalar other);
  public native @ByVal Tensor bitwise_and(@Const @ByRef Tensor other);
  public native @ByRef Tensor bitwise_and_(@Const @ByRef Scalar other);
  public native @ByRef Tensor bitwise_and_(@Const @ByRef Tensor other);
  public native @ByVal Tensor __and__(@Const @ByRef Scalar other);
  public native @ByVal Tensor __and__(@Const @ByRef Tensor other);
  public native @ByRef Tensor __iand__(@Const @ByRef Scalar other);
  public native @ByRef Tensor __iand__(@Const @ByRef Tensor other);
  public native @ByVal Tensor bitwise_or(@Const @ByRef Scalar other);
  public native @ByVal Tensor bitwise_or(@Const @ByRef Tensor other);
  public native @ByRef Tensor bitwise_or_(@Const @ByRef Scalar other);
  public native @ByRef Tensor bitwise_or_(@Const @ByRef Tensor other);
  public native @ByVal Tensor __or__(@Const @ByRef Scalar other);
  public native @ByVal Tensor __or__(@Const @ByRef Tensor other);
  public native @ByRef Tensor __ior__(@Const @ByRef Scalar other);
  public native @ByRef Tensor __ior__(@Const @ByRef Tensor other);
  public native @ByVal Tensor bitwise_xor(@Const @ByRef Scalar other);
  public native @ByVal Tensor bitwise_xor(@Const @ByRef Tensor other);
  public native @ByRef Tensor bitwise_xor_(@Const @ByRef Scalar other);
  public native @ByRef Tensor bitwise_xor_(@Const @ByRef Tensor other);
  public native @ByVal Tensor __xor__(@Const @ByRef Scalar other);
  public native @ByVal Tensor __xor__(@Const @ByRef Tensor other);
  public native @ByRef Tensor __ixor__(@Const @ByRef Scalar other);
  public native @ByRef Tensor __ixor__(@Const @ByRef Tensor other);
  public native @ByVal Tensor __lshift__(@Const @ByRef Scalar other);
  public native @ByVal Tensor __lshift__(@Const @ByRef Tensor other);
  public native @ByRef Tensor __ilshift__(@Const @ByRef Scalar other);
  public native @ByRef Tensor __ilshift__(@Const @ByRef Tensor other);
  public native @ByVal Tensor bitwise_left_shift(@Const @ByRef Tensor other);
  public native @ByRef Tensor bitwise_left_shift_(@Const @ByRef Tensor other);
  public native @ByVal Tensor bitwise_left_shift(@Const @ByRef Scalar other);
  public native @ByRef Tensor bitwise_left_shift_(@Const @ByRef Scalar other);
  public native @ByVal Tensor __rshift__(@Const @ByRef Scalar other);
  public native @ByVal Tensor __rshift__(@Const @ByRef Tensor other);
  public native @ByRef Tensor __irshift__(@Const @ByRef Scalar other);
  public native @ByRef Tensor __irshift__(@Const @ByRef Tensor other);
  public native @ByVal Tensor bitwise_right_shift(@Const @ByRef Tensor other);
  public native @ByRef Tensor bitwise_right_shift_(@Const @ByRef Tensor other);
  public native @ByVal Tensor bitwise_right_shift(@Const @ByRef Scalar other);
  public native @ByRef Tensor bitwise_right_shift_(@Const @ByRef Scalar other);
  public native @ByRef Tensor tril_(@Cast("int64_t") long diagonal/*=0*/);
  public native @ByRef Tensor tril_();
  public native @ByRef Tensor triu_(@Cast("int64_t") long diagonal/*=0*/);
  public native @ByRef Tensor triu_();
  public native @ByRef Tensor digamma_();
  public native @ByRef Tensor lerp_(@Const @ByRef Tensor end, @Const @ByRef Scalar weight);
  public native @ByRef Tensor lerp_(@Const @ByRef Tensor end, @Const @ByRef Tensor weight);
  public native @ByRef Tensor addbmm_(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByRef Tensor addbmm_(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2);
  public native @ByVal Tensor addbmm(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar beta, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar alpha);
  public native @ByVal Tensor addbmm(@Const @ByRef Tensor batch1, @Const @ByRef Tensor batch2);
  public native @ByRef Tensor random_(@Cast("int64_t") long from, @ByVal LongOptional to, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor random_(@Cast("int64_t") long from, @ByVal LongOptional to);
  public native @ByRef Tensor random_(@Cast("int64_t") long to, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor random_(@Cast("int64_t") long to);
  public native @ByRef Tensor random_(@ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor random_();
  public native @ByRef Tensor uniform_(double from/*=0*/, double to/*=1*/, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor uniform_();
  public native @ByRef Tensor cauchy_(double median/*=0*/, double sigma/*=1*/, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor cauchy_();
  public native @ByRef Tensor log_normal_(double mean/*=1*/, double std/*=2*/, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor log_normal_();
  public native @ByRef Tensor exponential_(double lambd/*=1*/, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor exponential_();
  public native @ByRef Tensor geometric_(double p, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor geometric_(double p);
  public native @ByVal Tensor diag(@Cast("int64_t") long diagonal/*=0*/);
  public native @ByVal Tensor diag();
  public native @ByVal Tensor cross(@Const @ByRef Tensor other, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim);
  public native @ByVal Tensor cross(@Const @ByRef Tensor other);
  public native @ByVal Tensor triu(@Cast("int64_t") long diagonal/*=0*/);
  public native @ByVal Tensor triu();
  public native @ByVal Tensor tril(@Cast("int64_t") long diagonal/*=0*/);
  public native @ByVal Tensor tril();
  public native @ByVal Tensor trace();
  public native @ByVal Tensor ne(@Const @ByRef Scalar other);
  public native @ByVal Tensor ne(@Const @ByRef Tensor other);
  public native @ByRef Tensor ne_(@Const @ByRef Scalar other);
  public native @ByRef Tensor ne_(@Const @ByRef Tensor other);
  public native @ByVal Tensor not_equal(@Const @ByRef Scalar other);
  public native @ByVal Tensor not_equal(@Const @ByRef Tensor other);
  public native @ByRef Tensor not_equal_(@Const @ByRef Scalar other);
  public native @ByRef Tensor not_equal_(@Const @ByRef Tensor other);
  public native @ByVal Tensor eq(@Const @ByRef Scalar other);
  public native @ByVal Tensor eq(@Const @ByRef Tensor other);
  public native @ByVal Tensor ge(@Const @ByRef Scalar other);
  public native @ByVal Tensor ge(@Const @ByRef Tensor other);
  public native @ByRef Tensor ge_(@Const @ByRef Scalar other);
  public native @ByRef Tensor ge_(@Const @ByRef Tensor other);
  public native @ByVal Tensor greater_equal(@Const @ByRef Scalar other);
  public native @ByVal Tensor greater_equal(@Const @ByRef Tensor other);
  public native @ByRef Tensor greater_equal_(@Const @ByRef Scalar other);
  public native @ByRef Tensor greater_equal_(@Const @ByRef Tensor other);
  public native @ByVal Tensor le(@Const @ByRef Scalar other);
  public native @ByVal Tensor le(@Const @ByRef Tensor other);
  public native @ByRef Tensor le_(@Const @ByRef Scalar other);
  public native @ByRef Tensor le_(@Const @ByRef Tensor other);
  public native @ByVal Tensor less_equal(@Const @ByRef Scalar other);
  public native @ByVal Tensor less_equal(@Const @ByRef Tensor other);
  public native @ByRef Tensor less_equal_(@Const @ByRef Scalar other);
  public native @ByRef Tensor less_equal_(@Const @ByRef Tensor other);
  public native @ByVal Tensor gt(@Const @ByRef Scalar other);
  public native @ByVal Tensor gt(@Const @ByRef Tensor other);
  public native @ByRef Tensor gt_(@Const @ByRef Scalar other);
  public native @ByRef Tensor gt_(@Const @ByRef Tensor other);
  public native @ByVal Tensor greater(@Const @ByRef Scalar other);
  public native @ByVal Tensor greater(@Const @ByRef Tensor other);
  public native @ByRef Tensor greater_(@Const @ByRef Scalar other);
  public native @ByRef Tensor greater_(@Const @ByRef Tensor other);
  public native @ByVal Tensor lt(@Const @ByRef Scalar other);
  public native @ByVal Tensor lt(@Const @ByRef Tensor other);
  public native @ByRef Tensor lt_(@Const @ByRef Scalar other);
  public native @ByRef Tensor lt_(@Const @ByRef Tensor other);
  public native @ByVal Tensor less(@Const @ByRef Scalar other);
  public native @ByVal Tensor less(@Const @ByRef Tensor other);
  public native @ByRef Tensor less_(@Const @ByRef Scalar other);
  public native @ByRef Tensor less_(@Const @ByRef Tensor other);
  public native @ByVal Tensor take(@Const @ByRef Tensor index);
  public native @ByVal Tensor take_along_dim(@Const @ByRef Tensor indices, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim);
  public native @ByVal Tensor take_along_dim(@Const @ByRef Tensor indices);
  public native @ByVal Tensor index_select(@Cast("int64_t") long dim, @Const @ByRef Tensor index);
  public native @ByVal Tensor index_select(@ByVal Dimname dim, @Const @ByRef Tensor index);
  public native @ByVal Tensor masked_select(@Const @ByRef Tensor mask);
  public native @ByVal Tensor nonzero();
  public native @ByVal Tensor nonzero_static(@Cast("int64_t") long size, @Cast("int64_t") long fill_value/*=-1*/);
  public native @ByVal Tensor nonzero_static(@Cast("int64_t") long size);
  public native @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector nonzero_numpy();
  public native @ByVal Tensor argwhere();
  public native @ByVal Tensor gather(@Cast("int64_t") long dim, @Const @ByRef Tensor index, @Cast("bool") boolean sparse_grad/*=false*/);
  public native @ByVal Tensor gather(@Cast("int64_t") long dim, @Const @ByRef Tensor index);
  public native @ByVal Tensor gather(@ByVal Dimname dim, @Const @ByRef Tensor index, @Cast("bool") boolean sparse_grad/*=false*/);
  public native @ByVal Tensor gather(@ByVal Dimname dim, @Const @ByRef Tensor index);
  public native @ByVal Tensor addcmul(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar value);
  public native @ByVal Tensor addcmul(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2);
  public native @ByRef Tensor addcmul_(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar value);
  public native @ByRef Tensor addcmul_(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2);
  public native @ByVal Tensor addcdiv(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar value);
  public native @ByVal Tensor addcdiv(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2);
  public native @ByRef Tensor addcdiv_(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2, @Const @ByRef(nullValue = "at::Scalar(1)") Scalar value);
  public native @ByRef Tensor addcdiv_(@Const @ByRef Tensor tensor1, @Const @ByRef Tensor tensor2);
  public native @ByVal T_TensorTensor_T triangular_solve(@Const @ByRef Tensor A, @Cast("bool") boolean upper/*=true*/, @Cast("bool") boolean transpose/*=false*/, @Cast("bool") boolean unitriangular/*=false*/);
  public native @ByVal T_TensorTensor_T triangular_solve(@Const @ByRef Tensor A);
  public native @ByVal T_TensorTensorTensor_T svd(@Cast("bool") boolean some/*=true*/, @Cast("bool") boolean compute_uv/*=true*/);
  public native @ByVal T_TensorTensorTensor_T svd();
  public native @ByVal Tensor swapaxes(@Cast("int64_t") long axis0, @Cast("int64_t") long axis1);
  public native @ByRef Tensor swapaxes_(@Cast("int64_t") long axis0, @Cast("int64_t") long axis1);
  public native @ByVal Tensor swapdims(@Cast("int64_t") long dim0, @Cast("int64_t") long dim1);
  public native @ByRef Tensor swapdims_(@Cast("int64_t") long dim0, @Cast("int64_t") long dim1);
  public native @ByVal Tensor cholesky(@Cast("bool") boolean upper/*=false*/);
  public native @ByVal Tensor cholesky();
  public native @ByVal Tensor cholesky_solve(@Const @ByRef Tensor input2, @Cast("bool") boolean upper/*=false*/);
  public native @ByVal Tensor cholesky_solve(@Const @ByRef Tensor input2);
  public native @ByVal Tensor cholesky_inverse(@Cast("bool") boolean upper/*=false*/);
  public native @ByVal Tensor cholesky_inverse();
  public native @ByVal T_TensorTensor_T qr(@Cast("bool") boolean some/*=true*/);
  public native @ByVal T_TensorTensor_T qr();
  public native @ByVal T_TensorTensor_T geqrf();
  public native @ByVal Tensor orgqr(@Const @ByRef Tensor input2);
  public native @ByVal Tensor ormqr(@Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Cast("bool") boolean left/*=true*/, @Cast("bool") boolean transpose/*=false*/);
  public native @ByVal Tensor ormqr(@Const @ByRef Tensor input2, @Const @ByRef Tensor input3);
  public native @ByVal Tensor lu_solve(@Const @ByRef Tensor LU_data, @Const @ByRef Tensor LU_pivots);
  public native @ByVal Tensor multinomial(@Cast("int64_t") long num_samples, @Cast("bool") boolean replacement/*=false*/, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByVal Tensor multinomial(@Cast("int64_t") long num_samples);
  public native @ByRef Tensor lgamma_();
  public native @ByVal Tensor lgamma();
  public native @ByVal Tensor digamma();
  public native @ByVal Tensor polygamma(@Cast("int64_t") long n);
  public native @ByRef Tensor polygamma_(@Cast("int64_t") long n);
  public native @ByVal Tensor erfinv();
  public native @ByRef Tensor erfinv_();
  public native @ByVal Tensor i0();
  public native @ByRef Tensor i0_();
  public native @ByVal Tensor sign();
  public native @ByRef Tensor sign_();
  public native @ByVal Tensor signbit();
  public native @ByVal Tensor dist(@Const @ByRef Tensor other, @Const @ByRef(nullValue = "at::Scalar(2)") Scalar p);
  public native @ByVal Tensor dist(@Const @ByRef Tensor other);
  public native @ByRef Tensor atan2_(@Const @ByRef Tensor other);
  public native @ByVal Tensor atan2(@Const @ByRef Tensor other);
  public native @ByVal Tensor arctan2(@Const @ByRef Tensor other);
  public native @ByRef Tensor arctan2_(@Const @ByRef Tensor other);
  public native @ByVal Tensor lerp(@Const @ByRef Tensor end, @Const @ByRef Scalar weight);
  public native @ByVal Tensor lerp(@Const @ByRef Tensor end, @Const @ByRef Tensor weight);
  public native @ByVal Tensor histc(@Cast("int64_t") long bins/*=100*/, @Const @ByRef(nullValue = "at::Scalar(0)") Scalar min, @Const @ByRef(nullValue = "at::Scalar(0)") Scalar max);
  public native @ByVal Tensor histc();
  public native @ByVal T_TensorTensor_T histogram(@Const @ByRef Tensor bins, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional weight, @Cast("bool") boolean density/*=false*/);
  public native @ByVal T_TensorTensor_T histogram(@Const @ByRef Tensor bins);
  public native @ByVal T_TensorTensor_T histogram(@Cast("int64_t") long bins/*=100*/, @ByVal(nullValue = "c10::optional<at::ArrayRef<double> >(c10::nullopt)") DoubleArrayRefOptional range, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional weight, @Cast("bool") boolean density/*=false*/);
  public native @ByVal T_TensorTensor_T histogram();
  public native @ByVal T_TensorTensor_T histogram(@Cast("int64_t") long bins/*=100*/, @ByVal(nullValue = "c10::optional<at::ArrayRef<double> >(c10::nullopt)") @Cast({"double*", "c10::ArrayRef<double>", "std::vector<double>&"}) @StdVector double[] range, @Const @ByRef(nullValue = "c10::optional<at::Tensor>{}") TensorOptional weight, @Cast("bool") boolean density/*=false*/);
  public native @ByVal Tensor fmod(@Const @ByRef Scalar other);
  public native @ByRef Tensor fmod_(@Const @ByRef Scalar other);
  public native @ByVal Tensor fmod(@Const @ByRef Tensor other);
  public native @ByRef Tensor fmod_(@Const @ByRef Tensor other);
  public native @ByVal Tensor hypot(@Const @ByRef Tensor other);
  public native @ByRef Tensor hypot_(@Const @ByRef Tensor other);
  public native @ByVal Tensor igamma(@Const @ByRef Tensor other);
  public native @ByRef Tensor igamma_(@Const @ByRef Tensor other);
  public native @ByVal Tensor igammac(@Const @ByRef Tensor other);
  public native @ByRef Tensor igammac_(@Const @ByRef Tensor other);
  public native @ByVal Tensor nextafter(@Const @ByRef Tensor other);
  public native @ByRef Tensor nextafter_(@Const @ByRef Tensor other);
  public native @ByVal Tensor remainder(@Const @ByRef Scalar other);
  public native @ByRef Tensor remainder_(@Const @ByRef Scalar other);
  public native @ByVal Tensor remainder(@Const @ByRef Tensor other);
  public native @ByRef Tensor remainder_(@Const @ByRef Tensor other);
  public native @ByVal Tensor min();
  public native @ByVal Tensor fmin(@Const @ByRef Tensor other);
  public native @ByVal Tensor max();
  public native @ByVal Tensor fmax(@Const @ByRef Tensor other);
  public native @ByVal Tensor maximum(@Const @ByRef Tensor other);
  public native @ByVal Tensor max(@Const @ByRef Tensor other);
  public native @ByVal Tensor minimum(@Const @ByRef Tensor other);
  public native @ByVal Tensor min(@Const @ByRef Tensor other);
  public native @ByVal Tensor quantile(@Const @ByRef Tensor q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView BytePointer interpolation/*="linear"*/);
  public native @ByVal Tensor quantile(@Const @ByRef Tensor q);
  public native @ByVal Tensor quantile(@Const @ByRef Tensor q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView String interpolation/*="linear"*/);
  public native @ByVal Tensor quantile(double q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView BytePointer interpolation/*="linear"*/);
  public native @ByVal Tensor quantile(double q);
  public native @ByVal Tensor quantile(double q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView String interpolation/*="linear"*/);
  public native @ByVal Tensor nanquantile(@Const @ByRef Tensor q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView BytePointer interpolation/*="linear"*/);
  public native @ByVal Tensor nanquantile(@Const @ByRef Tensor q);
  public native @ByVal Tensor nanquantile(@Const @ByRef Tensor q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView String interpolation/*="linear"*/);
  public native @ByVal Tensor nanquantile(double q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView BytePointer interpolation/*="linear"*/);
  public native @ByVal Tensor nanquantile(double q);
  public native @ByVal Tensor nanquantile(double q, @ByVal(nullValue = "c10::optional<int64_t>(c10::nullopt)") LongOptional dim, @Cast("bool") boolean keepdim/*=false*/, @StringView String interpolation/*="linear"*/);
  public native @ByVal T_TensorTensor_T sort(@Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean descending/*=false*/);
  public native @ByVal T_TensorTensor_T sort();
  public native @ByVal T_TensorTensor_T sort(@ByVal BoolOptional stable, @Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean descending/*=false*/);
  public native @ByVal T_TensorTensor_T sort(@ByVal BoolOptional stable);
  public native @ByVal T_TensorTensor_T sort(@ByVal Dimname dim, @Cast("bool") boolean descending/*=false*/);
  public native @ByVal T_TensorTensor_T sort(@ByVal Dimname dim);
  public native @ByVal T_TensorTensor_T sort(@ByVal BoolOptional stable, @ByVal Dimname dim, @Cast("bool") boolean descending/*=false*/);
  public native @ByVal T_TensorTensor_T sort(@ByVal BoolOptional stable, @ByVal Dimname dim);
  public native @ByVal Tensor msort();
  public native @ByVal Tensor argsort(@Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean descending/*=false*/);
  public native @ByVal Tensor argsort();
  public native @ByVal Tensor argsort(@Cast("bool") boolean stable, @Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean descending/*=false*/);
  public native @ByVal Tensor argsort(@Cast("bool") boolean stable);
  public native @ByVal Tensor argsort(@ByVal Dimname dim, @Cast("bool") boolean descending/*=false*/);
  public native @ByVal Tensor argsort(@ByVal Dimname dim);
  public native @ByVal T_TensorTensor_T topk(@Cast("int64_t") long k, @Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean largest/*=true*/, @Cast("bool") boolean sorted/*=true*/);
  public native @ByVal T_TensorTensor_T topk(@Cast("int64_t") long k);
  public native @ByVal T_TensorTensor_T topk_symint(@ByVal SymInt k, @Cast("int64_t") long dim/*=-1*/, @Cast("bool") boolean largest/*=true*/, @Cast("bool") boolean sorted/*=true*/);
  public native @ByVal T_TensorTensor_T topk_symint(@ByVal SymInt k);
  public native @ByVal Tensor all();
  public native @ByVal Tensor any();
  public native @ByVal Tensor renorm(@Const @ByRef Scalar p, @Cast("int64_t") long dim, @Const @ByRef Scalar maxnorm);
  public native @ByRef Tensor renorm_(@Const @ByRef Scalar p, @Cast("int64_t") long dim, @Const @ByRef Scalar maxnorm);
  public native @ByVal Tensor unfold(@Cast("int64_t") long dimension, @Cast("int64_t") long size, @Cast("int64_t") long step);
  public native @Cast("bool") boolean equal(@Const @ByRef Tensor other);
  public native @ByVal Tensor pow(@Const @ByRef Tensor exponent);
  public native @ByVal Tensor pow(@Const @ByRef Scalar exponent);
  public native @ByRef Tensor pow_(@Const @ByRef Scalar exponent);
  public native @ByRef Tensor pow_(@Const @ByRef Tensor exponent);
  public native @ByVal Tensor float_power(@Const @ByRef Tensor exponent);
  public native @ByVal Tensor float_power(@Const @ByRef Scalar exponent);
  public native @ByRef Tensor float_power_(@Const @ByRef Scalar exponent);
  public native @ByRef Tensor float_power_(@Const @ByRef Tensor exponent);
  public native @ByRef Tensor normal_(double mean/*=0*/, double std/*=1*/, @ByVal(nullValue = "c10::optional<at::Generator>(c10::nullopt)") GeneratorOptional generator);
  public native @ByRef Tensor normal_();
  public native @ByVal Tensor alias();
  public native @ByVal Tensor isfinite();
  public native @ByVal Tensor isinf();
  public native void record_stream(@ByVal Stream s);
  public native @ByVal Tensor isposinf();
  public native @ByVal Tensor isneginf();
  public native @ByVal Tensor det();
  public native @ByVal T_TensorTensor_T slogdet();
  public native @ByVal Tensor logdet();
  public native @ByVal Tensor inverse();
  public native @ByVal Tensor inner(@Const @ByRef Tensor other);
  public native @ByVal Tensor outer(@Const @ByRef Tensor vec2);
  public native @ByVal Tensor ger(@Const @ByRef Tensor vec2);
  public native @ByVal Tensor to_padded_tensor(double padding, @ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") LongArrayRefOptional output_size);
  public native @ByVal Tensor to_padded_tensor(double padding);
  public native @ByVal Tensor to_padded_tensor(double padding, @ByVal(nullValue = "at::OptionalIntArrayRef(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long... output_size);
  public native @ByVal Tensor to_padded_tensor_symint(double padding, @ByVal(nullValue = "at::OptionalSymIntArrayRef(c10::nullopt)") SymIntArrayRefOptional output_size);
  public native @ByVal Tensor to_padded_tensor_symint(double padding);

  // Special C++ only overloads for std()-like functions (See gh-40287)
  // These are needed because int -> bool conversion takes precedence over int -> IntArrayRef
  // So, for example std(0) would select the std(unbiased=False) overload

  public native @ByVal Tensor var(int dim);

  public native @ByVal Tensor std(int dim);

  // We changed .dtype() to return a TypeMeta in #12766. Ideally, we want the
  // at::kDouble and its friends to be TypeMeta's, but that hasn't happened yet.
  // Before that change, we make this method to maintain BC for C++ usage like
  // `x.to(y.dtype)`.
  // TODO: remove following two after at::kDouble and its friends are TypeMeta's.
  public native @ByVal Tensor to(@ByVal TypeMeta type_meta, @Cast("bool") boolean non_blocking/*=false*/, @Cast("bool") boolean copy/*=false*/);
  public native @ByVal Tensor to(@ByVal TypeMeta type_meta);
  public native @ByVal Tensor to(@ByVal Device device, @ByVal TypeMeta type_meta, @Cast("bool") boolean non_blocking/*=false*/, @Cast("bool") boolean copy/*=false*/);
  public native @ByVal Tensor to(@ByVal Device device, @ByVal TypeMeta type_meta);

  /** NOTE: This is similar to the legacy {@code .data()} function on {@code Variable}, and is intended
   *  to be used from functions that need to access the {@code Variable}'s equivalent {@code Tensor}
   *  (i.e. {@code Tensor} that shares the same storage and tensor metadata with the {@code Variable}).
   * 
   *  One notable difference with the legacy {@code .data()} function is that changes to the
   *  returned {@code Tensor}'s tensor metadata (e.g. sizes / strides / storage / storage_offset)
   *  will not update the original {@code Variable}, due to the fact that this function
   *  shallow-copies the {@code Variable}'s underlying TensorImpl. */
  
  ///
  public native @ByVal Tensor tensor_data();

  /** NOTE: {@code var.variable_data()} in C++ has the same semantics as {@code tensor.data}
   *  in Python, which create a new {@code Variable} that shares the same storage and
   *  tensor metadata with the original {@code Variable}, but with a completely new
   *  autograd history.
   * 
   *  NOTE: If we change the tensor metadata (e.g. sizes / strides /
   *  storage / storage_offset) of a variable created from {@code var.variable_data()}, those
   *  changes will not update the original variable {@code var}. In {@code .variable_data()}, we set
   *  {@code allow_tensor_metadata_change_} to false to make such changes explicitly illegal,
   *  in order to prevent users from changing metadata of {@code var.variable_data()}
   *  and expecting the original variable {@code var} to also be updated. */
  public native @ByVal Tensor variable_data();

  // Hooks
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  ///
  ///
  ///

  /** Registers a backward hook.
   * 
   *  The hook will be called every time a gradient with respect to the Tensor is computed.
   *  The hook should have one of the following signature:
   *  <pre>{@code
   *  hook(Tensor grad) -> Tensor
   *  }</pre>
   *  <pre>{@code
   *  hook(Tensor grad) -> void
   *  }</pre>
   *  The hook should not modify its argument, but it can optionally return a new gradient
   *  which will be used in place of {@code grad}.
   * 
   *  This function returns the index of the hook in the list which can be used to remove hook.
   * 
   *  Example:
   *  <pre>{@code
   *  auto v = torch::tensor({0., 0., 0.}, torch::requires_grad());
   *  auto h = v.register_hook([](torch::Tensor grad){ return grad * 2; }); // double the gradient
   *  v.backward(torch::tensor({1., 2., 3.}));
   *  // This prints:
   *  // ```
   *  //  2
   *  //  4
   *  //  6
   *  // [ CPUFloatType{3} ]
   *  // ```
   *  std::cout << v.grad() << std::endl;
   *  v.remove_hook(h);  // removes the hook
   *  }</pre> */

  // Variable methods
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public native @ByVal Tensor data();

  public native void _backward(@ByVal TensorArrayRef inputs, @Const @ByRef TensorOptional gradient, @ByVal BoolOptional keep_graph, @Cast("bool") boolean create_graph);
  public native void _backward(@ByVal TensorVector inputs, @Const @ByRef TensorOptional gradient, @ByVal BoolOptional keep_graph, @Cast("bool") boolean create_graph);

  public native @Const @ByRef Tensor requires_grad_(@Cast("bool") boolean _requires_grad/*=true*/);
  public native @Const @ByRef Tensor requires_grad_();
}
