// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


/** A list of {@code Module}s that acts as a {@code Module} itself.
 * 
 *  A {@code Sequential} is fundamentally a list of {@code Module}s, each with a {@code forward()}
 *  method. {@code Sequential} provides a {@code forward()} method of its own, which accepts
 *  any input and forwards it to the first module it stores. It then "chains"
 *  outputs to inputs sequentially for each subsequent module, finally returning
 *  the output of the last module. For example:
 * 
 *  \rst
 *  .. code-block:: cpp
 * 
 *    torch::nn::Sequential seq(
 *      torch::nn::Linear(3, 4),
 *      torch::nn::BatchNorm1d(4),
 *      torch::nn::Dropout(0.5)
 *    );
 * 
 *    auto output = seq->forward(torch::ones(3));
 * 
 *  \endrst
 * 
 *  This can conceptually be thought of as the following loop (using Python as
 *  pseudocode):
 * 
 *  \rst
 *  .. code-block:: python
 * 
 *    def forward(sequential, input):
 *      for module in sequential:
 *        input = module(input)
 *      return input
 * 
 *  \endrst
 * 
 *  Why should you use {@code Sequential} instead of a simple {@code std::vector}? The value
 *  a {@code Sequential} provides over manually calling a sequence of modules is that
 *  it allows treating the whole container *as a single module*, such that
 *  performing a transformation on the {@code Sequential} applies to each of the
 *  modules it stores (which are each a registered submodule of the
 *  {@code Sequential}). For example, calling
 *  {@code .to(torch::kCUDA)} on a {@code Sequential} will move each module in the list to
 *  CUDA memory. For example:
 * 
 *  \rst
 *  .. code-block:: cpp
 * 
 *    torch::nn::Sequential seq(
 *      torch::nn::Linear(3, 4),
 *      torch::nn::BatchNorm1d(4),
 *      torch::nn::Dropout(0.5)
 *    );
 * 
 *    // Convert all modules to CUDA.
 *    seq->to(torch::kCUDA);
 * 
 *  \endrst
 * 
 *  Finally, {@code Sequential} provides a lightweight container API, such as allowing
 *  iteration over submodules, positional access, adding a new module after
 *  construction via {@code push_back}, as well as joining two {@code Sequential}s via
 *  {@code extend}.
 * 
 *  \rst
 *  .. attention::
 *    One current limitation of {@code Sequential} is that all except the first module
 *    must accept a single argument. If your modules need to take multiple
 *    arguments, you should define them to take and return tuples.
 *  \endrst */
@Namespace("torch::nn") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class SequentialImpl extends SequentialImplCloneable {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SequentialImpl(Pointer p) { super(p); }
    /** Downcast constructor. */
    public SequentialImpl(Module pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @SharedPtr @Name("SHARED_PTR_NAMESPACE::dynamic_pointer_cast<torch::nn::SequentialImpl, torch::nn::Module>") void allocate(@SharedPtr Module pointer);


  public SequentialImpl() { super((Pointer)null); allocate(); }
  @SharedPtr @Name("std::make_shared<torch::nn::SequentialImpl>") private native void allocate();

  /** Constructs the {@code Sequential} from a variadic list of modules. */

  /** Constructs the {@code Sequential} from an {@code OrderedDict} of named {@code AnyModule}s. */
  public SequentialImpl(
        @ByRef(true) StringAnyModuleDict ordered_dict) { super((Pointer)null); allocate(ordered_dict); }
  @SharedPtr @Name("std::make_shared<torch::nn::SequentialImpl>") private native void allocate(
        @ByRef(true) StringAnyModuleDict ordered_dict);

  /** Constructs the {@code Sequential} from a braced-init-list of named {@code AnyModule}s.
   *  It enables the following use case:
   *  {@code Sequential sequential({{"m1", M(1)}, {"m2", M(2)}})} */

  /** Special cloning function for {@code Sequential} because it does not use
   *  {@code reset()}. */
  public native @SharedPtr("torch::nn::Module") @ByVal Module clone(
        @Const @ByRef(nullValue = "c10::optional<torch::Device>(c10::nullopt)") DeviceOptional device);
  public native @SharedPtr("torch::nn::Module") @ByVal Module clone();

  /** {@code reset()} is empty for {@code Sequential}, since it does not have parameters of
   *  its own. */
  public native void reset();

  /** Pretty prints the {@code Sequential} module into the given {@code stream}. */
  
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  public native void pretty_print(@Cast("std::ostream*") @ByRef Pointer stream);

  /** Feeds {@code inputs} to the first module and then chains outputs to inputs,
   *  returning the last output.
   * 
   *  Conceptually the following loop in Python:
   * 
   *  \rst
   *  .. code-block:: python
   * 
   *    def forward(sequential, input):
   *      for module in sequential:
   *        input = module(input)
   *      return input
   * 
   *  \endrst
   * 
   *  The return type is taken as the first template parameter. It defaults to
   *  {@code Tensor}. If the last module in the {@code Sequential} returns another type {@code T},
   *  you should call {@code forward<T>(inputs)} instead of just {@code forward(inputs)}:
   * 
   *  \rst
   *  .. code-block:: cpp
   * 
   *    torch::Tensor tensor = sequential1->forward(inputs);
   *    int integer = sequential2->forward<int>(inputs);
   *    float value = sequential3->forward<float>(inputs);
   * 
   *  \endrst */
  public native @ByVal Tensor forward(@Const @ByRef Tensor input);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6, @Const @ByRef Tensor input7, @Const @ByRef Tensor input8);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input, @ByRef(nullValue = "c10::optional<at::IntArrayRef>(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long... output_size);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input, @Const @ByRef(nullValue = "c10::optional<at::IntArrayRef>(c10::nullopt)") LongArrayRefOptional output_size);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input, @Const @ByRef Tensor indices, @Const @ByRef(nullValue = "c10::optional<std::vector<int64_t> >(c10::nullopt)") LongVectorOptional output_size);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor>>>") T_TensorT_TensorTensor_T_T forwardT_TensorT_TensorTensor_T_T(@Const @ByRef Tensor input);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor>>>") T_TensorT_TensorTensor_T_T forwardT_TensorT_TensorTensor_T_T(@Const @ByRef Tensor input, @ByVal(nullValue = "torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}") T_TensorTensor_TOptional hx_opt);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input, @ByVal(nullValue = "torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}") T_TensorTensor_TOptional hx_opt);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor query, @Const @ByRef Tensor key, @Const @ByRef Tensor value, @Const @ByRef(nullValue = "torch::Tensor{}") Tensor key_padding_mask, @Cast("bool") boolean need_weights/*=true*/, @Const @ByRef(nullValue = "torch::Tensor{}") Tensor attn_mask, @Cast("bool") boolean average_attn_weights/*=true*/);
  public native @ByVal @Name("forward<torch::nn::ASMoutput>") ASMoutput forwardASMoutput(@Const @ByRef Tensor input, @Const @ByRef Tensor target);

  /** Adds a new (boxed) {@code Module} to the {@code Sequential} container. */
  public native @Name("push_back<torch::nn::AdaptiveLogSoftmaxWithLossImpl>") void push_back(@SharedPtr AdaptiveLogSoftmaxWithLossImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm1dImpl>") void push_back(@SharedPtr BatchNorm1dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm1dImpl>") void push_back(@SharedPtr InstanceNorm1dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv1dImpl>") void push_back(@SharedPtr Conv1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose1dImpl>") void push_back(@SharedPtr ConvTranspose1dImpl module_ptr);
  public native @Name("push_back<torch::nn::DropoutImpl>") void push_back(@SharedPtr DropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm2dImpl>") void push_back(@SharedPtr BatchNorm2dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm2dImpl>") void push_back(@SharedPtr InstanceNorm2dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv2dImpl>") void push_back(@SharedPtr Conv2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose2dImpl>") void push_back(@SharedPtr ConvTranspose2dImpl module_ptr);
  public native @Name("push_back<torch::nn::Dropout2dImpl>") void push_back(@SharedPtr Dropout2dImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm3dImpl>") void push_back(@SharedPtr BatchNorm3dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm3dImpl>") void push_back(@SharedPtr InstanceNorm3dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv3dImpl>") void push_back(@SharedPtr Conv3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose3dImpl>") void push_back(@SharedPtr ConvTranspose3dImpl module_ptr);
  public native @Name("push_back<torch::nn::Dropout3dImpl>") void push_back(@SharedPtr Dropout3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AlphaDropoutImpl>") void push_back(@SharedPtr AlphaDropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::FeatureAlphaDropoutImpl>") void push_back(@SharedPtr FeatureAlphaDropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::CosineSimilarityImpl>") void push_back(@SharedPtr CosineSimilarityImpl module_ptr);
  public native @Name("push_back<torch::nn::PairwiseDistanceImpl>") void push_back(@SharedPtr PairwiseDistanceImpl module_ptr);
  public native @Name("push_back<torch::nn::EmbeddingImpl>") void push_back(@SharedPtr EmbeddingImpl module_ptr);
  public native @Name("push_back<torch::nn::EmbeddingBagImpl>") void push_back(@SharedPtr EmbeddingBagImpl module_ptr);
  public native @Name("push_back<torch::nn::FoldImpl>") void push_back(@SharedPtr FoldImpl module_ptr);
  public native @Name("push_back<torch::nn::UnfoldImpl>") void push_back(@SharedPtr UnfoldImpl module_ptr);
  public native @Name("push_back<torch::nn::IdentityImpl>") void push_back(@SharedPtr IdentityImpl module_ptr);
  public native @Name("push_back<torch::nn::LinearImpl>") void push_back(@SharedPtr LinearImpl module_ptr);
  public native @Name("push_back<torch::nn::BilinearImpl>") void push_back(@SharedPtr BilinearImpl module_ptr);
  public native @Name("push_back<torch::nn::FlattenImpl>") void push_back(@SharedPtr FlattenImpl module_ptr);
  public native @Name("push_back<torch::nn::UnflattenImpl>") void push_back(@SharedPtr UnflattenImpl module_ptr);
  public native @Name("push_back<torch::nn::L1LossImpl>") void push_back(@SharedPtr L1LossImpl module_ptr);
  public native @Name("push_back<torch::nn::KLDivLossImpl>") void push_back(@SharedPtr KLDivLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MSELossImpl>") void push_back(@SharedPtr MSELossImpl module_ptr);
  public native @Name("push_back<torch::nn::BCELossImpl>") void push_back(@SharedPtr BCELossImpl module_ptr);
  public native @Name("push_back<torch::nn::HingeEmbeddingLossImpl>") void push_back(@SharedPtr HingeEmbeddingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiMarginLossImpl>") void push_back(@SharedPtr MultiMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CosineEmbeddingLossImpl>") void push_back(@SharedPtr CosineEmbeddingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::SmoothL1LossImpl>") void push_back(@SharedPtr SmoothL1LossImpl module_ptr);
  public native @Name("push_back<torch::nn::HuberLossImpl>") void push_back(@SharedPtr HuberLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiLabelMarginLossImpl>") void push_back(@SharedPtr MultiLabelMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftMarginLossImpl>") void push_back(@SharedPtr SoftMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiLabelSoftMarginLossImpl>") void push_back(@SharedPtr MultiLabelSoftMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::TripletMarginLossImpl>") void push_back(@SharedPtr TripletMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::TripletMarginWithDistanceLossImpl>") void push_back(@SharedPtr TripletMarginWithDistanceLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CTCLossImpl>") void push_back(@SharedPtr CTCLossImpl module_ptr);
  public native @Name("push_back<torch::nn::PoissonNLLLossImpl>") void push_back(@SharedPtr PoissonNLLLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MarginRankingLossImpl>") void push_back(@SharedPtr MarginRankingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::NLLLossImpl>") void push_back(@SharedPtr NLLLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CrossEntropyLossImpl>") void push_back(@SharedPtr CrossEntropyLossImpl module_ptr);
  public native @Name("push_back<torch::nn::BCEWithLogitsLossImpl>") void push_back(@SharedPtr BCEWithLogitsLossImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad1dImpl>") void push_back(@SharedPtr ReflectionPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad1dImpl>") void push_back(@SharedPtr ReplicationPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad1dImpl>") void push_back(@SharedPtr ConstantPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad1dImpl>") void push_back(@SharedPtr ZeroPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool1dImpl>") void push_back(@SharedPtr AvgPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool1dImpl>") void push_back(@SharedPtr MaxPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool1dImpl>") void push_back(@SharedPtr AdaptiveAvgPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool1dImpl>") void push_back(@SharedPtr AdaptiveMaxPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool1dImpl>") void push_back(@SharedPtr MaxUnpool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::LPPool1dImpl>") void push_back(@SharedPtr LPPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad2dImpl>") void push_back(@SharedPtr ReflectionPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad2dImpl>") void push_back(@SharedPtr ReplicationPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad2dImpl>") void push_back(@SharedPtr ConstantPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad2dImpl>") void push_back(@SharedPtr ZeroPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool2dImpl>") void push_back(@SharedPtr AvgPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool2dImpl>") void push_back(@SharedPtr MaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool2dImpl>") void push_back(@SharedPtr AdaptiveAvgPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool2dImpl>") void push_back(@SharedPtr AdaptiveMaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool2dImpl>") void push_back(@SharedPtr MaxUnpool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::FractionalMaxPool2dImpl>") void push_back(@SharedPtr FractionalMaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::LPPool2dImpl>") void push_back(@SharedPtr LPPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad3dImpl>") void push_back(@SharedPtr ReflectionPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad3dImpl>") void push_back(@SharedPtr ReplicationPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad3dImpl>") void push_back(@SharedPtr ConstantPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad3dImpl>") void push_back(@SharedPtr ZeroPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool3dImpl>") void push_back(@SharedPtr AvgPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool3dImpl>") void push_back(@SharedPtr MaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool3dImpl>") void push_back(@SharedPtr AdaptiveAvgPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool3dImpl>") void push_back(@SharedPtr AdaptiveMaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool3dImpl>") void push_back(@SharedPtr MaxUnpool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::FractionalMaxPool3dImpl>") void push_back(@SharedPtr FractionalMaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::RNNImpl>") void push_back(@SharedPtr RNNImpl module_ptr);
  public native @Name("push_back<torch::nn::LSTMImpl>") void push_back(@SharedPtr LSTMImpl module_ptr);
  public native @Name("push_back<torch::nn::GRUImpl>") void push_back(@SharedPtr GRUImpl module_ptr);
  public native @Name("push_back<torch::nn::RNNCellImpl>") void push_back(@SharedPtr RNNCellImpl module_ptr);
  public native @Name("push_back<torch::nn::LSTMCellImpl>") void push_back(@SharedPtr LSTMCellImpl module_ptr);
  public native @Name("push_back<torch::nn::GRUCellImpl>") void push_back(@SharedPtr GRUCellImpl module_ptr);
  public native @Name("push_back<torch::nn::PixelShuffleImpl>") void push_back(@SharedPtr PixelShuffleImpl module_ptr);
  public native @Name("push_back<torch::nn::PixelUnshuffleImpl>") void push_back(@SharedPtr PixelUnshuffleImpl module_ptr);
  public native @Name("push_back<torch::nn::UpsampleImpl>") void push_back(@SharedPtr UpsampleImpl module_ptr);
  public native @Name("push_back<torch::nn::ELUImpl>") void push_back(@SharedPtr ELUImpl module_ptr);
  public native @Name("push_back<torch::nn::SELUImpl>") void push_back(@SharedPtr SELUImpl module_ptr);
  public native @Name("push_back<torch::nn::HardshrinkImpl>") void push_back(@SharedPtr HardshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::HardtanhImpl>") void push_back(@SharedPtr HardtanhImpl module_ptr);
  public native @Name("push_back<torch::nn::LeakyReLUImpl>") void push_back(@SharedPtr LeakyReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::LogSigmoidImpl>") void push_back(@SharedPtr LogSigmoidImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftmaxImpl>") void push_back(@SharedPtr SoftmaxImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftminImpl>") void push_back(@SharedPtr SoftminImpl module_ptr);
  public native @Name("push_back<torch::nn::LogSoftmaxImpl>") void push_back(@SharedPtr LogSoftmaxImpl module_ptr);
  public native @Name("push_back<torch::nn::Softmax2dImpl>") void push_back(@SharedPtr Softmax2dImpl module_ptr);
  public native @Name("push_back<torch::nn::PReLUImpl>") void push_back(@SharedPtr PReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::ReLUImpl>") void push_back(@SharedPtr ReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::ReLU6Impl>") void push_back(@SharedPtr ReLU6Impl module_ptr);
  public native @Name("push_back<torch::nn::RReLUImpl>") void push_back(@SharedPtr RReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::CELUImpl>") void push_back(@SharedPtr CELUImpl module_ptr);
  public native @Name("push_back<torch::nn::GLUImpl>") void push_back(@SharedPtr GLUImpl module_ptr);
  public native @Name("push_back<torch::nn::GELUImpl>") void push_back(@SharedPtr GELUImpl module_ptr);
  public native @Name("push_back<torch::nn::SiLUImpl>") void push_back(@SharedPtr SiLUImpl module_ptr);
  public native @Name("push_back<torch::nn::MishImpl>") void push_back(@SharedPtr MishImpl module_ptr);
  public native @Name("push_back<torch::nn::SigmoidImpl>") void push_back(@SharedPtr SigmoidImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftplusImpl>") void push_back(@SharedPtr SoftplusImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftshrinkImpl>") void push_back(@SharedPtr SoftshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftsignImpl>") void push_back(@SharedPtr SoftsignImpl module_ptr);
  public native @Name("push_back<torch::nn::TanhImpl>") void push_back(@SharedPtr TanhImpl module_ptr);
  public native @Name("push_back<torch::nn::TanhshrinkImpl>") void push_back(@SharedPtr TanhshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::ThresholdImpl>") void push_back(@SharedPtr ThresholdImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiheadAttentionImpl>") void push_back(@SharedPtr MultiheadAttentionImpl module_ptr);
  public native @Name("push_back<torch::nn::LayerNormImpl>") void push_back(@SharedPtr LayerNormImpl module_ptr);
  public native @Name("push_back<torch::nn::LocalResponseNormImpl>") void push_back(@SharedPtr LocalResponseNormImpl module_ptr);
  public native @Name("push_back<torch::nn::CrossMapLRN2dImpl>") void push_back(@SharedPtr CrossMapLRN2dImpl module_ptr);
  public native @Name("push_back<torch::nn::GroupNormImpl>") void push_back(@SharedPtr GroupNormImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerEncoderLayerImpl>") void push_back(@SharedPtr TransformerEncoderLayerImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerDecoderLayerImpl>") void push_back(@SharedPtr TransformerDecoderLayerImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerEncoderImpl>") void push_back(@SharedPtr TransformerEncoderImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerDecoderImpl>") void push_back(@SharedPtr TransformerDecoderImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerImpl>") void push_back(@SharedPtr TransformerImpl module_ptr);

  /** Adds a new named (boxed) {@code Module} to the {@code Sequential} container. */
  public native @Name("push_back<torch::nn::AdaptiveLogSoftmaxWithLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr AdaptiveLogSoftmaxWithLossImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveLogSoftmaxWithLossImpl>") void push_back(@StdString String name, @SharedPtr AdaptiveLogSoftmaxWithLossImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr BatchNorm1dImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm1dImpl>") void push_back(@StdString String name, @SharedPtr BatchNorm1dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr InstanceNorm1dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm1dImpl>") void push_back(@StdString String name, @SharedPtr InstanceNorm1dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr Conv1dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv1dImpl>") void push_back(@StdString String name, @SharedPtr Conv1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ConvTranspose1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose1dImpl>") void push_back(@StdString String name, @SharedPtr ConvTranspose1dImpl module_ptr);
  public native @Name("push_back<torch::nn::DropoutImpl>") void push_back(@StdString BytePointer name, @SharedPtr DropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::DropoutImpl>") void push_back(@StdString String name, @SharedPtr DropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr BatchNorm2dImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm2dImpl>") void push_back(@StdString String name, @SharedPtr BatchNorm2dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr InstanceNorm2dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm2dImpl>") void push_back(@StdString String name, @SharedPtr InstanceNorm2dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr Conv2dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv2dImpl>") void push_back(@StdString String name, @SharedPtr Conv2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ConvTranspose2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose2dImpl>") void push_back(@StdString String name, @SharedPtr ConvTranspose2dImpl module_ptr);
  public native @Name("push_back<torch::nn::Dropout2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr Dropout2dImpl module_ptr);
  public native @Name("push_back<torch::nn::Dropout2dImpl>") void push_back(@StdString String name, @SharedPtr Dropout2dImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr BatchNorm3dImpl module_ptr);
  public native @Name("push_back<torch::nn::BatchNorm3dImpl>") void push_back(@StdString String name, @SharedPtr BatchNorm3dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr InstanceNorm3dImpl module_ptr);
  public native @Name("push_back<torch::nn::InstanceNorm3dImpl>") void push_back(@StdString String name, @SharedPtr InstanceNorm3dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr Conv3dImpl module_ptr);
  public native @Name("push_back<torch::nn::Conv3dImpl>") void push_back(@StdString String name, @SharedPtr Conv3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ConvTranspose3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConvTranspose3dImpl>") void push_back(@StdString String name, @SharedPtr ConvTranspose3dImpl module_ptr);
  public native @Name("push_back<torch::nn::Dropout3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr Dropout3dImpl module_ptr);
  public native @Name("push_back<torch::nn::Dropout3dImpl>") void push_back(@StdString String name, @SharedPtr Dropout3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AlphaDropoutImpl>") void push_back(@StdString BytePointer name, @SharedPtr AlphaDropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::AlphaDropoutImpl>") void push_back(@StdString String name, @SharedPtr AlphaDropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::FeatureAlphaDropoutImpl>") void push_back(@StdString BytePointer name, @SharedPtr FeatureAlphaDropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::FeatureAlphaDropoutImpl>") void push_back(@StdString String name, @SharedPtr FeatureAlphaDropoutImpl module_ptr);
  public native @Name("push_back<torch::nn::CosineSimilarityImpl>") void push_back(@StdString BytePointer name, @SharedPtr CosineSimilarityImpl module_ptr);
  public native @Name("push_back<torch::nn::CosineSimilarityImpl>") void push_back(@StdString String name, @SharedPtr CosineSimilarityImpl module_ptr);
  public native @Name("push_back<torch::nn::PairwiseDistanceImpl>") void push_back(@StdString BytePointer name, @SharedPtr PairwiseDistanceImpl module_ptr);
  public native @Name("push_back<torch::nn::PairwiseDistanceImpl>") void push_back(@StdString String name, @SharedPtr PairwiseDistanceImpl module_ptr);
  public native @Name("push_back<torch::nn::EmbeddingImpl>") void push_back(@StdString BytePointer name, @SharedPtr EmbeddingImpl module_ptr);
  public native @Name("push_back<torch::nn::EmbeddingImpl>") void push_back(@StdString String name, @SharedPtr EmbeddingImpl module_ptr);
  public native @Name("push_back<torch::nn::EmbeddingBagImpl>") void push_back(@StdString BytePointer name, @SharedPtr EmbeddingBagImpl module_ptr);
  public native @Name("push_back<torch::nn::EmbeddingBagImpl>") void push_back(@StdString String name, @SharedPtr EmbeddingBagImpl module_ptr);
  public native @Name("push_back<torch::nn::FoldImpl>") void push_back(@StdString BytePointer name, @SharedPtr FoldImpl module_ptr);
  public native @Name("push_back<torch::nn::FoldImpl>") void push_back(@StdString String name, @SharedPtr FoldImpl module_ptr);
  public native @Name("push_back<torch::nn::UnfoldImpl>") void push_back(@StdString BytePointer name, @SharedPtr UnfoldImpl module_ptr);
  public native @Name("push_back<torch::nn::UnfoldImpl>") void push_back(@StdString String name, @SharedPtr UnfoldImpl module_ptr);
  public native @Name("push_back<torch::nn::IdentityImpl>") void push_back(@StdString BytePointer name, @SharedPtr IdentityImpl module_ptr);
  public native @Name("push_back<torch::nn::IdentityImpl>") void push_back(@StdString String name, @SharedPtr IdentityImpl module_ptr);
  public native @Name("push_back<torch::nn::LinearImpl>") void push_back(@StdString BytePointer name, @SharedPtr LinearImpl module_ptr);
  public native @Name("push_back<torch::nn::LinearImpl>") void push_back(@StdString String name, @SharedPtr LinearImpl module_ptr);
  public native @Name("push_back<torch::nn::BilinearImpl>") void push_back(@StdString BytePointer name, @SharedPtr BilinearImpl module_ptr);
  public native @Name("push_back<torch::nn::BilinearImpl>") void push_back(@StdString String name, @SharedPtr BilinearImpl module_ptr);
  public native @Name("push_back<torch::nn::FlattenImpl>") void push_back(@StdString BytePointer name, @SharedPtr FlattenImpl module_ptr);
  public native @Name("push_back<torch::nn::FlattenImpl>") void push_back(@StdString String name, @SharedPtr FlattenImpl module_ptr);
  public native @Name("push_back<torch::nn::UnflattenImpl>") void push_back(@StdString BytePointer name, @SharedPtr UnflattenImpl module_ptr);
  public native @Name("push_back<torch::nn::UnflattenImpl>") void push_back(@StdString String name, @SharedPtr UnflattenImpl module_ptr);
  public native @Name("push_back<torch::nn::L1LossImpl>") void push_back(@StdString BytePointer name, @SharedPtr L1LossImpl module_ptr);
  public native @Name("push_back<torch::nn::L1LossImpl>") void push_back(@StdString String name, @SharedPtr L1LossImpl module_ptr);
  public native @Name("push_back<torch::nn::KLDivLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr KLDivLossImpl module_ptr);
  public native @Name("push_back<torch::nn::KLDivLossImpl>") void push_back(@StdString String name, @SharedPtr KLDivLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MSELossImpl>") void push_back(@StdString BytePointer name, @SharedPtr MSELossImpl module_ptr);
  public native @Name("push_back<torch::nn::MSELossImpl>") void push_back(@StdString String name, @SharedPtr MSELossImpl module_ptr);
  public native @Name("push_back<torch::nn::BCELossImpl>") void push_back(@StdString BytePointer name, @SharedPtr BCELossImpl module_ptr);
  public native @Name("push_back<torch::nn::BCELossImpl>") void push_back(@StdString String name, @SharedPtr BCELossImpl module_ptr);
  public native @Name("push_back<torch::nn::HingeEmbeddingLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr HingeEmbeddingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::HingeEmbeddingLossImpl>") void push_back(@StdString String name, @SharedPtr HingeEmbeddingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiMarginLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr MultiMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiMarginLossImpl>") void push_back(@StdString String name, @SharedPtr MultiMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CosineEmbeddingLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr CosineEmbeddingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CosineEmbeddingLossImpl>") void push_back(@StdString String name, @SharedPtr CosineEmbeddingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::SmoothL1LossImpl>") void push_back(@StdString BytePointer name, @SharedPtr SmoothL1LossImpl module_ptr);
  public native @Name("push_back<torch::nn::SmoothL1LossImpl>") void push_back(@StdString String name, @SharedPtr SmoothL1LossImpl module_ptr);
  public native @Name("push_back<torch::nn::HuberLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr HuberLossImpl module_ptr);
  public native @Name("push_back<torch::nn::HuberLossImpl>") void push_back(@StdString String name, @SharedPtr HuberLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiLabelMarginLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr MultiLabelMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiLabelMarginLossImpl>") void push_back(@StdString String name, @SharedPtr MultiLabelMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftMarginLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr SoftMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftMarginLossImpl>") void push_back(@StdString String name, @SharedPtr SoftMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiLabelSoftMarginLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr MultiLabelSoftMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiLabelSoftMarginLossImpl>") void push_back(@StdString String name, @SharedPtr MultiLabelSoftMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::TripletMarginLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr TripletMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::TripletMarginLossImpl>") void push_back(@StdString String name, @SharedPtr TripletMarginLossImpl module_ptr);
  public native @Name("push_back<torch::nn::TripletMarginWithDistanceLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr TripletMarginWithDistanceLossImpl module_ptr);
  public native @Name("push_back<torch::nn::TripletMarginWithDistanceLossImpl>") void push_back(@StdString String name, @SharedPtr TripletMarginWithDistanceLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CTCLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr CTCLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CTCLossImpl>") void push_back(@StdString String name, @SharedPtr CTCLossImpl module_ptr);
  public native @Name("push_back<torch::nn::PoissonNLLLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr PoissonNLLLossImpl module_ptr);
  public native @Name("push_back<torch::nn::PoissonNLLLossImpl>") void push_back(@StdString String name, @SharedPtr PoissonNLLLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MarginRankingLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr MarginRankingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::MarginRankingLossImpl>") void push_back(@StdString String name, @SharedPtr MarginRankingLossImpl module_ptr);
  public native @Name("push_back<torch::nn::NLLLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr NLLLossImpl module_ptr);
  public native @Name("push_back<torch::nn::NLLLossImpl>") void push_back(@StdString String name, @SharedPtr NLLLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CrossEntropyLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr CrossEntropyLossImpl module_ptr);
  public native @Name("push_back<torch::nn::CrossEntropyLossImpl>") void push_back(@StdString String name, @SharedPtr CrossEntropyLossImpl module_ptr);
  public native @Name("push_back<torch::nn::BCEWithLogitsLossImpl>") void push_back(@StdString BytePointer name, @SharedPtr BCEWithLogitsLossImpl module_ptr);
  public native @Name("push_back<torch::nn::BCEWithLogitsLossImpl>") void push_back(@StdString String name, @SharedPtr BCEWithLogitsLossImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ReflectionPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad1dImpl>") void push_back(@StdString String name, @SharedPtr ReflectionPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ReplicationPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad1dImpl>") void push_back(@StdString String name, @SharedPtr ReplicationPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ConstantPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad1dImpl>") void push_back(@StdString String name, @SharedPtr ConstantPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ZeroPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad1dImpl>") void push_back(@StdString String name, @SharedPtr ZeroPad1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AvgPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool1dImpl>") void push_back(@StdString String name, @SharedPtr AvgPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr MaxPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool1dImpl>") void push_back(@StdString String name, @SharedPtr MaxPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AdaptiveAvgPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool1dImpl>") void push_back(@StdString String name, @SharedPtr AdaptiveAvgPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AdaptiveMaxPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool1dImpl>") void push_back(@StdString String name, @SharedPtr AdaptiveMaxPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr MaxUnpool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool1dImpl>") void push_back(@StdString String name, @SharedPtr MaxUnpool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::LPPool1dImpl>") void push_back(@StdString BytePointer name, @SharedPtr LPPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::LPPool1dImpl>") void push_back(@StdString String name, @SharedPtr LPPool1dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ReflectionPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad2dImpl>") void push_back(@StdString String name, @SharedPtr ReflectionPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ReplicationPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad2dImpl>") void push_back(@StdString String name, @SharedPtr ReplicationPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ConstantPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad2dImpl>") void push_back(@StdString String name, @SharedPtr ConstantPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ZeroPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad2dImpl>") void push_back(@StdString String name, @SharedPtr ZeroPad2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AvgPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool2dImpl>") void push_back(@StdString String name, @SharedPtr AvgPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr MaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool2dImpl>") void push_back(@StdString String name, @SharedPtr MaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AdaptiveAvgPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool2dImpl>") void push_back(@StdString String name, @SharedPtr AdaptiveAvgPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AdaptiveMaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool2dImpl>") void push_back(@StdString String name, @SharedPtr AdaptiveMaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr MaxUnpool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool2dImpl>") void push_back(@StdString String name, @SharedPtr MaxUnpool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::FractionalMaxPool2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr FractionalMaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::FractionalMaxPool2dImpl>") void push_back(@StdString String name, @SharedPtr FractionalMaxPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::LPPool2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr LPPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::LPPool2dImpl>") void push_back(@StdString String name, @SharedPtr LPPool2dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ReflectionPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReflectionPad3dImpl>") void push_back(@StdString String name, @SharedPtr ReflectionPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ReplicationPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ReplicationPad3dImpl>") void push_back(@StdString String name, @SharedPtr ReplicationPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ConstantPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ConstantPad3dImpl>") void push_back(@StdString String name, @SharedPtr ConstantPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr ZeroPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::ZeroPad3dImpl>") void push_back(@StdString String name, @SharedPtr ZeroPad3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AvgPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AvgPool3dImpl>") void push_back(@StdString String name, @SharedPtr AvgPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr MaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxPool3dImpl>") void push_back(@StdString String name, @SharedPtr MaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AdaptiveAvgPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveAvgPool3dImpl>") void push_back(@StdString String name, @SharedPtr AdaptiveAvgPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr AdaptiveMaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::AdaptiveMaxPool3dImpl>") void push_back(@StdString String name, @SharedPtr AdaptiveMaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr MaxUnpool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::MaxUnpool3dImpl>") void push_back(@StdString String name, @SharedPtr MaxUnpool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::FractionalMaxPool3dImpl>") void push_back(@StdString BytePointer name, @SharedPtr FractionalMaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::FractionalMaxPool3dImpl>") void push_back(@StdString String name, @SharedPtr FractionalMaxPool3dImpl module_ptr);
  public native @Name("push_back<torch::nn::RNNImpl>") void push_back(@StdString BytePointer name, @SharedPtr RNNImpl module_ptr);
  public native @Name("push_back<torch::nn::RNNImpl>") void push_back(@StdString String name, @SharedPtr RNNImpl module_ptr);
  public native @Name("push_back<torch::nn::LSTMImpl>") void push_back(@StdString BytePointer name, @SharedPtr LSTMImpl module_ptr);
  public native @Name("push_back<torch::nn::LSTMImpl>") void push_back(@StdString String name, @SharedPtr LSTMImpl module_ptr);
  public native @Name("push_back<torch::nn::GRUImpl>") void push_back(@StdString BytePointer name, @SharedPtr GRUImpl module_ptr);
  public native @Name("push_back<torch::nn::GRUImpl>") void push_back(@StdString String name, @SharedPtr GRUImpl module_ptr);
  public native @Name("push_back<torch::nn::RNNCellImpl>") void push_back(@StdString BytePointer name, @SharedPtr RNNCellImpl module_ptr);
  public native @Name("push_back<torch::nn::RNNCellImpl>") void push_back(@StdString String name, @SharedPtr RNNCellImpl module_ptr);
  public native @Name("push_back<torch::nn::LSTMCellImpl>") void push_back(@StdString BytePointer name, @SharedPtr LSTMCellImpl module_ptr);
  public native @Name("push_back<torch::nn::LSTMCellImpl>") void push_back(@StdString String name, @SharedPtr LSTMCellImpl module_ptr);
  public native @Name("push_back<torch::nn::GRUCellImpl>") void push_back(@StdString BytePointer name, @SharedPtr GRUCellImpl module_ptr);
  public native @Name("push_back<torch::nn::GRUCellImpl>") void push_back(@StdString String name, @SharedPtr GRUCellImpl module_ptr);
  public native @Name("push_back<torch::nn::PixelShuffleImpl>") void push_back(@StdString BytePointer name, @SharedPtr PixelShuffleImpl module_ptr);
  public native @Name("push_back<torch::nn::PixelShuffleImpl>") void push_back(@StdString String name, @SharedPtr PixelShuffleImpl module_ptr);
  public native @Name("push_back<torch::nn::PixelUnshuffleImpl>") void push_back(@StdString BytePointer name, @SharedPtr PixelUnshuffleImpl module_ptr);
  public native @Name("push_back<torch::nn::PixelUnshuffleImpl>") void push_back(@StdString String name, @SharedPtr PixelUnshuffleImpl module_ptr);
  public native @Name("push_back<torch::nn::UpsampleImpl>") void push_back(@StdString BytePointer name, @SharedPtr UpsampleImpl module_ptr);
  public native @Name("push_back<torch::nn::UpsampleImpl>") void push_back(@StdString String name, @SharedPtr UpsampleImpl module_ptr);
  public native @Name("push_back<torch::nn::ELUImpl>") void push_back(@StdString BytePointer name, @SharedPtr ELUImpl module_ptr);
  public native @Name("push_back<torch::nn::ELUImpl>") void push_back(@StdString String name, @SharedPtr ELUImpl module_ptr);
  public native @Name("push_back<torch::nn::SELUImpl>") void push_back(@StdString BytePointer name, @SharedPtr SELUImpl module_ptr);
  public native @Name("push_back<torch::nn::SELUImpl>") void push_back(@StdString String name, @SharedPtr SELUImpl module_ptr);
  public native @Name("push_back<torch::nn::HardshrinkImpl>") void push_back(@StdString BytePointer name, @SharedPtr HardshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::HardshrinkImpl>") void push_back(@StdString String name, @SharedPtr HardshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::HardtanhImpl>") void push_back(@StdString BytePointer name, @SharedPtr HardtanhImpl module_ptr);
  public native @Name("push_back<torch::nn::HardtanhImpl>") void push_back(@StdString String name, @SharedPtr HardtanhImpl module_ptr);
  public native @Name("push_back<torch::nn::LeakyReLUImpl>") void push_back(@StdString BytePointer name, @SharedPtr LeakyReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::LeakyReLUImpl>") void push_back(@StdString String name, @SharedPtr LeakyReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::LogSigmoidImpl>") void push_back(@StdString BytePointer name, @SharedPtr LogSigmoidImpl module_ptr);
  public native @Name("push_back<torch::nn::LogSigmoidImpl>") void push_back(@StdString String name, @SharedPtr LogSigmoidImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftmaxImpl>") void push_back(@StdString BytePointer name, @SharedPtr SoftmaxImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftmaxImpl>") void push_back(@StdString String name, @SharedPtr SoftmaxImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftminImpl>") void push_back(@StdString BytePointer name, @SharedPtr SoftminImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftminImpl>") void push_back(@StdString String name, @SharedPtr SoftminImpl module_ptr);
  public native @Name("push_back<torch::nn::LogSoftmaxImpl>") void push_back(@StdString BytePointer name, @SharedPtr LogSoftmaxImpl module_ptr);
  public native @Name("push_back<torch::nn::LogSoftmaxImpl>") void push_back(@StdString String name, @SharedPtr LogSoftmaxImpl module_ptr);
  public native @Name("push_back<torch::nn::Softmax2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr Softmax2dImpl module_ptr);
  public native @Name("push_back<torch::nn::Softmax2dImpl>") void push_back(@StdString String name, @SharedPtr Softmax2dImpl module_ptr);
  public native @Name("push_back<torch::nn::PReLUImpl>") void push_back(@StdString BytePointer name, @SharedPtr PReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::PReLUImpl>") void push_back(@StdString String name, @SharedPtr PReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::ReLUImpl>") void push_back(@StdString BytePointer name, @SharedPtr ReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::ReLUImpl>") void push_back(@StdString String name, @SharedPtr ReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::ReLU6Impl>") void push_back(@StdString BytePointer name, @SharedPtr ReLU6Impl module_ptr);
  public native @Name("push_back<torch::nn::ReLU6Impl>") void push_back(@StdString String name, @SharedPtr ReLU6Impl module_ptr);
  public native @Name("push_back<torch::nn::RReLUImpl>") void push_back(@StdString BytePointer name, @SharedPtr RReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::RReLUImpl>") void push_back(@StdString String name, @SharedPtr RReLUImpl module_ptr);
  public native @Name("push_back<torch::nn::CELUImpl>") void push_back(@StdString BytePointer name, @SharedPtr CELUImpl module_ptr);
  public native @Name("push_back<torch::nn::CELUImpl>") void push_back(@StdString String name, @SharedPtr CELUImpl module_ptr);
  public native @Name("push_back<torch::nn::GLUImpl>") void push_back(@StdString BytePointer name, @SharedPtr GLUImpl module_ptr);
  public native @Name("push_back<torch::nn::GLUImpl>") void push_back(@StdString String name, @SharedPtr GLUImpl module_ptr);
  public native @Name("push_back<torch::nn::GELUImpl>") void push_back(@StdString BytePointer name, @SharedPtr GELUImpl module_ptr);
  public native @Name("push_back<torch::nn::GELUImpl>") void push_back(@StdString String name, @SharedPtr GELUImpl module_ptr);
  public native @Name("push_back<torch::nn::SiLUImpl>") void push_back(@StdString BytePointer name, @SharedPtr SiLUImpl module_ptr);
  public native @Name("push_back<torch::nn::SiLUImpl>") void push_back(@StdString String name, @SharedPtr SiLUImpl module_ptr);
  public native @Name("push_back<torch::nn::MishImpl>") void push_back(@StdString BytePointer name, @SharedPtr MishImpl module_ptr);
  public native @Name("push_back<torch::nn::MishImpl>") void push_back(@StdString String name, @SharedPtr MishImpl module_ptr);
  public native @Name("push_back<torch::nn::SigmoidImpl>") void push_back(@StdString BytePointer name, @SharedPtr SigmoidImpl module_ptr);
  public native @Name("push_back<torch::nn::SigmoidImpl>") void push_back(@StdString String name, @SharedPtr SigmoidImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftplusImpl>") void push_back(@StdString BytePointer name, @SharedPtr SoftplusImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftplusImpl>") void push_back(@StdString String name, @SharedPtr SoftplusImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftshrinkImpl>") void push_back(@StdString BytePointer name, @SharedPtr SoftshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftshrinkImpl>") void push_back(@StdString String name, @SharedPtr SoftshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftsignImpl>") void push_back(@StdString BytePointer name, @SharedPtr SoftsignImpl module_ptr);
  public native @Name("push_back<torch::nn::SoftsignImpl>") void push_back(@StdString String name, @SharedPtr SoftsignImpl module_ptr);
  public native @Name("push_back<torch::nn::TanhImpl>") void push_back(@StdString BytePointer name, @SharedPtr TanhImpl module_ptr);
  public native @Name("push_back<torch::nn::TanhImpl>") void push_back(@StdString String name, @SharedPtr TanhImpl module_ptr);
  public native @Name("push_back<torch::nn::TanhshrinkImpl>") void push_back(@StdString BytePointer name, @SharedPtr TanhshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::TanhshrinkImpl>") void push_back(@StdString String name, @SharedPtr TanhshrinkImpl module_ptr);
  public native @Name("push_back<torch::nn::ThresholdImpl>") void push_back(@StdString BytePointer name, @SharedPtr ThresholdImpl module_ptr);
  public native @Name("push_back<torch::nn::ThresholdImpl>") void push_back(@StdString String name, @SharedPtr ThresholdImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiheadAttentionImpl>") void push_back(@StdString BytePointer name, @SharedPtr MultiheadAttentionImpl module_ptr);
  public native @Name("push_back<torch::nn::MultiheadAttentionImpl>") void push_back(@StdString String name, @SharedPtr MultiheadAttentionImpl module_ptr);
  public native @Name("push_back<torch::nn::LayerNormImpl>") void push_back(@StdString BytePointer name, @SharedPtr LayerNormImpl module_ptr);
  public native @Name("push_back<torch::nn::LayerNormImpl>") void push_back(@StdString String name, @SharedPtr LayerNormImpl module_ptr);
  public native @Name("push_back<torch::nn::LocalResponseNormImpl>") void push_back(@StdString BytePointer name, @SharedPtr LocalResponseNormImpl module_ptr);
  public native @Name("push_back<torch::nn::LocalResponseNormImpl>") void push_back(@StdString String name, @SharedPtr LocalResponseNormImpl module_ptr);
  public native @Name("push_back<torch::nn::CrossMapLRN2dImpl>") void push_back(@StdString BytePointer name, @SharedPtr CrossMapLRN2dImpl module_ptr);
  public native @Name("push_back<torch::nn::CrossMapLRN2dImpl>") void push_back(@StdString String name, @SharedPtr CrossMapLRN2dImpl module_ptr);
  public native @Name("push_back<torch::nn::GroupNormImpl>") void push_back(@StdString BytePointer name, @SharedPtr GroupNormImpl module_ptr);
  public native @Name("push_back<torch::nn::GroupNormImpl>") void push_back(@StdString String name, @SharedPtr GroupNormImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerEncoderLayerImpl>") void push_back(@StdString BytePointer name, @SharedPtr TransformerEncoderLayerImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerEncoderLayerImpl>") void push_back(@StdString String name, @SharedPtr TransformerEncoderLayerImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerDecoderLayerImpl>") void push_back(@StdString BytePointer name, @SharedPtr TransformerDecoderLayerImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerDecoderLayerImpl>") void push_back(@StdString String name, @SharedPtr TransformerDecoderLayerImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerEncoderImpl>") void push_back(@StdString BytePointer name, @SharedPtr TransformerEncoderImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerEncoderImpl>") void push_back(@StdString String name, @SharedPtr TransformerEncoderImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerDecoderImpl>") void push_back(@StdString BytePointer name, @SharedPtr TransformerDecoderImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerDecoderImpl>") void push_back(@StdString String name, @SharedPtr TransformerDecoderImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerImpl>") void push_back(@StdString BytePointer name, @SharedPtr TransformerImpl module_ptr);
  public native @Name("push_back<torch::nn::TransformerImpl>") void push_back(@StdString String name, @SharedPtr TransformerImpl module_ptr);

  /** Adds a new {@code Module} to the {@code Sequential} container, moving or copying it
   *  into a {@code shared_ptr} internally. This method allows passing value types,
   *  and letting the container deal with the boxing. This means you can write
   *  {@code Sequential(Module(3, 4))} instead of
   *  {@code Sequential(std::make_shared<Module>(3, 4))}. */

  /** Adds a new named {@code Module} to the {@code Sequential} container, moving or copying
   *  it into a {@code shared_ptr} internally. This method allows passing value types,
   *  and letting the container deal with the boxing. */

  /** Unwraps the contained module of a {@code ModuleHolder} and adds it to the
   *  {@code Sequential}. */

  /** Unwraps the contained named module of a {@code ModuleHolder} and adds it to the
   *  {@code Sequential}. */

  /** Iterates over the container and calls {@code push_back()} on each value. */

  /** Adds a type-erased {@code AnyModule} to the {@code Sequential}. */
  public native void push_back(@ByVal AnyModule any_module);

  public native void push_back(@StdString BytePointer name, @ByVal AnyModule any_module);
  public native void push_back(@StdString String name, @ByVal AnyModule any_module);

  /** Returns an iterator to the start of the {@code Sequential}. */
  public native @ByVal @Cast("torch::nn::SequentialImpl::Iterator*") AnyModuleVector.Iterator begin();

  /** Returns a const iterator to the start of the {@code Sequential}. */

  /** Returns an iterator to the end of the {@code Sequential}. */
  public native @ByVal @Cast("torch::nn::SequentialImpl::Iterator*") AnyModuleVector.Iterator end();

  /** Returns a const iterator to the end of the {@code Sequential}. */

  /** Attempts to return the module at the given index as the requested type.
   *  Throws an exception if the index is out of bounds or the types do not
   *  match. */

  /** Attempts to return the module at the given index as the requested type.
   *  Throws an exception if the index is out of bounds or the types do not
   *  match. */

  /** Attempts to return a {@code std::shared_ptr} whose dynamic type is that of the
   *  underlying module at the given index. Throws an exception if the index is
   *  out of bounds. */
  public native @SharedPtr("torch::nn::Module") @ByVal Module ptr(@Cast("size_t") long index);

  /** Attempts to return a {@code std::shared_ptr} whose type is the one provided.
   *  Throws an exception if the index is out of bounds or the types do not
   *  match. */

  /** Like {@code ptr(index)}. */
  public native @SharedPtr("torch::nn::Module") @ByVal @Name("operator []") Module get(@Cast("size_t") long index);

  /** The current size of the {@code Sequential} container. */
  public native @Cast("size_t") @NoException(true) long size();

  /** True if there are no modules in the {@code Sequential}. */
  public native @Cast("bool") @NoException(true) boolean is_empty();
}
