// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


/** The base class for all modules in PyTorch.
 * 
 *  \rst
 *  .. note::
 *    The design and implementation of this class is largely based on the Python
 *    API. You may want to consult the python documentation for
 *    :py:class:{@code pytorch:torch.nn.Module} for further clarification on certain
 *    methods or behavior.
 *  \endrst
 * 
 *  A {@code Module} is an abstraction over the implementation of some function or
 *  algorithm, possibly associated with some persistent data. A {@code Module} may
 *  contain further {@code Module}s ("submodules"), each with their own
 *  implementation, persistent data and further submodules. {@code Module}s can thus
 *  be said to form a recursive tree structure. A {@code Module} is registered as a
 *  submodule to another {@code Module} by calling {@code register_module()}, typically from
 *  within a parent module's constructor.
 * 
 *  A distinction is made between three kinds of persistent data that may be
 *  associated with a {@code Module}:
 * 
 *  1. *Parameters*: tensors that record gradients, typically weights updated
 *     during the backward step (e.g. the {@code weight} of a {@code Linear} module),
 *  2. *Buffers*: tensors that do not record gradients, typically updated during
 *     the forward step, such as running statistics (e.g. {@code mean} and {@code variance}
 *     in the {@code BatchNorm} module),
 *  3. Any additional state, not necessarily tensors, required for the
 *     implementation or configuration of a {@code Module}.
 * 
 *  The first two kinds of state are special in that they may be registered
 *  with the {@code Module} system to allow convenient access and batch configuration.
 *  For example, registered parameters in any {@code Module} may be iterated over via
 *  the {@code parameters()} accessor. Further, changing the data type of a {@code Module}'s
 *  registered parameters can be done conveniently via {@code Module::to()}, e.g.
 *  {@code module->to(torch::kCUDA)} to move all parameters to GPU memory. Lastly,
 *  registered parameters and buffers are handled specially during a {@code clone()}
 *  operation, which performs a deepcopy of a cloneable {@code Module} hierarchy.
 * 
 *  Parameters are registered with a {@code Module} via {@code register_parameter}. Buffers
 *  are registered separately via {@code register_buffer}. These methods are part of
 *  the public API of {@code Module} and are typically invoked from within a
 *  concrete {@code Module}s constructor. */
@Namespace("torch::nn") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class Module extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Module(Pointer p) { super(p); }
    public Module asModule() { return this; }


  /** Tells the base {@code Module} about the name of the submodule. */
  public Module(@StdString BytePointer name) { super((Pointer)null); allocate(name); }
  @SharedPtr @Name("std::make_shared<JavaCPP_torch_0003a_0003ann_0003a_0003aModule>") private native void allocate(@StdString BytePointer name);
  public Module(@StdString String name) { super((Pointer)null); allocate(name); }
  @SharedPtr @Name("std::make_shared<JavaCPP_torch_0003a_0003ann_0003a_0003aModule>") private native void allocate(@StdString String name);

  /** Constructs the module without immediate knowledge of the submodule's name.
   *  The name of the submodule is inferred via RTTI (if possible) the first
   *  time {@code .name()} is invoked. */
  public Module() { super((Pointer)null); allocate(); }
  @SharedPtr @Name("std::make_shared<JavaCPP_torch_0003a_0003ann_0003a_0003aModule>") private native void allocate();

  /** Returns the name of the {@code Module}.
   * 
   *  A {@code Module} has an associated {@code name}, which is a string representation of
   *  the kind of concrete {@code Module} it represents, such as {@code "Linear"} for the
   *  {@code Linear} module. Under most circumstances, this name is automatically
   *  inferred via runtime type information (RTTI). In the unusual circumstance
   *  that you have this feature disabled, you may want to manually name your
   *  {@code Module}s by passing the string name to the {@code Module} base class'
   *  constructor. */
  
  ///
  ///
  public BytePointer name() { return asModule()._name(); }
  private native @StdString @NoException(true) @Name("name") BytePointer _name();

  /** Performs a recursive deep copy of the module and all its registered
   *  parameters, buffers and submodules.
   * 
   *  Optionally, this method sets the current device
   *  to the one supplied before cloning. If no device is given, each
   *  parameter and buffer will be moved to the device of its source.
   * 
   *  \rst
   *  .. attention::
   *    Attempting to call the {@code clone()} method inherited from the base {@code Module}
   *    class (the one documented here) will fail. To inherit an actual
   *    implementation of {@code clone()}, you must subclass {@code Cloneable}. {@code Cloneable}
   *    is templatized on the concrete module type, and can thus properly copy a
   *    {@code Module}. This method is provided on the base class' API solely for an
   *    easier-to-use polymorphic interface.
   *  \endrst */
  
  ///
  public Module clone(DeviceOptional device) { return asModule()._clone(device); }
  private native @SharedPtr("torch::nn::Module") @ByVal @Virtual(subclasses=false, method="clone") @Cast({"", "std::shared_ptr<torch::nn::Module>"}) @Const({false, false, true}) @Name("clone") Module _clone(
        @Const @ByRef(nullValue = "c10::optional<torch::Device>(c10::nullopt)") DeviceOptional device);

  /** Applies the {@code function} to the {@code Module} and recursively to every submodule.
   *  The function must accept a {@code Module&}.
   * 
   *  \rst
   *  .. code-block:: cpp
   *    MyModule module;
   *    module->apply([](nn::Module& module) {
   *      std::cout << module.name() << std::endl;
   *    });
   *  \endrst */
  
  ///
  public void apply(ModuleApplyFunction function) { asModule()._apply(function); }
  private native @Name("apply") void _apply(@Const @ByRef ModuleApplyFunction function);

  /** Applies the {@code function} to the {@code Module} and recursively to every submodule.
   *  The function must accept a {@code const Module&}.
   * 
   *  \rst
   *  .. code-block:: cpp
   *    MyModule module;
   *    module->apply([](const nn::Module& module) {
   *      std::cout << module.name() << std::endl;
   *    });
   *  \endrst */

  /** Applies the {@code function} to the {@code Module} and recursively to every submodule.
   *  The function must accept a {@code const std::string&} for the key of the module,
   *  and a {@code Module&}. The key of the module itself is the empty string. If
   *  {@code name_prefix} is given, it is prepended to every key as
   *  {@code <name_prefix>.<key>} (and just {@code name_prefix} for the module itself).
   * 
   *  \rst
   *  .. code-block:: cpp
   *    MyModule module;
   *    module->apply([](const std::string& key, nn::Module& module) {
   *      std::cout << key << ": " << module.name() << std::endl;
   *    });
   *  \endrst */
  
  ///
  public void apply(NamedModuleApplyFunction function, BytePointer name_prefix) { asModule()._apply(function, name_prefix); }
  private native @Name("apply") void _apply(
        @Const @ByRef NamedModuleApplyFunction function,
        @StdString BytePointer name_prefix/*=std::string()*/);
  public void apply(NamedModuleApplyFunction function) { asModule()._apply(function); }
  private native @Name("apply") void _apply(
        @Const @ByRef NamedModuleApplyFunction function);
  public void apply(NamedModuleApplyFunction function, String name_prefix) { asModule()._apply(function, name_prefix); }
  private native @Name("apply") void _apply(
        @Const @ByRef NamedModuleApplyFunction function,
        @StdString String name_prefix/*=std::string()*/);

  /** Applies the {@code function} to the {@code Module} and recursively to every submodule.
   *  The function must accept a {@code const std::string&} for the key of the module,
   *  and a {@code const Module&}. The key of the module itself is the empty string.
   *  If {@code name_prefix} is given, it is prepended to every key as
   *  {@code <name_prefix>.<key>} (and just {@code name_prefix} for the module itself).
   * 
   *  \rst
   *  .. code-block:: cpp
   *    MyModule module;
   *    module->apply([](const std::string& key, const nn::Module& module) {
   *      std::cout << key << ": " << module.name() << std::endl;
   *    });
   *  \endrst */

  /** Applies the {@code function} to the {@code Module} and recursively to every submodule.
   *  The function must accept a {@code const std::shared_ptr<Module>&}.
   * 
   *  \rst
   *  .. code-block:: cpp
   *    MyModule module;
   *    module->apply([](const std::shared_ptr<nn::Module>& module) {
   *      std::cout << module->name() << std::endl;
   *    });
   *  \endrst */
  
  ///
  public void apply(SharedModuleApplyFunction function) { asModule()._apply(function); }
  private native @Name("apply") void _apply(@Cast("const torch::nn::Module::ModulePointerApplyFunction*") @ByRef SharedModuleApplyFunction function);

  /** Applies the {@code function} to the {@code Module} and recursively to every submodule.
   *  The function must accept a {@code const std::string&} for the key of the module,
   *  and a {@code const std::shared_ptr<Module>&}. The key of the module itself is
   *  the empty string. If {@code name_prefix} is given, it is prepended to every key
   *  as
   *  {@code <name_prefix>.<key>} (and just {@code name_prefix} for the module itself).
   * 
   *  \rst
   *  .. code-block:: cpp
   *    MyModule module;
   *    module->apply([](const std::string& key,
   *                     const std::shared_ptr<nn::Module>& module) {
   *      std::cout << key << ": " << module->name() << std::endl;
   *    });
   *  \endrst */
  public void apply(NamedSharedModuleApplyFunction function, BytePointer name_prefix) { asModule()._apply(function, name_prefix); }
  private native @Name("apply") void _apply(
        @Const @ByRef NamedSharedModuleApplyFunction function,
        @StdString BytePointer name_prefix/*=std::string()*/);
  public void apply(NamedSharedModuleApplyFunction function) { asModule()._apply(function); }
  private native @Name("apply") void _apply(
        @Const @ByRef NamedSharedModuleApplyFunction function);
  public void apply(NamedSharedModuleApplyFunction function, String name_prefix) { asModule()._apply(function, name_prefix); }
  private native @Name("apply") void _apply(
        @Const @ByRef NamedSharedModuleApplyFunction function,
        @StdString String name_prefix/*=std::string()*/);

  /** Returns the parameters of this {@code Module} and if {@code recurse} is true, also
   *  recursively of every submodule. */
  public TensorVector parameters(boolean recurse) { return asModule()._parameters(recurse); }
  private native @Name("parameters") @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector _parameters(@Cast("bool") boolean recurse/*=true*/);
  public TensorVector parameters() { return asModule()._parameters(); }
  private native @Name("parameters") @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector _parameters();

  /** Returns an {@code OrderedDict} with the parameters of this {@code Module} along with
   *  their keys, and if {@code recurse} is true also recursively of every submodule. */
  public StringTensorDict named_parameters(boolean recurse) { return asModule()._named_parameters(recurse); }
  private native @ByVal @Name("named_parameters") StringTensorDict _named_parameters(@Cast("bool") boolean recurse/*=true*/);
  public StringTensorDict named_parameters() { return asModule()._named_parameters(); }
  private native @ByVal @Name("named_parameters") StringTensorDict _named_parameters();

  /** Returns the buffers of this {@code Module} and if {@code recurse} is true, also
   *  recursively of every submodule. */
  public TensorVector buffers(boolean recurse) { return asModule()._buffers(recurse); }
  private native @Name("buffers") @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector _buffers(@Cast("bool") boolean recurse/*=true*/);
  public TensorVector buffers() { return asModule()._buffers(); }
  private native @Name("buffers") @Cast({"", "std::vector<torch::Tensor>"}) @StdMove TensorVector _buffers();

  /** Returns an {@code OrderedDict} with the buffers of this {@code Module} along with
   *  their keys, and if {@code recurse} is true also recursively of every submodule. */
  
  ///
  public StringTensorDict named_buffers(boolean recurse) { return asModule()._named_buffers(recurse); }
  private native @ByVal @Name("named_buffers") StringTensorDict _named_buffers(@Cast("bool") boolean recurse/*=true*/);
  public StringTensorDict named_buffers() { return asModule()._named_buffers(); }
  private native @ByVal @Name("named_buffers") StringTensorDict _named_buffers();

  /** Returns the submodules of this {@code Module} (the entire submodule hierarchy)
   *  and if {@code include_self} is true, also inserts a {@code shared_ptr} to this module
   *  in the first position.
   * 
   *  \rst
   *  .. warning::
   *    Only pass {@code include_self} as {@code true} if this {@code Module} is stored in a
   *    {@code shared_ptr}! Otherwise an exception will be thrown. You may still call
   *    this method with {@code include_self} set to false if your {@code Module} is not
   *    stored in a {@code shared_ptr}.
   *  \endrst */
  
  ///
  public SharedModuleVector modules(boolean include_self) { return asModule()._modules(include_self); }
  private native @ByVal @Name("modules") SharedModuleVector _modules(@Cast("bool") boolean include_self/*=true*/);
  public SharedModuleVector modules() { return asModule()._modules(); }
  private native @ByVal @Name("modules") SharedModuleVector _modules();

  /** Returns an {@code OrderedDict} of the submodules of this {@code Module} (the entire
   *  submodule hierarchy) and their keys, and if {@code include_self} is true, also
   *  inserts a {@code shared_ptr} to this module in the first position. If
   *  {@code name_prefix} is given, it is prepended to every key as
   *  {@code <name_prefix>.<key>} (and just {@code name_prefix} for the module itself).
   * 
   *  \rst
   *  .. warning::
   *    Only pass {@code include_self} as {@code true} if this {@code Module} is stored in a
   *    {@code shared_ptr}! Otherwise an exception will be thrown. You may still call
   *    this method with {@code include_self} set to false if your {@code Module} is not
   *    stored in a {@code shared_ptr}.
   *  \endrst */
  public StringSharedModuleDict named_modules(BytePointer name_prefix, boolean include_self) { return asModule()._named_modules(name_prefix, include_self); }
  private native @ByVal @Name("named_modules") StringSharedModuleDict _named_modules(
        @StdString BytePointer name_prefix/*=std::string()*/,
        @Cast("bool") boolean include_self/*=true*/);
  public StringSharedModuleDict named_modules() { return asModule()._named_modules(); }
  private native @ByVal @Name("named_modules") StringSharedModuleDict _named_modules();
  public StringSharedModuleDict named_modules(String name_prefix, boolean include_self) { return asModule()._named_modules(name_prefix, include_self); }
  private native @ByVal @Name("named_modules") StringSharedModuleDict _named_modules(
        @StdString String name_prefix/*=std::string()*/,
        @Cast("bool") boolean include_self/*=true*/);

  /** Returns the direct submodules of this {@code Module}. */
  public SharedModuleVector children() { return asModule()._children(); }
  private native @ByVal @Name("children") SharedModuleVector _children();

  /** Returns an {@code OrderedDict} of the direct submodules of this {@code Module} and
   *  their keys. */
  public StringSharedModuleDict named_children() { return asModule()._named_children(); }
  private native @ByVal @Name("named_children") StringSharedModuleDict _named_children();

  /** Enables "training" mode. */
  public void train(boolean on) { asModule()._train(on); }
  private native @Virtual(subclasses=false, method="train") @Name("train") void _train(@Cast("bool") boolean on/*=true*/);

  /** Calls train(false) to enable "eval" mode.
   *  Do not override this method, override {@code train()} instead. */
  
  ///
  public void eval() { asModule()._eval(); }
  private native @Name("eval") void _eval();

  /** True if the module is in training mode.
   * 
   *  Every {@code Module} has a boolean associated with it that determines whether
   *  the {@code Module} is currently in *training* mode (set via {@code .train()}) or in
   *  *evaluation* (inference) mode (set via {@code .eval()}). This property is
   *  exposed via {@code is_training()}, and may be used by the implementation of a
   *  concrete module to modify its runtime behavior. See the {@code BatchNorm} or
   *  {@code Dropout} modules for examples of {@code Module}s that use different code paths
   *  depending on this property. */
  
  ///
  public boolean is_training() { return asModule()._is_training(); }
  private native @Cast("bool") @Virtual(subclasses=false, method="is_training") @NoException(true) @Const({false, false, true}) @Name("is_training") boolean _is_training();

  /** Recursively casts all parameters to the given {@code dtype} and {@code device}.
   * 
   *  If {@code non_blocking} is true and the source is in pinned memory and
   *  destination is on the GPU or vice versa, the copy is performed
   *  asynchronously with respect to the host. Otherwise, the argument has no
   *  effect. */
  
  ///
  public void to(Device device, ScalarType dtype, boolean non_blocking) { asModule()._to(device, dtype, non_blocking); }
  private native @Virtual(subclasses=false, method="to") @Name("to") void _to(
        @ByVal Device device,
        ScalarType dtype,
        @Cast("bool") boolean non_blocking/*=false*/);

  /** Recursively casts all parameters to the given dtype.
   * 
   *  If {@code non_blocking} is true and the source is in pinned memory and
   *  destination is on the GPU or vice versa, the copy is performed
   *  asynchronously with respect to the host. Otherwise, the argument has no
   *  effect. */
  
  ///
  public void to(ScalarType dtype, boolean non_blocking) { asModule()._to(dtype, non_blocking); }
  private native @Virtual(subclasses=false, method="to") @Name("to") void _to(ScalarType dtype, @Cast("bool") boolean non_blocking/*=false*/);

  /** Recursively moves all parameters to the given device.
   * 
   *  If {@code non_blocking} is true and the source is in pinned memory and
   *  destination is on the GPU or vice versa, the copy is performed
   *  asynchronously with respect to the host. Otherwise, the argument has no
   *  effect. */
  public void to(Device device, boolean non_blocking) { asModule()._to(device, non_blocking); }
  private native @Virtual(subclasses=false, method="to") @Name("to") void _to(@ByVal Device device, @Cast("bool") boolean non_blocking/*=false*/);

  /** Recursively zeros out the {@code grad} value of each registered parameter. */
  
  ///
  ///
  ///
  public void zero_grad(boolean set_to_none) { asModule()._zero_grad(set_to_none); }
  private native @Virtual(subclasses=false, method="zero_grad") @Name("zero_grad") void _zero_grad(@Cast("bool") boolean set_to_none/*=true*/);

  /** Attempts to cast this {@code Module} to the given {@code ModuleType}.
   * 
   *  This method is useful when calling {@code apply()}.
   *  \rst
   *  .. code-block:: cpp
   * 
   *    void initialize_weights(nn::Module& module) {
   *      torch::NoGradGuard no_grad;
   *      if (auto* linear = module.as<nn::Linear>()) {
   *        linear->weight.normal_(0.0, 0.02);
   *      }
   *    }
   * 
   *    MyModule module;
   *    module->apply(initialize_weights);
   *  \endrst */

  /** Attempts to cast this {@code Module} to the given {@code ModuleType}.
   * 
   *  This method is useful when calling {@code apply()}.
   *  \rst
   *  .. code-block:: cpp
   *    void initialize_weights(nn::Module& module) {
   *      torch::NoGradGuard no_grad;
   *      if (auto* linear = module.as<nn::Linear>()) {
   *        linear->weight.normal_(0.0, 0.02);
   *      }
   *    }
   * 
   *    MyModule module;
   *    module->apply(initialize_weights);
   *  \endrst */

  /** Attempts to cast this {@code Module} to the given {@code ModuleType}.
   * 
   *  This method is useful when calling {@code apply()}.
   *  \rst
   *  .. code-block:: cpp
   * 
   *    void initialize_weights(nn::Module& module) {
   *      torch::NoGradGuard no_grad;
   *      if (auto* linear = module.as<nn::Linear>()) {
   *        linear->weight.normal_(0.0, 0.02);
   *      }
   *    }
   * 
   *    MyModule module;
   *    module.apply(initialize_weights);
   *  \endrst */

  /** Attempts to cast this {@code Module} to the given {@code ModuleType}.
   * 
   *  This method is useful when calling {@code apply()}.
   *  \rst
   *  .. code-block:: cpp
   * 
   *    void initialize_weights(nn::Module& module) {
   *      torch::NoGradGuard no_grad;
   *      if (auto* linear = module.as<nn::Linear>()) {
   *        linear->weight.normal_(0.0, 0.02);
   *      }
   *    }
   * 
   *    MyModule module;
   *    module.apply(initialize_weights);
   *  \endrst */

  /** Serializes the {@code Module} into the given {@code OutputArchive}.
   * 
   *  If the {@code Module} contains unserializable submodules (e.g.
   *  {@code nn::Functional}), those submodules are skipped when serializing. */
  
  ///
  public void save(OutputArchive archive) { asModule()._save(archive); }
  private native @Virtual(subclasses=false, method="save") @Const({false, false, true}) @Name("save") void _save(@ByRef OutputArchive archive);

  /** Deserializes the {@code Module} from the given {@code InputArchive}.
   * 
   *  If the {@code Module} contains unserializable submodules (e.g.
   *  {@code nn::Functional}), we don't check the existence of those submodules in the
   *  {@code InputArchive} when deserializing. */
  
  ///
  public void load(InputArchive archive) { asModule()._load(archive); }
  private native @Virtual(subclasses=false, method="load") @Name("load") void _load(@ByRef InputArchive archive);

  /** Streams a pretty representation of the {@code Module} into the given {@code stream}.
   *  By default, this representation will be the name of the module (taken from
   *  {@code name()}), followed by a recursive pretty print of all of the {@code Module}'s
   *  submodules.
   * 
   *  Override this method to change the pretty print. The input
   *  {@code stream} should be returned from the method, to allow easy chaining. */
  public void pretty_print(Pointer stream) { asModule()._pretty_print(stream); }
  private native @Virtual(subclasses=false, method="pretty_print") @Const({false, false, true}) @Name("pretty_print") void _pretty_print(@Cast("std::ostream*") @ByRef Pointer stream);

  /** Returns whether the {@code Module} is serializable. */
  
  ///
  ///
  ///
  ///
  public boolean is_serializable() { return asModule()._is_serializable(); }
  private native @Cast("bool") @Virtual(subclasses=false, method="is_serializable") @Const({false, false, true}) @Name("is_serializable") boolean _is_serializable();

  /** Registers a parameter with this {@code Module}.
   * 
   *  A parameter should be any gradient-recording tensor used in the
   *  implementation of your {@code Module}. Registering it makes it available to
   *  methods such as {@code parameters()}, {@code clone()} or {@code to().}
   * 
   *  Note that registering an undefined Tensor (e.g.
   *  {@code module.register_parameter("param", Tensor())}) is allowed, and is
   *  equivalent to {@code module.register_parameter("param", None)} in Python API.
   * 
   *  \rst
   *  .. code-block:: cpp
   * 
   *    MyModule::MyModule() {
   *      weight_ = register_parameter("weight", torch::randn({A, B}));
   *    }
   *  \endrst */
  
  ///
  ///
  ///
  public Tensor register_parameter(BytePointer name, Tensor tensor, boolean requires_grad) { return asModule()._register_parameter(name, tensor, requires_grad); }
  private native @ByRef @Name("register_parameter") Tensor _register_parameter(
        @StdString BytePointer name,
        @ByVal Tensor tensor,
        @Cast("bool") boolean requires_grad/*=true*/);
  public Tensor register_parameter(BytePointer name, Tensor tensor) { return asModule()._register_parameter(name, tensor); }
  private native @ByRef @Name("register_parameter") Tensor _register_parameter(
        @StdString BytePointer name,
        @ByVal Tensor tensor);
  public Tensor register_parameter(String name, Tensor tensor, boolean requires_grad) { return asModule()._register_parameter(name, tensor, requires_grad); }
  private native @ByRef @Name("register_parameter") Tensor _register_parameter(
        @StdString String name,
        @ByVal Tensor tensor,
        @Cast("bool") boolean requires_grad/*=true*/);
  public Tensor register_parameter(String name, Tensor tensor) { return asModule()._register_parameter(name, tensor); }
  private native @ByRef @Name("register_parameter") Tensor _register_parameter(
        @StdString String name,
        @ByVal Tensor tensor);

  /** Registers a buffer with this {@code Module}.
   * 
   *  A buffer is intended to be state in your module that does not record
   *  gradients, such as running statistics. Registering it makes it available
   *  to methods such as {@code buffers()}, {@code clone()} or {@code to().
   * 
   *  \rst
   *  .. code-block:: cpp
   * 
   *    MyModule::MyModule() {
   *      mean_ = register_buffer("mean", torch::empty({num_features_}));
   *    }
   *  \endrst */
  
  ///
  ///
  ///
  public Tensor register_buffer(BytePointer name, Tensor tensor) { return asModule()._register_buffer(name, tensor); }
  private native @ByRef @Name("register_buffer") Tensor _register_buffer(@StdString BytePointer name, @ByVal Tensor tensor);
  public Tensor register_buffer(String name, Tensor tensor) { return asModule()._register_buffer(name, tensor); }
  private native @ByRef @Name("register_buffer") Tensor _register_buffer(@StdString String name, @ByVal Tensor tensor);

  /** Registers a submodule with this {@code Module}.
   * 
   *  Registering a module makes it available to methods such as {@code modules()},
   *  {@code clone()} or {@code to()}.
   * 
   *  \rst
   *  .. code-block:: cpp
   * 
   *    MyModule::MyModule() {
   *      submodule_ = register_module("linear", torch::nn::Linear(3, 4));
   *    }
   *  \endrst */
  
  ///
  ///
  ///
  ///
  private native @Name("register_module<torch::nn::Module>") void _register_module(@StdString BytePointer name, @SharedPtr @ByVal Module module);
  public <M extends Module> M register_module(BytePointer name, M module) { asModule()._register_module(name, module.asModule()); return module; }
  private native @Name("register_module<torch::nn::Module>") void _register_module(@StdString String name, @SharedPtr @ByVal Module module);
  public <M extends Module> M register_module(String name, M module) { asModule()._register_module(name, module.asModule()); return module; }

  /** Registers a submodule with this {@code Module}.
   * 
   *  This method deals with {@code ModuleHolder}s.
   * 
   *  Registering a module makes it available to methods such as {@code modules()},
   *  {@code clone()} or {@code to()}.
   * 
   *  \rst
   *  .. code-block:: cpp
   * 
   *    MyModule::MyModule() {
   *      submodule_ = register_module("linear", torch::nn::Linear(3, 4));
   *    }
   *  \endrst */

  /** Replaces a registered submodule with this {@code Module}.
   * 
   *  This takes care of the registration, if you used submodule members, you
   *  should */
  //  assign the submodule as well, i.e. use as
  /**     module->submodule_ = module->replace_module("linear",
  /**     torch::nn::Linear(3, 4));
  /** It only works when a module of the name is already registered.
  /**
  /** This is useful for replacing a module after initialization, e.g.
  /** for finetuning. */

  /** Replaces a registered submodule with this {@code Module}.
   *  This method deals with {@code ModuleHolder}s.
   * 
   *  This takes care of the registration, if you used submodule members, you
   *  should */
  //  assign the submodule as well, i.e. use as
  /**     module->submodule_ = module->replace_module("linear", linear_holder);
  /** It only works when a module of the name is already registered.
  /**
  /** This is useful for replacing a module after initialization, e.g.
  /** for finetuning. */

  /** Unregisters a submodule from this {@code Module}. If there is no such module
   *  with {@code name} an exception is thrown. */
  public void unregister_module(BytePointer name) { asModule()._unregister_module(name); }
  private native @Name("unregister_module") void _unregister_module(@StdString BytePointer name);
  public void unregister_module(String name) { asModule()._unregister_module(name); }
  private native @Name("unregister_module") void _unregister_module(@StdString String name);
  private static Pointer shiftLeft(Pointer stream, Module module) { return _shiftLeft(stream, module.asModule()); }
  private static native @Namespace @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer _shiftLeft(
        @Cast("std::ostream*") @ByRef Pointer stream,
        @Const @ByRef Module module);
  public Pointer shiftLeft(Pointer stream) { return shiftLeft(stream, this); }
}
