// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ MarginRankingLoss
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/** Creates a criterion that measures the loss given
 *  inputs :math:{@code x1}, :math:{@code x2}, two 1D mini-batch {@code Tensors},
 *  and a label 1D mini-batch tensor :math:{@code y} (containing 1 or -1).
 *  See https://pytorch.org/docs/master/nn.html#torch.nn.MarginRankingLoss to
 *  learn about the exact behavior of this module.
 * 
 *  See the documentation for {@code torch::nn::MarginRankingLossOptions} class to
 *  learn what constructor arguments are supported for this module.
 * 
 *  Example:
 *  <pre>{@code
 *  MarginRankingLoss
 *  model(MarginRankingLossOptions().margin(0.5).reduction(torch::kSum));
 *  }</pre> */
@Namespace("torch::nn") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class MarginRankingLossImpl extends MarginRankingLossImplCloneable {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MarginRankingLossImpl(Pointer p) { super(p); }
    /** Downcast constructor. */
    public MarginRankingLossImpl(Module pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @SharedPtr @Name("SHARED_PTR_NAMESPACE::dynamic_pointer_cast<torch::nn::MarginRankingLossImpl, torch::nn::Module>") void allocate(@SharedPtr Module pointer);

  public MarginRankingLossImpl(@ByVal(nullValue = "torch::nn::MarginRankingLossOptions{}") MarginRankingLossOptions options_) { super((Pointer)null); allocate(options_); }
  @SharedPtr @Name("std::make_shared<torch::nn::MarginRankingLossImpl>") private native void allocate(@ByVal(nullValue = "torch::nn::MarginRankingLossOptions{}") MarginRankingLossOptions options_);
  public MarginRankingLossImpl() { super((Pointer)null); allocate(); }
  @SharedPtr @Name("std::make_shared<torch::nn::MarginRankingLossImpl>") private native void allocate();

  public native void reset();

  /** Pretty prints the {@code MarginRankingLoss} module into the given {@code stream}. */
  public native void pretty_print(@Cast("std::ostream*") @ByRef Pointer stream);

  public native @ByVal Tensor forward(
        @Const @ByRef Tensor input1,
        @Const @ByRef Tensor input2,
        @Const @ByRef Tensor targets);

  /** The options with which this {@code Module} was constructed. */
  public native @ByRef MarginRankingLossOptions options(); public native MarginRankingLossImpl options(MarginRankingLossOptions setter);
}
