// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


/** A dataloader for stateless datasets.
 * 
 *  This dataloader follows the traditional PyTorch dataloader design, whereby a
 *  (posssibly) stateful sampler produces *batch requests* for a stateless
 *  dataset, which acts as a simple batch request to batch mapping. The batch
 *  request will often be an array of indices, and if the dataset is a simple
 *  image dataset, the dataset would produce the images at those indices. */
@Name("torch::data::StatelessDataLoader<torch::data::datasets::MapDataset<torch::data::datasets::MNIST,torch::data::transforms::Stack<torch::data::Example<torch::Tensor,torch::Tensor> > >,torch::data::samplers::RandomSampler>") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class MNISTRandomDataLoader extends MNISTRandomDataLoaderBase {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MNISTRandomDataLoader(Pointer p) { super(p); }


  /** Constructs the {@code StatelessDataLoader} from a {@code dataset}, a {@code sampler} and
   *  some {@code options}. */
  public MNISTRandomDataLoader(
        @ByVal MNISTMapDataset dataset,
        @ByVal RandomSampler sampler,
        @ByVal DataLoaderOptions options) { super((Pointer)null); allocate(dataset, sampler, options); }
  private native void allocate(
        @ByVal MNISTMapDataset dataset,
        @ByVal RandomSampler sampler,
        @ByVal DataLoaderOptions options);
}
