// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ LogSoftmax ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/** Applies the LogSoftmax function element-wise.
 *  See https://pytorch.org/docs/master/nn.html#torch.nn.LogSoftmax to learn
 *  about the exact behavior of this module.
 * 
 *  See the documentation for {@code torch::nn::LogSoftmaxOptions} class to learn what
 *  constructor arguments are supported for this module.
 * 
 *  Example:
 *  <pre>{@code
 *  LogSoftmax model(LogSoftmaxOptions(1));
 *  }</pre> */
@Namespace("torch::nn") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class LogSoftmaxImpl extends LogSoftmaxImplCloneable {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LogSoftmaxImpl(Pointer p) { super(p); }
    /** Downcast constructor. */
    public LogSoftmaxImpl(Module pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @SharedPtr @Name("SHARED_PTR_NAMESPACE::dynamic_pointer_cast<torch::nn::LogSoftmaxImpl, torch::nn::Module>") void allocate(@SharedPtr Module pointer);

  public LogSoftmaxImpl(@Cast("int64_t") long dim) { super((Pointer)null); allocate(dim); }
  @SharedPtr @Name("std::make_shared<torch::nn::LogSoftmaxImpl>") private native void allocate(@Cast("int64_t") long dim);
  public LogSoftmaxImpl(@Const @ByRef LogSoftmaxOptions options_) { super((Pointer)null); allocate(options_); }
  @SharedPtr @Name("std::make_shared<torch::nn::LogSoftmaxImpl>") private native void allocate(@Const @ByRef LogSoftmaxOptions options_);

  public native @ByVal Tensor forward(@Const @ByRef Tensor input);

  public native void reset();

  /** Pretty prints the {@code LogSoftmax} module into the given {@code stream}. */
  public native void pretty_print(@Cast("std::ostream*") @ByRef Pointer stream);

  public native @ByRef LogSoftmaxOptions options(); public native LogSoftmaxImpl options(LogSoftmaxOptions setter);
}
